/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.CastExpr;
import org.apache.xalan.xsltc.compiler.Expression;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.util.BooleanType;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.compiler.util.IntType;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.MethodType;
import org.apache.xalan.xsltc.compiler.util.MultiHashtable;
import org.apache.xalan.xsltc.compiler.util.ObjectType;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.runtime.TransletLoader;

class FunctionCall
extends Expression {
    private QName _fname;
    private final Vector _arguments;
    private static final Vector EMPTY_ARG_LIST = new Vector(0);
    protected static final String EXT_XSLTC = "http://xml.apache.org/xalan/xsltc";
    protected static final String JAVA_EXT_XSLTC = "http://xml.apache.org/xalan/xsltc/java";
    protected static final String EXT_XALAN = "http://xml.apache.org/xalan";
    protected static final String JAVA_EXT_XALAN = "http://xml.apache.org/xslt/java";
    Expression _thisArgument = null;
    private String _className;
    private Method _chosenMethod;
    private Constructor _chosenConstructor;
    private MethodType _chosenMethodType;
    private boolean unresolvedExternal;
    private boolean _isExtConstructor = false;
    private static final MultiHashtable _internal2Java = new MultiHashtable();
    private static final Hashtable _java2Internal = new Hashtable();

    public FunctionCall(QName fname, Vector arguments) {
        this._fname = fname;
        this._arguments = arguments;
        this._type = null;
    }

    public FunctionCall(QName fname) {
        this(fname, EMPTY_ARG_LIST);
    }

    public String getName() {
        return this._fname.toString();
    }

    public void setParser(Parser parser2) {
        super.setParser(parser2);
        if (this._arguments != null) {
            int n = this._arguments.size();
            int i = 0;
            while (i < n) {
                Expression exp = (Expression)this._arguments.elementAt(i);
                exp.setParser(parser2);
                exp.setParent(this);
                ++i;
            }
        }
    }

    public String getClassNameFromUri(String uri) throws TypeCheckError {
        int length;
        int n = uri.startsWith(JAVA_EXT_XSLTC) ? JAVA_EXT_XSLTC.length() + 1 : (length = uri.startsWith(JAVA_EXT_XALAN) ? JAVA_EXT_XALAN.length() + 1 : 0);
        if (length == 0) {
            throw new TypeCheckError(this);
        }
        return uri.length() > length ? uri.substring(length) : "";
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        if (this._type != null) {
            return this._type;
        }
        String namespace = this._fname.getNamespace();
        String local = this._fname.getLocalPart();
        if (this.isExtension()) {
            this._fname = new QName(null, null, local);
            return this.typeCheckStandard(stable);
        }
        if (this.isStandard()) {
            return this.typeCheckStandard(stable);
        }
        try {
            this._className = this.getClassNameFromUri(namespace);
            int pos = local.lastIndexOf(46);
            if (pos > 0) {
                this._className = this._className + local.substring(0, pos);
                this._fname = new QName(namespace, null, local.substring(pos + 1));
            } else {
                this._fname = new QName(namespace, null, local);
            }
            return this.typeCheckExternal(stable);
        }
        catch (TypeCheckError e) {
            ErrorMsg errorMsg = e.getErrorMsg();
            if (errorMsg == null) {
                String name = this._fname.getLocalPart();
                errorMsg = new ErrorMsg(6, name);
            }
            this.getParser().reportError(3, errorMsg);
            this._type = Type.Void;
            return this._type;
        }
    }

    public Type typeCheckStandard(SymbolTable stable) throws TypeCheckError {
        this._fname.clearNamespace();
        int n = this._arguments.size();
        Vector argsType = this.typeCheckArgs(stable);
        MethodType args = new MethodType(Type.Void, argsType);
        MethodType ptype = this.lookupPrimop(stable, this._fname.getLocalPart(), args);
        if (ptype != null) {
            int i = 0;
            while (i < n) {
                Expression exp;
                Type argType = (Type)ptype.argsType().elementAt(i);
                if (!argType.identicalTo((exp = (Expression)this._arguments.elementAt(i)).getType())) {
                    try {
                        this._arguments.setElementAt(new CastExpr(exp, argType), i);
                    }
                    catch (TypeCheckError e) {
                        throw new TypeCheckError(this);
                    }
                }
                ++i;
            }
            this._chosenMethodType = ptype;
            this._type = ptype.resultType();
            return this._type;
        }
        throw new TypeCheckError(this);
    }

    public Type typeCheckConstructor(SymbolTable stable) throws TypeCheckError {
        Vector constructors = this.findConstructors();
        if (constructors == null) {
            throw new TypeCheckError(77, this._className);
        }
        int nConstructors = constructors.size();
        int nArgs = this._arguments.size();
        Vector argsType = this.typeCheckArgs(stable);
        int bestConstrDistance = Integer.MAX_VALUE;
        this._type = null;
        int i = 0;
        while (i < nConstructors) {
            Constructor constructor = (Constructor)constructors.elementAt(i);
            Class<?>[] paramTypes = constructor.getParameterTypes();
            Class<?> extType = null;
            int currConstrDistance = 0;
            int j = 0;
            while (j < nArgs) {
                extType = paramTypes[j];
                Type intType = (Type)argsType.elementAt(j);
                Object match = _internal2Java.maps(intType, extType);
                if (match != null) {
                    currConstrDistance += ((JavaType)match).distance;
                } else {
                    currConstrDistance = Integer.MAX_VALUE;
                    break;
                }
                ++j;
            }
            if (j == nArgs && currConstrDistance < bestConstrDistance) {
                this._chosenConstructor = constructor;
                this._isExtConstructor = true;
                bestConstrDistance = currConstrDistance;
                this._type = new ObjectType(this._className);
            }
            ++i;
        }
        if (this._type != null) {
            return this._type;
        }
        StringBuffer buf = new StringBuffer(this._className);
        buf.append('.').append(this._fname.getLocalPart()).append('(');
        int i2 = 0;
        while (i2 < nArgs) {
            Type intType = (Type)argsType.elementAt(i2);
            buf.append(intType.toString());
            if (i2 < nArgs - 1) {
                buf.append(", ");
            }
            ++i2;
        }
        buf.append(')');
        throw new TypeCheckError(7, buf.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    public Type typeCheckExternal(SymbolTable stable) throws TypeCheckError {
        Vector methods;
        String name;
        int nArgs;
        block16: {
            nArgs = this._arguments.size();
            name = this._fname.getLocalPart();
            if (this._className.length() == 0) {
                if (nArgs > 0) {
                    this._thisArgument = (Expression)this._arguments.elementAt(0);
                    this._arguments.remove(0);
                    --nArgs;
                    Type type = this._thisArgument.typeCheck(stable);
                    if (!(type instanceof ObjectType)) {
                        throw new TypeCheckError(78, name);
                    }
                    this._className = ((ObjectType)type).getJavaClassName();
                    break block16;
                } else {
                    Parser parser2 = this.getParser();
                    if (parser2 != null) {
                        this.reportWarning(this, parser2, 13, this._fname.toString());
                    }
                    this.unresolvedExternal = true;
                    this._type = Type.Int;
                    return this._type;
                }
            }
            if (this._fname.getLocalPart().equals("new")) {
                return this.typeCheckConstructor(stable);
            }
        }
        if ((methods = this.findMethods()) == null) {
            throw new TypeCheckError(6, name);
        }
        Class<?> extType = null;
        int nMethods = methods.size();
        Vector argsType = this.typeCheckArgs(stable);
        int bestMethodDistance = Integer.MAX_VALUE;
        this._type = null;
        int i = 0;
        while (i < nMethods) {
            Method method = (Method)methods.elementAt(i);
            Class<?>[] paramTypes = method.getParameterTypes();
            int currMethodDistance = 0;
            int j = 0;
            while (j < nArgs) {
                extType = paramTypes[j];
                Type intType = (Type)argsType.elementAt(j);
                Object match = _internal2Java.maps(intType, extType);
                if (match != null) {
                    currMethodDistance += ((JavaType)match).distance;
                    ++j;
                    continue;
                }
                currMethodDistance = Integer.MAX_VALUE;
                break;
            }
            if (j == nArgs) {
                extType = method.getReturnType();
                Type type = this._type = extType.getName().equals("void") ? Type.Void : (Type)_java2Internal.get(extType);
                if (this._type != null && currMethodDistance < bestMethodDistance) {
                    this._chosenMethod = method;
                    bestMethodDistance = currMethodDistance;
                }
            }
            ++i;
        }
        if (this._type != null) {
            if (this._type == Type.NodeSet) {
                this.getXSLTC().setMultiDocument(true);
            }
            return this._type;
        }
        StringBuffer buf = new StringBuffer(this._className);
        buf.append('.').append(this._fname.getLocalPart()).append('(');
        int i2 = 0;
        while (i2 < nArgs) {
            Type intType = (Type)argsType.elementAt(i2);
            buf.append(intType.toString());
            if (i2 < nArgs - 1) {
                buf.append(", ");
            }
            ++i2;
        }
        buf.append(')');
        throw new TypeCheckError(7, buf.toString());
    }

    public Vector typeCheckArgs(SymbolTable stable) throws TypeCheckError {
        Vector<Type> result = new Vector<Type>();
        Enumeration e = this._arguments.elements();
        while (e.hasMoreElements()) {
            Expression exp = (Expression)e.nextElement();
            result.addElement(exp.typeCheck(stable));
        }
        return result;
    }

    protected final Expression argument(int i) {
        return (Expression)this._arguments.elementAt(i);
    }

    protected final Expression argument() {
        return this.argument(0);
    }

    protected final int argumentCount() {
        return this._arguments.size();
    }

    protected final void setArgument(int i, Expression exp) {
        this._arguments.setElementAt(exp, i);
    }

    public void translateDesynthesized(ClassGenerator classGen, MethodGenerator methodGen) {
        Type type = Type.Boolean;
        if (this._chosenMethodType != null) {
            type = this._chosenMethodType.resultType();
        }
        InstructionList il = methodGen.getInstructionList();
        this.translate(classGen, methodGen);
        if (type instanceof BooleanType || type instanceof IntType) {
            this._falseList.add(il.append(new IFEQ(null)));
        }
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        int n = this.argumentCount();
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        if (this.isStandard() || this.isExtension()) {
            int i = 0;
            while (i < n) {
                Expression exp = this.argument(i);
                exp.translate(classGen, methodGen);
                exp.startResetIterator(classGen, methodGen);
                ++i;
            }
            String name = this._fname.toString().replace('-', '_') + "F";
            String args = "";
            if (name.equals("sumF")) {
                args = "Lorg/apache/xalan/xsltc/DOM;";
                il.append(methodGen.loadDOM());
            } else if (name.equals("normalize_spaceF") && this._chosenMethodType.toSignature(args).equals("()Ljava/lang/String;")) {
                args = "ILorg/apache/xalan/xsltc/DOM;";
                il.append(methodGen.loadContextNode());
                il.append(methodGen.loadDOM());
            }
            int index = cpg.addMethodref("org.apache.xalan.xsltc.runtime.BasisLibrary", name, this._chosenMethodType.toSignature(args));
            il.append(new INVOKESTATIC(index));
        } else if (this.unresolvedExternal) {
            int index = cpg.addMethodref("org.apache.xalan.xsltc.runtime.BasisLibrary", "unresolved_externalF", "(Ljava/lang/String;)V");
            il.append(new PUSH(cpg, this._fname.toString()));
            il.append(new INVOKESTATIC(index));
        } else if (this._isExtConstructor) {
            String clazz = this._chosenConstructor.getDeclaringClass().getName();
            Class<?>[] paramTypes = this._chosenConstructor.getParameterTypes();
            il.append(new NEW(cpg.addClass(this._className)));
            il.append(InstructionConstants.DUP);
            int i = 0;
            while (i < n) {
                Expression exp = this.argument(i);
                exp.translate(classGen, methodGen);
                exp.startResetIterator(classGen, methodGen);
                exp.getType().translateTo(classGen, methodGen, paramTypes[i]);
                ++i;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append('(');
            int i2 = 0;
            while (i2 < paramTypes.length) {
                buffer.append(FunctionCall.getSignature(paramTypes[i2]));
                ++i2;
            }
            buffer.append(')');
            buffer.append("V");
            int index = cpg.addMethodref(clazz, "<init>", buffer.toString());
            il.append(new INVOKESPECIAL(index));
            Type.Object.translateFrom(classGen, methodGen, this._chosenConstructor.getDeclaringClass());
        } else {
            String clazz = this._chosenMethod.getDeclaringClass().getName();
            Class<?>[] paramTypes = this._chosenMethod.getParameterTypes();
            if (this._thisArgument != null) {
                this._thisArgument.translate(classGen, methodGen);
            }
            int i = 0;
            while (i < n) {
                Expression exp = this.argument(i);
                exp.translate(classGen, methodGen);
                exp.startResetIterator(classGen, methodGen);
                exp.getType().translateTo(classGen, methodGen, paramTypes[i]);
                ++i;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append('(');
            int i3 = 0;
            while (i3 < paramTypes.length) {
                buffer.append(FunctionCall.getSignature(paramTypes[i3]));
                ++i3;
            }
            buffer.append(')');
            buffer.append(FunctionCall.getSignature(this._chosenMethod.getReturnType()));
            int index = cpg.addMethodref(clazz, this._fname.getLocalPart(), buffer.toString());
            il.append(this._thisArgument != null ? new INVOKEVIRTUAL(index) : new INVOKESTATIC(index));
            this._type.translateFrom(classGen, methodGen, this._chosenMethod.getReturnType());
        }
    }

    public String toString() {
        return "funcall(" + this._fname + ", " + this._arguments + ')';
    }

    public boolean isStandard() {
        String namespace = this._fname.getNamespace();
        return namespace == null || namespace.equals("");
    }

    public boolean isExtension() {
        String namespace = this._fname.getNamespace();
        return namespace != null && (namespace.equals(EXT_XSLTC) || namespace.equals(EXT_XALAN));
    }

    private Vector findMethods() {
        Vector<Method> result = null;
        String namespace = this._fname.getNamespace();
        if (namespace.startsWith(JAVA_EXT_XSLTC) || namespace.startsWith(JAVA_EXT_XALAN)) {
            int nArgs = this._arguments.size();
            try {
                TransletLoader loader = new TransletLoader();
                Class clazz = loader.loadClass(this._className);
                if (clazz == null) {
                    ErrorMsg msg = new ErrorMsg(5, this._className);
                    this.getParser().reportError(3, msg);
                } else {
                    String methodName = this._fname.getLocalPart();
                    Method[] methods = clazz.getDeclaredMethods();
                    int i = 0;
                    while (i < methods.length) {
                        int mods = methods[i].getModifiers();
                        if (Modifier.isPublic(mods) && methods[i].getName().equals(methodName) && methods[i].getParameterTypes().length == nArgs) {
                            if (result == null) {
                                result = new Vector<Method>();
                            }
                            result.addElement(methods[i]);
                        }
                        ++i;
                    }
                }
            }
            catch (ClassNotFoundException e) {
                ErrorMsg msg = new ErrorMsg(5, this._className);
                this.getParser().reportError(3, msg);
            }
        }
        return result;
    }

    private Vector findConstructors() {
        Vector result = null;
        String namespace = this._fname.getNamespace();
        if (namespace.startsWith(JAVA_EXT_XSLTC) || namespace.startsWith(JAVA_EXT_XALAN)) {
            int nArgs = this._arguments.size();
            try {
                TransletLoader loader = new TransletLoader();
                Class clazz = loader.loadClass(this._className);
                if (clazz == null) {
                    ErrorMsg msg = new ErrorMsg(5, this._className);
                    this.getParser().reportError(3, msg);
                } else {
                    Constructor<?>[] constructors = clazz.getConstructors();
                    int i = 0;
                    while (i < constructors.length) {
                        int mods = constructors[i].getModifiers();
                        if (Modifier.isPublic(mods) && constructors[i].getParameterTypes().length == nArgs) {
                            if (result == null) {
                                result = new Vector();
                            }
                            result.addElement(constructors[i]);
                        }
                        ++i;
                    }
                }
            }
            catch (ClassNotFoundException e) {
                ErrorMsg msg = new ErrorMsg(5, this._className);
                this.getParser().reportError(3, msg);
            }
        }
        return result;
    }

    static final String getSignature(Class clazz) {
        if (clazz.isArray()) {
            StringBuffer sb = new StringBuffer();
            Class<?> cl = clazz;
            while (cl.isArray()) {
                sb.append("[");
                cl = cl.getComponentType();
            }
            sb.append(FunctionCall.getSignature(cl));
            return sb.toString();
        }
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
            String name = clazz.toString();
            ErrorMsg err = new ErrorMsg(53, name);
            throw new Error(err.toString());
        }
        return "L" + clazz.getName().replace('.', '/') + ';';
    }

    static final String getSignature(Method meth) {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        Class<?>[] params = meth.getParameterTypes();
        int j = 0;
        while (j < params.length) {
            sb.append(FunctionCall.getSignature(params[j]));
            ++j;
        }
        return sb.append(')').append(FunctionCall.getSignature(meth.getReturnType())).toString();
    }

    static final String getSignature(Constructor cons) {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        Class<?>[] params = cons.getParameterTypes();
        int j = 0;
        while (j < params.length) {
            sb.append(FunctionCall.getSignature(params[j]));
            ++j;
        }
        return sb.append(")V").toString();
    }

    static {
        try {
            Class<?> objectClass = Class.forName("java.lang.Object");
            Class<?> stringClass = Class.forName("java.lang.String");
            Class<?> nodeClass = Class.forName("org.w3c.dom.Node");
            Class<?> nodeListClass = Class.forName("org.w3c.dom.NodeList");
            _internal2Java.put(Type.Boolean, new JavaType(Boolean.TYPE, 0));
            _internal2Java.put(Type.Int, new JavaType(Character.TYPE, 6));
            _internal2Java.put(Type.Int, new JavaType(Byte.TYPE, 5));
            _internal2Java.put(Type.Int, new JavaType(Short.TYPE, 4));
            _internal2Java.put(Type.Int, new JavaType(Integer.TYPE, 0));
            _internal2Java.put(Type.Int, new JavaType(Long.TYPE, 1));
            _internal2Java.put(Type.Int, new JavaType(Float.TYPE, 2));
            _internal2Java.put(Type.Int, new JavaType(Double.TYPE, 3));
            _internal2Java.put(Type.Real, new JavaType(Character.TYPE, 6));
            _internal2Java.put(Type.Real, new JavaType(Byte.TYPE, 5));
            _internal2Java.put(Type.Real, new JavaType(Short.TYPE, 4));
            _internal2Java.put(Type.Real, new JavaType(Integer.TYPE, 3));
            _internal2Java.put(Type.Real, new JavaType(Long.TYPE, 2));
            _internal2Java.put(Type.Real, new JavaType(Float.TYPE, 1));
            _internal2Java.put(Type.Real, new JavaType(Double.TYPE, 0));
            _internal2Java.put(Type.String, new JavaType(stringClass, 0));
            _internal2Java.put(Type.Node, new JavaType(nodeClass, 0));
            _internal2Java.put(Type.Node, new JavaType(nodeListClass, 1));
            _internal2Java.put(Type.NodeSet, new JavaType(Integer.TYPE, 10));
            _internal2Java.put(Type.NodeSet, new JavaType(nodeClass, 1));
            _internal2Java.put(Type.NodeSet, new JavaType(nodeListClass, 0));
            _internal2Java.put(Type.ResultTree, new JavaType(nodeClass, 1));
            _internal2Java.put(Type.ResultTree, new JavaType(nodeListClass, 0));
            _internal2Java.put(Type.ResultTree, new JavaType(objectClass, 2));
            _internal2Java.put(Type.Reference, new JavaType(objectClass, 0));
            _java2Internal.put(Boolean.TYPE, Type.Boolean);
            _java2Internal.put(Character.TYPE, Type.Real);
            _java2Internal.put(Byte.TYPE, Type.Real);
            _java2Internal.put(Short.TYPE, Type.Real);
            _java2Internal.put(Integer.TYPE, Type.Real);
            _java2Internal.put(Long.TYPE, Type.Real);
            _java2Internal.put(Float.TYPE, Type.Real);
            _java2Internal.put(Double.TYPE, Type.Real);
            _java2Internal.put(stringClass, Type.String);
            _java2Internal.put(objectClass, Type.Reference);
            _java2Internal.put(nodeListClass, Type.NodeSet);
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
        }
    }

    static class JavaType {
        public Class type;
        public int distance;

        public JavaType(Class type, int distance) {
            this.type = type;
            this.distance = distance;
        }

        public boolean equals(Object query) {
            return query.equals(this.type);
        }
    }
}

