/*
 * Decompiled with CFR 0.152.
 */
package ui.gui;

import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.resource.DBAImageResource;
import dbaut.util.PlatformUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ui.gui.JsqlGUI;

public class JsqlHistoryDialog
extends JDialog {
    private DbaButton selectButton = new DbaButton(new Dimension(100, 24), "Select", 'S', DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"), new ReflectionAction(this, "selectButtonActionPerformed"));
    private DbaButton cancelButton = new DbaButton(new Dimension(100, 24), "Cancel", 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelButtonActionPerformed"));
    private JList cmdList = null;
    private JsqlGUI ui = null;

    public JsqlHistoryDialog(JsqlGUI ui) {
        super(ui.getFrame());
        this.ui = ui;
        this.init();
    }

    private void init() {
        this.setTitle("Command history");
        this.setSize(new Dimension(300, 20));
        this.setResizable(true);
        this.setModal(true);
        ArrayList<String> cmds = this.ui.getCmdLists();
        this.cmdList = new JList<String>(this.getRevertVector(cmds));
        this.cmdList.setSelectionMode(0);
        this.cmdList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    JsqlHistoryDialog.this.selectButtonActionPerformed(null);
                }
            }
        });
        this.cmdList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    this.cmdListkeyReleased(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.cmdListkeyReleased(e);
            }

            private void cmdListkeyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    JsqlHistoryDialog.this.selectButtonActionPerformed(null);
                }
            }
        });
        JPanel centerPanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setAutoscrolls(true);
        scrollPane.getViewport().add(this.cmdList);
        this.cmdList.setVisibleRowCount(10);
        if (this.cmdList.getModel().getSize() > 1) {
            // empty if block
        }
        this.cmdList.setSelectedIndex(1);
        centerPanel.add(scrollPane);
        JPanel southPanel = new JPanel(new FlowLayout(2));
        southPanel.add(this.selectButton);
        southPanel.add(this.cancelButton);
        Container container = this.getContentPane();
        container.add((Component)centerPanel, "Center");
        container.add((Component)southPanel, "South");
        this.setNames();
    }

    private void setNames() {
        this.setName("JsqlHistoryDialog");
        this.selectButton.setName("SelectButton");
        this.cancelButton.setName("CancelButton");
        this.cmdList.setName("CmdList");
    }

    private Vector<String> getRevertVector(ArrayList<String> cmds) {
        Vector<String> v = new Vector<String>();
        String cmd = "";
        for (int i = cmds.size() - 1; i >= 0; --i) {
            cmd = cmds.get(i);
            if (cmd.trim().length() <= 0) continue;
            v.add(cmd);
        }
        return v;
    }

    public void selectButtonActionPerformed(ActionEvent e) {
        String cmd = (String)this.cmdList.getSelectedValue();
        this.ui.getFrame().getSimulator().inputCmd(cmd);
        this.setVisible(false);
        this.dispose();
    }

    public void cancelButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }
}

