/*
 * Decompiled with CFR 0.152.
 */
package ui.gui;

import dbaut.resource.DBAImageResource;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import ui.Jsql2Preferences;
import ui.gui.JsqlCmdSimulator;
import ui.gui.JsqlGUI;
import ui.gui.JsqlMenuBar;
import ui.gui.JsqlStatusBar;
import ui.gui.JsqlToolBar;

public class JsqlFrame
extends JFrame {
    private JsqlGUI ui = null;
    private JsqlMenuBar menuBar = null;
    private JsqlToolBar toolBar = null;
    private JsqlCmdSimulator cmdSimulator = null;
    private JsqlStatusBar statusBar = null;
    private boolean isToolBarShow = true;
    private boolean isStatusBarShow = true;
    private boolean isHorizontalBarShow = true;
    private boolean isVerticalBarShow = true;

    public JsqlFrame(JsqlGUI ui) {
        this.ui = ui;
        this.init();
    }

    private void init() {
        Jsql2Preferences jsql2Pref = Jsql2Preferences.getPreferencesXml(this.ui);
        this.menuBar = new JsqlMenuBar(this.ui);
        this.toolBar = new JsqlToolBar(this.ui);
        this.cmdSimulator = new JsqlCmdSimulator(this.ui);
        this.statusBar = new JsqlStatusBar(this.ui);
        this.setIconImage(DBAImageResource.getResource(this.getClass(), "/svrmgrimages/logo16.gif").getImage());
        this.setJMenuBar(this.menuBar);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.toolBar, "North");
        contentPane.add((Component)this.cmdSimulator, "Center");
        contentPane.add((Component)this.statusBar, "South");
        this.setTexts();
        this.setSize(jsql2Pref.getSize());
        this.setLocation(jsql2Pref.getLocation());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                JsqlFrame.this.cmdSimulator.simulatorRequireFocus();
            }

            @Override
            public void windowClosing(WindowEvent e) {
                JsqlFrame.this.menuBar.databaseExitActionPerformed(null);
                JsqlFrame.this.setVisible(false);
                JsqlFrame.this.dispose();
            }
        });
    }

    private void setTexts() {
        this.setTitle("Jsql2");
    }

    @Override
    public JsqlMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public JsqlToolBar getToolBar() {
        return this.toolBar;
    }

    public JsqlCmdSimulator getSimulator() {
        return this.cmdSimulator;
    }

    public JsqlStatusBar getStatusBar() {
        return this.statusBar;
    }

    public boolean isHorizontalBarShow() {
        return this.cmdSimulator.isHorizontalBarShow();
    }

    public boolean isVerticalBarShow() {
        return this.cmdSimulator.isVerticalBarShow();
    }

    public boolean isStatusBarShow() {
        return this.isStatusBarShow;
    }

    public boolean isToolBarShow() {
        return this.isToolBarShow;
    }

    public void hideStatusBar() {
        this.getContentPane().remove(this.statusBar);
        this.isStatusBarShow = false;
        this.validate();
    }

    public void showStatusBar() {
        this.getContentPane().add((Component)this.statusBar, "South");
        this.isStatusBarShow = true;
        this.validate();
    }

    public void hideToolBar() {
        this.getContentPane().remove(this.toolBar);
        this.isToolBarShow = false;
        this.validate();
    }

    public void showToolBar() {
        this.getContentPane().add((Component)this.toolBar, "North");
        this.isToolBarShow = true;
        this.validate();
    }
}

