/*
 * Decompiled with CFR 0.152.
 */
package svrmgrwizard.restore;

import dbaut.GuiUt;
import dbaut.IncBackupFile;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class IncBackupTableCols
extends AbstractTableModel {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("svrmgrproperties.svrmgr.ResWizard", LocaleManager.getLocale());
    private final String[] columnNames = new String[]{"", this.res.getString("Backup_ID"), this.res.getString("Incremental_Backup_File_Name"), this.res.getString("Time")};
    private Vector data = new Vector();
    private int rtime = 0;
    private int point = -1;
    public static final int IS_RESTORE = 0;
    public static final int INC_BACKUP_ID = 1;
    public static final int INC_BACKUP_FILENAME = 2;
    public static final int INC_RESTORE_TIME = 3;

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col].toString().trim();
    }

    @Override
    public Object getValueAt(int row, int col) {
        IncBackupFile rowData = (IncBackupFile)this.data.elementAt(row);
        return rowData.getValueAt(col);
    }

    public Class getColumnClass(int c) {
        IncBackupFile rowData = (IncBackupFile)this.data.elementAt(0);
        return rowData.getValueAt(c).getClass();
    }

    public void addValue(IncBackupFile newData) {
        this.data.addElement(newData);
    }

    public void removeValue(int x) {
        this.data.remove(x);
    }

    public void removeAll() {
        this.data.removeAllElements();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0;
    }

    public void setRTime(int rTime) {
        this.rtime = rTime;
    }

    public void addAll(Vector v) {
        this.data = v;
        IncBackupFile ibf = null;
        int fileTime = 0;
        for (int i = 0; i < this.data.size(); ++i) {
            ibf = (IncBackupFile)this.data.elementAt(i);
            fileTime = GuiUt.convertStrToTime(ibf.time);
            if (this.rtime >= fileTime) continue;
            this.setValueAt(Boolean.FALSE, i, 0);
            if (this.point != -1) continue;
            this.point = i;
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    public Vector getAll() {
        return this.data;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        block5: {
            if (value == null) {
                return;
            }
            IncBackupFile rowData = (IncBackupFile)this.data.elementAt(row);
            rowData.setValueAt(value, col);
            if (col != 0) break block5;
            if (((Boolean)value).booleanValue()) {
                for (int i = row - 1; i >= 0; --i) {
                    rowData = (IncBackupFile)this.data.elementAt(i);
                    rowData.setValueAt(value, col);
                }
            } else {
                for (int i = row + 1; i < this.data.size(); ++i) {
                    rowData = (IncBackupFile)this.data.elementAt(i);
                    rowData.setValueAt(value, col);
                }
            }
        }
    }
}

