/*
 * Decompiled with CFR 0.152.
 */
package svrmgrwizard.diagnoseDB;

import ServerMgr.SmFrame;
import ServerMgr.SmHelpButton;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.CheckingStatusRenderer;
import dbaut.CommonUt.ColumnTableModel;
import dbaut.CommonUt.EmptyPanel;
import dbaut.CommonUt.WizardTextArea;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import svrmgrwizard.diagnoseDB.ProcessPanel;
import svrmgrwizard.diagnoseDB.RepairOptionsDlg;
import svrmgrwizard.diagnoseDB.RepairReport;
import svrmgrwizard.diagnoseDB.RepairTableDialog;

public class RepairStatus
extends AbstractWizardPanel
implements ProcessPanel {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("svrmgrproperties.svrmgr.DiagnoseRes", LocaleManager.getLocale());
    private String title = this.res.getString("wizard_title6");
    private RepairTableDialog redlg = null;
    private AbstractWizardPanel next1 = null;
    private AbstractWizardPanel previous = null;
    private ColumnTableModel model = null;
    private JTable jtable = null;
    private DbaButton cancel_Button = new DbaButton(this.res.getString("Cancel"), 'C', new ReflectionAction(this, "cancel_Button_actionPerformed"));
    private DbaButton next_Button = new DbaButton(this.res.getString("Next"), 'N', new ReflectionAction(this, "next_Button_actionPerformed"));

    public RepairStatus(RepairTableDialog redlg, AbstractWizardPanel previous) {
        try {
            this.redlg = redlg;
            this.previous = previous;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setName("RepaireStatusPanel");
        this.next_Button.setName("NextButton");
        DbaButton back_Button = new DbaButton(this.res.getString("Previous"), 'P', new ReflectionAction(this, "back_Button_actionPerformed"));
        SmHelpButton help_Button = new SmHelpButton();
        JPanel panel1 = new JPanel(new BorderLayout(10, 0));
        JPanel panel4 = new JPanel(new FlowLayout(2));
        JPanel panel6 = new JPanel(new BorderLayout());
        WizardTextArea area1 = new WizardTextArea(this.title, this.res.getString("It_will_show_repaired"));
        this.model = this.redlg.checktable_model;
        this.jtable = new JTable(this.model);
        JScrollPane jscroll2 = new JScrollPane(this.jtable);
        this.next_Button.setHorizontalTextPosition(2);
        back_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"));
        this.next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/next.gif"));
        this.cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        jscroll2.setBorder(null);
        jscroll2.setPreferredSize(new Dimension(300, 80));
        jscroll2.setVerticalScrollBarPolicy(20);
        panel4.add(back_Button);
        panel4.add(this.next_Button);
        panel4.add(new EmptyPanel());
        panel4.add(this.cancel_Button);
        panel4.add(help_Button);
        panel6.add((Component)jscroll2, "Center");
        this.setImage(DBAImageResource.getResource(this.getClass(), "/svrmgrimages/DiagnoseDB.jpg"));
        this.setButtonBar(panel4);
        this.setTextArea(area1);
        this.setContent(panel6);
        this.next_Button.setEnabled(false);
        this.cancel_Button.setEnabled(false);
        SmFrame.frame.enableDialogHelp(this, help_Button, "wizard_DiagnoseDB_RepairStatus", null);
        TableColumnModel tcmodel = this.jtable.getColumnModel();
        TableColumn col = tcmodel.getColumn(0);
        col.setPreferredWidth(10);
        col.setCellRenderer(new CheckingStatusRenderer());
        tcmodel.getColumn(1).setPreferredWidth(80);
        tcmodel.getColumn(2).setPreferredWidth(80);
        tcmodel.getColumn(3).setPreferredWidth(200);
    }

    public void back_Button_actionPerformed(ActionEvent e) {
        this.redlg.Next(this.previous);
    }

    public void next_Button_actionPerformed(ActionEvent e) {
        if (this.next1 == null) {
            this.next1 = new RepairReport(this.redlg, this);
        }
        this.redlg.Next(this.next1);
    }

    public void cancel_Button_actionPerformed(ActionEvent e) {
        this.redlg.dispose();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    private boolean getTablespaceStatus(String ts_name) {
        String tmp = null;
        int size = this.redlg.checkcatalog_model.getRowCount();
        for (int i = 0; i < size; ++i) {
            tmp = (String)this.redlg.checkcatalog_model.getValueAt(i, 1);
            if (!tmp.equalsIgnoreCase(ts_name)) continue;
            Integer status = (Integer)this.redlg.checkcatalog_model.getValueAt(i, 0);
            switch (status) {
                case 4: {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    private String executeSQL(Statement stmt, String query, boolean repairon) throws Exception {
        this.redlg.log.append(query);
        if (repairon) {
            this.redlg.log.append(" (repair) ");
        }
        try {
            if (this.redlg.isRepairOn != repairon && !this.redlg.setRepairOption(this.redlg.conn, stmt, repairon)) {
                throw new Exception("error set repair on");
            }
            stmt.execute(query);
            this.redlg.log.append(" --> OK " + this.redlg.endline);
            return null;
        }
        catch (SQLException sqle) {
            this.redlg.log.append(" --> FAIL " + this.redlg.endline);
            String msg = "";
            for (SQLException e = sqle; e != null; e = e.getNextException()) {
                this.redlg.log.append(e.getMessage() + this.redlg.endline);
                msg = msg + " " + e.getMessage();
            }
            return msg;
        }
    }

    private void setStatus(int status, int row) {
        this.model.setValueAt(new Integer(status), row, 0);
        this.model.fireTableChanged(new TableModelEvent(this.model));
    }

    private int getStartStep(boolean ts_status) {
        if (!ts_status) {
            return 1;
        }
        return this.redlg.autorepiar || this.redlg.repairoption == 2 ? 2 : 1;
    }

    @Override
    public void procStart() {
        String query = null;
        Statement stmt = null;
        Object rs = null;
        String name = null;
        String owner = null;
        String tsname = null;
        int i = 0;
        try {
            stmt = this.redlg.conn.getDbConnection().createStatement();
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(this.redlg, this.res.getString("CreateStatement_error"), sqle);
            return;
        }
        String errormsg = null;
        int size = this.model.getRowCount();
        try {
            for (i = 0; i < size; ++i) {
                this.model.setValueAt(new Integer(1), i, 0);
                this.model.fireTableChanged(new TableModelEvent(this.model));
                owner = (String)this.model.getValueAt(i, 1);
                name = (String)this.model.getValueAt(i, 2);
                tsname = (String)this.model.getValueAt(i, 4);
                query = "CHECK TABLE " + GuiUt.getIDString(owner) + "." + GuiUt.getIDString(name);
                boolean ts_status = this.getTablespaceStatus(tsname);
                if (!ts_status || !this.redlg.autorepiar && this.redlg.repairoption != 2) {
                    errormsg = this.executeSQL(stmt, query, false);
                    if (errormsg == null) {
                        this.model.setValueAt(this.res.getString("Check_ok"), i, 3);
                        this.setStatus(2, i);
                        continue;
                    }
                    if (ts_status && this.redlg.repairoption != 4) {
                        RepairOptionsDlg dlg = new RepairOptionsDlg(this.redlg, this.res.getString("Repair_option"), true, this.res.getString("Errors_found_when_check") + "(" + query + ")" + this.res.getString("Do_you_wnat_to_repair"), errormsg);
                        GuiUt.setCenterLocation(this.redlg, dlg);
                        dlg.show();
                        this.redlg.repairoption = dlg.result;
                    }
                    if (!ts_status || this.redlg.repairoption == 4 || this.redlg.repairoption == 3) {
                        this.model.setValueAt(this.res.getString("Error_found"), i, 3);
                        this.setStatus(4, i);
                        continue;
                    }
                }
                if ((errormsg = this.executeSQL(stmt, query, true)) == null) {
                    this.model.setValueAt(this.res.getString("Check_ok"), i, 3);
                    this.setStatus(2, i);
                    continue;
                }
                errormsg = this.executeSQL(stmt, query, false);
                this.redlg.repaired = true;
                if (errormsg == null) {
                    this.model.setValueAt(this.res.getString("Error_found_repair_ok"), i, 3);
                    this.setStatus(3, i);
                    continue;
                }
                this.model.setValueAt(this.res.getString("Error_found_repair_fail"), i, 3);
                this.setStatus(5, i);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            DbaObject.close(stmt);
            this.cancel_Button.setEnabled(true);
            return;
        }
        DbaObject.close(stmt);
        this.next_Button.setEnabled(true);
        this.cancel_Button.setEnabled(true);
    }
}

