/*
 * Decompiled with CFR 0.152.
 */
package svrmgrwizard.backup;

import ServerMgr.DatabaseConnection;
import ServerMgr.SmFrame;
import ServerMgr.SmHelpButton;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.JdmConfig;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.comp.WizardTextPane;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import svrmgrwizard.backup.BackupDlg;
import svrmgrwizard.backup.OfflineDiffBackupPanel;
import svrmgrwizard.backup.OfflineFullBackupPanel;
import svrmgrwizard.backup.OfflineFullBackupToTapePanel;

public class SelectOfflineBackupTypePanel
extends AbstractWizardPanel {
    private static final long serialVersionUID = 1160696275974716495L;
    private BackupDlg parentDialog = null;
    private AbstractWizardPanel previousPanel = null;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("svrmgrproperties.svrmgr.BackupRes", LocaleManager.getLocale());
    private String title = null;
    private AbstractWizardPanel next = null;
    private SmHelpButton helpButton = new SmHelpButton();
    private DbaButton cancelButton = new DbaButton(new Dimension(100, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelButtonActionPerformed"));
    private DbaButton nextButton = new DbaButton(new Dimension(100, 24), this.res.getString("Next"), 'N', DBAImageResource.getResource(this.getClass(), "/dbautimages/next.gif"), new ReflectionAction(this, "nextButtonActionPerformed"));
    private DbaButton previousButton = new DbaButton(new Dimension(100, 24), this.res.getString("Previous"), 'P', DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"), new ReflectionAction(this, "previousButtonActionPerformed"));
    private JRadioButton fullBackupRadioButton = new JRadioButton();
    private JRadioButton differentialBackupRadioButton = new JRadioButton();
    private JCheckBox isToTapeCheckBox = new JCheckBox();
    private boolean isToTapeStatus = false;
    private ArrayList selectStatus = new ArrayList();
    private DatabaseConnection connection = null;
    private ArrayList info = null;

    public SelectOfflineBackupTypePanel(BackupDlg parentDialog, AbstractWizardPanel previousPanel, DatabaseConnection connection, ArrayList info) {
        this.parentDialog = parentDialog;
        this.previousPanel = previousPanel;
        this.connection = connection;
        this.info = info;
        this.init();
    }

    private void init() {
        this.setName("SelectOfflineBackupTypePanel");
        this.fullBackupRadioButton.setName("FullBackupRadioButton");
        this.nextButton.setName("NextButton");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JLabel jLabel1 = new JLabel();
        jLabel1.setBorder(BorderFactory.createLoweredBevelBorder());
        ImageIcon imgIcon = DBAImageResource.getResource(this.getClass(), "/svrmgrimages/BackupDBleft.gif");
        jLabel1.setIcon(imgIcon);
        JPanel jPanel1 = new JPanel();
        jPanel1.setPreferredSize(new Dimension(470, 440));
        jPanel1.setBorder(BorderFactory.createEtchedBorder());
        jPanel1.setLayout(new BorderLayout());
        WizardTextPane jTextPane1 = new WizardTextPane(20, 14);
        jTextPane1.setText(this.res.getString("Offline_Backup_Description_FullStop"));
        jPanel1.add((Component)jTextPane1, "Center");
        JPanel backupTypePanel = new JPanel(new BorderLayout());
        backupTypePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true), this.res.getString("Backup_Type"), 1, 2), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        JPanel backupTypeTopPanel = new JPanel(new FlowLayout(0));
        backupTypeTopPanel.setBorder(BorderFactory.createEtchedBorder());
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.fullBackupRadioButton);
        bg1.add(this.differentialBackupRadioButton);
        this.fullBackupRadioButton.setText(this.res.getString("Full_Backup"));
        this.fullBackupRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectOfflineBackupTypePanel.this.fullBackupRadioButtonActionPerformed(e);
            }
        });
        this.fullBackupRadioButton.setSelected(true);
        this.differentialBackupRadioButton.setText(this.res.getString("Differential_Backup"));
        this.differentialBackupRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectOfflineBackupTypePanel.this.differentialBackupRadioButtonActionPerformed(e);
            }
        });
        backupTypeTopPanel.add(this.fullBackupRadioButton);
        JPanel backupTypeCenterPanel = new JPanel(new FlowLayout(0));
        backupTypeCenterPanel.setBorder(BorderFactory.createEtchedBorder());
        this.isToTapeCheckBox.setText(this.res.getString("Is_To_Tape"));
        this.isToTapeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectOfflineBackupTypePanel.this.isToTapeCheckBoxActionPerformed(e);
            }
        });
        backupTypeCenterPanel.add(this.isToTapeCheckBox);
        backupTypePanel.add((Component)backupTypeTopPanel, "North");
        backupTypePanel.add((Component)backupTypeCenterPanel, "Center");
        jPanel1.add((Component)backupTypePanel, "South");
        panel.add((Component)jLabel1, "West");
        panel.add((Component)jPanel1, "East");
        this.add((Component)panel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.nextButton.setHorizontalTextPosition(2);
        this.cancelButton.setHorizontalTextPosition(2);
        SmFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "Help_Backup_SelectOfflineBackupTypePanel", null);
        buttonPanel.add(this.previousButton);
        buttonPanel.add(this.nextButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.helpButton);
        this.setButtonBar(buttonPanel);
    }

    private void fullBackupRadioButtonActionPerformed(ActionEvent e) {
        if (this.fullBackupRadioButton.isSelected()) {
            this.isToTapeCheckBox.setEnabled(true);
            this.isToTapeCheckBox.setSelected(this.isToTapeStatus);
        }
    }

    private void differentialBackupRadioButtonActionPerformed(ActionEvent e) {
        if (this.isToTapeCheckBox.isEnabled()) {
            this.isToTapeStatus = this.isToTapeCheckBox.isSelected();
        }
        if (this.differentialBackupRadioButton.isSelected()) {
            this.isToTapeCheckBox.setSelected(false);
            this.isToTapeCheckBox.setEnabled(false);
        }
    }

    private void isToTapeCheckBoxActionPerformed(ActionEvent e) {
        this.isToTapeStatus = this.isToTapeCheckBox.isSelected();
    }

    public void previousButtonActionPerformed(ActionEvent e) {
        if (this.connection.isConnected()) {
            this.connection.disconnect();
        }
        if (this.info.size() > 0) {
            String dbName = (String)this.info.get(0);
            String svrAddress = (String)this.info.get(5);
            Integer svrPtNum = (Integer)this.info.get(6);
            JdmConfig.setTerminalServer(false, dbName, svrAddress, svrPtNum);
        }
        this.parentDialog.next(this.previousPanel);
    }

    public void nextButtonActionPerformed(ActionEvent e) {
        if (this.next == null || this.selectStatusIsChanged()) {
            if (this.fullBackupRadioButton.isSelected() && !this.isToTapeCheckBox.isSelected()) {
                this.next = new OfflineFullBackupPanel(this.parentDialog, this, this.connection, this.info);
            } else if (this.fullBackupRadioButton.isSelected() && this.isToTapeCheckBox.isSelected()) {
                this.next = new OfflineFullBackupToTapePanel(this.parentDialog, this, this.connection, this.info);
            } else if (this.differentialBackupRadioButton.isSelected()) {
                this.next = new OfflineDiffBackupPanel(this.parentDialog, this, this.connection, this.info);
            }
        }
        this.selectStatus.clear();
        this.selectStatus.add(new Boolean(this.fullBackupRadioButton.isSelected()));
        this.selectStatus.add(new Boolean(this.differentialBackupRadioButton.isSelected()));
        this.selectStatus.add(new Boolean(this.isToTapeCheckBox.isSelected()));
        this.parentDialog.next(this.next);
    }

    private boolean selectStatusIsChanged() {
        boolean isChanged = false;
        ArrayList<Boolean> tmp = new ArrayList<Boolean>();
        tmp.add(new Boolean(this.fullBackupRadioButton.isSelected()));
        tmp.add(new Boolean(this.differentialBackupRadioButton.isSelected()));
        tmp.add(new Boolean(this.isToTapeCheckBox.isSelected()));
        isChanged = !this.selectStatus.equals(tmp);
        return isChanged;
    }

    public void cancelButtonActionPerformed(ActionEvent e) {
        this.next = null;
        if (this.connection.isConnected()) {
            this.connection.disconnect();
        }
        if (this.info.size() > 0) {
            String dbName = (String)this.info.get(0);
            String svrAddress = (String)this.info.get(5);
            Integer svrPtNum = (Integer)this.info.get(6);
            JdmConfig.setTerminalServer(false, dbName, svrAddress, svrPtNum);
        }
        this.parentDialog.dispose();
    }

    @Override
    public void windowClosing() {
        this.cancelButtonActionPerformed(null);
    }

    @Override
    public String getTitle() {
        this.title = "Select_Offline_Backup";
        return this.title;
    }
}

