/*
 * Decompiled with CFR 0.152.
 */
package svrmgrwizard.backup;

import ServerMgr.DatabaseConnection;
import ServerMgr.SmFrame;
import ServerMgr.SmHelpButton;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.DbaObject;
import dbaut.DbaUtDef;
import dbaut.FullBackupFile;
import dbaut.GuiUt;
import dbaut.JBackupHistory;
import dbaut.JdmConfig;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaTable;
import dbaut.comp.ProgressDialog;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.system.BackupFile;
import dbaut.textField.CharField;
import dbaut.util.JavaTypeUtil;
import dbmaker.sql.JdbcOdbcStatement;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import svrmgrwizard.backup.BackupConstants;
import svrmgrwizard.backup.BackupDlg;
import svrmgrwizard.backup.IncrementalBackupTableModel;
import svrmgrwizard.backup.exception.CopyFileErrorException;
import svrmgrwizard.backup.exception.DeleteFileFailedException;
import svrmgrwizard.backup.exception.UserCancelException;

public class OnlineIncrementalBackupPanel
extends AbstractWizardPanel {
    private static final long serialVersionUID = 3072165689926287148L;
    public static final short BACKUP_ID = 0;
    public static final short PHYSICAL_NAME = 1;
    public static final short DESTINATION = 2;
    private BackupDlg parentDialog = null;
    private AbstractWizardPanel previousPanel = null;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("svrmgrproperties.svrmgr.BackupRes", LocaleManager.getLocale());
    private String title = null;
    private SmHelpButton helpButton = new SmHelpButton();
    private DbaButton cancelButton = new DbaButton(new Dimension(100, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelButtonActionPerformed"));
    private DbaButton finishButton = new DbaButton(new Dimension(100, 24), this.res.getString("Finish"), 'F', DBAImageResource.getResource(this.getClass(), "/dbautimages/finish.gif"), new ReflectionAction(this, "finishButtonActionPerformed"));
    private DbaButton previousButton = new DbaButton(new Dimension(100, 24), this.res.getString("Previous"), 'P', DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"), new ReflectionAction(this, "previousButtonActionPerformed"));
    private IncrementalBackupTableModel model = new IncrementalBackupTableModel();
    private DbaTable table = new DbaTable(this.model);
    private DatabaseConnection connection = null;
    private ArrayList connectionInfo = null;
    private String dbName = null;
    private Integer db_bkzip = null;
    private String db_bkdir = null;

    public OnlineIncrementalBackupPanel(BackupDlg parentDialog, AbstractWizardPanel previousPanel, DatabaseConnection connection, ArrayList connectionInfo) throws SQLException {
        this.parentDialog = parentDialog;
        this.previousPanel = previousPanel;
        this.connection = connection;
        this.connectionInfo = connectionInfo;
        if (this.connectionInfo.size() <= 0) {
            System.out.println("No connection information." + this.getClass().getName());
            return;
        }
        this.dbName = (String)this.connectionInfo.get(0);
        CallableStatement cstmt = connection.dbconn.prepareCall("{call GETSYSTEMOPTION('bkzip', ?)}");
        cstmt.registerOutParameter(1, 12);
        cstmt.execute();
        this.db_bkzip = JavaTypeUtil.valueOfInteger(cstmt.getString(1), this.parentDialog);
        cstmt.close();
        this.init();
    }

    private void init() throws SQLException {
        this.setName("OnlineIncBackupPanel");
        this.finishButton.setName("FinishButton");
        JPanel jPanel1 = new JPanel();
        jPanel1.setPreferredSize(new Dimension(640, 440));
        jPanel1.setBorder(BorderFactory.createEtchedBorder());
        jPanel1.setLayout(new BorderLayout());
        JPanel tableContentsPanel = new JPanel(new BorderLayout());
        tableContentsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true), this.res.getString("Backup_Contents"), 1, 2), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        JScrollPane tableContentsScrollPane = new JScrollPane();
        tableContentsScrollPane.setBorder(BorderFactory.createEtchedBorder());
        tableContentsScrollPane.getViewport().add(this.table);
        tableContentsPanel.add(tableContentsScrollPane);
        jPanel1.add((Component)tableContentsPanel, "Center");
        this.add((Component)jPanel1, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.finishButton.setHorizontalTextPosition(2);
        this.cancelButton.setHorizontalTextPosition(2);
        SmFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "Help_Backup_OnlineIncrementalBackupPanel", null);
        buttonPanel.add(this.previousButton);
        buttonPanel.add(this.finishButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.helpButton);
        this.setButtonBar(buttonPanel);
        this.initColumnSizes(this.table);
        this.setDestColumn(this.table.getColumnModel().getColumn(2));
        this.initTableContents();
    }

    private void initColumnSizes(JTable table) {
        TableColumn column = null;
        column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(100);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(220);
        column = table.getColumnModel().getColumn(2);
        column.setPreferredWidth(220);
    }

    private void setDestColumn(TableColumn destColumn) {
        CharField destField = new CharField(255, true);
        destColumn.setCellEditor(new DefaultCellEditor(destField));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        destColumn.setCellRenderer(renderer);
    }

    private String getIncBackupFileName(String fileName) {
        long nowMillis = System.currentTimeMillis();
        fileName = "I" + nowMillis + "_" + fileName;
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initTableContents() throws SQLException {
        Statement stmt;
        block8: {
            stmt = null;
            try {
                this.db_bkdir = JdmConfig.getOnlineBackupDir(this.dbName, this.connection.dbconn);
                stmt = this.connection.dbconn.createStatement();
                stmt.execute("BEGIN INCREMENTAL BACKUP");
                byte[] bkinfo = ((JdbcOdbcStatement)stmt).getOptionBytes(1103);
                CallableStatement cstmt = this.connection.dbconn.prepareCall("{call GETSYSTEMOPTION('fullbkid', ?)}");
                cstmt.registerOutParameter(1, 12);
                cstmt.executeQuery();
                int full_bk_id_time = JavaTypeUtil.parseInt(cstmt.getString(1), this.parentDialog);
                boolean isFound = false;
                if (bkinfo != null) {
                    for (int i = 0; i < bkinfo.length; ++i) {
                        if (bkinfo[i] == 0) continue;
                        isFound = true;
                        break;
                    }
                }
                if (!isFound) {
                    System.out.println("get statement option BACKUP_ID failed.");
                    break block8;
                }
                int offset = 8;
                byte[] nums = new byte[]{bkinfo[0], bkinfo[1], bkinfo[2], bkinfo[3]};
                byte[] bkids = new byte[]{bkinfo[4], bkinfo[5], bkinfo[6], bkinfo[7]};
                int num = GuiUt.convertByteArrayToInt(nums);
                int bkid = GuiUt.convertByteArrayToInt(bkids);
                JdmConfig config = new JdmConfig();
                for (int i = 0; i < num; ++bkid, offset += 256, ++i) {
                    String name = new String(bkinfo, offset, 255).trim();
                    if (name.length() == 0) {
                        System.out.println("Invalid journal filename from getOptionStr");
                        break;
                    }
                    String bkname = config.getFormatBackupName(this.dbName, bkid, name, full_bk_id_time);
                    Object[] one_row = new Object[3];
                    one_row[0] = new Integer(bkid);
                    one_row[1] = name;
                    String tmp = this.db_bkdir + BackupConstants.FILE_SEPARATOR + this.getIncBackupFileName(bkname);
                    if (this.db_bkzip == 1) {
                        tmp = tmp + ".gz";
                    }
                    one_row[2] = tmp;
                    this.model.addValue(one_row);
                }
            }
            catch (Throwable throwable) {
                DbaObject.close(stmt);
                throw throwable;
            }
        }
        DbaObject.close(stmt);
        this.model.fireTableChanged(new TableModelEvent(this.model));
    }

    public void previousButtonActionPerformed(ActionEvent e) {
        try {
            Statement stmt = this.connection.dbconn.createStatement();
            this.abortBackup(stmt);
            stmt.close();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        this.parentDialog.next(this.previousPanel);
    }

    public void finishButtonActionPerformed(ActionEvent e) {
        try {
            if (!this.isFullBackupIntegrity()) {
                GuiUt.showErrorDlg(this.parentDialog, this.res.getString("You_Must_Do_Full_Backup_Before_Incremental_Backup_FullStop"), "");
                return;
            }
        }
        catch (SQLException e1) {
            GuiUt.showErrorDlg(this.parentDialog, e1.getMessage(), "");
            return;
        }
        int rowCount = this.model.getRowCount();
        if (rowCount < 1) {
            GuiUt.showErrorDlg(this.parentDialog, this.res.getString("No_Incemental_Backup_Files_To_Be_Found_FullStop"), "");
            return;
        }
        String fileFullPath = null;
        File tmpFile = null;
        long len = 0L;
        for (int i = 0; i < rowCount; ++i) {
            fileFullPath = (String)this.model.getValueAt(i, 1);
            tmpFile = new File(fileFullPath);
            len += tmpFile.length();
        }
        final long totalLen = len;
        Thread t1 = new Thread(){

            @Override
            public void run() {
                OnlineIncrementalBackupPanel.this.runBackupTask(totalLen);
            }
        };
        t1.start();
    }

    private boolean isFullBackupIntegrity() throws SQLException {
        File backupLogFile;
        String backupDir = JdmConfig.getOnlineBackupDir(this.dbName, this.connection.dbconn);
        File file = new File(backupDir);
        if (!file.exists()) {
            return false;
        }
        String absolutePath = file.getAbsolutePath();
        if (!absolutePath.endsWith(BackupConstants.FILE_SEPARATOR)) {
            absolutePath = absolutePath + BackupConstants.FILE_SEPARATOR;
        }
        if (!(backupLogFile = new File(absolutePath + "dmBackup.his")).exists()) {
            return false;
        }
        JBackupHistory hist = new JBackupHistory(SmFrame.frame);
        int rc = hist.FileOpen(this.dbName, backupLogFile.getAbsolutePath(), "0");
        if (rc != DbaUtDef.RTN_OK) {
            System.out.println("Error open backup history file " + backupLogFile.getAbsolutePath() + ". And err no = " + rc);
            return false;
        }
        Vector fullBackupList = hist.getFullBackupList();
        if (fullBackupList.size() < 1) {
            return false;
        }
        Vector fullBackupInfo = hist.getFullBackupInfo(fullBackupList.size());
        hist.FileClose();
        FullBackupFile bf = null;
        String s = null;
        File f = null;
        for (int i = 0; i < fullBackupInfo.size(); ++i) {
            bf = (FullBackupFile)fullBackupInfo.get(i);
            s = bf.getBackupFile();
            f = new File(s);
            if (f.exists()) continue;
            System.out.println(f.getAbsolutePath() + " is not exist.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBackupTask(long len) {
        final ProgressDialog progressDialog = new ProgressDialog(this.parentDialog, this.res.getString("Online_Incremental_Backup"));
        JBackupHistory hist = null;
        BackupFile bf = null;
        Statement stmt = null;
        try {
            stmt = this.connection.dbconn.createStatement();
            this.table.editingStopped(null);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    progressDialog.show();
                }
            });
            bf = new BackupFile();
            Integer backupId = null;
            String db_file = null;
            String dest_file = null;
            File tmpFile = null;
            long fileLen = -1L;
            long workLen = -1L;
            int rowCount = this.model.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                backupId = (Integer)this.model.getValueAt(i, 0);
                db_file = (String)this.model.getValueAt(i, 1);
                tmpFile = new File(db_file);
                fileLen = tmpFile.length();
                workLen += fileLen;
                dest_file = (String)this.model.getValueAt(i, 2);
                boolean isSuccessful = bf.copyFile(db_file, dest_file);
                if (!isSuccessful) {
                    throw new CopyFileErrorException();
                }
                int percent = (int)((double)workLen / (double)len * 100.0);
                progressDialog.setProgressBarValue(percent);
                if (!progressDialog.isCanceling()) continue;
                ProgressDialog.sem.semaphoreWait();
                progressDialog.setIsCanceling(false);
                if (!progressDialog.isUserCanceled()) continue;
                throw new UserCancelException();
            }
            stmt.execute("END BACKUP JOURNAL");
            hist = new JBackupHistory(SmFrame.frame);
            String backupHisFileFullPath = null;
            backupHisFileFullPath = this.db_bkdir.endsWith(BackupConstants.FILE_SEPARATOR) ? this.db_bkdir + "dmBackup.his" : this.db_bkdir + BackupConstants.FILE_SEPARATOR + "dmBackup.his";
            int rc = hist.FileOpen(this.dbName, backupHisFileFullPath, "1");
            if (rc != DbaUtDef.RTN_OK) {
                System.out.println("Error open backup history file. err no = " + rc);
                throw new UserCancelException();
            }
            int isSetBackupDataSuccessful = -1;
            for (int i = 0; i < rowCount; ++i) {
                backupId = (Integer)this.model.getValueAt(i, 0);
                db_file = (String)this.model.getValueAt(i, 1);
                dest_file = (String)this.model.getValueAt(i, 2);
                isSetBackupDataSuccessful = hist.setBackupData(backupId, 8, db_file, "", dest_file, 0);
                if (isSetBackupDataSuccessful == 0) continue;
                throw new UserCancelException();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    progressDialog.setVisible(false);
                    progressDialog.dispose();
                    GuiUt.showInformationDlg(OnlineIncrementalBackupPanel.this.parentDialog, OnlineIncrementalBackupPanel.this.res.getString("Backup_Successfully_FullStop"));
                    OnlineIncrementalBackupPanel.this.cancelButtonActionPerformed(null);
                }
            });
        }
        catch (UserCancelException ex1) {
            System.out.println("User canceled.");
            this.abortBackup(stmt);
            this.clean(progressDialog);
        }
        catch (CopyFileErrorException e) {
            System.out.println("Copy file error.");
            String copyFileErrorMessage = "";
            if (bf != null) {
                copyFileErrorMessage = bf.copyFileErrorMessage;
            }
            this.abortBackup(stmt);
            this.clean(progressDialog, copyFileErrorMessage);
        }
        catch (InterruptedException e) {
            System.out.println("Interrupted exception.");
            this.abortBackup(stmt);
            this.clean(progressDialog);
        }
        catch (SQLException e) {
            String message = e.getMessage();
            System.out.println(message);
            this.abortBackup(stmt);
            this.clean(progressDialog, message);
        }
        finally {
            if (hist != null) {
                hist.FileClose();
            }
        }
    }

    private void abortBackup(Statement stmt) {
        try {
            stmt.execute("abort backup");
        }
        catch (SQLException e2) {
            System.out.println("About Backup execute exception.");
            e2.printStackTrace();
        }
    }

    private void clean(final ProgressDialog progressDialog) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progressDialog.setVisible(false);
                progressDialog.dispose();
                OnlineIncrementalBackupPanel.this.cancelButtonActionPerformed(null);
            }
        });
        try {
            this.cleanBackupFile();
        }
        catch (DeleteFileFailedException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private void clean(final ProgressDialog progressDialog, final String str) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progressDialog.setVisible(false);
                progressDialog.dispose();
                GuiUt.showErrorDlg(OnlineIncrementalBackupPanel.this.parentDialog, str, "");
            }
        });
        try {
            this.cleanBackupFile();
        }
        catch (DeleteFileFailedException e1) {
            System.out.println(e1.getMessage());
            e1.printStackTrace();
        }
    }

    private void cleanBackupFile() throws DeleteFileFailedException {
        String dest_file = null;
        File desFile = null;
        int rowCount = this.model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            dest_file = (String)this.model.getValueAt(i, 2);
            desFile = new File(dest_file);
            if (!desFile.exists() || desFile.delete()) continue;
            throw new DeleteFileFailedException(desFile.getAbsolutePath());
        }
    }

    public void cancelButtonActionPerformed(ActionEvent e) {
        if (this.connection.isConnected()) {
            try {
                Statement stmt = this.connection.dbconn.createStatement();
                this.abortBackup(stmt);
                stmt.close();
            }
            catch (SQLException e1) {
                System.out.println("Abort backup");
            }
            this.connection.disconnect();
        }
        this.parentDialog.setVisible(false);
        this.parentDialog.dispose();
    }

    @Override
    public void windowClosing() {
        this.cancelButtonActionPerformed(null);
    }

    @Override
    public String getTitle() {
        this.title = "Online_Incremental_Backup";
        return this.title;
    }
}

