/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importText;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

public class DataContent
extends JPanel {
    private int[] trueXPos = new int[251];
    private int trueXPosCount = 0;
    private int space = 3;
    private int width;
    private int charWidth = 0;
    private String rowDelimiter = null;
    private String text = null;

    public DataContent(String text, String rowDelimiter, int space) {
        this.rowDelimiter = rowDelimiter;
        this.space = space;
        this.setContent(text);
        Font font = new Font("Monospaced", 0, 12);
        this.setFont(font);
        this.charWidth = this.getFontSize(font);
        this.width = this.getContentSize(font);
        this.setPreferredSize(new Dimension(this.width, 100));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DataContent.this.this_mouseClicked(e);
            }
        });
        this.setBackground(Color.white);
    }

    private int getFontSize(Font font) {
        FontMetrics fontM = this.getFontMetrics(font);
        return fontM.charWidth(this.text.charAt(0));
    }

    public void sort_trueXPos_array() {
        for (int i = 0; i < this.trueXPosCount; ++i) {
            for (int j = i + 1; j < this.trueXPosCount; ++j) {
                if (this.trueXPos[i] <= this.trueXPos[j]) continue;
                int tmp = this.trueXPos[i];
                this.trueXPos[i] = this.trueXPos[j];
                this.trueXPos[j] = tmp;
            }
        }
    }

    public int[] getData() {
        int i;
        if (this.trueXPosCount > 1) {
            this.sort_trueXPos_array();
        }
        int[] ia = new int[this.trueXPosCount + 1];
        int[] trueIA = null;
        for (i = 0; i < this.trueXPosCount; ++i) {
            ia[i] = i == 0 ? this.trueXPos[i] - this.space : this.trueXPos[i] - this.trueXPos[i - 1] - this.space;
        }
        ia[this.trueXPosCount] = this.trueXPosCount != 0 ? this.width / this.charWidth - this.trueXPos[this.trueXPosCount - 1] : this.width / this.charWidth;
        if (this.trueXPosCount != 0) {
            if (ia[this.trueXPosCount] == 0) {
                trueIA = new int[ia.length - 1];
                for (i = 0; i < trueIA.length; ++i) {
                    trueIA[i] = ia[i];
                }
            } else {
                trueIA = ia;
            }
        } else {
            trueIA = ia;
        }
        return trueIA;
    }

    public void setContent(String text) {
        this.text = text;
    }

    private int getContentSize(Font font) {
        FontMetrics fontM = this.getFontMetrics(font);
        int max = 0;
        int tmp = 0;
        int i = 0;
        int currentPos = 0;
        String tmpText = this.text;
        int strLen = 0;
        while (true) {
            int x;
            if ((i = tmpText.indexOf(this.rowDelimiter, currentPos)) < 0) {
                tmp = 0;
                strLen = tmpText.length();
                for (x = 0; x < strLen; ++x) {
                    tmp += fontM.charWidth(tmpText.charAt(x));
                }
                if (tmp <= max) break;
                max = tmp;
                break;
            }
            tmp = 0;
            String tmpStr = tmpText.substring(currentPos, i);
            strLen = tmpStr.length();
            for (x = 0; x < strLen; ++x) {
                tmp += fontM.charWidth(tmpStr.charAt(x));
            }
            if (tmp > max) {
                max = tmp;
            }
            if (this.rowDelimiter.length() == 1) {
                tmpText = tmpText.substring(i + 1, tmpText.length());
                currentPos = i + 1;
                continue;
            }
            tmpText = tmpText.substring(i + 2, tmpText.length());
            currentPos = i + 2;
        }
        return max;
    }

    private int setComponentWidth() {
        int max = 0;
        int tmp = 0;
        boolean i = false;
        int currentPos = 0;
        char[] rowDelimiterArray = this.rowDelimiter.toCharArray();
        char[] cArray = this.text.toCharArray();
        int size = cArray.length;
        for (int j = 0; j < size; ++j) {
            if (rowDelimiterArray.length == 1) {
                if (cArray[j] != rowDelimiterArray[0]) continue;
                if (j < 0) {
                    tmp = size - currentPos;
                    if (tmp <= max) break;
                    max = tmp;
                    break;
                }
                tmp = j - currentPos;
                if (tmp > max) {
                    max = tmp;
                }
                currentPos = j + 1;
                ++j;
                continue;
            }
            if (rowDelimiterArray.length != 2 || cArray[j] != rowDelimiterArray[0] || cArray[j + 1] != rowDelimiterArray[1]) continue;
            if (j < 0) {
                tmp = size - currentPos;
                if (tmp <= max) break;
                max = tmp;
                break;
            }
            tmp = j - currentPos;
            if (tmp > max) {
                max = tmp;
            }
            currentPos = j + 2;
            ++j;
            ++j;
        }
        return max;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        for (int i = 0; i < this.width; ++i) {
            if (i % 5 == 0) {
                if (i >= 10) {
                    g.drawString(new Integer(i).toString(), i * this.charWidth - 5, 12);
                } else {
                    g.drawString(new Integer(i).toString(), i * this.charWidth - 2, 12);
                }
                g.drawString("+", i * this.charWidth, 24);
                continue;
            }
            g.drawString(".", i * this.charWidth, 24);
        }
        Insets insets = this.getInsets();
        int currentWidth = this.getWidth() - insets.left - insets.right;
        int currentHeight = this.getHeight() - insets.top - insets.bottom;
        g.drawLine(insets.left, insets.top + 26, insets.right + currentWidth, insets.top + 26);
        String t = this.text;
        int y = insets.top + 40;
        int x = insets.left;
        boolean i = false;
        byte[] rowDelimiterArray = this.rowDelimiter.getBytes();
        byte[] cArray = t.getBytes();
        int index = t.indexOf(this.rowDelimiter);
        String tmpStr = null;
        while (index > 0) {
            tmpStr = t.substring(0, index);
            t = this.rowDelimiter.length() == 1 ? t.substring(index + 1, t.length()) : t.substring(index + 2, t.length());
            g.drawString(tmpStr, x, y);
            x += tmpStr.length() * this.charWidth;
            y += 20;
            x = insets.left;
            index = t.indexOf(this.rowDelimiter);
        }
        for (int m = 0; m < this.trueXPosCount; ++m) {
            g.drawLine(this.trueXPos[m] * this.charWidth, insets.top + 27, this.trueXPos[m] * this.charWidth, currentHeight + insets.bottom);
        }
    }

    void this_mouseClicked(MouseEvent e) {
        int m;
        int xPos = e.getX();
        Insets insets = this.getInsets();
        int currentWidth = this.getWidth() - insets.left - insets.right;
        int i = xPos % this.charWidth;
        int tmp = xPos / this.charWidth;
        if (i > 5) {
            ++tmp;
        }
        for (m = 0; m < this.trueXPosCount; ++m) {
            if (Math.abs(tmp - this.trueXPos[m]) >= 1) continue;
            for (int n = m + 1; n < this.trueXPosCount; ++n) {
                this.trueXPos[n - 1] = this.trueXPos[n];
            }
            --this.trueXPosCount;
            this.repaint();
            return;
        }
        if (tmp < this.space + 1) {
            return;
        }
        for (m = 0; m < this.trueXPosCount; ++m) {
            if (Math.abs(tmp - this.trueXPos[m]) >= this.space + 1) continue;
            return;
        }
        if (this.trueXPosCount > 252) {
            return;
        }
        this.trueXPos[this.trueXPosCount] = tmp;
        ++this.trueXPosCount;
        this.repaint();
    }
}

