/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importODBC;

import com.syscom.dm.dtt.sca.DefaultDataTransferAuthority;
import datatransfer.DataTransferFrame;
import datatransfer.HelpButton;
import dbaut.ComboEditorField;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.DetailDialog;
import dbaut.CommonUt.EmptyPanel;
import dbaut.CommonUt.ODBCRenderer;
import dbaut.CommonUt.WizardTextArea;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.SqlTypeDef;
import dbaut.comp.ComboBoxCellEditor;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaFileFilter;
import dbaut.comp.ReflectionAction;
import dbaut.dbalib;
import dbaut.infoObject.ColumnInfoObject;
import dbaut.infoObject.TableInfoObject;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dttwizard.importODBC.ButtonEditor;
import dttwizard.importODBC.ButtonRenderer;
import dttwizard.importODBC.ColumnMapTransfer;
import dttwizard.importODBC.DetailInfo;
import dttwizard.importODBC.SourceTableModel;
import dttwizard.importODBC.odbcDialog;
import dttwizard.importXML.XmlElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SourceTableView
extends AbstractWizardPanel {
    private static final long serialVersionUID = -5011662661336879488L;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Import.dtt_ImportOdbcRes", LocaleManager.getLocale());
    private String title = this.res.getString("Page_title_sourcetableview");
    private odbcDialog odbcdlg = null;
    private AbstractWizardPanel previous = null;
    private AbstractWizardPanel next = null;
    private DbaButton next_Button = new DbaButton(new Dimension(100, 24), false, this.res.getString("Execute"), 'E', DBAImageResource.getResource(this.getClass(), "/dbautimages/execute.gif"), new ReflectionAction(this, "next_Button_actionPerformed"));
    private DbaButton saveButton = new DbaButton(new Dimension(100, 24), false, this.res.getString("Save_batch"), 'S', DBAImageResource.getResource(this.getClass(), "/dttimages/save_batch.gif"), new ReflectionAction(this, "saveButton_actionPerformed"));
    private String[] header = new String[]{"", this.res.getString("Source_Table"), this.res.getString("Destination_Table"), this.res.getString("Transform")};
    private SourceTableModel sourceTableModel = new SourceTableModel(this.header);
    JTable sourceTableViewTable = new JTable(this.sourceTableModel);
    private JComboBox sourceCombo = new JComboBox();
    private JComboBox destinationCombo = new JComboBox();
    private ComboBoxCellEditor cbce = null;
    private boolean isLoadBatch = false;
    JCheckBox checkAll = new JCheckBox(this.res.getString("All"));
    JCheckBox checkAllTables = new JCheckBox(this.res.getString("Table"));
    JCheckBox checkAllViews = new JCheckBox(this.res.getString("View"));
    private boolean changing = false;

    public SourceTableView(odbcDialog odbcdlg, AbstractWizardPanel previous, boolean isLoadBatch) {
        try {
            this.odbcdlg = odbcdlg;
            this.previous = previous;
            this.isLoadBatch = isLoadBatch;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        DbaButton back_Button = new DbaButton(this.res.getString("Previous"), 'P', new ReflectionAction(this, "back_Button_actionPerformed"));
        DbaButton cancel_Button = new DbaButton(this.res.getString("Cancel"), 'C', new ReflectionAction(this, "cancel_Button_actionPerformed"));
        HelpButton help_Button = new HelpButton();
        this.checkAll.setMnemonic('A');
        this.checkAll.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (SourceTableView.this.changing) {
                    return;
                }
                SourceTableView.this.changing = true;
                if (SourceTableView.this.checkAll.isSelected()) {
                    SourceTableView.this.checkAllTables.setSelected(true);
                    SourceTableView.this.checkAllViews.setSelected(true);
                } else {
                    SourceTableView.this.checkAllTables.setSelected(false);
                    SourceTableView.this.checkAllViews.setSelected(false);
                }
                SourceTableView.this.changing = false;
                SourceTableView.this.checkAll();
            }
        });
        this.checkAllTables.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (SourceTableView.this.changing) {
                    return;
                }
                SourceTableView.this.changing = true;
                if (!SourceTableView.this.checkAllTables.isSelected()) {
                    SourceTableView.this.checkAll.setSelected(false);
                }
                SourceTableView.this.changing = false;
                SourceTableView.this.checkAll();
            }
        });
        this.checkAllViews.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (SourceTableView.this.changing) {
                    return;
                }
                SourceTableView.this.changing = true;
                if (!SourceTableView.this.checkAllViews.isSelected()) {
                    SourceTableView.this.checkAll.setSelected(false);
                }
                SourceTableView.this.changing = false;
                SourceTableView.this.checkAll();
            }
        });
        WizardTextArea area1 = new WizardTextArea(this.title, this.res.getString("Please_select_tableview"));
        JScrollPane jscroll2 = new JScrollPane(this.sourceTableViewTable);
        this.destinationCombo.setEditor(new ComboEditorField());
        this.sourceTableModel.setParentDialog(this.odbcdlg);
        back_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"));
        cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        jscroll2.setVerticalScrollBarPolicy(20);
        this.sourceTableViewTable.setBorder(BorderFactory.createLoweredBevelBorder());
        this.sourceTableViewTable.setRowHeight(24);
        this.saveButton.setEnabled(false);
        this.sourceTableModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SourceTableView.this.checkButtonStatus();
            }
        });
        JPanel panel4 = new JPanel(new FlowLayout(2));
        panel4.add(back_Button);
        panel4.add(this.next_Button);
        panel4.add(new EmptyPanel());
        panel4.add(cancel_Button);
        panel4.add(help_Button);
        JPanel panel10 = new JPanel(new FlowLayout(0));
        panel10.add(this.checkAll);
        panel10.add(this.checkAllTables);
        panel10.add(this.checkAllViews);
        panel10.add(new EmptyPanel(new Dimension(160, 0)));
        panel10.add(this.saveButton);
        JPanel panel6 = new JPanel(new BorderLayout());
        panel6.add((Component)jscroll2, "Center");
        panel6.add((Component)panel10, "South");
        this.setImage(DBAImageResource.getResource(this.getClass(), "/dttimages/ImportODBC.jpg"));
        this.setButtonBar(panel4);
        this.setTextArea(area1);
        this.setContent(panel6);
        DataTransferFrame.enableDialogHelp(this, help_Button, "wizard_ImportODBC_from_tables", null);
        DatabaseMetaData dbmd = this.odbcdlg.sourceConnection.getDbConnection().getMetaData();
        this.assignTableName(dbmd, true);
        this.assignTableName(this.odbcdlg.destinationConnection.getDbConnection(), false);
        TableColumnModel tcsourceTableModel = this.sourceTableViewTable.getColumnModel();
        TableColumn col = tcsourceTableModel.getColumn(0);
        col.setPreferredWidth(30);
        col = tcsourceTableModel.getColumn(1);
        col.setPreferredWidth(200);
        col.setCellEditor(new DefaultCellEditor(this.sourceCombo));
        col.setCellRenderer(new ODBCRenderer());
        col = tcsourceTableModel.getColumn(2);
        col.setPreferredWidth(200);
        this.cbce = new ComboBoxCellEditor(this.destinationCombo, false, this.odbcdlg.destinationConnection.getUserName());
        col.setCellEditor(this.cbce);
        col.setCellRenderer(new ODBCRenderer());
        col = tcsourceTableModel.getColumn(3);
        col.setPreferredWidth(70);
        col.setCellEditor(new ButtonEditor(this.odbcdlg));
        col.setCellRenderer(new ButtonRenderer(this.odbcdlg));
        this.assignTableData();
        this.destinationCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = ((SourceTableView)SourceTableView.this).cbce.x.getSelectedIndex();
                if (SourceTableView.this.destinationCombo.getSelectedIndex() <= 0) {
                    SourceTableView.this.destinationCombo.setEditable(true);
                } else {
                    SourceTableView.this.destinationCombo.setEditable(false);
                    ((SourceTableView)SourceTableView.this).cbce.x.setSelectedIndex(index);
                }
            }
        });
        this.next_Button.setEnabled(false);
        if (this.isLoadBatch) {
            this.loadSettingFromXML();
        }
    }

    public void loadSettingFromXML() {
        int size = this.odbcdlg.xmlFile.root.child.size();
        Vector<XmlElement> xmlElementVector = new Vector<XmlElement>();
        XmlElement celm = null;
        for (int i = 0; i < size; ++i) {
            celm = (XmlElement)this.odbcdlg.xmlFile.root.child.elementAt(i);
            if (!celm.name.equalsIgnoreCase("TABLE_TRANSFER")) continue;
            xmlElementVector.add(celm);
        }
        XmlElement column_mapping_element = null;
        String table_action = null;
        String s_owner = null;
        String s_name = null;
        String d_owner = null;
        String d_name = null;
        int rowCount = this.sourceTableModel.getRowCount();
        TableInfoObject stio = null;
        TableInfoObject dtio = null;
        ColumnMapTransfer cmt = null;
        for (int i = 0; i < xmlElementVector.size(); ++i) {
            XmlElement d_element;
            XmlElement element = (XmlElement)xmlElementVector.elementAt(i);
            table_action = element.getAttributeValue("TABLE_ACTION");
            XmlElement s_element = element.searchElement("SOURCE");
            if (s_element != null) {
                s_owner = s_element.getAttributeValue("TABLE_OWNER");
                s_name = s_element.getAttributeValue("TABLE_NAME");
            }
            if ((d_element = element.searchElement("DESTINATION")) != null) {
                d_owner = d_element.getAttributeValue("TABLE_OWNER");
                d_name = d_element.getAttributeValue("TABLE_NAME");
            }
            for (int j = 0; j < rowCount; ++j) {
                stio = (TableInfoObject)this.sourceTableViewTable.getValueAt(j, 1);
                dtio = (TableInfoObject)this.sourceTableViewTable.getValueAt(j, 2);
                if (!stio.toString().equalsIgnoreCase(s_element.data.trim())) continue;
                this.sourceTableModel.setValueAt(Boolean.TRUE, j, 0);
                if (!dtio.toString().equalsIgnoreCase(d_element.data.trim())) {
                    if (d_owner != null && d_name != null) {
                        dtio = new TableInfoObject(d_owner, d_name, false, "", this.odbcdlg.destinationConnection.getUserName());
                    } else {
                        String[] sA = this.getOwnerAndTable(d_element.data, this.odbcdlg.destinationDbName);
                        dtio = new TableInfoObject(sA[0], sA[1], false, "", this.odbcdlg.destinationConnection.getUserName());
                    }
                    this.sourceTableModel.setValueAt(dtio, j, 2);
                }
                DetailDialog ddlg = new DetailDialog(this.odbcdlg, true);
                cmt = dtio.owner.length() == 0 && dtio.name.length() != 0 ? new ColumnMapTransfer(ddlg, this.odbcdlg, stio, dtio, true, false) : new ColumnMapTransfer(ddlg, this.odbcdlg, stio, dtio, false, false);
                Vector<XmlElement> col_map_vector = new Vector<XmlElement>();
                for (int k = 0; k < element.child.size(); ++k) {
                    column_mapping_element = (XmlElement)element.child.elementAt(k);
                    if (!column_mapping_element.name.equalsIgnoreCase("COLUMN_MAPPING")) continue;
                    col_map_vector.add(column_mapping_element);
                }
                if (table_action.equalsIgnoreCase("create")) {
                    cmt.create_RadioButton.setSelected(true);
                    cmt.create_RadioButton.setEnabled(true);
                    cmt.delete_RadioButton.setEnabled(false);
                    cmt.append_RadioButton.setEnabled(false);
                    cmt.replace_RadioButton.setEnabled(false);
                    cmt.radioButtonValue = 1;
                } else if (table_action.equalsIgnoreCase("delete")) {
                    cmt.delete_RadioButton.setSelected(true);
                    cmt.delete_RadioButton.setEnabled(true);
                    cmt.create_RadioButton.setEnabled(false);
                    cmt.append_RadioButton.setEnabled(true);
                    cmt.replace_RadioButton.setEnabled(true);
                    cmt.radioButtonValue = (short)2;
                } else if (table_action.equalsIgnoreCase("append")) {
                    cmt.append_RadioButton.setSelected(true);
                    cmt.append_RadioButton.setEnabled(true);
                    cmt.create_RadioButton.setEnabled(false);
                    cmt.delete_RadioButton.setEnabled(true);
                    cmt.replace_RadioButton.setEnabled(true);
                    cmt.radioButtonValue = (short)3;
                } else if (table_action.equalsIgnoreCase("replace")) {
                    cmt.replace_RadioButton.setSelected(true);
                    cmt.replace_RadioButton.setEnabled(true);
                    cmt.create_RadioButton.setEnabled(false);
                    cmt.delete_RadioButton.setEnabled(true);
                    cmt.append_RadioButton.setEnabled(true);
                    cmt.radioButtonValue = (short)4;
                } else if (dtio.owner.length() == 0) {
                    cmt.create_RadioButton.setSelected(true);
                    cmt.create_RadioButton.setEnabled(true);
                    cmt.delete_RadioButton.setEnabled(false);
                    cmt.append_RadioButton.setEnabled(false);
                    cmt.replace_RadioButton.setEnabled(false);
                    cmt.radioButtonValue = 1;
                } else {
                    cmt.append_RadioButton.setSelected(true);
                    cmt.append_RadioButton.setEnabled(true);
                    cmt.create_RadioButton.setEnabled(false);
                    cmt.delete_RadioButton.setEnabled(true);
                    cmt.replace_RadioButton.setEnabled(true);
                    cmt.radioButtonValue = (short)3;
                }
                XmlElement tmp_element = null;
                ColumnInfoObject cio = null;
                String colname = null;
                String type = null;
                int precision = -100;
                int scale = -100;
                for (int k = 0; k < col_map_vector.size(); ++k) {
                    column_mapping_element = (XmlElement)col_map_vector.elementAt(k);
                    tmp_element = column_mapping_element.searchElement("SOURCE_COL");
                    if (tmp_element != null) {
                        cmt.jtable.setValueAt(tmp_element.data, k, 0);
                    }
                    if ((tmp_element = column_mapping_element.searchElement("DESTINATION_COL")) != null) {
                        colname = tmp_element.data;
                    }
                    if ((tmp_element = column_mapping_element.searchElement("TYPE")) != null) {
                        type = tmp_element.data.toLowerCase();
                    }
                    if ((tmp_element = column_mapping_element.searchElement("PRECISION")) != null) {
                        precision = tmp_element.data.trim().length() == 0 ? 10 : Integer.parseInt(tmp_element.data);
                    }
                    if ((tmp_element = column_mapping_element.searchElement("SCALE")) != null) {
                        scale = tmp_element.data.trim().length() == 0 ? 0 : Integer.parseInt(tmp_element.data);
                    }
                    if ((tmp_element = column_mapping_element.searchElement("NULLABLE")) != null) {
                        if (tmp_element.data.equalsIgnoreCase("true")) {
                            if (colname != null && type != null && precision != -100 && scale != -100) {
                                cio = new ColumnInfoObject(colname, SqlTypeDef.getDBMakerDataTypeToInt(type), precision, scale, true, false, type);
                            }
                        } else if (colname != null && type != null && precision != -100 && scale != -100) {
                            cio = new ColumnInfoObject(colname, SqlTypeDef.getDBMakerDataTypeToInt(type), precision, scale, false, false, type);
                        }
                        cmt.jtable.setValueAt(cio, k, 1);
                    }
                    colname = null;
                    type = null;
                    precision = -100;
                    scale = -100;
                }
                XmlElement transformation_element = null;
                tmp_element = element.searchElement("TRANSFORMATION");
                if (tmp_element != null) {
                    transformation_element = tmp_element.searchElement("SELECT_SQL");
                    if (transformation_element != null) {
                        cmt.select_TextPane.setText(transformation_element.data);
                        cmt.select_Str = transformation_element.data;
                    }
                    if ((transformation_element = tmp_element.searchElement("INSERT_SQL")) != null) {
                        cmt.insert_TextPane.setText(transformation_element.data);
                        cmt.insert_Str = transformation_element.data;
                    }
                }
                this.sourceTableModel.setValueAt(cmt, j, 3);
                cmt.preVector = cmt.curTransferCols.getCloneData();
            }
        }
    }

    boolean checkTargetValue() {
        int rowCount = this.sourceTableModel.getRowCount();
        boolean b = false;
        Boolean objB = null;
        int targetLen = 0;
        for (int i = 0; i < rowCount; ++i) {
            objB = (Boolean)this.sourceTableModel.getValueAt(i, 0);
            targetLen = this.sourceTableModel.getValueAt(i, 2).toString().trim().length();
            if (!objB.booleanValue() || targetLen != 0) continue;
            b = true;
            break;
        }
        return b;
    }

    public boolean checkButtonStatus() {
        int a = this.sourceTableModel.getRowCount();
        boolean status = false;
        Boolean objB = null;
        for (int b = 0; b < a; ++b) {
            objB = (Boolean)this.sourceTableModel.getValueAt(b, 0);
            if (objB.booleanValue()) {
                status = true;
                break;
            }
            if (b != a - 1) continue;
            status = false;
        }
        if (!status) {
            this.next_Button.setEnabled(false);
            this.saveButton.setEnabled(false);
        } else {
            this.next_Button.setEnabled(true);
            this.saveButton.setEnabled(true);
        }
        return status;
    }

    public void next_Button_actionPerformed(ActionEvent e) {
        this.sourceTableViewTable.editingStopped(null);
        if (!this.checkButtonStatus()) {
            GuiUt.showWarningDlg(this.odbcdlg, this.res.getString("Warning"), this.res.getString("Please_select_sometable"));
            return;
        }
        if (this.checkTargetValue()) {
            GuiUt.showWarningDlg(this.odbcdlg, this.res.getString("Warning"), this.res.getString("Please_input_newtable"));
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.next = new DetailInfo(this.odbcdlg, this);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.odbcdlg.Next(this.next);
    }

    public void cancel_Button_actionPerformed(ActionEvent e) {
        this.odbcdlg.dispose();
    }

    public void back_Button_actionPerformed(ActionEvent e) {
        this.odbcdlg.Next(this.previous);
    }

    private void checkAll() {
        if (this.checkAll.isSelected()) {
            int a = this.sourceTableModel.getRowCount();
            for (int b = 0; b < a; ++b) {
                this.sourceTableModel.setValueAt(true, b, 0);
            }
        } else {
            boolean check0 = this.checkAllTables.isSelected();
            boolean check1 = this.checkAllViews.isSelected();
            int a = this.sourceTableModel.getRowCount();
            TableInfoObject tinfo = null;
            for (int b = 0; b < a; ++b) {
                tinfo = (TableInfoObject)this.sourceTableModel.getValueAt(b, 1);
                if (!tinfo.isView()) {
                    this.sourceTableModel.setValueAt(check0, b, 0);
                    continue;
                }
                this.sourceTableModel.setValueAt(check1, b, 0);
            }
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void saveButton_actionPerformed(ActionEvent e) {
        this.sourceTableViewTable.editingStopped(null);
        if (this.checkTargetValue()) {
            GuiUt.showWarningDlg(this.odbcdlg, this.res.getString("Warning"), this.res.getString("Please_input_a_new_table"));
            return;
        }
        JFileChooser filechooser = new JFileChooser();
        filechooser.addChoosableFileFilter(new DbaFileFilter("xml", "XML Files (*.xml)"));
        int rc = filechooser.showDialog(this.odbcdlg, this.res.getString("Save_batch_file"));
        String fileName = "";
        if (rc == 0) {
            int reply;
            fileName = filechooser.getSelectedFile().toString().trim();
            String ss = null;
            if (fileName.length() <= 4) {
                fileName = fileName + ".xml";
            } else {
                ss = fileName.substring(fileName.length() - 4, fileName.length());
                if (!ss.equalsIgnoreCase(".xml")) {
                    fileName = fileName + ".xml";
                }
            }
            File f = new File(fileName);
            if (f.exists() && (reply = GuiUt.showOptionDlg(this.odbcdlg, this.res.getString("Warning"), this.res.getString("File") + " " + fileName + " " + this.res.getString("Already_exits_overwrite_it"))) != 0) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            dbalib lib = new dbalib();
            String xmlString = "<?xml version=\"1.0\" encoding=";
            int language = lib.getLicLCode();
            switch (language) {
                case 0: {
                    xmlString = xmlString + "\"ASCII\"?>\n\n";
                    break;
                }
                case 1: {
                    xmlString = xmlString + "\"BIG5\"?>\n\n";
                    break;
                }
                case 2: {
                    xmlString = xmlString + "\"Shift_JIS\"?>\n\n";
                    break;
                }
                case 3: {
                    xmlString = xmlString + "\"GB2312\"?>\n\n";
                    break;
                }
                case 4: {
                    xmlString = xmlString + "\"ISO8859_1\"?>\n\n";
                    break;
                }
                case 5: {
                    xmlString = xmlString + "\"ISO8859_2\"?>\n\n";
                    break;
                }
                case 6: {
                    xmlString = xmlString + "\"ISO8859_5\"?>\n\n";
                    break;
                }
                case 7: {
                    xmlString = xmlString + "\"ISO8859_7\"?>\n\n";
                    break;
                }
                case 8: {
                    xmlString = xmlString + "\"EUC\"?>\n\n";
                    break;
                }
                case 9: {
                    xmlString = xmlString + "\"GB18030\"?>\n\n";
                    break;
                }
                case 10: {
                    xmlString = xmlString + "\"UTF-8\"?>\n\n";
                }
            }
            try {
                FileWriter fw = new FileWriter(fileName);
                this.odbcdlg.WriteFileContent(fw, 0, xmlString);
                xmlString = "";
                String dbbrand = "DBMAKER";
                if (!LocaleManager.getIsDBMaker()) {
                    dbbrand = "DBMASTER";
                }
                xmlString = "<" + dbbrand + "_DATATRANSFER STYLE=\"IMPORT_ODBC\" SOURCE_DB=\"" + this.odbcdlg.sourceDbName + "\" SOURCE_ID=\"" + this.odbcdlg.sourceUserID + "\" DESTINATION_DB=\"" + this.odbcdlg.destinationDbName + "\" DESTINATION_ID=\"" + this.odbcdlg.destinationUserID + "\">\n";
                this.odbcdlg.WriteFileContent(fw, 0, xmlString);
                xmlString = "";
                xmlString = "<TRANSFER_SETTING TYPE=\"";
                xmlString = xmlString + "TABLE_TYPE\"/>\n";
                this.odbcdlg.WriteFileContent(fw, 4, xmlString);
                xmlString = "";
                int rowCount = this.sourceTableViewTable.getRowCount();
                ColumnMapTransfer cmt = null;
                Boolean objB = null;
                TableInfoObject stio = null;
                TableInfoObject dtio = null;
                for (int i = 0; i < rowCount; ++i) {
                    objB = (Boolean)this.sourceTableViewTable.getValueAt(i, 0);
                    if (!objB.booleanValue()) continue;
                    stio = (TableInfoObject)this.sourceTableViewTable.getValueAt(i, 1);
                    dtio = (TableInfoObject)this.sourceTableViewTable.getValueAt(i, 2);
                    cmt = (ColumnMapTransfer)this.sourceTableViewTable.getValueAt(i, 3);
                    if (cmt == null) {
                        DetailDialog ddlg = new DetailDialog(this.odbcdlg, true);
                        cmt = dtio.owner.length() == 0 && dtio.name.length() != 0 ? new ColumnMapTransfer(ddlg, this.odbcdlg, stio, dtio, true, false) : new ColumnMapTransfer(ddlg, this.odbcdlg, stio, dtio, false, false);
                        this.sourceTableViewTable.setValueAt(cmt, i, 3);
                    }
                    xmlString = "";
                    xmlString = "<TABLE_TRANSFER TABLE_ACTION=\"";
                    xmlString = cmt.create_RadioButton.isSelected() ? xmlString + "CREATE\">\n" : (cmt.delete_RadioButton.isSelected() ? xmlString + "DELETE\">\n" : (cmt.append_RadioButton.isSelected() ? xmlString + "APPEND\">\n" : xmlString + "REPLACE\">\n"));
                    this.odbcdlg.WriteFileContent(fw, 4, xmlString);
                    xmlString = "";
                    xmlString = "<SOURCE TABLE_OWNER=\"" + stio.owner + "\" TABLE_NAME=\"" + stio.name + "\">" + cmt.sourceTableInfo_TextField.getText().trim() + "</SOURCE>\n";
                    this.odbcdlg.WriteFileContent(fw, 8, xmlString);
                    xmlString = "";
                    xmlString = dtio.owner.trim().length() == 0 ? "<DESTINATION TABLE_NAME=\"" + dtio.name.trim() + "\">" + dtio.name.trim() + "</DESTINATION>\n" : "<DESTINATION TABLE_OWNER=\"" + dtio.owner.trim() + "\" TABLE_NAME=\"" + dtio.name.trim() + "\">" + cmt.destinationTableInfo_TextField.getText().trim() + "</DESTINATION>\n";
                    this.odbcdlg.WriteFileContent(fw, 8, xmlString);
                    xmlString = "";
                    int cmtRowCount = cmt.jtable.getRowCount();
                    for (int j = 0; j < cmtRowCount; ++j) {
                        xmlString = "<COLUMN_MAPPING>\n";
                        this.odbcdlg.WriteFileContent(fw, 8, xmlString);
                        xmlString = "";
                        xmlString = "<SOURCE_COL>" + cmt.jtable.getValueAt(j, 0).toString().trim() + "</SOURCE_COL>\n";
                        this.odbcdlg.WriteFileContent(fw, 12, xmlString);
                        xmlString = "";
                        xmlString = "<DESTINATION_COL>" + cmt.jtable.getValueAt(j, 1).toString().trim() + "</DESTINATION_COL>\n";
                        this.odbcdlg.WriteFileContent(fw, 12, xmlString);
                        xmlString = "";
                        xmlString = "<TYPE>" + cmt.jtable.getValueAt(j, 2).toString().trim() + "</TYPE>\n";
                        this.odbcdlg.WriteFileContent(fw, 12, xmlString);
                        xmlString = "";
                        xmlString = "<PRECISION>" + cmt.jtable.getValueAt(j, 3).toString().trim() + "</PRECISION>\n";
                        this.odbcdlg.WriteFileContent(fw, 12, xmlString);
                        xmlString = "";
                        xmlString = "<SCALE>" + cmt.jtable.getValueAt(j, 4).toString().trim() + "</SCALE>\n";
                        this.odbcdlg.WriteFileContent(fw, 12, xmlString);
                        xmlString = "";
                        xmlString = "<NULLABLE>" + cmt.jtable.getValueAt(j, 5).toString().trim() + "</NULLABLE>\n";
                        this.odbcdlg.WriteFileContent(fw, 12, xmlString);
                        xmlString = "";
                        xmlString = "</COLUMN_MAPPING>\n";
                        this.odbcdlg.WriteFileContent(fw, 8, xmlString);
                    }
                    xmlString = "";
                    if (cmt.select_TextPane.getText().trim().length() != 0 || cmt.insert_TextPane.getText().trim().length() != 0) {
                        xmlString = "<TRANSFORMATION>\n";
                        this.odbcdlg.WriteFileContent(fw, 8, xmlString);
                        if (cmt.select_TextPane.getText().trim().length() != 0) {
                            xmlString = "";
                            xmlString = "<SELECT_SQL>" + cmt.select_TextPane.getText().trim() + "</SELECT_SQL>\n";
                            this.odbcdlg.WriteFileContent(fw, 12, xmlString);
                        }
                        if (cmt.insert_TextPane.getText().trim().length() != 0) {
                            xmlString = "";
                            xmlString = "<INSERT_SQL>" + cmt.insert_TextPane.getText().trim() + "</INSERT_SQL>\n";
                            this.odbcdlg.WriteFileContent(fw, 12, xmlString);
                        }
                        xmlString = "";
                        xmlString = "</TRANSFORMATION>\n";
                        this.odbcdlg.WriteFileContent(fw, 8, xmlString);
                    }
                    xmlString = "";
                    xmlString = "</TABLE_TRANSFER>\n";
                    this.odbcdlg.WriteFileContent(fw, 4, xmlString);
                }
                xmlString = "";
                xmlString = "</" + dbbrand + "_DATATRANSFER>\n";
                this.odbcdlg.WriteFileContent(fw, 0, xmlString);
                fw.close();
                GuiUt.showInformationDlg(this.odbcdlg, this.res.getString("Save") + " " + fileName + "  " + this.res.getString("successfully"));
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            catch (IOException ioe) {
                GuiUt.showErrorDlg(this.odbcdlg, ioe.getMessage(), null);
                return;
            }
        }
    }

    private TableInfoObject autoMapSource2Destination(TableInfoObject stio) {
        TableInfoObject dtio = null;
        int destination_count = this.destinationCombo.getItemCount();
        boolean b = false;
        for (int i = 1; i < destination_count; ++i) {
            dtio = (TableInfoObject)this.destinationCombo.getItemAt(i);
            if (!stio.getName().equalsIgnoreCase(dtio.getName()) || !this.odbcdlg.destSchema.equalsIgnoreCase(dtio.getOwner())) continue;
            b = true;
            break;
        }
        if (!b) {
            dtio = (TableInfoObject)this.destinationCombo.getItemAt(0);
        }
        return dtio;
    }

    private void assignTableData() {
        TableInfoObject stio = null;
        TableInfoObject tio = null;
        int source_count = this.sourceCombo.getItemCount();
        for (int i = 0; i < source_count; ++i) {
            stio = (TableInfoObject)this.sourceCombo.getItemAt(i);
            tio = this.autoMapSource2Destination(stio);
            Object[] oa = new Object[]{Boolean.FALSE, stio, tio, null};
            this.sourceTableModel.addValue(oa);
        }
    }

    private void assignTableName(DatabaseMetaData dbmd, boolean isSource) {
        ResultSet dbmdrs = null;
        Vector<TableInfoObject> v = new Vector<TableInfoObject>();
        String schema = "";
        String owner = "";
        String table = "";
        String type = "";
        TableInfoObject tio = null;
        try {
            dbmdrs = this.odbcdlg.brand == odbcDialog.Brand.MYSQL ? dbmd.getTables(this.odbcdlg.sourceSchema, null, null, null) : dbmd.getTables(null, this.odbcdlg.sourceSchema, null, null);
            while (dbmdrs.next()) {
                schema = dbmdrs.getString(1);
                owner = dbmdrs.getString(2);
                table = dbmdrs.getString(3);
                type = dbmdrs.getString(4);
                if (this.odbcdlg.isDBMaker()) {
                    if (type.equals("TABLE")) {
                        tio = new TableInfoObject(schema, owner, table, false, type, this.odbcdlg.sourceConnection.getUserName());
                    } else if (type.equals("VIEW")) {
                        tio = new TableInfoObject(schema, owner, table, false, type, this.odbcdlg.sourceConnection.getUserName());
                    }
                } else if (type.equals("TABLE") || type.equals("SYSTEM TABLE")) {
                    tio = new TableInfoObject(schema, owner, table, false, type, this.odbcdlg.sourceConnection.getUserName());
                } else if (type.equals("VIEW")) {
                    tio = new TableInfoObject(schema, owner, table, false, type, this.odbcdlg.sourceConnection.getUserName());
                }
                if (tio != null) {
                    v.add(tio);
                }
                tio = null;
            }
            dbmdrs.close();
            if (!isSource) {
                tio = new TableInfoObject("", "", false, "", this.odbcdlg.destinationConnection.getUserName());
                v.insertElementAt(tio, 0);
                DefaultComboBoxModel cbm = new DefaultComboBoxModel(v);
                this.destinationCombo.setModel(cbm);
            } else {
                DefaultComboBoxModel cbm = new DefaultComboBoxModel(v);
                this.sourceCombo.setModel(cbm);
                if (v.size() != 0) {
                    this.sourceCombo.setSelectedIndex(0);
                }
            }
        }
        catch (SQLException exc) {
            GuiUt.showSQLException(this.odbcdlg, null, exc);
            DbaObject.close(dbmdrs);
        }
    }

    private void assignTableName(Connection connection, boolean isSource) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            DefaultDataTransferAuthority authority = new DefaultDataTransferAuthority(this.odbcdlg.destinationConnection);
            String query = null;
            if (authority.isAboveDba()) {
                query = "SELECT TABLE_OWNER, TABLE_NAME, TABLE_TYPE FROM SYSTABLE WHERE TABLE_TYPE = 'TABLE' ORDER BY TABLE_OWNER, TABLE_NAME ";
            } else if (authority.isResource()) {
                query = "SELECT TABLE_OWNER, TABLE_NAME, TABLE_TYPE FROM SYSTABLE WHERE TABLE_OWNER='" + this.odbcdlg.destinationConnection.getUserName() + "' OR EXISTS(SELECT TABLE_NAME FROM SYSAUTHTABLE " + "WHERE  TABLE_OWNER=SYSTABLE.TABLE_OWNER AND TABLE_NAME=SYSTABLE.TABLE_NAME " + "AND (INS_ALL<>0 OR INS<>0))" + "ORDER BY TABLE_OWNER, TABLE_NAME";
            } else if (authority.isConnect()) {
                query = "SELECT TABLE_OWNER, TABLE_NAME, TABLE_TYPE FROM SYSTABLE WHERE EXISTS(SELECT TABLE_NAME FROM SYSAUTHTABLE WHERE TABLE_OWNER=SYSTABLE.TABLE_OWNER AND TABLE_NAME=SYSTABLE.TABLE_NAME AND (INS_ALL<>0 OR INS<>0))ORDER BY TABLE_OWNER, TABLE_NAME";
            }
            rs = stmt.executeQuery(query);
            Vector<TableInfoObject> v = new Vector<TableInfoObject>();
            TableInfoObject tio = null;
            while (rs.next()) {
                String owner = rs.getString(1).trim();
                String table = rs.getString(2).trim();
                String type = rs.getString(3).trim();
                tio = type.equals("TABLE") ? new TableInfoObject(owner, table, false, type, this.odbcdlg.destinationConnection.getUserName()) : new TableInfoObject(owner, table, false, type, this.odbcdlg.destinationConnection.getUserName());
                v.add(tio);
                tio = null;
            }
            if (!isSource) {
                tio = new TableInfoObject("", "", false, "", this.odbcdlg.destinationConnection.getUserName());
                v.insertElementAt(tio, 0);
                DefaultComboBoxModel cbm = new DefaultComboBoxModel(v);
                this.destinationCombo.setModel(cbm);
            } else {
                DefaultComboBoxModel cbm = new DefaultComboBoxModel(v);
                this.sourceCombo.setModel(cbm);
                this.sourceCombo.setSelectedIndex(0);
            }
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(this.odbcdlg, null, sqle);
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
    }

    public String[] getOwnerAndTable(String total, String owner) {
        String myTblName;
        String myOwner;
        String[] sA = new String[2];
        int startdot = 0;
        int end = 0;
        int other = 0;
        startdot = total.indexOf(".");
        if (total.startsWith("\"")) {
            myOwner = "";
            myTblName = total.substring(1, total.length() - 1);
        } else {
            other = total.indexOf("\"");
            end = total.length();
            startdot = total.indexOf(".");
            if (other > 0) {
                myOwner = total.substring(0, startdot);
                myTblName = total.substring(other + 1, end - 1);
            } else if (startdot > 0) {
                myOwner = total.substring(0, startdot);
                myTblName = total.substring(startdot + 1, end);
            } else {
                myOwner = "";
                myTblName = total;
            }
        }
        sA[0] = myOwner;
        sA[1] = myTblName;
        return sA;
    }
}

