/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importODBC;

import datatransfer.DataTransferFrame;
import datatransfer.HelpButton;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.EmptyPanel;
import dbaut.CommonUt.WizardTextArea;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dttwizard.importODBC.ForeignKeyInfo;
import dttwizard.importODBC.IndexInfo;
import dttwizard.importODBC.PrimaryKeyInfo;
import dttwizard.importODBC.PrimaryKeyProcess;
import dttwizard.importODBC.odbcDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class PrimaryKeyView
extends AbstractWizardPanel {
    private static final long serialVersionUID = 1L;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Import.dtt_ImportOdbcRes", LocaleManager.getLocale());
    private String title = this.res.getString("Page_title_primarykeyview");
    private odbcDialog odbcdlg = null;
    private AbstractWizardPanel next = null;
    private DbaButton next_Button = new DbaButton(new Dimension(100, 24), false, this.res.getString("Execute"), 'E', DBAImageResource.getResource(this.getClass(), "/dbautimages/execute.gif"), new ReflectionAction(this, "next_Button_actionPerformed"));
    private PrimaryKeyTableModel pkTableModel = new PrimaryKeyTableModel();
    JTable pkViewTable = new JTable(this.pkTableModel);
    JCheckBox checkAll = new JCheckBox(this.res.getString("All"));
    private ArrayList<PrimaryKeyInfo> pkList = null;
    private ArrayList<IndexInfo> indexList = null;
    private ArrayList<ForeignKeyInfo> fkList = null;

    public PrimaryKeyView(odbcDialog odbcdlg, ArrayList<PrimaryKeyInfo> pkList, ArrayList<IndexInfo> indexList, ArrayList<ForeignKeyInfo> fkList) {
        try {
            this.odbcdlg = odbcdlg;
            this.pkList = pkList;
            this.indexList = indexList;
            this.fkList = fkList;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        DbaButton cancel_Button = new DbaButton(this.res.getString("Cancel"), 'C', new ReflectionAction(this, "cancel_Button_actionPerformed"));
        HelpButton help_Button = new HelpButton();
        this.checkAll.setMnemonic('A');
        this.checkAll.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PrimaryKeyView.this.checkAll();
            }
        });
        WizardTextArea area1 = new WizardTextArea(this.title, this.res.getString("Please_select_primarykeyview"));
        JScrollPane jscroll2 = new JScrollPane(this.pkViewTable);
        cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        jscroll2.setVerticalScrollBarPolicy(20);
        this.pkViewTable.setBorder(BorderFactory.createLoweredBevelBorder());
        this.pkViewTable.setRowHeight(24);
        JPanel panel4 = new JPanel(new FlowLayout(2));
        panel4.add(this.next_Button);
        panel4.add(new EmptyPanel());
        panel4.add(cancel_Button);
        panel4.add(help_Button);
        JPanel panel10 = new JPanel(new FlowLayout(0));
        panel10.add(this.checkAll);
        JPanel panel6 = new JPanel(new BorderLayout());
        panel6.add((Component)jscroll2, "Center");
        panel6.add((Component)panel10, "South");
        this.setImage(DBAImageResource.getResource(this.getClass(), "/dttimages/ImportODBC.jpg"));
        this.setButtonBar(panel4);
        this.setTextArea(area1);
        this.setContent(panel6);
        DataTransferFrame.enableDialogHelp(this, help_Button, "wizard_ImportODBC_from_tables", null);
        TableColumnModel tcsourceTableModel = this.pkViewTable.getColumnModel();
        TableColumn col = tcsourceTableModel.getColumn(0);
        col.setPreferredWidth(30);
        col = tcsourceTableModel.getColumn(1);
        col.setPreferredWidth(200);
        col = tcsourceTableModel.getColumn(2);
        col.setPreferredWidth(200);
        this.next_Button.setEnabled(false);
    }

    public boolean checkButtonStatus() {
        int a = this.pkTableModel.getRowCount();
        boolean status = false;
        Boolean objB = null;
        for (int b = 0; b < a; ++b) {
            objB = (Boolean)this.pkTableModel.getValueAt(b, 0);
            if (objB.booleanValue()) {
                status = true;
                break;
            }
            if (b != a - 1) continue;
            status = false;
        }
        if (!status) {
            this.next_Button.setEnabled(false);
        } else {
            this.next_Button.setEnabled(true);
        }
        return status;
    }

    public void next_Button_actionPerformed(ActionEvent e) {
        this.pkViewTable.editingStopped(null);
        if (!this.checkButtonStatus()) {
            GuiUt.showWarningDlg(this.odbcdlg, this.res.getString("Warning"), this.res.getString("Please_select_sometable"));
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        ArrayList<PrimaryKeyInfo> list = new ArrayList<PrimaryKeyInfo>();
        for (PrimaryKeyInfo info : this.pkList) {
            if (!info.create) continue;
            list.add(info);
        }
        ArrayList<IndexInfo> list2 = new ArrayList<IndexInfo>();
        for (IndexInfo info : this.indexList) {
            if (!info.create) continue;
            list2.add(info);
        }
        this.next = new PrimaryKeyProcess(this.odbcdlg, this, list, list2, this.fkList);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.odbcdlg.Next(this.next);
    }

    public void cancel_Button_actionPerformed(ActionEvent e) {
        this.odbcdlg.dispose();
    }

    private void checkAll() {
        boolean value = this.checkAll.isSelected();
        int a = this.pkTableModel.getRowCount();
        for (int b = 0; b < a; ++b) {
            this.pkTableModel.setValueAt(value, b, 0);
        }
        this.pkTableModel.fireTableChanged(new TableModelEvent(this.pkTableModel));
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    class PrimaryKeyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private String[] header;

        public PrimaryKeyTableModel() {
            this.header = new String[]{"", PrimaryKeyView.this.res.getString("Table"), PrimaryKeyView.this.res.getString("IndexName"), PrimaryKeyView.this.res.getString("Columns")};
        }

        @Override
        public String getColumnName(int col) {
            return this.header[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (row < PrimaryKeyView.this.pkList.size()) {
                PrimaryKeyInfo info = (PrimaryKeyInfo)PrimaryKeyView.this.pkList.get(row);
                if (col == 0) {
                    info.create = (Boolean)value;
                }
            } else {
                IndexInfo info = (IndexInfo)PrimaryKeyView.this.indexList.get(row - PrimaryKeyView.this.pkList.size());
                if (col == 0) {
                    info.create = (Boolean)value;
                }
            }
            PrimaryKeyView.this.checkButtonStatus();
        }

        @Override
        public int getColumnCount() {
            return this.header.length;
        }

        @Override
        public int getRowCount() {
            return PrimaryKeyView.this.pkList.size() + PrimaryKeyView.this.indexList.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < PrimaryKeyView.this.pkList.size()) {
                PrimaryKeyInfo info = (PrimaryKeyInfo)PrimaryKeyView.this.pkList.get(row);
                switch (col) {
                    case 0: {
                        return info.create;
                    }
                    case 1: {
                        return info.getTableName();
                    }
                    case 2: {
                        return "Primary Key";
                    }
                    case 3: {
                        return info.getColumns();
                    }
                }
                return null;
            }
            IndexInfo info = (IndexInfo)PrimaryKeyView.this.indexList.get(row - PrimaryKeyView.this.pkList.size());
            switch (col) {
                case 0: {
                    return info.create;
                }
                case 1: {
                    return info.getTableName();
                }
                case 2: {
                    return info.getIndexName();
                }
                case 3: {
                    return info.getColumns();
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }
    }
}

