/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importODBC;

import datatransfer.DataTransferFrame;
import datatransfer.HelpButton;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.CheckingStatusRenderer;
import dbaut.CommonUt.EmptyPanel;
import dbaut.CommonUt.WizardTextArea;
import dbaut.GuiUt;
import dbaut.alarm.Alarm2;
import dbaut.alarm.Sleeper;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dttwizard.importODBC.ForeignKeyInfo;
import dttwizard.importODBC.ForeignKeyView;
import dttwizard.importODBC.IndexInfo;
import dttwizard.importODBC.PrimaryKeyInfo;
import dttwizard.importODBC.odbcDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class PrimaryKeyProcess
extends AbstractWizardPanel
implements Sleeper {
    private static final long serialVersionUID = 4647430821231493167L;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Import.dtt_ImportOdbcRes", LocaleManager.getLocale());
    private String title = this.res.getString("Page_title_primarykeyprocess");
    private odbcDialog odbcdlg = null;
    private AbstractWizardPanel previous = null;
    private DbaButton next_Button = new DbaButton(this.res.getString("Done"), 'D', new ReflectionAction(this, "next_Button_actionPerformed"));
    private PrimaryKeyTableModel pkTableModel = new PrimaryKeyTableModel();
    JTable pkViewTable = new JTable(this.pkTableModel);
    ArrayList<PrimaryKeyInfo> pkList = null;
    ArrayList<ForeignKeyInfo> fkList = null;
    ArrayList<IndexInfo> indexList = null;
    private Alarm2 clock = null;

    public PrimaryKeyProcess(odbcDialog odbcdlg, AbstractWizardPanel previous, ArrayList<PrimaryKeyInfo> pkList, ArrayList<IndexInfo> indexList, ArrayList<ForeignKeyInfo> fkList) {
        try {
            this.odbcdlg = odbcdlg;
            this.previous = previous;
            this.pkList = pkList;
            this.indexList = indexList;
            this.fkList = fkList;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        DbaButton back_Button = new DbaButton(this.res.getString("Previous"), 'P', new ReflectionAction(this, "back_Button_actionPerformed"));
        DbaButton cancel_Button = new DbaButton(this.res.getString("Cancel"), 'C', new ReflectionAction(this, "cancel_Button_actionPerformed"));
        HelpButton help_Button = new HelpButton();
        WizardTextArea area1 = new WizardTextArea(this.title, this.res.getString(""));
        JScrollPane jscroll2 = new JScrollPane(this.pkViewTable);
        back_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"));
        cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        jscroll2.setVerticalScrollBarPolicy(20);
        this.pkViewTable.setBorder(BorderFactory.createLoweredBevelBorder());
        this.pkViewTable.setRowHeight(24);
        JPanel panel4 = new JPanel(new FlowLayout(2));
        panel4.add(back_Button);
        panel4.add(this.next_Button);
        panel4.add(new EmptyPanel());
        panel4.add(cancel_Button);
        panel4.add(help_Button);
        JPanel panel10 = new JPanel(new FlowLayout(0));
        panel10.add(new EmptyPanel(new Dimension(160, 0)));
        JPanel panel6 = new JPanel(new BorderLayout());
        panel6.add((Component)jscroll2, "Center");
        panel6.add((Component)panel10, "South");
        this.setImage(DBAImageResource.getResource(this.getClass(), "/dttimages/ImportODBC.jpg"));
        this.setButtonBar(panel4);
        this.setTextArea(area1);
        this.setContent(panel6);
        DataTransferFrame.enableDialogHelp(this, help_Button, "wizard_ImportODBC_from_tables", null);
        TableColumnModel tcsourceTableModel = this.pkViewTable.getColumnModel();
        TableColumn col = tcsourceTableModel.getColumn(0);
        col.setPreferredWidth(50);
        col.setCellRenderer(new CheckingStatusRenderer());
        col = tcsourceTableModel.getColumn(1);
        col.setPreferredWidth(200);
        col = tcsourceTableModel.getColumn(2);
        col.setPreferredWidth(200);
        this.clock = new Alarm2();
        this.setTimer();
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (this.fkList.size() > 0) {
            this.next_Button.setText(this.res.getString("Next"));
            this.next_Button.setMnemonic('N');
            this.next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/next.gif"));
        }
        this.next_Button.setEnabled(false);
    }

    public void setTimer() {
        this.clock.cancelAlarm(this);
        this.clock.setAlarm(this, 1L);
    }

    public void next_Button_actionPerformed(ActionEvent e) {
        if (this.fkList != null && this.fkList.size() > 0) {
            this.odbcdlg.Next(new ForeignKeyView(this.odbcdlg, this.fkList));
        } else {
            this.odbcdlg.dispose();
        }
    }

    public void cancel_Button_actionPerformed(ActionEvent e) {
        this.odbcdlg.dispose();
    }

    public void back_Button_actionPerformed(ActionEvent e) {
        this.odbcdlg.Next(this.previous);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    private void doJob() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Connection conn = this.odbcdlg.destinationConnection.getDbConnection();
        try {
            boolean first;
            String sql;
            Statement stmt = conn.createStatement();
            for (PrimaryKeyInfo primaryKeyInfo : this.pkList) {
                sql = "alter table ";
                if (primaryKeyInfo.owner != null) {
                    sql = sql + GuiUt.getIDString(primaryKeyInfo.owner) + ".";
                }
                sql = sql + GuiUt.getIDString(primaryKeyInfo.name);
                sql = sql + " primary key (";
                first = true;
                for (String column : primaryKeyInfo.columns) {
                    if (first) {
                        sql = sql + column;
                        first = false;
                        continue;
                    }
                    sql = sql + "," + column;
                }
                sql = sql + ")";
                try {
                    stmt.executeUpdate(sql);
                    primaryKeyInfo.result.value = 2;
                }
                catch (SQLException e) {
                    primaryKeyInfo.result.value = 4;
                    primaryKeyInfo.result.message = sql + e.getMessage();
                }
                this.pkTableModel.fireTableChanged(new TableModelEvent(this.pkTableModel));
            }
            for (IndexInfo indexInfo : this.indexList) {
                sql = indexInfo.isUnique ? "create unique index " + GuiUt.getIDString(indexInfo.index_name) + " on " : "create index " + GuiUt.getIDString(indexInfo.index_name) + " on ";
                if (indexInfo.tb_owner != null) {
                    sql = sql + GuiUt.getIDString(indexInfo.tb_owner) + ".";
                }
                sql = sql + GuiUt.getIDString(indexInfo.tb_name);
                sql = sql + " (";
                first = true;
                sql = sql + indexInfo.getColumns();
                sql = sql + ")";
                try {
                    stmt.executeUpdate(sql);
                    indexInfo.result.value = 2;
                }
                catch (SQLException e) {
                    indexInfo.result.value = 4;
                    indexInfo.result.message = sql + e.getMessage();
                }
                this.pkTableModel.fireTableChanged(new TableModelEvent(this.pkTableModel));
            }
            stmt.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.next_Button.setEnabled(true);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public synchronized void wakeUp() {
        this.clock.cancelAlarm(this);
        this.doJob();
        if (this.pkList.size() <= 0) {
            if (this.odbcdlg.sourceConnection != null && this.odbcdlg.sourceConnection.isConnected()) {
                this.odbcdlg.sourceConnection.disconnect();
            }
            if (this.odbcdlg.destinationConnection != null && this.odbcdlg.destinationConnection.isConnected()) {
                this.odbcdlg.destinationConnection.disconnect();
            }
            this.odbcdlg.sourceConnection = null;
            this.odbcdlg.destinationConnection = null;
        }
    }

    class PrimaryKeyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private String[] header;

        public PrimaryKeyTableModel() {
            this.header = new String[]{"", PrimaryKeyProcess.this.res.getString("Table"), PrimaryKeyProcess.this.res.getString("IndexName"), PrimaryKeyProcess.this.res.getString("Columns")};
        }

        @Override
        public String getColumnName(int col) {
            return this.header[col];
        }

        @Override
        public int getColumnCount() {
            return this.header.length;
        }

        @Override
        public int getRowCount() {
            return PrimaryKeyProcess.this.pkList.size() + PrimaryKeyProcess.this.indexList.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < PrimaryKeyProcess.this.pkList.size()) {
                PrimaryKeyInfo info = PrimaryKeyProcess.this.pkList.get(row);
                switch (col) {
                    case 0: {
                        return info.result;
                    }
                    case 1: {
                        return info.getTableName();
                    }
                    case 2: {
                        return "Primary Key";
                    }
                    case 3: {
                        return info.getColumns();
                    }
                }
                return null;
            }
            IndexInfo info = PrimaryKeyProcess.this.indexList.get(row - PrimaryKeyProcess.this.pkList.size());
            switch (col) {
                case 0: {
                    return info.result;
                }
                case 1: {
                    return info.getTableName();
                }
                case 2: {
                    return info.getIndexName();
                }
                case 3: {
                    return info.getColumns();
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }
    }
}

