/*
 * Decompiled with CFR 0.152.
 */
package dbaut.textField;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JFormattedTextField;
import javax.swing.text.MaskFormatter;

public class TimeField
extends JFormattedTextField {
    static MaskFormatter TIMEFORMAT = null;

    public TimeField() {
        super(TIMEFORMAT);
        this.setTimeToNow();
    }

    private void setTimeToNow() {
        this.setTimeToNow(0);
    }

    public void setTimeToNow(int offset_minute) {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, offset_minute);
        String formattedTime = formatter.format(calendar.getTime());
        this.setText(formattedTime);
    }

    public void setTime(String text) {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        String formattedTime = formatter.format(text);
        this.setText(formattedTime);
    }

    static {
        try {
            TIMEFORMAT = new MaskFormatter("##:##:##");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        TIMEFORMAT.setPlaceholderCharacter('_');
    }
}

