/*
 * Decompiled with CFR 0.152.
 */
package dbaut.textField;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.NumberFormatter;

class CalendarDialog
extends JDialog {
    private JSpinner monthSpinner;
    private JSpinner yearSpinner;
    private JPanel calendarPanel;
    private JButton[][] dayButtons;
    private Date selectedDate;

    public CalendarDialog(JDialog parent) {
        super(parent, "Choose a Date", true);
        String[] days;
        this.setLayout(new BorderLayout());
        Calendar cal = Calendar.getInstance();
        this.monthSpinner = this.createMonthSpinner(cal.get(2) + 1);
        this.yearSpinner = this.createYearSpinner(cal.get(1));
        JPanel topPanel = new JPanel();
        topPanel.add(this.monthSpinner);
        topPanel.add(new JLabel("Month"));
        topPanel.add(this.yearSpinner);
        topPanel.add(new JLabel("Year"));
        this.add((Component)topPanel, "North");
        this.calendarPanel = new JPanel(new GridLayout(7, 7));
        this.dayButtons = new JButton[6][7];
        for (String day : days = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"}) {
            this.calendarPanel.add(new JLabel(day, 0));
        }
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.dayButtons[i][j] = new JButton();
                this.dayButtons[i][j].setMargin(new Insets(1, 1, 1, 1));
                this.dayButtons[i][j].setEnabled(false);
                this.calendarPanel.add(this.dayButtons[i][j]);
                final int row = i;
                final int col = j;
                this.dayButtons[i][j].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Calendar cal = Calendar.getInstance();
                        cal.set(1, (Integer)CalendarDialog.this.yearSpinner.getValue());
                        cal.set(2, (Integer)CalendarDialog.this.monthSpinner.getValue() - 1);
                        cal.set(5, Integer.parseInt(CalendarDialog.this.dayButtons[row][col].getText()));
                        CalendarDialog.this.selectedDate = cal.getTime();
                        CalendarDialog.this.setVisible(false);
                    }
                });
            }
        }
        this.add((Component)this.calendarPanel, "Center");
        this.monthSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CalendarDialog.this.updateCalendar();
            }
        });
        this.yearSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CalendarDialog.this.updateCalendar();
            }
        });
        this.updateCalendar();
        this.setSize(400, 300);
        this.setLocationRelativeTo(parent);
    }

    private JSpinner createYearSpinner(int currentYear) {
        NumberFormat format = NumberFormat.getIntegerInstance();
        format.setGroupingUsed(false);
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Integer.class);
        formatter.setAllowsInvalid(false);
        formatter.setCommitsOnValidEdit(true);
        JFormattedTextField textField = new JFormattedTextField(formatter);
        textField.setFocusLostBehavior(3);
        JSpinner spinner = new JSpinner(new SpinnerNumberModel(currentYear, 1900, 2100, 1));
        spinner.setEditor(new JSpinner.NumberEditor(spinner, "#"));
        ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setFormatterFactory(textField.getFormatterFactory());
        return spinner;
    }

    private JSpinner createMonthSpinner(int currentMonth) {
        NumberFormat format = NumberFormat.getIntegerInstance();
        format.setGroupingUsed(false);
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Integer.class);
        formatter.setMinimum(Integer.valueOf(1));
        formatter.setMaximum(Integer.valueOf(12));
        formatter.setAllowsInvalid(false);
        formatter.setCommitsOnValidEdit(true);
        JFormattedTextField textField = new JFormattedTextField(formatter);
        JSpinner spinner = new JSpinner(new SpinnerNumberModel(currentMonth, 1, 12, 1));
        spinner.setEditor(new JSpinner.NumberEditor(spinner, "#"));
        ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setFormatterFactory(textField.getFormatterFactory());
        return spinner;
    }

    private void updateCalendar() {
        Calendar cal = Calendar.getInstance();
        int currentDay = cal.get(5);
        cal.set(1, (Integer)this.yearSpinner.getValue());
        cal.set(2, (Integer)this.monthSpinner.getValue() - 1);
        cal.set(5, 1);
        int startDay = cal.get(7);
        int daysInMonth = cal.getActualMaximum(5);
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.dayButtons[i][j].setText("");
                this.dayButtons[i][j].setEnabled(false);
            }
        }
        int day = 1;
        JComponent todayButton = null;
        for (int i = startDay - 1; i < startDay - 1 + daysInMonth; ++i) {
            int row = i / 7;
            int col = i % 7;
            this.dayButtons[row][col].setText(String.valueOf(day));
            this.dayButtons[row][col].setEnabled(true);
            if (day == currentDay && cal.get(2) == Calendar.getInstance().get(2) && cal.get(1) == Calendar.getInstance().get(1)) {
                todayButton = this.dayButtons[row][col];
            }
            ++day;
        }
        if (todayButton != null) {
            todayButton.requestFocus();
        }
    }

    public Date getSelectedDate() {
        return this.selectedDate;
    }
}

