/*
 * Decompiled with CFR 0.152.
 */
package dbaut.boundaryValue;

import dbaut.boundaryValue.BoundaryItem;
import java.util.Date;

public class BoundaryInterval
extends BoundaryItem {
    private String strMin = null;
    private String strMax = null;
    private String strDefault = null;
    private boolean canBeNull = false;

    public BoundaryInterval(String strMin, String strMax, String strDefault, boolean canBeNull) {
        this.setStrMin(strMin);
        this.setStrMax(strMax);
        this.setStrDefault(strDefault);
        this.setCanBeNull(canBeNull);
    }

    @Override
    public boolean checkValue(Object value) {
        boolean x_ret = false;
        try {
            String strValue = (String)value;
            if (strValue != null && strValue.trim().length() != 0) {
                String[] arrStrValue = strValue.split("-");
                String[] arrStrMax = this.strMax.split("-");
                String[] arrStrMin = this.strMin.split("-");
                if (Long.parseLong(arrStrValue[0]) >= Long.parseLong(arrStrMin[0]) && Long.parseLong(arrStrValue[0]) <= Long.parseLong(arrStrMax[0]) && this.checkTime(arrStrValue[1], arrStrMin[1], arrStrMax[1])) {
                    x_ret = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return x_ret;
    }

    public boolean checkTime(String strValue, String stMin, String strMax) {
        boolean x_ret = false;
        try {
            String[] arrStrValue = strValue.split(":");
            String[] arrStrMin = this.strMin.split(":");
            String[] arrStrMax = strMax.split(":");
            if (arrStrValue.length == 3 && arrStrMin.length == 3 && arrStrMax.length == 3) {
                long CurTime = System.currentTimeMillis();
                Date valueDate = new Date(CurTime);
                Date maxDate = new Date(CurTime);
                Date minDate = new Date(CurTime);
                valueDate.setHours(Integer.parseInt(arrStrValue[0]));
                valueDate.setMinutes(Integer.parseInt(arrStrValue[1]));
                valueDate.setSeconds(Integer.parseInt(arrStrValue[1]));
                minDate.setHours(Integer.parseInt(arrStrValue[0]));
                minDate.setMinutes(Integer.parseInt(arrStrValue[1]));
                minDate.setSeconds(Integer.parseInt(arrStrValue[1]));
                maxDate.setHours(Integer.parseInt(arrStrValue[0]));
                maxDate.setMinutes(Integer.parseInt(arrStrValue[1]));
                maxDate.setSeconds(Integer.parseInt(arrStrValue[1]));
                if (valueDate.getTime() >= minDate.getTime() && valueDate.getTime() <= maxDate.getTime()) {
                    x_ret = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return x_ret;
    }

    @Override
    public Object getDefault() {
        return new Boolean(this.canBeNull);
    }

    @Override
    public String toString() {
        return "MaxValue: " + this.getStrMax() + "  MinValue:" + this.getStrMin();
    }

    public String getStrMin() {
        return this.strMin;
    }

    public void setStrMin(String strMin) {
        this.strMin = strMin;
    }

    public String getStrMax() {
        return this.strMax;
    }

    public void setStrMax(String strMax) {
        this.strMax = strMax;
    }

    public String getStrDefault() {
        return this.strDefault;
    }

    public void setStrDefault(String strDefault) {
        this.strDefault = strDefault;
    }

    public boolean isCanBeNull() {
        return this.canBeNull;
    }

    public void setCanBeNull(boolean canBeNull) {
        this.canBeNull = canBeNull;
    }

    public String getMaxDay() {
        String strMaxDay = null;
        if (this.getStrMax() != null) {
            strMaxDay = this.getStrMax().split("-")[0];
        }
        return strMaxDay;
    }

    public String getMaxTime() {
        String strMaxTime = null;
        if (this.getStrMax() != null) {
            strMaxTime = this.getStrMax().split("-")[1];
        }
        return strMaxTime;
    }

    public String getMinTime() {
        String strMinTime = null;
        if (this.getStrMin() != null) {
            strMinTime = this.getStrMin().split("-")[1];
        }
        return strMinTime;
    }

    public String getMinDay() {
        String strMinDay = null;
        if (this.getStrMin() != null) {
            strMinDay = this.getStrMin().split("-")[0];
        }
        return strMinDay;
    }

    public String getDefaultDay() {
        String strDefaultDay = null;
        strDefaultDay = this.getStrDefault() != null && this.getStrDefault().length() != 0 ? this.getStrDefault().split("-")[0] : "";
        return strDefaultDay;
    }

    public String getDefaultTime() {
        String strDefaultTime = null;
        strDefaultTime = this.getStrDefault() != null && this.getStrDefault().length() != 0 ? this.getStrDefault().split("-")[0] : "  :  :  ";
        return strDefaultTime;
    }
}

