/*
 * Decompiled with CFR 0.152.
 */
package dbatool.tableModel;

import dbatool.tableModel.ColumnSorting;
import dbatool.tableModel.DBARowInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class DbaTableModel
extends AbstractTableModel
implements ColumnSorting {
    private ArrayList data = new ArrayList();
    private String[] columnNames = null;
    private Vector columnNamesV = null;
    private Object target = null;
    private String methodname = null;

    public DbaTableModel(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public DbaTableModel(Vector columnNamesV) {
        this.columnNamesV = columnNamesV;
    }

    public DbaTableModel() {
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public void setColumnNames(Vector columnNamesV) {
        this.columnNamesV = columnNamesV;
    }

    @Override
    public int getColumnCount() {
        if (this.columnNames != null) {
            return this.columnNames.length;
        }
        return this.columnNamesV.size();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        if (this.columnNames != null) {
            return this.columnNames[col];
        }
        return (String)this.columnNamesV.elementAt(col);
    }

    @Override
    public Object getValueAt(int row, int col) {
        DBARowInfo rowData = (DBARowInfo)this.data.get(row);
        return rowData.getValueAt(col);
    }

    public Class getColumnClass(int col) {
        DBARowInfo rowData = (DBARowInfo)this.data.get(0);
        if (rowData == null) {
            return super.getColumnClass(col);
        }
        Object obj = rowData.getValueAt(col);
        if (obj != null) {
            return obj.getClass();
        }
        return super.getColumnClass(col);
    }

    public void addValue(DBARowInfo newData) {
        this.data.add(newData);
    }

    public void setTargetTableValueChanged(Object target, String methodname) {
        this.target = target;
        this.methodname = methodname;
    }

    @Override
    public void switchOrder(int godown, int goup) {
        Object downRow = this.data.get(godown);
        Object upRow = this.data.get(goup);
        this.data.set(goup, downRow);
        this.data.set(godown, upRow);
        if (this.target == null) {
            return;
        }
        try {
            Class<?> c = Class.forName("javax.swing.event.ListSelectionEvent");
            Class[] argTypes = new Class[]{c};
            Method method = this.target.getClass().getMethod(this.methodname, argTypes);
            Object e = null;
            Object[] args = new Object[]{e};
            method.invoke(this.target, args);
        }
        catch (Exception ex) {
            System.out.println("get method error " + ex.getMessage());
        }
    }

    public void removeAll() {
        this.data.clear();
    }

    public void removeItemAt(int row) {
        this.data.remove(row);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        DBARowInfo rowData = (DBARowInfo)this.data.get(row);
        rowData.setValueAt(value, col);
    }
}

