/*
 * Decompiled with CFR 0.152.
 */
package dbatool.TreeNode;

import dbatool.DbFrame;
import dbatool.Popupmenu.List_Popupmenu;
import dbatool.Task.TaskInfo;
import dbatool.TreeNode.DBATreeNode;
import dbaut.GuiUt;
import dbaut.locale.LocaleChangeEvent;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;

public class TaskTreeNode
extends DBATreeNode {
    private String owner;
    private String name;
    private static ImageIcon icon = null;
    private String toString = null;

    public TaskTreeNode() {
    }

    public TaskTreeNode(String owner, String name) {
        this.name = GuiUt.rightTrim(name);
        this.owner = GuiUt.rightTrim(owner);
        this.toString = this.owner + "." + this.name;
    }

    @Override
    public String getHelpID() {
        return "task.info";
    }

    public String getTaskName() {
        return this.name;
    }

    public String getTaskOwner() {
        return this.owner;
    }

    @Override
    public String toString() {
        return this.toString;
    }

    @Override
    public ImageIcon getImageIcon() {
        if (icon == null) {
            icon = DBAImageResource.getResource(this.getClass(), "/jdbaimages/single_task.gif");
        }
        return icon;
    }

    @Override
    public void displayObject() {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        DbFrame.frame.setStatusDisc(GuiUt.mapStringForProperty(res.getString("Information_about"), res.getString("Task") + " " + this.name));
        DbFrame.frame.setContentPanel(new TaskInfo(this.owner, this.name));
    }

    @Override
    public void displayMenu(MouseEvent e) {
        List_Popupmenu popup = new List_Popupmenu(this);
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
    }

    @Override
    public boolean isFound(String s1, String s2, String s3) {
        return this.owner.equalsIgnoreCase(s1) && this.name.equalsIgnoreCase(s2);
    }

    @Override
    public void refresh() {
        this.displayObject();
    }
}

