/*
 * Decompiled with CFR 0.152.
 */
package dbatool.TreeNode;

import dbatool.DbFrame;
import dbatool.Function.FunctionInfo;
import dbatool.Popupmenu.List_Popupmenu;
import dbatool.TreeNode.DBATreeNode;
import dbaut.GuiUt;
import dbaut.locale.LocaleChangeEvent;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;

public class FunctionTreeNode
extends DBATreeNode {
    private String func_owner;
    private String func_name;
    private String toString;
    private static ImageIcon icon = null;

    public FunctionTreeNode(String func_owner, String func_name) {
        this.func_owner = GuiUt.rightTrim(func_owner);
        this.func_name = GuiUt.rightTrim(func_name);
        this.toString = this.func_owner + "." + this.func_name;
    }

    @Override
    public String getHelpID() {
        return "storedprocedure.info";
    }

    @Override
    public String toString() {
        return this.toString;
    }

    @Override
    public ImageIcon getImageIcon() {
        if (icon == null) {
            icon = DBAImageResource.getResource(this.getClass(), "/jdbaimages/single_function.gif");
        }
        return icon;
    }

    @Override
    public void displayObject() {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        DbFrame.frame.setStatusDisc(GuiUt.mapStringForProperty(res.getString("Information_about"), this.func_owner + "." + this.func_name));
        DbFrame.frame.setContentPanel(new FunctionInfo(this.func_owner, this.func_name));
    }

    @Override
    public void displayMenu(MouseEvent e) {
        List_Popupmenu popup = new List_Popupmenu(this);
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
    }

    @Override
    public boolean isFound(String s1, String s2, String s3) {
        return this.func_owner.equalsIgnoreCase(s2) && this.func_name.equalsIgnoreCase(s3);
    }

    @Override
    public void refresh() {
        this.displayObject();
    }

    public String getFuncOwner() {
        return this.func_owner;
    }

    public String getFuncName() {
        return this.func_name;
    }
}

