/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Tablespace;

import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.LoginDlg;
import dbatool.Tablespace.AlterFileDlg;
import dbatool.Tablespace.AlterTablespaceDlg;
import dbatool.Tablespace.GetRatioDlg;
import dbatool.Tablespace.IndexesPanel;
import dbatool.Tablespace.TablesPanel;
import dbatool.tableCell.PhysicalEditor;
import dbatool.tableCell.PhysicalRenderer;
import dbatool.tableModel.DBARowInfo;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbatool.tableModel.DbaTableModel;
import dbatool.tableModel.FileSize;
import dbaut.DbaObject;
import dbaut.DbaUtDef;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.Logical_file;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.DbaTable;
import dbaut.comp.ReflectionAction;
import dbaut.comp.TableColumnSelectionListener;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.CharField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TableSpaceInfo
extends DbaTabbedPane
implements ComponentPrivilege {
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    private JRadioButton Prop_Regular_Button = new JRadioButton();
    private JRadioButton Prop_AutoExtend_Button = new JRadioButton();
    private JRadioButton Prop_ReadOnly_RadioButton = new JRadioButton();
    private JRadioButton Prop_ReadWrite_RadioButton = new JRadioButton();
    private TableCols model = new TableCols();
    private DBAToolAbstractTableModel absModel = new DBAToolAbstractTableModel(this.model);
    private DbaTable table1 = new DbaTable(this.absModel);
    private String ts_name = "";
    private String db_name = "";
    private String db_dir = null;
    private short ts_type = 0;
    private Connection db_connection = null;
    private int byteperpage = DbFrame.conn_DatabaseConnection.getDbPageSize();
    private int byteperframe = DbFrame.conn_DatabaseConnection.getBlobFrameSize();
    private int bepeIndex = DbFrame.conn_DatabaseConnection.getBePeIndex();
    private int LOGICAL_NAME = 0;
    private int PHYSICAL_NAME = 1;
    private int TYPE = 2;
    private int SIZE = 3;
    private int SIZE_IN_BYTE = 4;
    private int FREE_SIZE = 5;
    private int FREE_SIZE_IN_BYTE = 6;
    private int CREATE_TIME = 7;
    private int OFFSET = 8;
    private int NEW = 9;
    private DbaButton Update_Statistics_Button = new DbaButton(new Dimension(140, 24), this.res.getString("Update_Statistics"), 'U', DBAImageResource.getResource(this.getClass(), "/jdbaimages/update_statistics.gif"), new ReflectionAction(this, "Update_Statistics_Button_actionPerformed"));
    private DbaButton Check_Button = new DbaButton(new Dimension(140, 24), this.res.getString("Check_Tablespace"), 'K', DBAImageResource.getResource(this.getClass(), "/jdbaimages/rebuild.gif"), new ReflectionAction(this, "Check_Button_actionPerformed"));
    private DbaButton Prop_Cancel_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/cancel.gif"), new ReflectionAction(this, "Prop_Cancel_Button_actionPerformed"));
    private DbaButton Prop_Confirm_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Confirm"), 'N', DBAImageResource.getResource(this.getClass(), "/jdbaimages/confirm.gif"), new ReflectionAction(this, "Prop_Confirm_Button_actionPerformed"));
    private DbaButton Prop_Modify_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Start_Modify"), 'M', DBAImageResource.getResource(this.getClass(), "/jdbaimages/start_modify.gif"), new ReflectionAction(this, "Prop_Modify_Button_actionPerformed"));
    private DbaButton Alter_TS_Button = new DbaButton(new Dimension(130, 24), this.res.getString("Alter_TS"), 'A', DBAImageResource.getResource(this.getClass(), "/jdbaimages/alter_tablespace.gif"), new ReflectionAction(this, "Alter_TS_Button_actionPerformed"));
    private DbaButton Alter_File_Button = new DbaButton(new Dimension(120, 24), this.res.getString("Alter_File"), 'F', DBAImageResource.getResource(this.getClass(), "/jdbaimages/alter_file.gif"), new ReflectionAction(this, "Alter_File_Button_actionPerformed"));
    private DbaButton Drop_File_Button = new DbaButton(new Dimension(120, 24), this.res.getString("Drop_File"), 'D', DBAImageResource.getResource(this.getClass(), "/jdbaimages/drop.gif"), new ReflectionAction(this, "Drop_File_Button_actionPerformed"));
    private TablesPanel tp = null;
    private IndexesPanel indexesPanel = null;
    private static final String tmpTSName = "TMPTABLESPACE";
    private static final String sysTSName = "SYSTABLESPACE";
    private boolean isReadOnlyTs = false;
    private int dataTotal = 0;
    private int blobTotal = 0;
    private int dataFree = 0;
    private int blobFree = 0;

    public TableSpaceInfo(String ts_name) {
        try {
            this.ts_name = ts_name.trim();
            this.db_name = DbFrame.conn_DatabaseConnection.dbname;
            this.db_connection = DbFrame.conn_DatabaseConnection.getDbConnection();
            this.db_dir = DbFrame.conn_DatabaseConnection.getDBDir();
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("TablespaceTabbedPane");
        this.Check_Button.setName("CheckTablespaceButton");
        this.Update_Statistics_Button.setName("UpdateStatisticsButton");
        this.Alter_File_Button.setName("AlterFileButton");
        this.Drop_File_Button.setName("DropFileButton");
        this.Alter_TS_Button.setName("AlterTablespaceButton");
        this.Prop_Confirm_Button.setName("ConfirmButton");
        this.Prop_Modify_Button.setName("ModifyButton");
        this.Prop_Cancel_Button.setName("CancelButton");
        this.table1.setName("TablespaceInfoPropertiesTable");
        DbaPanel jPanel2 = new DbaPanel(DbFrame.helpres, "tablespace.info");
        this.Prop_Regular_Button.setText(this.res.getString("Regular"));
        this.Prop_AutoExtend_Button.setText(this.res.getString("Auto_Extend"));
        this.Prop_ReadOnly_RadioButton.setText(this.res.getString("Read_Only"));
        this.Prop_ReadWrite_RadioButton.setText(this.res.getString("Read_Write"));
        this.table1.getTableHeader().setReorderingAllowed(false);
        this.table1.setAutoResizeMode(4);
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.setPreferredSize(new Dimension(480, 404));
        ButtonGroup tstype_group = new ButtonGroup();
        ButtonGroup readonly_group = new ButtonGroup();
        tstype_group.add(this.Prop_Regular_Button);
        tstype_group.add(this.Prop_AutoExtend_Button);
        readonly_group.add(this.Prop_ReadOnly_RadioButton);
        readonly_group.add(this.Prop_ReadWrite_RadioButton);
        jScrollPane1.setBorder(null);
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        JLabel label0 = new JLabel(this.res.getString("Tablespace_Mode_"));
        label0.setPreferredSize(new Dimension(160, 24));
        jPanel4.add(label0);
        jPanel4.add(this.Prop_AutoExtend_Button);
        jPanel4.add(this.Prop_Regular_Button);
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        label0 = new JLabel(this.res.getString("Read_Only_Mode"));
        label0.setPreferredSize(new Dimension(160, 24));
        jPanel5.add(label0);
        jPanel5.add(this.Prop_ReadOnly_RadioButton);
        jPanel5.add(this.Prop_ReadWrite_RadioButton);
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        jPanel7.setName("TableSpaceInfoButtonPanel2");
        jPanel7.add((Component)this.Prop_Modify_Button, null);
        jPanel7.add((Component)this.Prop_Confirm_Button, null);
        jPanel7.add((Component)this.Prop_Cancel_Button, null);
        JPanel jPanel8 = new JPanel(new FlowLayout(0));
        jPanel8.setName("TableSpaceInfoButtonPanel1");
        jPanel8.add((Component)this.Check_Button, null);
        jPanel8.add((Component)this.Update_Statistics_Button, null);
        jPanel8.add((Component)this.Alter_File_Button, null);
        jPanel8.add((Component)this.Drop_File_Button, null);
        jPanel8.add((Component)this.Alter_TS_Button, null);
        JPanel jPanel3 = new JPanel(new GridLayout(4, 1));
        jPanel3.add((Component)jPanel8, null);
        jPanel3.add((Component)jPanel7, null);
        jPanel3.add((Component)jPanel4, null);
        jPanel3.add((Component)jPanel5, null);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel3, "North");
        jPanel2.add((Component)jScrollPane1, "Center");
        jScrollPane1.getViewport().add((Component)this.table1, null);
        this.add((Component)jPanel2, this.res.getTitle("Properties"));
        this.getTableSpaceInfo();
        if (!DbFrame.frame.isLocalHost) {
            this.Prop_Modify_Button.setEnabled(false);
        }
        this.initColumnSizes(this.table1);
        this.table1.setUpIntegerEditor();
        this.table1.setUpBigIntEditor(this.SIZE, false);
        this.table1.setUpIntegerEditor(this.OFFSET);
        this.table1.setUpCharEditor(0, new CharField(128, true));
        this.setUpPhysicalColumn();
        this.setUpTypeEditor();
        this.absModel.addMouseListenerToHeaderInTable(this.table1);
        this.table1.setSelectionMode(0);
        this.table1.addColumnSelectionListener(new TableColumnSelectionListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    TableSpaceInfo.this.TableSelectionChanged(e);
                }
            }
        });
        this.table1.addRowSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    TableSpaceInfo.this.TableSelectionChanged(e);
                }
            }
        });
        this.authority = DbaAuthorityFactory.create(this);
        this.setEditable(false);
        if (!this.ts_name.equals(tmpTSName) || !this.ts_name.equals(sysTSName)) {
            this.tp = new TablesPanel(this.ts_name, this.isReadOnlyTs);
            this.tp.setName("TablespaceTablesPanel");
            this.add((Component)this.tp, this.res.getTitle("Tables"));
        }
        if (!this.ts_name.equals(tmpTSName) || !this.ts_name.equals(sysTSName)) {
            this.indexesPanel = new IndexesPanel(this.ts_name, this.isReadOnlyTs);
            this.indexesPanel.setName("TablespaceIndexesPanel");
            this.add((Component)this.indexesPanel, this.res.getTitle("Indexes"));
        }
    }

    @Override
    public int getComponentType() {
        return 100;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.Alter_TS_Button.setEnabled(enabled);
        boolean isLocalHost = enabled && DbFrame.frame.isLocalHost;
        this.Prop_Modify_Button.setEnabled(isLocalHost);
        this.Check_Button.setEnabled(enabled);
    }

    @Override
    public void grant(boolean enabled) {
        int row = this.table1.getSelectedRow();
        if (!this.table1.getSelectionModel().isSelectionEmpty() && row >= 0 && row < this.table1.getRowCount() && this.Prop_ReadWrite_RadioButton.isSelected()) {
            this.Alter_File_Button.setEnabled(true);
        } else {
            this.Alter_File_Button.setEnabled(false);
        }
        if (this.Prop_Modify_Button.isEnabled() && !this.table1.getSelectionModel().isSelectionEmpty() && row >= 0 && row < this.table1.getRowCount() && this.table1.getRowCount() > 1) {
            this.Drop_File_Button.setEnabled(true);
        } else {
            this.Drop_File_Button.setEnabled(false);
        }
    }

    private void setAlterFileButton() {
        this.authority.authorise();
    }

    private void setEditable(boolean editable) {
        int row = this.table1.getSelectedRow();
        if (editable) {
            this.Check_Button.setEnabled(false);
            this.Alter_TS_Button.setEnabled(false);
            this.Update_Statistics_Button.setEnabled(false);
            this.Prop_Modify_Button.setEnabled(false);
            this.Prop_Cancel_Button.setEnabled(true);
            this.Prop_Confirm_Button.setEnabled(true);
            if (this.ts_type == 0 || this.ts_type == 1) {
                this.Prop_AutoExtend_Button.setEnabled(true);
                this.Prop_Regular_Button.setEnabled(true);
            } else {
                this.Prop_AutoExtend_Button.setEnabled(false);
                this.Prop_Regular_Button.setEnabled(false);
            }
            this.Prop_ReadOnly_RadioButton.setEnabled(true);
            this.Prop_ReadWrite_RadioButton.setEnabled(true);
        } else {
            this.authority.authoriseOnce();
            this.Update_Statistics_Button.setEnabled(true);
            this.Prop_Cancel_Button.setEnabled(false);
            this.Prop_Confirm_Button.setEnabled(false);
            this.Prop_Regular_Button.setEnabled(false);
            this.Prop_AutoExtend_Button.setEnabled(false);
            this.Prop_ReadOnly_RadioButton.setEnabled(false);
            this.Prop_ReadWrite_RadioButton.setEnabled(false);
        }
        this.setAlterFileButton();
    }

    private void initColumnSizes(JTable table) {
        TableColumn column = null;
        column = table.getColumnModel().getColumn(this.LOGICAL_NAME);
        column.setPreferredWidth(80);
        column = table.getColumnModel().getColumn(this.PHYSICAL_NAME);
        column.setPreferredWidth(200);
        column = table.getColumnModel().getColumn(this.TYPE);
        column.setPreferredWidth(40);
        column = table.getColumnModel().getColumn(this.SIZE);
        column.setPreferredWidth(50);
        column = table.getColumnModel().getColumn(this.FREE_SIZE);
        column.setPreferredWidth(50);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(4);
        column = table.getColumnModel().getColumn(this.FREE_SIZE_IN_BYTE);
        column.setPreferredWidth(70);
        column.setCellRenderer(renderer);
        column = table.getColumnModel().getColumn(this.SIZE_IN_BYTE);
        column.setPreferredWidth(70);
        column.setCellRenderer(renderer);
        column = table.getColumnModel().getColumn(this.CREATE_TIME);
        column.setPreferredWidth(110);
        column = table.getColumnModel().getColumn(this.OFFSET);
        column.setPreferredWidth(60);
    }

    private void setUpPhysicalColumn() {
        TableColumn column = this.table1.getColumnModel().getColumn(this.PHYSICAL_NAME);
        PhysicalRenderer renderer = new PhysicalRenderer(DbFrame.frame);
        PhysicalEditor editor = new PhysicalEditor(DbFrame.frame);
        column.setCellRenderer(renderer);
        column.setCellEditor(editor);
    }

    public void setUpTypeEditor() {
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem("DATA");
        comboBox.addItem("BLOB");
        TableColumn column = this.table1.getColumnModel().getColumn(this.TYPE);
        column.setCellEditor(new DefaultCellEditor(comboBox));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText(this.res.getString("Click_for_combo_box"));
        column.setCellRenderer(renderer);
        TableCellRenderer headerRenderer = column.getHeaderRenderer();
        if (headerRenderer != null && headerRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)headerRenderer).setToolTipText(this.res.getString("Click_the_DATA_or"));
        }
    }

    private void getTableSpaceInfo() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.model.removeAll();
            stmt = this.db_connection.createStatement();
            String query = "select TS_TYPE from SYSTEM.SYSTABLESPACE where TS_NAME = '" + this.ts_name + "'";
            rs = stmt.executeQuery(query);
            rs.next();
            this.ts_type = rs.getShort(1);
            switch (this.ts_type) {
                case 0: {
                    this.Prop_Regular_Button.setSelected(true);
                    this.Prop_ReadWrite_RadioButton.setSelected(true);
                    this.isReadOnlyTs = false;
                    break;
                }
                case 1: {
                    this.Prop_AutoExtend_Button.setSelected(true);
                    this.Prop_ReadWrite_RadioButton.setSelected(true);
                    this.isReadOnlyTs = false;
                    break;
                }
                case 2: {
                    this.Prop_Regular_Button.setSelected(true);
                    this.Prop_ReadOnly_RadioButton.setSelected(true);
                    this.isReadOnlyTs = true;
                    break;
                }
                case 3: {
                    this.Prop_AutoExtend_Button.setSelected(true);
                    this.Prop_ReadOnly_RadioButton.setSelected(true);
                    this.isReadOnlyTs = true;
                }
            }
            rs.close();
            query = "select FILE_NAME, FILE_NPAGES, FILE_TYPE,FILE_FREEPAGES, GETFILENAME(FILE_NAME), DWTOSTR(CREATE_TIME)  from SYSTEM.SYSFILE where TS_NAME = '" + this.ts_name + "'";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                this.model.addValue(new DBARowInfo(this.getRowInfo(rs.getString(1).trim(), rs.getString(5).trim(), rs.getShort(3), rs.getInt(2), rs.getInt(4), rs.getString(6), "", false)));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
            this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
            int sr = this.table1.getSelectedRow();
            if (sr >= 0 && this.absModel.getRowCount() > sr) {
                this.table1.setSelectedRow(sr);
            } else {
                this.table1.clearSelection();
            }
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    private Object[] getRowInfo(String logical_name, String physical_name, short file_type, long file_npages, long file_freepages, String create_time, String offset, boolean isNew) {
        Object[] data = new Object[10];
        data[this.LOGICAL_NAME] = logical_name;
        data[this.PHYSICAL_NAME] = physical_name;
        if (file_type == 1) {
            data[this.TYPE] = new String("DATA");
            data[this.SIZE_IN_BYTE] = FileSize.sizeToStr(file_npages * (long)this.byteperpage);
            data[this.FREE_SIZE_IN_BYTE] = FileSize.sizeToStr(file_freepages * (long)this.byteperpage);
        } else {
            data[this.TYPE] = new String("BLOB");
            long BE = (long)Math.ceil((double)file_npages / (double)(1 + DbaUtDef.PE_PER_BE[this.bepeIndex] * (DbaUtDef.PG_PER_PE[this.bepeIndex] + 1)));
            long PE = (long)Math.ceil((double)(file_npages - BE) / (double)(DbaUtDef.PG_PER_PE[this.bepeIndex] + 1));
            data[this.SIZE_IN_BYTE] = FileSize.sizeToStr(file_npages * (long)this.byteperframe - (long)(this.byteperframe - this.byteperpage) * (PE + BE));
            data[this.FREE_SIZE_IN_BYTE] = FileSize.sizeToStr(file_freepages * (long)this.byteperframe);
        }
        data[this.SIZE] = new Long(file_npages);
        data[this.FREE_SIZE] = new Long(file_freepages);
        data[this.CREATE_TIME] = create_time;
        data[this.NEW] = new Boolean(isNew);
        data[this.OFFSET] = offset;
        return data;
    }

    private boolean isLogicalFileExists(String filename, int index) {
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen("dmconfig.ini", this.db_name, "r");
        if (rc != 0) {
            return false;
        }
        boolean isFound = false;
        String s = (String)config.getPara(filename, 4096);
        if (s != null && s.length() > 0) {
            isFound = true;
        }
        config.fileClose();
        if (isFound) {
            return isFound;
        }
        int size = this.model.getRowCount();
        String temp = null;
        for (int i = 0; i < size; ++i) {
            if (i == index || (temp = (String)this.model.getValueAt(i, this.LOGICAL_NAME)).length() <= 0 || !temp.equalsIgnoreCase(filename)) continue;
            isFound = true;
            break;
        }
        return isFound;
    }

    private String getFullPath(String file, String path) {
        String fileseparator = System.getProperty("file.separator");
        String filename = null;
        filename = file.indexOf(fileseparator) < 0 ? (path.endsWith(fileseparator) ? path + file : path + fileseparator + file) : file;
        return filename;
    }

    private boolean isFileExists(String file, String path, int index) {
        String filename = this.getFullPath(file, path);
        File f = new File(filename);
        if (f.exists()) {
            return true;
        }
        int size = this.model.getRowCount();
        String temp = null;
        for (int i = 0; i < size; ++i) {
            if (i == index || (temp = (String)this.model.getValueAt(i, this.PHYSICAL_NAME)).length() <= 0 || !this.getFullPath(temp, path).equalsIgnoreCase(filename)) continue;
            return true;
        }
        return false;
    }

    public void Update_Statistics_Button_actionPerformed(ActionEvent e) {
        boolean result;
        int reply = GuiUt.showOptionDlg(DbFrame.frame, this.res.getString("Update_Statistics"), this.res.getString("Do_you_want_to_update_tablespace_statistics"));
        if (reply != 0) {
            return;
        }
        GetRatioDlg ratiodlg = DbFrame.isWindows ? new GetRatioDlg(DbFrame.frame) : new GetRatioDlg(DbFrame.frame, "", true);
        ratiodlg.setTitle(this.res.getString("Sample_Ratio"));
        GuiUt.setCenterLocation(DbFrame.frame, ratiodlg);
        ratiodlg.show();
        if (ratiodlg.getResult() != 0) {
            ratiodlg.dispose();
            return;
        }
        String ratiostr = ratiodlg.getRatio();
        ratiodlg.dispose();
        String query = "UPDATE TABLESPACE STATISTICS \"" + this.ts_name + "\" ";
        if (ratiostr != null && ratiostr.length() > 0) {
            query = query + "SAMPLE = " + ratiostr;
        }
        if (result = DatabaseConnection.executeSQL(query)) {
            GuiUt.showInformationDlg(DbFrame.frame, this.res.getString("Statistics_has_been"));
            DbFrame.frame.setStatusDisc(this.res.getString("Statistics_has_been"));
        }
    }

    public void Prop_Modify_Button_actionPerformed(ActionEvent e) {
        this.setEditable(true);
        if (this.Prop_ReadWrite_RadioButton.isSelected()) {
            this.model.addValue(new DBARowInfo(this.getRowInfo("", "", (short)1, 0L, 0L, "", "", true)));
        }
        this.absModel.removeMouseListenerToHeaderInTable(this.table1);
        this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
        this.table1.setselectedCell(this.model.getRowCount() - 1, 0);
        this.fixTabbedPanelAt(0);
    }

    public void Prop_Confirm_Button_actionPerformed(ActionEvent e) {
        this.table1.editingStopped(null);
        String logical_name = null;
        String physical_name = null;
        Boolean isNew = null;
        Long size = null;
        File f = null;
        int count = this.model.getRowCount();
        for (int i = 0; i < count; ++i) {
            isNew = (Boolean)this.model.getValueAt(i, this.NEW);
            if (!isNew.booleanValue()) continue;
            logical_name = (String)this.model.getValueAt(i, this.LOGICAL_NAME);
            logical_name = logical_name.trim();
            physical_name = (String)this.model.getValueAt(i, this.PHYSICAL_NAME);
            physical_name = physical_name.trim();
            size = (Long)this.model.getValueAt(i, this.SIZE);
            if (logical_name.length() <= 0 && physical_name.length() <= 0) continue;
            if (logical_name.length() <= 0 || physical_name.length() <= 0) {
                GuiUt.showErrorDlg(DbFrame.frame, this.res.getString("Both_logical_and_physical_name_are_required"), null);
                return;
            }
            if (size != null && size != 0L) continue;
            GuiUt.showErrorDlg(DbFrame.frame, this.res.getString("Data_file_size_cannot_be_zero"), null);
            return;
        }
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen("dmconfig.ini", this.db_name, "r+");
        if (rc != 0) {
            System.out.println("can't open dmconfig file rc =" + rc);
            return;
        }
        StringBuffer query_sb = new StringBuffer();
        String file_type = null;
        Logical_file logfile = null;
        for (int i = 0; i < count; ++i) {
            isNew = (Boolean)this.model.getValueAt(i, this.NEW);
            if (!isNew.booleanValue()) continue;
            logical_name = (String)this.model.getValueAt(i, this.LOGICAL_NAME);
            physical_name = (String)this.model.getValueAt(i, this.PHYSICAL_NAME);
            file_type = (String)this.model.getValueAt(i, this.TYPE);
            size = (Long)this.model.getValueAt(i, this.SIZE);
            if (logical_name.length() <= 0 && physical_name.length() <= 0) continue;
            if (GuiUt.isWindows()) {
                logfile = new Logical_file(physical_name, size);
            } else if (this.Prop_Regular_Button.isSelected()) {
                if (physical_name.startsWith("/dev/")) {
                    String offset = this.model.getValueAt(i, this.OFFSET).toString().trim();
                    int r_offset = offset.length() == 0 ? 0 : Integer.parseInt(offset);
                    logfile = new Logical_file(physical_name, size, r_offset);
                } else {
                    logfile = new Logical_file(physical_name, size);
                }
            } else {
                logfile = new Logical_file(physical_name, size);
            }
            config.insertPara(logical_name, logfile, 53760);
            query_sb.append("ALTER TABLESPACE \"").append(this.ts_name).append("\" ").append("ADD DATAFILE \"").append(logical_name).append("\" TYPE=").append(file_type).append(";\n");
        }
        config.fileClose();
        switch (this.ts_type) {
            case 0: {
                if (this.Prop_AutoExtend_Button.isSelected()) {
                    query_sb.append("ALTER TABLESPACE \"").append(this.ts_name).append("\" SET AUTOEXTEND ON;\n");
                }
                if (!this.Prop_ReadOnly_RadioButton.isSelected()) break;
                query_sb.append("ALTER TABLESPACE \"").append(this.ts_name).append("\" SET READ ONLY;\n");
                break;
            }
            case 1: {
                if (this.Prop_Regular_Button.isSelected()) {
                    query_sb.append("ALTER TABLESPACE \"").append(this.ts_name).append("\" SET AUTOEXTEND OFF;\n");
                }
                if (!this.Prop_ReadOnly_RadioButton.isSelected()) break;
                query_sb.append("ALTER TABLESPACE \"").append(this.ts_name).append("\" SET READ ONLY;\n");
                break;
            }
            case 2: {
                if (this.Prop_ReadWrite_RadioButton.isSelected()) {
                    query_sb.append("ALTER TABLESPACE \"").append(this.ts_name).append("\" SET READ WRITE;\n");
                }
                if (!this.Prop_AutoExtend_Button.isSelected()) break;
                query_sb.append("ALTER TABLESPACE \"").append(this.ts_name).append("\" SET AUTOEXTEND ON;\n");
                break;
            }
            case 3: {
                if (this.Prop_ReadWrite_RadioButton.isSelected()) {
                    query_sb.append("ALTER TABLESPACE \"").append(this.ts_name).append("\" SET READ WRITE;\n");
                }
                if (!this.Prop_Regular_Button.isSelected()) break;
                query_sb.append("ALTER TABLESPACE \"").append(this.ts_name).append("\" SET AUTOEXTEND OFF;\n");
            }
        }
        if (query_sb.length() == 0) {
            this.Prop_Cancel_Button_actionPerformed(null);
            return;
        }
        boolean result = DatabaseConnection.executeMultiSQL(query_sb.toString());
        if (!result) {
            rc = config.fileOpen("dmconfig.ini", this.db_name, "r+");
            if (rc == 0) {
                logical_name = null;
                isNew = null;
                for (int i = 0; i < count; ++i) {
                    isNew = (Boolean)this.model.getValueAt(i, this.NEW);
                    if (!isNew.booleanValue()) continue;
                    logical_name = (String)this.model.getValueAt(i, this.LOGICAL_NAME);
                    if (logical_name.length() > 0) {
                        config.procDelete(logical_name, 0);
                    }
                    physical_name = (String)this.model.getValueAt(i, this.PHYSICAL_NAME);
                    f = new File(physical_name);
                    f.delete();
                }
                config.fileClose();
            }
        } else {
            this.Prop_Cancel_Button_actionPerformed(null);
        }
    }

    public void Prop_Cancel_Button_actionPerformed(ActionEvent e) {
        this.table1.editingCanceled(null);
        this.getTableSpaceInfo();
        this.absModel.addMouseListenerToHeaderInTable(this.table1);
        this.releaseTabbedPanel();
        this.setEditable(false);
    }

    public void Alter_TS_Button_actionPerformed(ActionEvent e) {
        String[][] str = this.model.getSizeDescription();
        AlterTablespaceDlg dlg = DbFrame.isWindows ? new AlterTablespaceDlg((Frame)DbFrame.frame, this.ts_name, str) : new AlterTablespaceDlg(DbFrame.frame, "", true, this.ts_name, str);
        GuiUt.setCenterLocation(DbFrame.frame, dlg);
        dlg.setModal(true);
        dlg.show();
        dlg = null;
        this.getTableSpaceInfo();
    }

    public void Drop_File_Button_actionPerformed(ActionEvent e) {
        int row = this.table1.getSelectedRow();
        int col = this.table1.getSelectedColumn();
        if (row < 0 || col < 0 || row >= this.table1.getRowCount() || col >= this.table1.getColumnCount()) {
            return;
        }
        String logName = (String)this.model.getValueAt(row, this.LOGICAL_NAME);
        String phyName = (String)this.model.getValueAt(row, this.PHYSICAL_NAME);
        String query = "ALTER TABLESPACE " + GuiUt.getIDString(this.ts_name) + " DROP DATAFILE " + GuiUt.getIDString(logName);
        boolean result = DatabaseConnection.executeSQL(query);
        if (result) {
            this.model.removeItemAt(row);
            this.Prop_Cancel_Button_actionPerformed(null);
            File f = new File(phyName);
            f.delete();
            JdmConfig config = new JdmConfig();
            config.fileOpen("dmconfig.ini", LoginDlg.selectedDBName, "r+");
            config.procDelete(logName, 0);
            config.fileClose();
        }
    }

    public void Alter_File_Button_actionPerformed(ActionEvent e) {
        int row = this.table1.getSelectedRow();
        int col = this.table1.getSelectedColumn();
        if (row < 0 || col < 0 || row >= this.table1.getRowCount() || col >= this.table1.getColumnCount()) {
            return;
        }
        AlterFileDlg dlg = DbFrame.isWindows ? new AlterFileDlg((Frame)DbFrame.frame, this.ts_name, (String)this.model.getValueAt(row, this.LOGICAL_NAME), (Long)this.model.getValueAt(row, this.SIZE)) : new AlterFileDlg(DbFrame.frame, "", true, this.ts_name, (String)this.model.getValueAt(row, this.LOGICAL_NAME), (Long)this.model.getValueAt(row, this.SIZE));
        GuiUt.setCenterLocation(DbFrame.frame, dlg);
        dlg.setModal(true);
        dlg.show();
        dlg = null;
        this.getTableSpaceInfo();
    }

    void TableSelectionChanged(ListSelectionEvent e) {
        this.setAlterFileButton();
        int row = this.table1.getSelectedRow();
        int col = this.table1.getSelectedColumn();
        if (row < 0 || col < 0) {
            return;
        }
        if (row >= this.table1.getRowCount() || col >= this.table1.getColumnCount()) {
            return;
        }
        this.table1.editCellAt(row, col);
    }

    public void Check_Button_actionPerformed(ActionEvent e) {
        int reply = GuiUt.showOptionDlg(DbFrame.frame, this.res.getString("Check_Tablespace"), this.res.getString("Do_you_want_to_check_tablespace"));
        if (reply != 0) {
            return;
        }
        String query = "CHECK TABLESPACE \"" + this.ts_name + "\"";
        if (!GuiUt.showSqlScript(query)) {
            return;
        }
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        Statement stmt = null;
        try {
            Connection conn = DbFrame.conn_DatabaseConnection.getDbConnection();
            stmt = conn.createStatement();
            stmt.execute(query);
            stmt.close();
            GuiUt.showInformationDlg(DbFrame.frame, this.res.getString("Check_Tablespace_Successful"));
        }
        catch (SQLException sqle) {
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    private void getPercentSize() {
        int rowCount = this.table1.getModel().getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String type = (String)this.table1.getModel().getValueAt(i, 2);
            if (type.equalsIgnoreCase("DATA")) {
                this.dataTotal = (int)((long)this.dataTotal + (Long)this.table1.getModel().getValueAt(i, 3));
                this.dataFree = (int)((long)this.dataFree + (Long)this.table1.getModel().getValueAt(i, 5));
                continue;
            }
            this.blobTotal = (int)((long)this.blobTotal + (Long)this.table1.getModel().getValueAt(i, 3));
            this.blobFree = (int)((long)this.blobFree + (Long)this.table1.getModel().getValueAt(i, 5));
        }
    }

    private class TableCols
    extends DbaTableModel {
        private String[] names;

        public TableCols() {
            this.names = new String[]{TableSpaceInfo.this.res.getString("Logical_Name"), TableSpaceInfo.this.res.getString("Physical_name"), TableSpaceInfo.this.res.getString("Type"), TableSpaceInfo.this.res.getString("Total_Pages"), TableSpaceInfo.this.res.getString("Total_Bytes"), TableSpaceInfo.this.res.getString("Free_Pages"), TableSpaceInfo.this.res.getString("Free_Bytes"), TableSpaceInfo.this.res.getString("Creation_Time"), TableSpaceInfo.this.res.getString("Offset")};
            super.setColumnNames(this.names);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            Boolean isNew = (Boolean)this.getValueAt(row, TableSpaceInfo.this.NEW);
            if (GuiUt.isWindows()) {
                return !TableSpaceInfo.this.Prop_Modify_Button.isEnabled() && isNew != false && col != TableSpaceInfo.this.SIZE_IN_BYTE && col != TableSpaceInfo.this.FREE_SIZE_IN_BYTE && col != TableSpaceInfo.this.FREE_SIZE && col != TableSpaceInfo.this.CREATE_TIME && col != TableSpaceInfo.this.OFFSET && !TableSpaceInfo.this.Prop_ReadOnly_RadioButton.isSelected() && !TableSpaceInfo.this.Prop_ReadOnly_RadioButton.isSelected();
            }
            if (TableSpaceInfo.this.Prop_Modify_Button.isEnabled() || !isNew.booleanValue() || col == TableSpaceInfo.this.SIZE_IN_BYTE || col == TableSpaceInfo.this.FREE_SIZE_IN_BYTE || col == TableSpaceInfo.this.FREE_SIZE || col == TableSpaceInfo.this.CREATE_TIME || TableSpaceInfo.this.Prop_ReadOnly_RadioButton.isSelected()) {
                return false;
            }
            if (TableSpaceInfo.this.Prop_Regular_Button.isSelected()) {
                if (col == TableSpaceInfo.this.OFFSET) {
                    String s = this.getValueAt(row, TableSpaceInfo.this.PHYSICAL_NAME).toString().trim().toLowerCase();
                    return !s.startsWith("/dev/");
                }
                return true;
            }
            return col != TableSpaceInfo.this.OFFSET;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == TableSpaceInfo.this.LOGICAL_NAME && value.toString().length() > 0 && TableSpaceInfo.this.isLogicalFileExists(((String)value).trim(), row)) {
                GuiUt.showErrorDlg(DbFrame.frame, value + " " + TableSpaceInfo.this.res.getString("file_already_exists"), null);
                return;
            }
            if (col == TableSpaceInfo.this.PHYSICAL_NAME && value.toString().length() > 0 && TableSpaceInfo.this.isFileExists(((String)value).trim(), TableSpaceInfo.this.db_dir, row)) {
                GuiUt.showErrorDlg(DbFrame.frame, value + " " + TableSpaceInfo.this.res.getString("file_already_exists"), null);
                return;
            }
            super.setValueAt(value, row, col);
            if (col == TableSpaceInfo.this.LOGICAL_NAME && value != null && value.toString().length() > 0 && row == this.getRowCount() - 1) {
                TableSpaceInfo.this.model.addValue(new DBARowInfo(TableSpaceInfo.this.getRowInfo("", "", (short)1, 0L, 0L, "", "", true)));
            }
        }

        public String[][] getSizeDescription() {
            int row_count = this.getRowCount();
            long total_pages = 0L;
            long total_free_pages = 0L;
            long total_frames = 0L;
            long total_free_frames = 0L;
            String type = null;
            for (int i = 0; i < row_count; ++i) {
                type = (String)this.getValueAt(i, TableSpaceInfo.this.TYPE);
                if (type.equalsIgnoreCase("DATA")) {
                    total_pages += ((Long)this.getValueAt(i, TableSpaceInfo.this.SIZE)).longValue();
                    total_free_pages += ((Long)this.getValueAt(i, TableSpaceInfo.this.FREE_SIZE)).longValue();
                    continue;
                }
                total_frames += ((Long)this.getValueAt(i, TableSpaceInfo.this.SIZE)).longValue();
                total_free_frames += ((Long)this.getValueAt(i, TableSpaceInfo.this.FREE_SIZE)).longValue();
            }
            String[][] str = new String[2][4];
            str[0][0] = TableSpaceInfo.this.res.getString("Total_Pages") + " : ";
            str[0][1] = Long.toString(total_pages);
            str[0][2] = TableSpaceInfo.this.res.getString("free_pages") + " : ";
            str[0][3] = Long.toString(total_free_pages);
            str[1][0] = TableSpaceInfo.this.res.getString("Total_Frames") + " : ";
            str[1][1] = Long.toString(total_frames);
            str[1][2] = TableSpaceInfo.this.res.getString("free_frames") + " : ";
            str[1][3] = Long.toString(total_free_frames);
            return str;
        }
    }
}

