/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.border.Border;

public class ResizableBorder
implements Border {
    private int dist = 8;
    int[] locations = new int[]{1, 5, 7, 3, 8, 2, 6, 4};
    int[] cursors = new int[]{8, 9, 10, 11, 6, 7, 4, 5};

    public void setDist(int dist) {
        this.dist = dist;
    }

    public ResizableBorder(int dist) {
        this.dist = dist;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return new Insets(this.dist, this.dist, this.dist, this.dist);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component component, Graphics g, int x, int y, int w, int h) {
        g.setColor(Color.black);
        if (component.hasFocus()) {
            g.drawRect(x + this.dist / 2, y + this.dist / 2, w - this.dist, h - this.dist);
            for (int i = 0; i < this.locations.length; ++i) {
                Rectangle rect = this.getRectangle(x, y, w, h, this.locations[i]);
                g.setColor(Color.GREEN);
                g.fillRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
                g.setColor(Color.BLACK);
                g.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
            }
        }
    }

    private Rectangle getRectangle(int x, int y, int w, int h, int location) {
        switch (location) {
            case 1: {
                return new Rectangle(x + w / 2 - this.dist / 2, y, this.dist, this.dist);
            }
            case 5: {
                return new Rectangle(x + w / 2 - this.dist / 2, y + h - this.dist, this.dist, this.dist);
            }
            case 7: {
                return new Rectangle(x, y + h / 2 - this.dist / 2, this.dist, this.dist);
            }
            case 3: {
                return new Rectangle(x + w - this.dist, y + h / 2 - this.dist / 2, this.dist, this.dist);
            }
            case 8: {
                return new Rectangle(x, y, this.dist, this.dist);
            }
            case 2: {
                return new Rectangle(x + w - this.dist, y, this.dist, this.dist);
            }
            case 6: {
                return new Rectangle(x, y + h - this.dist, this.dist, this.dist);
            }
            case 4: {
                return new Rectangle(x + w - this.dist, y + h - this.dist, this.dist, this.dist);
            }
        }
        return null;
    }

    public int getCursor(MouseEvent me) {
        Component c = me.getComponent();
        int w = c.getWidth();
        int h = c.getHeight();
        for (int i = 0; i < this.locations.length; ++i) {
            Rectangle rectangle = this.getRectangle(0, 0, w, h, this.locations[i]);
            if (!rectangle.contains(me.getPoint())) continue;
            return this.cursors[i];
        }
        return 13;
    }
}

