/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Synonym;

import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.tableModel.DBARowInfo;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbatool.tableModel.DbaTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.resource.DBAImageResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;

public class SynonymList
extends DbaTabbedPane
implements ComponentPrivilege {
    private DbaTableModel model1 = null;
    private DBAToolAbstractTableModel absModel = null;
    private JTable table1 = null;
    private DbaButton Create_Button;
    private DbaButton Drop_Button;

    public SynonymList() {
        this.Create_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Create"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/create.gif"), new ReflectionAction(this, "Create_Button_actionPerformed"));
        this.Drop_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Drop"), 'D', DBAImageResource.getResource(this.getClass(), "/jdbaimages/drop.gif"), new ReflectionAction(this, "Drop_Button_actionPerformed"));
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("SynonymsTabbedPane");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "synonym.list");
        String[] columnNames = new String[]{DbFrame.frame.res.getString("Schema_Name_Big"), DbFrame.frame.res.getString("Synonym_Name"), DbFrame.frame.res.getString("Schema_Name_Big"), DbFrame.frame.res.getString("Table_View_name"), DbFrame.frame.res.getString("Link")};
        this.model1 = new DbaTableModel(columnNames);
        this.absModel = new DBAToolAbstractTableModel(this.model1);
        this.table1 = new JTable(this.absModel);
        this.table1.setName("SynonymsListTable");
        JScrollPane jScrollPane1 = new JScrollPane();
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.setName("SynonymsButtonPanel");
        this.setPreferredSize(new Dimension(420, 420));
        jPanel1.setLayout(new BorderLayout());
        jScrollPane1.setBorder(BorderFactory.createLoweredBevelBorder());
        this.table1.setSelectionMode(0);
        this.add((Component)jPanel1, DbFrame.frame.res.getTitle("Synonym"));
        jPanel1.add((Component)jScrollPane1, "Center");
        jPanel1.add((Component)jPanel2, "North");
        this.Create_Button.setName("CreateButton");
        this.Drop_Button.setName("DropButton");
        jPanel2.add((Component)this.Create_Button, null);
        jPanel2.add((Component)this.Drop_Button, null);
        jScrollPane1.getViewport().add((Component)this.table1, null);
        this.getSynonymList();
        this.table1.setAutoResizeMode(4);
        this.initColumnSizes(this.table1);
        this.absModel.addMouseListenerToHeaderInTable(this.table1);
        this.table1.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table1_valueChanged"));
        this.authority = DbaAuthorityFactory.create(this);
        this.authority.authoriseOnce();
        this.grant(false);
    }

    @Override
    public int getComponentType() {
        return 10;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.Create_Button.setEnabled(enabled);
    }

    @Override
    public void grant(boolean enabled) {
        this.Drop_Button.setEnabled(enabled);
    }

    public void table1_valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.grant(false);
        } else {
            int r = this.table1.getSelectedRow();
            Object value = this.model1.getValueAt(r, 0);
            String owner = (String)value;
            this.authority.authorise(owner);
        }
    }

    private void getSynonymList() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.model1.removeAll();
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "SELECT OWNER, SNAME, TV_OWNER, TV_NAME, TV_LINK, TV_SERVER FROM SYSTEM.SYSSYNONYM ";
            if (!DbFrame.frame.px.getShowSystemTable()) {
                query = query + "WHERE OWNER != 'SYSTEM'";
            }
            rs = stmt.executeQuery(query);
            String tv_server = null;
            while (rs.next()) {
                String tv_link = rs.getString(5);
                tv_link = rs.wasNull() ? "" : tv_link;
                tv_server = rs.getString(6);
                tv_server = rs.wasNull() ? "" : tv_server;
                this.model1.addValue(new DBARowInfo(this.getRowInfo(GuiUt.rightTrim(rs.getString(1)), GuiUt.rightTrim(rs.getString(2)), GuiUt.rightTrim(rs.getString(3)), GuiUt.rightTrim(rs.getString(4)), tv_link, tv_server)));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
            DbFrame.frame.setStatusDisc(DbFrame.frame.res.getString("The_number_of_synonym") + this.model1.getRowCount());
            this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    private void initColumnSizes(JTable table) {
        TableColumn column = null;
        column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(100);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(100);
        column = table.getColumnModel().getColumn(2);
        column.setPreferredWidth(100);
        column = table.getColumnModel().getColumn(3);
        column.setPreferredWidth(100);
        column = table.getColumnModel().getColumn(4);
        column.setPreferredWidth(100);
    }

    private Object[] getRowInfo(String owner, String sname, String tv_owner, String tv_name, String tv_link, String tv_server) {
        Object[] data = new Object[]{GuiUt.rightTrim(owner), GuiUt.rightTrim(sname), tv_owner, tv_name, tv_link.length() == 0 ? tv_server : tv_link};
        return data;
    }

    public void Create_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.menubar.CreateObjectChoice(10);
        this.getSynonymList();
    }

    public void Drop_Button_actionPerformed(ActionEvent e) {
        int row = this.table1.getSelectedRow();
        if (row >= this.model1.getRowCount()) {
            return;
        }
        String name = (String)this.model1.getValueAt(row, 1);
        String str1 = DbFrame.frame.res.getString("Do_you_want_to_drop_synonym");
        String str2 = GuiUt.mapStringForProperty(str1, name);
        int reply = GuiUt.showOptionDlg(DbFrame.frame, DbFrame.frame.res.getString("Drop_Synonym"), str2 + " ?");
        if (reply != 0) {
            return;
        }
        String query = "DROP SYNONYM \"" + name + "\"";
        boolean result = DatabaseConnection.executeSQL(query);
        if (result) {
            this.getSynonymList();
            if (row >= this.table1.getRowCount()) {
                this.table1.clearSelection();
            }
        }
    }
}

