/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Schema;

import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.tableModel.DBARowInfo;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbatool.tableModel.DbaTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.resource.DBAImageResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;

public class SchemaList
extends DbaTabbedPane
implements ComponentPrivilege {
    private DbaTableModel model1 = null;
    private DBAToolAbstractTableModel absModel = null;
    private JTable table1 = null;
    private DbaButton Create_Button = null;
    private DbaButton Drop_Button;

    public SchemaList() {
        this.Drop_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Drop"), 'D', DBAImageResource.getResource(this.getClass(), "/jdbaimages/drop.gif"), new ReflectionAction(this, "Drop_Button_actionPerformed"));
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("SchemasTabbedPane");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "schema.list");
        String[] columnNames = new String[]{DbFrame.frame.res.getString("Schema_Name_Big"), DbFrame.frame.res.getString("Schema_owner")};
        this.model1 = new DbaTableModel(columnNames);
        this.absModel = new DBAToolAbstractTableModel(this.model1);
        this.table1 = new JTable(this.absModel);
        this.table1.setName("SchemasListTable");
        JScrollPane jScrollPane1 = new JScrollPane();
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.setName("SchemasButtonPanel");
        this.setPreferredSize(new Dimension(420, 420));
        jPanel1.setLayout(new BorderLayout());
        jScrollPane1.setBorder(BorderFactory.createLoweredBevelBorder());
        this.Create_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Create"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/create.gif"), new ReflectionAction(this, "Create_Button_actionPerformed"));
        this.table1.setSelectionMode(0);
        this.add((Component)jPanel1, DbFrame.frame.res.getString("Schema"));
        jPanel1.add((Component)jScrollPane1, "Center");
        jPanel1.add((Component)jPanel2, "North");
        jPanel2.add((Component)this.Create_Button, null);
        jPanel2.add((Component)this.Drop_Button, null);
        this.Create_Button.setName("CreateButton");
        this.Drop_Button.setName("DropButton");
        jScrollPane1.getViewport().add((Component)this.table1, null);
        this.getSchemaList();
        this.table1.setAutoResizeMode(4);
        this.initColumnSizes(this.table1);
        this.absModel.addMouseListenerToHeaderInTable(this.table1);
        this.table1.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table1_valueChanged"));
        this.authority = DbaAuthorityFactory.create(this);
        this.authority.authoriseOnce();
        this.grant(false);
    }

    @Override
    public int getComponentType() {
        return 22;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.Create_Button.setEnabled(enabled);
    }

    @Override
    public void grant(boolean enabled) {
        this.Drop_Button.setEnabled(enabled);
    }

    public void table1_valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.grant(false);
        } else {
            this.authority.authorise();
        }
    }

    private void getSchemaList() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.model1.removeAll();
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            boolean insystbl = DbFrame.frame.treePanel.getOption("INSYSTBL");
            String query = "SELECT SCHEMA_NAME, SCHEMA_OWNER FROM SYSSCHEMA ";
            if (!insystbl) {
                query = query + "where SCHEMA_OWNER != 'SYSTEM' ";
            }
            query = query + "ORDER BY SCHEMA_OWNER";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                this.model1.addValue(new DBARowInfo(this.getRowInfo(GuiUt.rightTrim(rs.getString(1)), GuiUt.rightTrim(rs.getString(2)))));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
            DbFrame.frame.setStatusDisc(DbFrame.frame.res.getString("The_number_of_schema") + this.model1.getRowCount());
            this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    private void initColumnSizes(JTable table) {
        TableColumn column = null;
        column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(100);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(100);
    }

    private Object[] getRowInfo(String name, String owner) {
        Object[] data = new Object[]{GuiUt.rightTrim(name), GuiUt.rightTrim(owner)};
        return data;
    }

    public void Create_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.menubar.CreateObjectChoice(19);
        this.getSchemaList();
    }

    public void Drop_Button_actionPerformed(ActionEvent e) {
        int row = this.table1.getSelectedRow();
        if (row >= this.model1.getRowCount()) {
            return;
        }
        String name = (String)this.model1.getValueAt(row, 0);
        String str1 = DbFrame.frame.res.getString("Do_you_want_to_drop_schema");
        String str2 = GuiUt.mapStringForProperty(str1, name);
        int[] option = new int[1];
        String[] optionStr = new String[]{"", "RESTRICT", "CASCADE"};
        int reply = GuiUt.showDropOptionsDlg(DbFrame.frame, DbFrame.frame.res.getString("Drop_Schema"), str2 + " ?", option);
        if (reply != 0) {
            return;
        }
        String query = "DROP SCHEMA \"" + name + "\" " + optionStr[option[0]];
        boolean result = DatabaseConnection.executeSQL(query);
        if (result) {
            this.getSchemaList();
            if (row >= this.table1.getRowCount()) {
                this.table1.clearSelection();
            }
        }
    }
}

