/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Qbe.treetable;

import dbatool.Qbe.ColumnInfo;
import dbatool.Qbe.TableInfo;
import dbaut.resource.DBAImageResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.TreeCellRenderer;

public class QbeTreeRenderer
extends JPanel
implements TreeCellRenderer {
    protected JCheckBox check;
    protected TreeLabel label;
    private String tableImage = "/jdbaimages/qbe/table.gif";
    private String viewImage = "/jdbaimages/qbe/view.gif";
    private String columnImage = "/jdbaimages/qbe/column.gif";
    private ImageIcon icon = null;

    public QbeTreeRenderer() {
        this.setLayout(null);
        this.label = new TreeLabel();
        this.add(this.label);
        this.label.setForeground(UIManager.getColor("Tree.textForeground"));
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, hasFocus);
        this.setEnabled(tree.isEnabled());
        this.label.setFont(tree.getFont());
        this.label.setText(stringValue);
        this.label.setSelected(isSelected);
        this.label.setFocus(hasFocus);
        TableInfo ti = null;
        if (value instanceof TableInfo) {
            ti = (TableInfo)value;
            if (ti.isView()) {
                this.label.setIcon(DBAImageResource.getResource(this.getClass(), this.viewImage));
            } else {
                this.label.setIcon(DBAImageResource.getResource(this.getClass(), this.tableImage));
            }
        } else if (value instanceof ColumnInfo) {
            this.label.setIcon(DBAImageResource.getResource(this.getClass(), this.columnImage));
        }
        this.label.revalidate();
        this.label.repaint();
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d_label = this.label.getPreferredSize();
        return new Dimension(d_label.width, d_label.height);
    }

    @Override
    public void doLayout() {
        Dimension d_label = this.label.getPreferredSize();
        this.label.setLocation(d_label.width, d_label.height);
        this.label.setBounds(0, 0, d_label.width, d_label.height);
    }

    @Override
    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public class TreeLabel
    extends JLabel {
        boolean isSelected;
        boolean hasFocus;

        @Override
        public void setBackground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setBackground(color);
        }

        @Override
        public void paint(Graphics g) {
            String str = this.getText();
            if (str != null && 0 < str.length()) {
                if (this.isSelected) {
                    g.setColor(UIManager.getColor("Tree.selectionBackground"));
                } else {
                    g.setColor(UIManager.getColor("Tree.textBackground"));
                }
                Dimension d = this.getPreferredSize();
                int imageOffset = 0;
                Icon currentI = this.getIcon();
                if (currentI != null) {
                    imageOffset = currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                }
                g.fillRect(imageOffset, 0, d.width - 1 - imageOffset, d.height);
                if (this.hasFocus) {
                    g.setColor(UIManager.getColor("Tree.selectionBorderColor"));
                    g.drawRect(imageOffset, 0, d.width - 1 - imageOffset, d.height - 1);
                }
            }
            super.paint(g);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension retDimension = super.getPreferredSize();
            if (retDimension != null) {
                retDimension = new Dimension(retDimension.width + 1000, retDimension.height);
            }
            return retDimension;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        public void setFocus(boolean hasFocus) {
            this.hasFocus = hasFocus;
        }
    }
}

