/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Group;

import dbatool.DbFrame;
import dbatool.tableModel.ColumnSorting;
import dbaut.GuiUt;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class GroupTableModel
extends AbstractTableModel
implements ColumnSorting {
    private String[] columnNames;
    private Vector data;
    private Vector old_data;
    private boolean isEditable;

    public GroupTableModel() {
        this.columnNames = new String[]{DbFrame.frame.res.getString("User_Group"), DbFrame.frame.res.getString("Type"), DbFrame.frame.res.getString("Include")};
        this.data = new Vector();
        this.old_data = null;
        this.isEditable = false;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object[] rowData = (Object[])this.data.elementAt(row);
        return rowData[col];
    }

    public Class getColumnClass(int c) {
        Object[] rowData = (Object[])this.data.elementAt(0);
        return rowData[c].getClass();
    }

    public void addValue(Object[] newData) {
        this.data.addElement(newData);
    }

    @Override
    public void switchOrder(int godown, int goup) {
        Object downRow = this.data.elementAt(godown);
        Object upRow = this.data.elementAt(goup);
        this.data.setElementAt(downRow, goup);
        this.data.setElementAt(upRow, godown);
    }

    public void setEditable(boolean editable) {
        this.isEditable = editable;
        if (this.isEditable) {
            this.old_data = new Vector();
            int size = this.data.size();
            for (int i = 0; i < size; ++i) {
                this.old_data.addElement(new Boolean((Boolean)this.getValueAt(i, 2)));
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.isEditable && col == 2;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Object[] rowData = (Object[])this.data.elementAt(row);
        rowData[col] = value;
    }

    public void removeAll() {
        this.data.removeAllElements();
    }

    public Vector getUpdatingGroup(String group) {
        StringBuffer add_str_sb = new StringBuffer();
        StringBuffer remove_str_sb = new StringBuffer();
        int size = this.data.size();
        for (int i = 0; i < size; ++i) {
            Object[] cur_row = (Object[])this.data.elementAt(i);
            Boolean cur_value = (Boolean)cur_row[2];
            String user = (String)cur_row[0];
            Boolean old_value = (Boolean)this.old_data.elementAt(i);
            if (cur_value.booleanValue() && !old_value.booleanValue()) {
                if (add_str_sb.length() == 0) {
                    add_str_sb.append("ADD  ").append(GuiUt.getIDString(user));
                } else {
                    add_str_sb.append(", ").append(GuiUt.getIDString(user));
                }
            }
            if (cur_value.booleanValue() || !old_value.booleanValue()) continue;
            if (remove_str_sb.length() == 0) {
                remove_str_sb.append("REMOVE  ").append(GuiUt.getIDString(user));
                continue;
            }
            remove_str_sb.append(", ").append(GuiUt.getIDString(user));
        }
        Vector<String> v = new Vector<String>();
        if (remove_str_sb.length() > 0) {
            v.addElement(remove_str_sb.append(" FROM GROUP ").append(GuiUt.getIDString(group)).toString());
        }
        if (add_str_sb.length() > 0) {
            v.addElement(add_str_sb.append(" TO GROUP ").append(GuiUt.getIDString(group)).toString());
        }
        return v;
    }
}

