/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Group;

import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.tableModel.DBARowInfo;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbatool.tableModel.DbaTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.resource.DBAImageResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;

public class GroupList
extends DbaTabbedPane {
    private DbaTableModel model1 = null;
    private DBAToolAbstractTableModel absModel = null;
    private JTable table1 = null;
    private DbaButton Create_Button;
    private DbaButton Drop_Button;

    public GroupList() {
        this.Create_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Create"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/create.gif"), new ReflectionAction(this, "Create_Button_actionPerformed"));
        this.Drop_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Drop"), 'D', DBAImageResource.getResource(this.getClass(), "/jdbaimages/drop.gif"), new ReflectionAction(this, "Drop_Button_actionPerformed"));
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("GroupsTabbedPane");
        String[] columnNames = new String[]{DbFrame.frame.res.getString("Group_Owner"), DbFrame.frame.res.getString("Group_Name"), DbFrame.frame.res.getString("_of_Members")};
        this.model1 = new DbaTableModel(columnNames);
        this.absModel = new DBAToolAbstractTableModel(this.model1);
        this.table1 = new JTable(this.absModel);
        DbaPanel Users = new DbaPanel(DbFrame.helpres, "group.list");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JScrollPane jScrollPane1 = new JScrollPane();
        Users.setLayout(new BorderLayout());
        jScrollPane1.setBorder(BorderFactory.createLoweredBevelBorder());
        this.table1.setSelectionMode(0);
        this.table1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GroupList.this.table1_mouseClicked(e);
            }
        });
        Users.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)Users, DbFrame.frame.res.getTitle("Groups"));
        Users.add((Component)jScrollPane1, "Center");
        Users.add((Component)jPanel2, "North");
        jPanel2.setName("GroupsListButtonPanel");
        this.Create_Button.setName("CreateButton");
        this.Drop_Button.setName("DropButton");
        this.table1.setName("GroupsListTable");
        jPanel2.add((Component)this.Create_Button, null);
        jPanel2.add((Component)this.Drop_Button, null);
        jScrollPane1.getViewport().add((Component)this.table1, null);
        this.getGroupList();
        this.initColumnSizes(this.table1);
        this.absModel.addMouseListenerToHeaderInTable(this.table1);
        this.setEditable(false);
        this.table1.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table_valueChanged"));
    }

    public void table_valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.Drop_Button.setEnabled(false);
        } else {
            this.Drop_Button.setEnabled(true);
        }
    }

    private void setEditable(boolean editable) {
        if (editable) {
            this.Create_Button.setEnabled(false);
            this.Drop_Button.setEnabled(false);
        } else {
            this.Create_Button.setEnabled(true);
            if (this.table1.getSelectedRow() >= 0) {
                this.Drop_Button.setEnabled(true);
            } else {
                this.Drop_Button.setEnabled(false);
            }
        }
    }

    private void getGroupList() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.model1.removeAll();
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "SELECT GROUP_OWNER, GROUP_NAME, NUM_MEMBERS from SYSAUTHGROUP";
            rs = stmt.executeQuery(query);
            String group_name = null;
            int num_members = 0;
            while (rs.next()) {
                String group_owner = GuiUt.rightTrim(rs.getString(1));
                group_name = GuiUt.rightTrim(rs.getString(2));
                num_members = rs.getInt(3);
                this.model1.addValue(new DBARowInfo(this.getRowInfo(group_owner, group_name, num_members)));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
            DbFrame.frame.setStatusDisc(GuiUt.mapStringForProperty(DbFrame.frame.res.getString("The_number_of_groups_is"), Integer.toString(this.model1.getRowCount())));
            this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    private void initColumnSizes(JTable table) {
        TableColumn column = null;
        int[] sizes = new int[]{120, 80, 120};
        for (int i = 0; i < sizes.length; ++i) {
            column = table.getColumnModel().getColumn(i);
            column.setPreferredWidth(sizes[i]);
        }
    }

    private Object[] getRowInfo(String group_owner, String group_name, int num_members) {
        Object[] data = new Object[]{GuiUt.rightTrim(group_owner), GuiUt.rightTrim(group_name), new Integer(num_members)};
        return data;
    }

    public void Create_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.menubar.CreateObjectChoice(8);
        this.getGroupList();
        DbFrame.frame.treePanel.refreshGroupTree();
    }

    public void Drop_Button_actionPerformed(ActionEvent e) {
        int row = this.table1.getSelectedRow();
        String group_name = (String)this.model1.getValueAt(row, 1);
        if (DbFrame.conn_DatabaseConnection.dropGroup(group_name)) {
            DbFrame.frame.treePanel.afterDropObject(9);
        }
    }

    void table1_mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            int row = this.table1.getSelectedRow();
            if (row < 0 || row >= this.absModel.getRowCount()) {
                return;
            }
            String group = (String)this.absModel.getValueAt(row, 1);
            DbFrame.frame.treePanel.openGroupTree(group);
        }
    }
}

