/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Function;

import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.tableModel.DBARowInfo;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbatool.tableModel.DbaTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.resource.DBAImageResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;

public class FunctionList
extends DbaTabbedPane
implements ComponentPrivilege {
    private static int OWNER = 0;
    private static int NAME = 1;
    private static int REMARK = 2;
    private int INPUT = 3;
    private DbaButton Create_Button;
    private DbaButton Drop_Button;
    private DbaTableModel model;
    private DBAToolAbstractTableModel absModel;
    private JTable table;

    public FunctionList() {
        this.Create_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Create"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/create.gif"), new ReflectionAction(this, "Create_Button_actionPerformed"));
        this.Drop_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Drop"), 'D', DBAImageResource.getResource(this.getClass(), "/jdbaimages/drop.gif"), new ReflectionAction(this, "Drop_Button_actionPerformed"));
        this.model = null;
        this.absModel = null;
        this.table = null;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("FunctionsTabbedPane");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "Function.list");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JScrollPane jScrollPane1 = new JScrollPane();
        String[] columnNames = new String[]{DbFrame.frame.res.getString("Schema_Name_Big"), DbFrame.frame.res.getString("Name"), DbFrame.frame.res.getString("Type"), DbFrame.frame.res.getString("Num_Of_Params")};
        this.model = new DbaTableModel(columnNames);
        this.absModel = new DBAToolAbstractTableModel(this.model);
        this.table = new JTable(this.absModel);
        jPanel1.setLayout(new BorderLayout());
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FunctionList.this.table_mouseClicked(e);
            }
        });
        this.add((Component)jPanel1, DbFrame.frame.res.getTitle("Function"));
        jPanel1.add((Component)jPanel2, "North");
        jPanel2.setName("FunctionsButtonPanel");
        this.Create_Button.setName("CreateButton");
        this.Drop_Button.setName("DropButton");
        jPanel2.add((Component)this.Create_Button, null);
        jPanel2.add((Component)this.Drop_Button, null);
        jPanel1.add((Component)jScrollPane1, "Center");
        this.table.setName("FunctionsListTable");
        jScrollPane1.getViewport().add((Component)this.table, null);
        this.authority = DbaAuthorityFactory.create(this);
        this.authority.authoriseOnce();
        this.initColumnSizes();
        this.getFunctionList();
        this.Drop_Button.setEnabled(false);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table_valueChanged"));
        this.absModel.addMouseListenerToHeaderInTable(this.table);
    }

    @Override
    public int getComponentType() {
        return 28;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.Create_Button.setEnabled(enabled);
    }

    @Override
    public void grant(boolean enabled) {
        if (this.getSelectedIndex() == 0) {
            this.Drop_Button.setEnabled(enabled);
        }
    }

    public void table_valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.grant(false);
        } else {
            int r = this.table.getSelectedRow();
            Object value = this.table.getValueAt(r, 1);
            String owner = (String)value;
            if (owner.compareTo("SYSTEM") == 0) {
                this.Drop_Button.setEnabled(false);
            } else {
                this.authority.authorise(owner);
            }
        }
    }

    private void initColumnSizes() {
        TableColumn column = null;
        Object renderer = null;
        column = this.table.getColumnModel().getColumn(OWNER);
        column.setPreferredWidth(100);
        column = this.table.getColumnModel().getColumn(NAME);
        column.setPreferredWidth(100);
    }

    private void getFunctionList() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.model.removeAll();
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select PROC_OWNER, PROC_NAME, REMARKS, NUM_IN_PARAMS, NUM_OUT_PARAMS from SYSTEM.SYSPROCINFO Where MODULENAME='FUNCPROC' order by PROC_OWNER, PROC_NAME";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                this.model.addValue(new DBARowInfo(this.getRowInfo(rs.getString(1).trim(), rs.getString(2).trim(), rs.getString(3).trim(), rs.getInt(4), rs.getInt(5))));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
            DbFrame.frame.setStatusDisc(GuiUt.mapStringForProperty(DbFrame.frame.res.getString("The_number_of_functions_is"), Integer.toString(this.model.getRowCount())));
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
        this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
    }

    private Object[] getRowInfo(String owner, String name, String remark, int num_input_params, int num_output_params) {
        Object[] data = new Object[6];
        data[FunctionList.OWNER] = GuiUt.rightTrim(owner);
        data[FunctionList.NAME] = GuiUt.rightTrim(name);
        data[FunctionList.REMARK] = remark;
        data[this.INPUT] = new Integer(num_input_params);
        return data;
    }

    public void Create_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.menubar.CreateObjectChoice(24);
        DbFrame.frame.treePanel.refreshProcedureTree();
        this.getFunctionList();
    }

    public void Drop_Button_actionPerformed(ActionEvent e) {
        int row = this.table.getSelectedRow();
        if (row >= this.table.getRowCount() || row < 0) {
            return;
        }
        String owner = (String)this.model.getValueAt(row, OWNER);
        String name = (String)this.model.getValueAt(row, NAME);
        if (DbFrame.conn_DatabaseConnection.dropFunction(owner, name)) {
            DbFrame.frame.treePanel.afterDropObject(28);
        }
    }

    private void table_mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            int row = this.table.getSelectedRow();
            if (row < 0 || row >= this.absModel.getRowCount()) {
                return;
            }
            String owner = (String)this.absModel.getValueAt(row, OWNER);
            String name = (String)this.absModel.getValueAt(row, NAME);
            DbFrame.frame.treePanel.openFunctionTree(owner, name);
        }
    }
}

