/*
 * Decompiled with CFR 0.152.
 */
package ServerMgr;

import ServerMgr.AddServiceDlg;
import ServerMgr.SmFrame;
import ServerMgr.SmHelpButton;
import com.borland.jbcl.layout.VerticalFlowLayout;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.resource.DBAImageResource;
import dbaut.winlib;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;

public class NTServiceDlg
extends JDialog {
    private DbaButton Remove_Button;
    private JList ServiceList;

    public NTServiceDlg(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.Remove_Button = new DbaButton(SmFrame.frame.res.getString("Remove"), 'R', new ReflectionAction(this, "Remove_Button_actionPerformed"));
        this.ServiceList = new JList();
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public NTServiceDlg(Frame frame) {
        super(frame);
        this.Remove_Button = new DbaButton(SmFrame.frame.res.getString("Remove"), 'R', new ReflectionAction(this, "Remove_Button_actionPerformed"));
        this.ServiceList = new JList();
        this.setModal(true);
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        JPanel panel1 = new JPanel(new BorderLayout(10, 10));
        JPanel jPanel1 = new JPanel((LayoutManager)new VerticalFlowLayout());
        JScrollPane jScrollPane1 = new JScrollPane();
        JLabel jLabel1 = new JLabel();
        DbaButton Close_Button = new DbaButton(SmFrame.frame.res.getString("Close"), 'C', new ReflectionAction(this, "Close_Button_actionPerformed"));
        SmHelpButton help_Button = new SmHelpButton();
        DbaButton Install_Button = new DbaButton(SmFrame.frame.res.getString("Install"), 'I', new ReflectionAction(this, "Install_Button_actionPerformed"));
        Close_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        Install_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dttimages/add_SQL.gif"));
        this.Remove_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dttimages/none.gif"));
        SmFrame.frame.enableDialogHelp(this.getRootPane(), help_Button, "NTServiceDlgHelpIDInformation", null);
        this.setTitle(SmFrame.frame.res.getString("NT_Service"));
        this.ServiceList.setSelectionMode(0);
        this.ServiceList.addListSelectionListener(new ReflectionListSelection(this, "ServiceList_valueChanged"));
        panel1.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel1.setPreferredSize(new Dimension(400, 300));
        jLabel1.setText(SmFrame.frame.res.getString("Installed_Services"));
        this.getContentPane().add(panel1);
        panel1.add((Component)jPanel1, "East");
        jPanel1.add((Component)Install_Button, null);
        jPanel1.add((Component)this.Remove_Button, null);
        jPanel1.add((Component)Close_Button, null);
        jPanel1.add((Component)help_Button, null);
        panel1.add((Component)jScrollPane1, "Center");
        panel1.add((Component)jLabel1, "North");
        jScrollPane1.getViewport().add((Component)this.ServiceList, null);
        this.getServiceList();
        this.Remove_Button.setEnabled(false);
        this.setName("NTServiceDialog");
        this.ServiceList.setName("ServiceList");
        Install_Button.setName("InstallButton");
        this.Remove_Button.setName("RemoveButton");
    }

    private void removeServiceDB(String dbname) {
        DefaultListModel dlm = (DefaultListModel)this.ServiceList.getModel();
        dlm.removeElement(dbname);
        this.ServiceList.revalidate();
        this.ServiceList.repaint();
        if (this.ServiceList.getModel().getSize() == 0) {
            this.Remove_Button.setEnabled(false);
        }
    }

    private void getServiceList() {
        DefaultListModel model;
        this.ServiceList.removeAll();
        winlib w = new winlib();
        Vector v = new Vector();
        int rc = w.getServiceNames(v);
        if (rc == 0) {
            model = new DefaultListModel();
            for (int i = 0; i < v.size(); ++i) {
                model.addElement(v.elementAt(i));
            }
        } else {
            GuiUt.showErrorDlg(this, SmFrame.frame.res.getString("Error_get_NT_Service_names") + rc, null);
            return;
        }
        this.ServiceList.setModel(model);
        this.ServiceList.revalidate();
        this.ServiceList.repaint();
        if (this.ServiceList.getModel().getSize() == 0) {
            this.Remove_Button.setEnabled(false);
        }
    }

    public void Close_Button_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    public void Remove_Button_actionPerformed(ActionEvent e) {
        String dbname = (String)this.ServiceList.getSelectedValue();
        String str1 = SmFrame.frame.res.getString("Do_you_really_want_to_remove_service");
        String str2 = GuiUt.mapStringForProperty(str1, dbname);
        int reply = GuiUt.showOptionDlg(this, SmFrame.frame.res.getString("Delete_Database_Service"), str2 + " ?");
        if (reply != 0) {
            return;
        }
        winlib w = new winlib();
        int rc = w.removeService(dbname);
        if (rc != 0) {
            GuiUt.showErrorDlg(this, SmFrame.frame.res.getString("Remove_NT_Service_failed") + rc, null);
        } else {
            this.removeServiceDB(dbname);
        }
    }

    public void Install_Button_actionPerformed(ActionEvent e) {
        AddServiceDlg dlg = null;
        dlg = SmFrame.frame.isWindows() ? new AddServiceDlg(SmFrame.frame) : new AddServiceDlg(SmFrame.frame, "", true);
        GuiUt.setCenterLocation(this, dlg);
        dlg.show();
        this.getServiceList();
    }

    public void ServiceList_valueChanged(ListSelectionEvent e) {
        if (this.ServiceList.getSelectedValue() != null) {
            this.Remove_Button.setEnabled(true);
        }
    }
}

