/*
 * Decompiled with CFR 0.152.
 */
package DmEditor.AllSectionInfo.userfiles;

import DmEditor.AllSectionInfo.userfiles.IVFRowInfo;
import DmEditor.AllSectionInfo.userfiles.IVFTableCols;
import DmEditor.MainDlg;
import DmEditor.MainFrame;
import DmEditor.Preferences.Preferences;
import com.borland.jbcl.layout.VerticalFlowLayout;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.CharField;
import dbaut.util.AvailableStrUtil;
import dbaut.util.PlatformUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;

public class IVFDlg
extends JDialog {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("configproperties.DmEditorRes", LocaleManager.getLocale());
    private CharField phyName_TextField = new CharField(255, true);
    private JButton ivfBrowseButton = new JButton();
    private DbaButton ok_Button = new DbaButton();
    private DbaButton canecel_Button = new DbaButton();
    private CharField logName_TextField = new CharField(32, true);
    private IVFTableCols parentIVFTableCols = null;
    private JTable parentTable = null;
    private DbaButton helpButton = new DbaButton();
    private Component comp = null;

    public IVFDlg(MainFrame frame, String title, boolean modal, IVFTableCols paraIVFTableCols, JTable paraTable, Component paracomp) {
        super(frame, title, modal);
        try {
            this.parentIVFTableCols = paraIVFTableCols;
            this.parentTable = paraTable;
            this.comp = paracomp;
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public IVFDlg(MainFrame frame, IVFTableCols paraIVFTableCols, JTable paraTable, Component paracomp) {
        super(frame);
        this.setModal(true);
        try {
            this.parentIVFTableCols = paraIVFTableCols;
            this.parentTable = paraTable;
            this.comp = paracomp;
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public IVFDlg(MainDlg dlg, String title, boolean modal, IVFTableCols paraIVFTableCols, JTable paraTable, Component paracomp) {
        super(dlg, title, modal);
        try {
            this.parentIVFTableCols = paraIVFTableCols;
            this.parentTable = paraTable;
            this.comp = paracomp;
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public IVFDlg(MainDlg dlg, IVFTableCols paraIVFTableCols, JTable paraTable, Component paracomp) {
        super(dlg);
        this.setModal(true);
        try {
            this.parentIVFTableCols = paraIVFTableCols;
            this.parentTable = paraTable;
            this.comp = paracomp;
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        try {
            if (Preferences.mainHB != null) {
                Preferences.mainHB.enableHelpKey((Component)this.getRootPane(), Preferences.helpres.getString("jconfigurationtool.userfiles"), null);
            } else {
                this.helpButton.setEnabled(false);
            }
        }
        catch (Exception ex) {
            System.out.println("Error Message is : " + ex.getMessage());
            return;
        }
        catch (ExceptionInInitializerError ex) {
            System.err.println("initialization error:");
            ex.getException().printStackTrace();
        }
        JLabel jLabel2 = new JLabel();
        JPanel panel1 = new JPanel(new BorderLayout());
        JLabel jLabel1 = new JLabel();
        panel1.setBorder(BorderFactory.createRaisedBevelBorder());
        panel1.setMinimumSize(new Dimension(420, 260));
        panel1.setPreferredSize(new Dimension(390, 110));
        jLabel1.setText(this.res.getString("Logical_File_Name"));
        jLabel2.setText(this.res.getString("Physical_File_Name"));
        this.ivfBrowseButton.setBorder(BorderFactory.createRaisedBevelBorder());
        this.ivfBrowseButton.setText("...");
        this.ivfBrowseButton.addActionListener(new ReflectionAction(this, "ivfBrowseButton_actionPerformed"));
        this.ok_Button.setMnemonic('O');
        this.ok_Button.setText(this.res.getString("Ok"));
        this.ok_Button.addActionListener(new ReflectionAction(this, "ok_Button_actionPerformed"));
        this.canecel_Button.setMnemonic('C');
        this.canecel_Button.setText(this.res.getString("Cancel"));
        this.canecel_Button.addActionListener(new ReflectionAction(this, "canecel_Button_actionPerformed"));
        this.logName_TextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    IVFDlg.this.logName_TextField_keyReleased(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                IVFDlg.this.logName_TextField_keyReleased(e);
            }
        });
        this.phyName_TextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    IVFDlg.this.phyName_TextField_keyReleased(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                IVFDlg.this.phyName_TextField_keyReleased(e);
            }
        });
        this.helpButton.setText(this.res.getString("Help"));
        this.helpButton.setMnemonic('H');
        this.ok_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"));
        this.canecel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        this.helpButton.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/help.gif"));
        this.getContentPane().add(panel1);
        if (Preferences.mainHB == null) {
            this.helpButton.setEnabled(false);
        } else {
            this.helpButton.addActionListener((ActionListener)new CSH.DisplayHelpFromSource((HelpBroker)Preferences.mainHB));
        }
        JPanel panel0 = new JPanel(new GridLayout(4, 1, 5, 5));
        panel0.add(jLabel1);
        panel0.add(this.logName_TextField);
        panel0.add(jLabel2);
        JPanel panel4 = new JPanel(new BorderLayout());
        panel4.add((Component)this.phyName_TextField, "Center");
        panel4.add((Component)this.ivfBrowseButton, "East");
        panel0.add(panel4);
        panel1.add((Component)panel0, "Center");
        panel0 = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel0.add(this.ok_Button);
        panel0.add(this.canecel_Button);
        panel0.add(this.helpButton);
        panel1.add((Component)panel0, "East");
        panel1.setBorder(BorderFactory.createEmptyBorder(5, 5, 15, 5));
        this.ok_Button.setEnabled(false);
        this.setName("IvfDialog");
        this.ok_Button.setName("OKButton");
        this.canecel_Button.setName("CancelButton");
        this.logName_TextField.setName("LogicalNameTextField");
        this.phyName_TextField.setName("PhysicalNameTextField");
        this.setPreferredSize(new Dimension(500, 190));
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 200) {
            this.logName_TextField.requestFocus();
        }
    }

    public void canecel_Button_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    public void setObject(String titleString) {
        this.setTitle(titleString);
    }

    public void ivfBrowseButton_actionPerformed(ActionEvent e) {
        String curDir = this.phyName_TextField.getText().trim();
        if (curDir == null || curDir.length() == 0) {
            curDir = System.getProperty("user.dir");
        }
        JFileChooser chooser = new JFileChooser(curDir);
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileHidingEnabled(false);
        chooser.setEnabled(false);
        int state = chooser.showDialog(null, this.res.getString("Select_Path"));
        File file = chooser.getSelectedFile();
        if (file != null) {
            this.phyName_TextField.setText(file.getPath());
            if (this.logName_TextField.getText().trim().length() > 0) {
                this.ok_Button.setEnabled(true);
            } else {
                this.ok_Button.setEnabled(false);
            }
        }
    }

    public void ok_Button_actionPerformed(ActionEvent e) {
        if (this.logName_TextField.getText().length() == 0 || this.phyName_TextField.getText().length() == 0) {
            if (this.logName_TextField.getText().length() == 0) {
                GuiUt.showInformationDlg(this, this.res.getString("Please_enter_the_logical_file_name!"));
                this.logName_TextField.requestFocus();
            } else {
                GuiUt.showInformationDlg(this, this.res.getString("Please_enter_the_physical_file_name!"));
                this.phyName_TextField.requestFocus();
            }
        } else {
            String logStr = this.logName_TextField.getText();
            String phyStr = this.phyName_TextField.getText();
            boolean flag = true;
            if (!AvailableStrUtil.isAvailableStr(phyStr)) {
                this.phyName_TextField.setText("");
                flag = false;
            }
            if (!AvailableStrUtil.isAvailableStr(logStr)) {
                this.logName_TextField.setText("");
                flag = false;
            }
            if (!flag) {
                return;
            }
            for (int i = 0; i < this.parentIVFTableCols.getRowCount(); ++i) {
                String log = this.parentIVFTableCols.getValueAt(i, 0).toString();
                String phy = this.parentIVFTableCols.getValueAt(i, 1).toString();
                if (log.equals(this.logName_TextField.getText())) {
                    GuiUt.showErrorDlg(this, this.res.getString("user_defined_logical_filename"), null);
                    return;
                }
                if (!phy.equals(this.phyName_TextField.getText())) continue;
                GuiUt.showErrorDlg(this, this.res.getString("user_defined_physical_filename"), null);
                return;
            }
            IVFRowInfo newRow = new IVFRowInfo(this.logName_TextField.getText(), this.phyName_TextField.getText());
            this.parentIVFTableCols.addValue(newRow);
            this.parentIVFTableCols.fireTableChanged(new TableModelEvent(this.parentIVFTableCols));
            this.setVisible(false);
            this.dispose();
        }
    }

    void logName_TextField_keyReleased(KeyEvent e) {
        if (this.phyName_TextField.getText().trim().length() <= 0 || this.logName_TextField.getText().trim().length() <= 0) {
            this.ok_Button.setEnabled(false);
            return;
        }
        this.ok_Button.setEnabled(true);
        if (e.getKeyCode() == 10 && this.phyName_TextField.getText().length() > 0 && this.logName_TextField.getText().length() > 0) {
            this.ok_Button_actionPerformed(null);
        }
    }

    void phyName_TextField_keyReleased(KeyEvent e) {
        if (this.phyName_TextField.getText().trim().length() <= 0 || this.logName_TextField.getText().trim().length() <= 0) {
            this.ok_Button.setEnabled(false);
            return;
        }
        this.ok_Button.setEnabled(true);
        if (e.getKeyCode() == 10 && this.phyName_TextField.getText().length() > 0) {
            this.ok_Button_actionPerformed(null);
        }
    }
}

