/*
 * Decompiled with CFR 0.152.
 */
package dbaut.textField;

import dbaut.GuiUt;
import dbaut.textField.DbaTextField;
import java.awt.Toolkit;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class DoubleField
extends JTextField
implements DbaTextField {
    private NumberFormat numberFormatter;
    private int max_length = 0;
    private boolean length_limited = false;
    private DoubleField field = this;
    private DoubleField current = this;

    public DoubleField(double value, int columns) {
        super(columns);
        this.numberFormatter = NumberFormat.getNumberInstance(Locale.US);
        this.setValue(value);
    }

    public DoubleField() {
        this(5);
    }

    public DoubleField(int columns) {
        super(columns);
        this.numberFormatter = NumberFormat.getNumberInstance(Locale.US);
    }

    @Override
    public Object getValue() {
        double retVal = 0.0;
        String t = this.getText();
        try {
            retVal = Double.parseDouble(t);
        }
        catch (NumberFormatException e) {
            if (t.length() > 0) {
                Toolkit.getDefaultToolkit().beep();
                GuiUt.showErrorDlg(this, t + " can't be formatted as Double", null);
            }
            return null;
        }
        return new Double(retVal);
    }

    public void setValue(double value) {
        this.setText(this.numberFormatter.format(value));
    }

    @Override
    protected Document createDefaultModel() {
        return new DoubleDocument();
    }

    protected class DoubleDocument
    extends PlainDocument {
        protected DoubleDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            String temp;
            if (DoubleField.this.length_limited && (temp = DoubleField.this.field.getText()).length() >= DoubleField.this.max_length) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            int length = str.length();
            for (int i = 0; i < length; ++i) {
                if (Character.isDigit(str.charAt(i)) || str.charAt(i) == '.' || str.charAt(i) == '-' || str.charAt(i) == 'E' || str.charAt(i) == 'e') continue;
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(offs, str, a);
        }
    }
}

