/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.xtm.jdbc;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.syscom.ut.GuiUt;
import com.syscom.ut.comp.DbaButton;
import com.syscom.ut.comp.ReflectionAction;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.ut.resource.DBAImageResource;
import com.syscom.xml.xtm.Preferences;
import com.syscom.xml.xtm.gui.XTMFrame;
import com.syscom.xml.xtm.jdbc.JdbcDriverDetail;
import com.syscom.xml.xtm.jdbc.JdbcDriverDetailDlg;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JdbcDriverDlg
extends JDialog {
    private ResourceBundle res = ResourceBundle.getBundle("com.syscom.xml.xtm.jdbc.resource.Res", LocaleManager.getLocale());
    private DbaButton okButton = new DbaButton(this.res.getString("Ok"), 'O', new ReflectionAction(this, "okButton_actionPerformed"));
    private DbaButton cancelButton = new DbaButton(this.res.getString("Cancel"), 'C', new ReflectionAction(this, "cancelButton_actionPerformed"));
    private DbaButton helpButton = new DbaButton(this.res.getString("Help"), 'H');
    private DbaButton addButton = new DbaButton(this.res.getString("Add"), 'A', new ReflectionAction(this, "addButton_actionPerformed"));
    private DbaButton editButton = new DbaButton(this.res.getString("Edit"), 'E', new ReflectionAction(this, "editButton_actionPerformed"));
    private DbaButton removeButton = new DbaButton(this.res.getString("Remove"), 'R', new ReflectionAction(this, "removeButton_actionPerformed"));
    private JList list = null;
    private DefaultListModel listModel = new DefaultListModel();

    public static JdbcDriverDlg createJdbcDriverDlg() {
        JdbcDriverDlg dlg = null;
        dlg = GuiUt.isWindows() ? new JdbcDriverDlg() : new JdbcDriverDlg((Frame)XTMFrame.frame, true);
        return dlg;
    }

    private JdbcDriverDlg(Frame frame, boolean modal) {
        super(frame, "", modal);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private JdbcDriverDlg() {
        super(XTMFrame.frame);
        this.setModal(true);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setResizable(false);
        this.okButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/ut/ok.gif"));
        this.cancelButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/ut/cancel.gif"));
        this.helpButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/ut/help.gif"));
        this.addButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/ut/add.gif"));
        this.removeButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/ut/remove.gif"));
        this.editButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/ut/edit.gif"));
        this.setTitle(this.res.getString("JDBC_Drivers"));
        JPanel panel1 = new JPanel(new BorderLayout(5, 5));
        JPanel panel2 = new JPanel(new FlowLayout());
        panel2.add(this.okButton);
        panel2.add(this.cancelButton);
        panel2.add(this.helpButton);
        XTMFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "jdbcdriverdlg");
        JPanel panel3 = new JPanel(new BorderLayout());
        JPanel panel4 = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel4.add(this.addButton);
        panel4.add(this.editButton);
        panel4.add(this.removeButton);
        Preferences preferences = XTMFrame.frame.getPreferences();
        Enumeration enum1 = preferences.getJdbcDrivers().elements();
        while (enum1.hasMoreElements()) {
            this.listModel.addElement(enum1.nextElement());
        }
        this.list = new JList(this.listModel);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JdbcDriverDlg.this.setButtonStatus();
            }
        });
        JScrollPane scollPane = new JScrollPane();
        scollPane.getViewport().add(this.list);
        scollPane.setPreferredSize(new Dimension(200, 240));
        panel3.add((Component)scollPane, "Center");
        panel3.add((Component)panel4, "East");
        panel1.add((Component)panel3, "Center");
        panel1.add((Component)panel2, "South");
        panel1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(panel1);
        this.setButtonStatus();
    }

    private void setButtonStatus() {
        JdbcDriverDetail item = (JdbcDriverDetail)this.list.getSelectedValue();
        if (item != null && item.isEditable()) {
            this.removeButton.setEnabled(true);
            this.editButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
        }
    }

    public void okButton_actionPerformed(ActionEvent e) {
        Vector v = new Vector();
        ListModel model = this.list.getModel();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            v.add(model.getElementAt(i));
        }
        Preferences preferences = XTMFrame.frame.getPreferences();
        preferences.setJdbcDrivers(v);
        this.setVisible(false);
    }

    public void cancelButton_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    public void addButton_actionPerformed(ActionEvent e) {
        JdbcDriverDetailDlg dlg = JdbcDriverDetailDlg.createJdbcDriverDetailDlg(this, null);
        GuiUt.setCenterLocation(this, dlg);
        dlg.show();
        JdbcDriverDetail detail = dlg.getJdbcDriverDetail();
        if (detail == null) {
            return;
        }
        this.listModel.addElement(detail);
        this.list.setSelectedIndex(this.listModel.getSize() - 1);
    }

    public void editButton_actionPerformed(ActionEvent e) {
        JdbcDriverDetail item = (JdbcDriverDetail)this.list.getSelectedValue();
        if (item == null) {
            return;
        }
        JdbcDriverDetailDlg dlg = JdbcDriverDetailDlg.createJdbcDriverDetailDlg(this, item);
        GuiUt.setCenterLocation(this, dlg);
        dlg.show();
        this.repaint();
    }

    public void removeButton_actionPerformed(ActionEvent e) {
        int index = this.list.getSelectedIndex();
        this.listModel.remove(index);
        if (index > 0) {
            this.list.setSelectedIndex(index - 1);
        }
    }
}

