/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.xtm.gui;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.syscom.tree.AbstractDmMutableTreeNode;
import com.syscom.tree.AbstractDmTransferableTreeNode;
import com.syscom.ut.GuiUt;
import com.syscom.ut.comp.DbaButton;
import com.syscom.ut.comp.DmRadioButton;
import com.syscom.ut.comp.ReflectionAction;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.ut.resource.DBAImageResource;
import com.syscom.ut.text.DmPlainTextArea;
import com.syscom.xml.xtm.XtmInfo;
import com.syscom.xml.xtm.gui.XTMFrame;
import com.syscom.xml.xtm.node.AbstractXtmMutableTreeNode;
import com.syscom.xml.xtm.node.XtmPreparedStatementNode;
import com.syscom.xml.xtm.node.XtmTableNode;
import com.syscom.xml.xtm.undo.AddNodeEdit;
import com.syscom.xml.xtm.undo.RemoveNodeEdit;
import com.syscom.xml.xtm.undo.ReplaceNodeEdit;
import com.syscom.xml.xtm.undo.UpdateNodeEdit;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class XtmNodeDlg
extends JDialog {
    private ResourceBundle res = ResourceBundle.getBundle("com.syscom.xml.xtm.gui.resource.Res", LocaleManager.getLocale());
    private DmRadioButton tableRadioButton = new DmRadioButton(this.res.getString("Table_or_view_"));
    private JComboBox tablesComboBox = new JComboBox();
    private DmRadioButton stmtRadioButton = new DmRadioButton(this.res.getString("Customized_SQL"));
    private JTextArea stmtTextArea = new JTextArea();
    private DbaButton okButton = new DbaButton(this.res.getString("Ok"), 'O', new ReflectionAction(this, "okButton_actionPerformed"));
    private DbaButton cancelButton = new DbaButton(this.res.getString("Cancel"), 'C', new ReflectionAction(this, "cancelButton_actionPerformed"));
    private DbaButton helpButton = new DbaButton(this.res.getString("Help"), 'H');
    private static short TABLE = 0;
    private static short STATEMENT = 1;
    private AbstractXtmMutableTreeNode current = null;
    private short type = TABLE;
    private AbstractDmTransferableTreeNode sel = null;
    private String command = null;

    private XtmNodeDlg(Frame frame, boolean modal, AbstractXtmMutableTreeNode current) {
        super(frame, "", modal);
        this.current = current;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private XtmNodeDlg(AbstractXtmMutableTreeNode current) {
        super(XTMFrame.frame);
        this.setModal(true);
        this.current = current;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static XtmNodeDlg createXtmNodeDlg(AbstractXtmMutableTreeNode current) {
        XtmNodeDlg dlg = null;
        dlg = GuiUt.isWindows() ? new XtmNodeDlg(current) : new XtmNodeDlg((Frame)XTMFrame.frame, true, current);
        return dlg;
    }

    void jbInit() throws Exception {
        this.setResizable(false);
        this.okButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/ut/ok.gif"));
        this.cancelButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/ut/cancel.gif"));
        this.helpButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/ut/help.gif"));
        if (this.current == null) {
            this.setTitle(this.res.getString("New_XTM_control_node"));
            XTMFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "newxtmnodedlg");
        } else {
            this.setTitle(this.res.getString("XTM_control_node"));
            XTMFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "xtmnodedlg");
        }
        JPanel panel2 = new JPanel(new FlowLayout(1));
        panel2.add(this.okButton);
        panel2.add(this.cancelButton);
        panel2.add(this.helpButton);
        this.stmtTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.stmtTextArea.setPreferredSize(new Dimension(400, 100));
        this.initTabesComboBox();
        JPanel panel3 = new JPanel((LayoutManager)new VerticalFlowLayout(true, false));
        JPanel panel4 = new JPanel((LayoutManager)new VerticalFlowLayout(true, false));
        panel3.add(this.tableRadioButton);
        panel3.add(this.tablesComboBox);
        panel4.add(this.stmtRadioButton);
        panel4.add(this.stmtTextArea);
        panel3.setBorder(BorderFactory.createEtchedBorder());
        panel4.setBorder(BorderFactory.createEtchedBorder());
        DmPlainTextArea text = new DmPlainTextArea(this.res.getString("You_can_select_one_of"));
        if (LocaleManager.getLanguageChoice() != 0) {
            text.setWrapStyleWord(false);
        }
        JPanel panel1 = new JPanel((LayoutManager)new VerticalFlowLayout(true, false));
        panel1.add(text);
        panel1.add(panel3);
        panel1.add(panel4);
        panel1.add(panel2);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.tableRadioButton);
        bg.add(this.stmtRadioButton);
        this.tableRadioButton.addActionListener(new ReflectionAction(this, "radioButtonActionPerformed"));
        this.stmtRadioButton.addActionListener(new ReflectionAction(this, "radioButtonActionPerformed"));
        panel1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(panel1);
        this.tableRadioButton.setSelected(true);
        if (this.current != null) {
            if (this.current instanceof XtmTableNode) {
                this.type = TABLE;
                this.tableRadioButton.setSelected(true);
                this.sel = this.searchTable(this.current.getText());
                if (this.sel != null) {
                    this.tablesComboBox.setSelectedItem(this.sel);
                }
            } else if (this.current instanceof XtmPreparedStatementNode) {
                this.type = STATEMENT;
                this.command = this.current.getText();
                this.stmtRadioButton.setSelected(true);
                this.stmtTextArea.setText(this.command);
            }
        }
        this.radioButtonActionPerformed(null);
        this.pack();
    }

    public void radioButtonActionPerformed(ActionEvent e) {
        if (this.tableRadioButton.isSelected()) {
            this.tablesComboBox.setEnabled(true);
            this.stmtTextArea.setEnabled(false);
        } else {
            this.tablesComboBox.setEnabled(false);
            this.stmtTextArea.setEnabled(true);
        }
    }

    private AbstractDmTransferableTreeNode searchTable(String name) {
        XtmInfo info = XTMFrame.frame.getXtmInfo();
        if (info.dbNode == null || info.dbNode.getChildCount() == 0) {
            return null;
        }
        for (AbstractDmTransferableTreeNode node = (AbstractDmTransferableTreeNode)info.dbNode.getFirstChild(); node != null; node = (AbstractDmTransferableTreeNode)node.getNextSibling()) {
            if (node.getText().compareTo(name) != 0) continue;
            return node;
        }
        return null;
    }

    private void initTabesComboBox() {
        XtmInfo info = XTMFrame.frame.getXtmInfo();
        if (info.dbNode == null || info.dbNode.getChildCount() == 0) {
            return;
        }
        Vector<AbstractDmMutableTreeNode> v = new Vector<AbstractDmMutableTreeNode>(info.dbNode.getChildCount());
        for (AbstractDmMutableTreeNode node = (AbstractDmMutableTreeNode)info.dbNode.getFirstChild(); node != null; node = (AbstractDmMutableTreeNode)node.getNextSibling()) {
            v.add(node);
        }
        DefaultComboBoxModel model = new DefaultComboBoxModel(v);
        this.tablesComboBox.setModel(model);
    }

    public void okButton_actionPerformed(ActionEvent e) {
        XtmInfo info = XTMFrame.frame.getXtmInfo();
        AbstractXtmMutableTreeNode node = info.xtmTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (this.stmtRadioButton.isSelected() && this.stmtTextArea.getText().trim().length() == 0) {
            GuiUt.showErrorDlg(this, this.res.getString("Empty_complete_SQL_script"));
            return;
        }
        CompoundEdit edit = null;
        if (this.current != null && (this.type == TABLE && !this.tableRadioButton.isSelected() || this.type == STATEMENT && this.tableRadioButton.isSelected())) {
            node = (AbstractXtmMutableTreeNode)this.current.getParent();
            int pos = node.getIndex(this.current);
            info.xtmTree.removeNodeFromParent(this.current, true);
            edit = new ReplaceNodeEdit();
            this.postEdit(edit);
            this.postEdit(new RemoveNodeEdit(info.xtmTree, node, this.current, pos, true));
            this.current = null;
        }
        if (this.current == null) {
            if (this.tableRadioButton.isSelected()) {
                AbstractDmTransferableTreeNode table = (AbstractDmTransferableTreeNode)this.tablesComboBox.getSelectedItem();
                if (table == null) {
                    return;
                }
                this.postEdit(node.accept(table, info.xtmTree));
            } else {
                String cmd = this.stmtTextArea.getText();
                XtmPreparedStatementNode stmt = new XtmPreparedStatementNode(cmd);
                if (stmt.isCatching) {
                    return;
                }
                int pos = node.getChildCount();
                info.xtmTree.insertNodeInto(stmt, node, pos, true);
                this.postEdit(new AddNodeEdit(info.xtmTree, node, stmt, pos, true));
            }
        } else if (this.tableRadioButton.isSelected()) {
            AbstractDmTransferableTreeNode table = (AbstractDmTransferableTreeNode)this.tablesComboBox.getSelectedItem();
            if (table == null) {
                return;
            }
            if (!table.equals(this.sel)) {
                AbstractXtmMutableTreeNode parent = (AbstractXtmMutableTreeNode)this.current.getParent();
                int pos = parent.getIndex(this.current);
                info.xtmTree.removeNodeFromParent(this.current, true);
                edit = new ReplaceNodeEdit();
                this.postEdit(edit);
                this.postEdit(new RemoveNodeEdit(info.xtmTree, parent, this.current, pos, true));
                this.postEdit(parent.accept(table, info.xtmTree));
            }
        } else {
            String value = this.stmtTextArea.getText();
            if (value.compareTo(this.command) != 0) {
                this.current.setText(value);
                edit = new UpdateNodeEdit(info.xtmTree, this.current, this.command, value, "text", true);
                this.postEdit(edit);
                try {
                    ((XtmPreparedStatementNode)this.current).updateParameters(info.xtmTree);
                }
                catch (Exception e1) {
                    GuiUt.showErrorDlg(this, e1.getMessage());
                    return;
                }
                info.xtmTree.nodeChanged(this.current);
            }
        }
        if (edit != null) {
            edit.end();
        }
        info.xtmTree.revalidate();
        info.xtmTree.repaint();
        this.setVisible(false);
    }

    public void cancelButton_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    private void postEdit(UndoableEdit edit) {
        XTMFrame.frame.postEdit(edit);
    }
}

