/*
 * Decompiled with CFR 0.152.
 */
package dbmaker.sql;

import dbmaker.sql.JdbcOdbcBoundParam;
import dbmaker.sql.JdbcOdbcConnection;
import dbmaker.sql.JdbcOdbcPreparedStatement;
import dbmaker.sql.ODBCDef;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;

public class JdbcOdbcCallableStatement
extends JdbcOdbcPreparedStatement
implements CallableStatement {
    private boolean[] lastwasNull = new boolean[1];

    public JdbcOdbcCallableStatement(JdbcOdbcConnection jdbcOdbcConnection, long l, String string) throws SQLException {
        super(jdbcOdbcConnection, l, string);
        this.lastwasNull[0] = false;
        this.initialize();
    }

    private void initialize() throws SQLException {
        if (this.nParam > 0) {
            for (int i = 0; i < this.nParam; ++i) {
                try {
                    this.boundParam[i].prec = this.ODBCOBJ.jdbcGetParamPrec(this.hSTMT, i + 1);
                    this.boundParam[i].descType = this.ODBCOBJ.jdbcGetParamType(this.hSTMT, i + 1);
                    continue;
                }
                catch (SQLWarning sQLWarning) {
                    this.lastWarning = sQLWarning;
                }
            }
        }
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        if (this.needTrace) {
            this.trace("CallableStatement.registerOutParameter " + n + ", " + n2 + ")");
        }
        this.checkClosed(this.isClosed());
        this.registerOutParameter(n, n2, 0);
    }

    private boolean isNumeric(int n) {
        switch (n) {
            case -5: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        int n4 = 0;
        if (this.needTrace) {
            this.trace("CallableStatement.registerOutParameter " + n + ", " + n2 + ", " + n3 + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        jdbcOdbcBoundParam.setOutputParameter(true);
        if (n2 == 2) {
            n2 = jdbcOdbcBoundParam.isInOutParameter() && jdbcOdbcBoundParam.boundValue != null ? this.getObjectType(jdbcOdbcBoundParam.boundValue) : 3;
        }
        this.checkType(n2);
        this.checkClosed(this.isClosed());
        switch (n2) {
            case -5: {
                n4 = PARAM_BIGINT_LEN;
                break;
            }
            case 4: 
            case 5: {
                n4 = PARAM_INT_LEN;
                break;
            }
            case 6: 
            case 7: {
                n4 = PARAM_FLOAT_LEN;
                break;
            }
            case 8: {
                n4 = PARAM_DOUBLE_LEN;
                break;
            }
            case 91: {
                n4 = PARAM_DATE_LEN;
                break;
            }
            case 92: {
                n4 = PARAM_TIME_LEN;
                break;
            }
            case 93: {
                n4 = PARAM_TIMESTAMP_LEN;
                break;
            }
            case 3: {
                n4 = 43;
                n4 *= 2;
                break;
            }
            case -2: {
                n4 = jdbcOdbcBoundParam.prec;
                break;
            }
            default: {
                switch (jdbcOdbcBoundParam.descType) {
                    case 3: {
                        n4 = 43;
                        break;
                    }
                    case 4: 
                    case 5: {
                        n4 = 12;
                        break;
                    }
                    case -5: {
                        n4 = 21;
                        break;
                    }
                    case 6: 
                    case 7: {
                        n4 = 23;
                        break;
                    }
                    case 8: {
                        n4 = 23;
                        break;
                    }
                    case 9: 
                    case 91: {
                        n4 = 11;
                        break;
                    }
                    case 10: 
                    case 92: {
                        n4 = 9;
                        break;
                    }
                    case 11: 
                    case 93: {
                        n4 = 30;
                        break;
                    }
                    case -2: {
                        n4 = jdbcOdbcBoundParam.prec * 2 + 1;
                        break;
                    }
                    default: {
                        n4 = jdbcOdbcBoundParam.prec + 1;
                    }
                }
                n4 *= 2;
            }
        }
        int n5 = JdbcOdbcCallableStatement.jdbcTypeToCType(n2);
        jdbcOdbcBoundParam.type = (short)n5;
        if (jdbcOdbcBoundParam.isInOutParameter() && jdbcOdbcBoundParam.boundValue != null) {
            int n6 = this.getObjectType(jdbcOdbcBoundParam.boundValue);
            if (!(this.isNumeric(n6) && this.isNumeric(n2) || n6 == n2)) {
                throw new SQLException("Type mismatch between the set function and registerOutParameter");
            }
            long[] lArray = jdbcOdbcBoundParam.releasePointers;
            lArray[4] = jdbcOdbcBoundParam.dataBuf.length;
            lArray[5] = n3;
            jdbcOdbcBoundParam.sqlType = (short)n2;
            jdbcOdbcBoundParam.type = (short)n5;
            try {
                JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
                synchronized (jdbcOdbcConnection) {
                    this.ODBCOBJ.jdbcBindInOutParameter(this.getHSTMT(), n, n5, n2, jdbcOdbcBoundParam.dataBuf, jdbcOdbcBoundParam.indBuf, jdbcOdbcBoundParam.releasePointers);
                }
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
            return;
        }
        byte[] byArray = jdbcOdbcBoundParam.allocDataBuf(n4);
        long[] lArray = jdbcOdbcBoundParam.getIndBuf();
        long[] lArray2 = jdbcOdbcBoundParam.releasePointers;
        lArray2[1] = 0L;
        lArray2[0] = 0L;
        lArray2[3] = 0L;
        lArray2[2] = 0L;
        lArray2[4] = jdbcOdbcBoundParam.descType == 3 ? 39L : (long)n4;
        lArray2[5] = n3;
        if (n2 == -15) {
            n2 = -8;
        } else if (n2 == -9) {
            n2 = -9;
        }
        this.freeGlobalVar(jdbcOdbcBoundParam);
        if (jdbcOdbcBoundParam.isInOutParameter()) {
            try {
                JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
                synchronized (jdbcOdbcConnection) {
                    this.ODBCOBJ.jdbcBindInOutParameterNull(this.getHSTMT(), n, n5, n2, byArray, lArray, lArray2);
                }
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
            return;
        }
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.ODBCOBJ.jdbcBindOutParameter(this.getHSTMT(), n, n5, jdbcOdbcBoundParam.descType, byArray, lArray, lArray2);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
    }

    public boolean wasNull() throws SQLException {
        if (this.needTrace) {
            this.trace("Callablestatement.wasNull");
        }
        this.checkClosed(this.isClosed());
        return this.lastwasNull[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isParameterNull(int n) throws SQLException {
        long l = 0L;
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        if (!jdbcOdbcBoundParam.isOutputParameter()) {
            throw new SQLException("Parameter " + n + " is not an OUTPUT parameter");
        }
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
            synchronized (jdbcOdbcConnection) {
                l = this.ODBCOBJ.jdbcGetParameterInd(this.getHSTMT(), n, jdbcOdbcBoundParam.releasePointers[2]);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        this.lastwasNull[0] = l == -1L;
        return this.lastwasNull[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int n) throws SQLException {
        String string;
        int n2 = 0;
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        if (this.needTrace) {
            this.trace("CallableStatement.getString (" + n + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        this.checkClosed(this.isClosed());
        this.lastwasNull[0] = this.isParameterNull(n);
        if (this.lastwasNull[0]) {
            return null;
        }
        switch (jdbcOdbcBoundParam.type) {
            case 92: {
                return this.getTime(n).toString();
            }
            case 91: {
                return this.getDate(n).toString();
            }
            case 93: {
                return this.getTimestamp(n).toString();
            }
        }
        byte[] byArray = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            byArray = this.ODBCOBJ.jdbcGetParameterDatabuf(this.getHSTMT(), n, jdbcOdbcBoundParam.dataBuf.length, jdbcOdbcBoundParam.releasePointers[0]);
        }
        int n3 = 0;
        while (n3 < byArray.length && (byArray[n3] != 0 || byArray[n3 + 1] != 0)) {
            n3 += 2;
            n2 += 2;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        try {
            string = new String(byArray2, ODBCDef.DM_UNICODE);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("encoding unsupported");
        }
        return string;
    }

    public boolean getBoolean(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("CallableStatement.getBoolean (" + n + ")");
        }
        this.checkClosed(this.isClosed());
        int n2 = this.getInt(n);
        return n2 != 0 && !this.wasNull();
    }

    public byte getByte(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("CallableStatement.getByte (" + n + ")");
        }
        this.checkClosed(this.isClosed());
        byte[] byArray = this.getBytes(n);
        if (!this.wasNull()) {
            return byArray[0];
        }
        return 0;
    }

    public short getShort(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("CallableStatement.getShort (" + n + ")");
        }
        return (short)this.getInt(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int n) throws SQLException {
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        if (this.needTrace) {
            this.trace("CallableStatement.getInt (" + n + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        this.checkClosed(this.isClosed());
        if (jdbcOdbcBoundParam.type == -8) {
            String string = this.getString(n);
            return Integer.parseInt(string);
        }
        this.lastwasNull[0] = this.isParameterNull(n);
        if (this.lastwasNull[0]) {
            return 0;
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            return this.ODBCOBJ.sqlGetParameterInt(this.getHSTMT(), n, jdbcOdbcBoundParam.releasePointers[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int n) throws SQLException {
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        if (this.needTrace) {
            this.trace("CallableStatement.getFloat (" + n + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        this.checkClosed(this.isClosed());
        this.lastwasNull[0] = this.isParameterNull(n);
        if (this.lastwasNull[0]) {
            return 0.0f;
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            return this.ODBCOBJ.sqlGetParameterFloat(this.getHSTMT(), n, jdbcOdbcBoundParam.releasePointers[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int n) throws SQLException {
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        if (this.needTrace) {
            this.trace("CallableStatement.getDouble (" + n + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        this.checkClosed(this.isClosed());
        this.lastwasNull[0] = this.isParameterNull(n);
        if (this.lastwasNull[0]) {
            return 0.0;
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            return this.ODBCOBJ.sqlGetParameterDouble(this.getHSTMT(), n, jdbcOdbcBoundParam.releasePointers[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("CallableStatement.getBytes (" + n + ")");
        }
        this.checkClosed(this.isClosed());
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        if (this.needTrace) {
            this.trace("CallableStatement.getString (" + n + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        if (this.lastwasNull[0] = this.isParameterNull(n)) {
            return null;
        }
        byte[] byArray = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            byArray = this.ODBCOBJ.jdbcGetParameterDatabuf(this.getHSTMT(), n, jdbcOdbcBoundParam.dataBuf.length, jdbcOdbcBoundParam.releasePointers[0]);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int n) throws SQLException {
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        if (this.needTrace) {
            this.trace("CallableStatement.getDate (" + n + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        this.checkClosed(this.isClosed());
        this.lastwasNull[0] = this.isParameterNull(n);
        if (this.lastwasNull[0]) {
            return null;
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            return this.ODBCOBJ.jdbcGetParameterDate(this.getHSTMT(), n, jdbcOdbcBoundParam.releasePointers[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int n) throws SQLException {
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        if (this.needTrace) {
            this.trace("CallableStatement.getTime (" + n + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        this.checkClosed(this.isClosed());
        this.lastwasNull[0] = this.isParameterNull(n);
        if (this.lastwasNull[0]) {
            return null;
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            return this.ODBCOBJ.jdbcGetParameterTime(this.getHSTMT(), n, jdbcOdbcBoundParam.releasePointers[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int n) throws SQLException {
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        if (this.needTrace) {
            this.trace("CallableStatement.getTimestamp (" + n + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        this.checkClosed(this.isClosed());
        this.lastwasNull[0] = this.isParameterNull(n);
        if (this.lastwasNull[0]) {
            return null;
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            return this.ODBCOBJ.jdbcGetParameterTimestamp(this.getHSTMT(), n, jdbcOdbcBoundParam.releasePointers[0]);
        }
    }

    public Object getObject(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("CallableStatement.getObject (" + n + ")");
        }
        this.checkClosed(this.isClosed());
        switch (this.boundParam[n - 1].descType) {
            case -1: 
            case 1: 
            case 3: 
            case 12: {
                return this.getString(n);
            }
            case -4: 
            case -2: {
                return new Byte(new String(this.getBytes(n)));
            }
            case 5: {
                return new Short(this.getShort(n));
            }
            case 4: {
                return new Integer(this.getInt(n));
            }
            case 6: {
                return new Float(this.getDouble(n));
            }
            case 7: {
                return new Float(this.getFloat(n));
            }
            case 8: {
                return new Double(this.getDouble(n));
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
        }
        return null;
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        if (this.needTrace) {
            this.trace("CallableStatement.getDate(" + n + "," + calendar + ")");
        }
        this.checkClosed(this.isClosed());
        Date date = this.getDate(n);
        long l = calendar.getTimeZone().getRawOffset();
        long l2 = TimeZone.getDefault().getRawOffset();
        return new Date(date.getTime() + (l2 - l));
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        if (this.needTrace) {
            this.trace("CallableStatement.getTime(" + n + "," + calendar + ")");
        }
        this.checkClosed(this.isClosed());
        Time time = this.getTime(n);
        long l = calendar.getTimeZone().getRawOffset();
        long l2 = TimeZone.getDefault().getRawOffset();
        return new Time(time.getTime() + (l2 - l));
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (this.needTrace) {
            this.trace("CallableStatement.getTimeStamp(" + n + "," + calendar + ")");
        }
        this.checkClosed(this.isClosed());
        Timestamp timestamp = this.getTimestamp(n);
        long l = calendar.getTimeZone().getRawOffset();
        long l2 = TimeZone.getDefault().getRawOffset();
        return new Timestamp(timestamp.getTime() + (l2 - l));
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getBigDecimal(int, int)", null);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        String string = this.getString(n);
        return new BigDecimal(string);
    }

    public Ref getRef(int n) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getRef(int)", null);
    }

    public Array getArray(int n) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getArray(int)", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int n) throws SQLException {
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        if (this.needTrace) {
            this.trace("CallableStatement.getLong (" + n + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        this.checkClosed(this.isClosed());
        this.lastwasNull[0] = this.isParameterNull(n);
        if (this.lastwasNull[0]) {
            return 0L;
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            return this.ODBCOBJ.sqlGetParameterLong(this.getHSTMT(), n, jdbcOdbcBoundParam.releasePointers[0]);
        }
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.registerOutParameter(int, int, String)", null);
    }

    public Blob getBlob(int n) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getBlob(int)", null);
    }

    public Clob getClob(int n) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getClob(int)", null);
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.registerOutParameter(String parameterName, int sqlType)", null);
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.registerOutParameter(String parameterName, int sqlType, int scale)", null);
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.registerOutParameter(String parameterName, int sqlType, String typeName)", null);
    }

    public URL getURL(int n) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getURL(int parameterIndex)", null);
    }

    public void setURL(String string, URL uRL) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getURL(int parameterIndex)", null);
    }

    public void setNull(String string, int n) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.setNull(String parameterName, int sqlType)", null);
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.setBoolean(String parameterName, boolean x)", null);
    }

    public void setByte(String string, byte by) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.setByte(String parameterName, byte x)", null);
    }

    public void setShort(String string, short s) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.setShort(String parameterName, short x)", null);
    }

    public void setInt(String string, int n) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.setInt(String parameterName, int x)", null);
    }

    public void setLong(String string, long l) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.setLong(String parameterName, long x)", null);
    }

    public void setFloat(String string, float f) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.setFloat(String parameterName, float x)", null);
    }

    public void setDouble(String string, double d) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.setDouble(String parameterName, double x)", null);
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.setBigDecimal(String parameterName, BigDecimal x)", null);
    }

    public void setString(String string, String string2) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.setString(String parameterName, String x)", null);
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.setBytes(String parameterName, byte[] x)", null);
    }

    public void setDate(String string, Date date) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.setDate(String parameterName, Date x)", null);
    }

    public void setTime(String string, Time time) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.setTime(String parameterName, Time x)", null);
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.setTime(String parameterName, Timestamp x)", null);
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.setAsciiStream(String parameterName, InputStream x, int length)", null);
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.setBinaryStream(String parameterName, InputStream x, int length)", null);
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.setObject(String parameterName, Object x,int targetSqlType, int scale)", null);
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.setObject(String parameterName, Object x, int targetSqlType)", null);
    }

    public void setObject(String string, Object object) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.setObject(String parameterName, Object x)", null);
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.setCharacterStream(String parameterName, Reader reader, int length)", null);
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.setDate(String parameterName, Date x, Calendar cal)", null);
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.setTime(String parameterName, Time x, Calendar cal)", null);
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.setTimestamp(String parameterName, Timestamp x, Calendar cal)", null);
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.setNull(String parameterName, int sqlType, String typeName)", null);
    }

    public String getString(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getString(String parameterName)", null);
    }

    public boolean getBoolean(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getBoolean(String parameterName)", null);
    }

    public byte getByte(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getByte(String parameterName)", null);
    }

    public short getShort(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getShort(String parameterName)", null);
    }

    public int getInt(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getInt(String parameterName)", null);
    }

    public long getLong(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getLong(String parameterName)", null);
    }

    public float getFloat(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getFloat(String parameterName)", null);
    }

    public double getDouble(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getDouble(String parameterName)", null);
    }

    public byte[] getBytes(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getBytes(String parameterName)", null);
    }

    public Date getDate(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getDate(String parameterName)", null);
    }

    public Time getTime(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getTime(String parameterName)", null);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getTimestamp(String parameterName)", null);
    }

    public Object getObject(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getObject(String parameterName)", null);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getBigDecimal(String parameterName)", null);
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getObject(String parameterName, Map map)", null);
    }

    public Ref getRef(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getRef(String parameterName)", null);
    }

    public Blob getBlob(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getBlob(String parameterName)", null);
    }

    public Clob getClob(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getClob(String parameterName)", null);
    }

    public Array getArray(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getArray(String parameterName)", null);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getDate(String parameterName, Calendar cal)", null);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getTime(String parameterName, Calendar cal)", null);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getTimestamp(String parameterName, Calendar cal)", null);
    }

    public URL getURL(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getURL(String parameterName)", null);
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "CallableStatement.getObject(int)", null);
    }
}

