/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codecimpl.JaiI18N;

public class TIFFLZWDecoder {
    byte[][] stringTable;
    byte[] data = null;
    byte[] uncompData;
    int tableIndex;
    int bitsToGet = 9;
    int bytePointer;
    int bitPointer;
    int dstIndex;
    int w;
    int h;
    int predictor;
    int samplesPerPixel;
    int nextData = 0;
    int nextBits = 0;
    int[] andTable = new int[]{511, 1023, 2047, 4095};

    public TIFFLZWDecoder(int n, int n2, int n3) {
        this.w = n;
        this.predictor = n2;
        this.samplesPerPixel = n3;
    }

    public byte[] decode(byte[] byArray, byte[] byArray2, int n) {
        int n2;
        if (byArray[0] == 0 && byArray[1] == 1) {
            throw new UnsupportedOperationException(JaiI18N.getString("TIFFLZWDecoder0"));
        }
        this.initializeStringTable();
        this.data = byArray;
        this.h = n;
        this.uncompData = byArray2;
        this.bytePointer = 0;
        this.bitPointer = 0;
        this.dstIndex = 0;
        this.nextData = 0;
        this.nextBits = 0;
        int n3 = 0;
        while ((n2 = this.getNextCode()) != 257 && this.dstIndex != byArray2.length) {
            byte[] byArray3;
            if (n2 == 256) {
                this.initializeStringTable();
                n2 = this.getNextCode();
                if (n2 == 257) break;
                this.writeString(this.stringTable[n2]);
                n3 = n2;
                continue;
            }
            if (n2 < this.tableIndex) {
                byArray3 = this.stringTable[n2];
                this.writeString(byArray3);
                this.addStringToTable(this.stringTable[n3], byArray3[0]);
                n3 = n2;
                continue;
            }
            byArray3 = this.stringTable[n3];
            byArray3 = this.composeString(byArray3, byArray3[0]);
            this.writeString(byArray3);
            this.addStringToTable(byArray3);
            n3 = n2;
        }
        if (this.predictor == 2) {
            int n4 = 0;
            while (n4 < n) {
                int n5 = this.samplesPerPixel * (n4 * this.w + 1);
                int n6 = this.samplesPerPixel;
                while (n6 < this.w * this.samplesPerPixel) {
                    int n7 = n5;
                    byArray2[n7] = (byte)(byArray2[n7] + byArray2[n5 - this.samplesPerPixel]);
                    ++n5;
                    ++n6;
                }
                ++n4;
            }
        }
        return byArray2;
    }

    public void initializeStringTable() {
        this.stringTable = new byte[4096][];
        int n = 0;
        while (n < 256) {
            this.stringTable[n] = new byte[1];
            this.stringTable[n][0] = (byte)n;
            ++n;
        }
        this.tableIndex = 258;
        this.bitsToGet = 9;
    }

    public void writeString(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            this.uncompData[this.dstIndex++] = byArray[n];
            ++n;
        }
    }

    public void addStringToTable(byte[] byArray, byte by) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray2[n] = by;
        this.stringTable[this.tableIndex++] = byArray2;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public void addStringToTable(byte[] byArray) {
        this.stringTable[this.tableIndex++] = byArray;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public byte[] composeString(byte[] byArray, byte by) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray2[n] = by;
        return byArray2;
    }

    public int getNextCode() {
        try {
            this.nextData = this.nextData << 8 | this.data[this.bytePointer++] & 0xFF;
            this.nextBits += 8;
            if (this.nextBits < this.bitsToGet) {
                this.nextData = this.nextData << 8 | this.data[this.bytePointer++] & 0xFF;
                this.nextBits += 8;
            }
            int n = this.nextData >> this.nextBits - this.bitsToGet & this.andTable[this.bitsToGet - 9];
            this.nextBits -= this.bitsToGet;
            return n;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 257;
        }
    }
}

