/*
 * Decompiled with CFR 0.152.
 */
package dbmaker.jdbc.ws.client;

import com.caucho.hessian.client.DMHessianProxyFactory;
import dbmaker.jdbc.ws.client.Connection;
import dbmaker.jdbc.ws.client.ResultSet;
import dbmaker.jdbc.ws.client.ServiceClient;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class Statement
extends ServiceClient
implements java.sql.Statement {
    protected Connection _conn = null;
    protected com.dbmaker.jdbc.ws.IF.Statement _statement = null;
    protected boolean _hasResultSet = false;
    protected boolean _isClosed = false;

    public Statement(DMHessianProxyFactory dMHessianProxyFactory, long l, Connection connection) throws Exception {
        super(dMHessianProxyFactory, l);
        this._conn = connection;
        this._statement = (com.dbmaker.jdbc.ws.IF.Statement)dMHessianProxyFactory.createObject("Statement");
    }

    @Override
    public void addBatch(String string) throws SQLException {
        this.checkClosed(this._isClosed);
        this._statement.addBatch(this._index, string);
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClosed(this._isClosed);
        this._statement.cancel(this._index);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkClosed(this._isClosed);
        this._statement.clearBatch(this._index);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed(this._isClosed);
        this._statement.clearWarnings(this._index);
    }

    @Override
    public void close() throws SQLException {
        if (this._isClosed) {
            throw new SQLWarning("Statement has been closed");
        }
        this._statement.close(this._index);
        this._isClosed = true;
    }

    @Override
    public boolean execute(String string) throws SQLException {
        this.checkClosed(this._isClosed);
        this._hasResultSet = this._statement.execute(this._index, string);
        return this._hasResultSet;
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        throw Statement.JDBCErrorNotSupport(this.SERVICE_CLASSNAME, "execute(String sql, int autoGeneratedKeys)");
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        throw Statement.JDBCErrorNotSupport(this.SERVICE_CLASSNAME, "execute(String sql, int[] columnIndexes)");
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw Statement.JDBCErrorNotSupport(this.SERVICE_CLASSNAME, "execute(String sql, String[] columnNames)");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClosed(this._isClosed);
        try {
            return this._statement.executeBatch(this._index);
        }
        catch (Exception exception) {
            throw this.checkException(exception);
        }
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        this.checkClosed(this._isClosed);
        try {
            if (this.execute(string)) {
                return this.getResultSet();
            }
        }
        catch (Exception exception) {
            throw this.checkException(exception);
        }
        return null;
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        this.checkClosed(this._isClosed);
        try {
            return this._statement.executeUpdate(this._index, string);
        }
        catch (Exception exception) {
            throw this.checkException(exception);
        }
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        throw Statement.JDBCErrorNotSupport(this.SERVICE_CLASSNAME, "executeUpdate(String sql, int autoGeneratedKeys)");
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw Statement.JDBCErrorNotSupport(this.SERVICE_CLASSNAME, "executeUpdate(String sql, int[] columnIndexes)");
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw Statement.JDBCErrorNotSupport(this.SERVICE_CLASSNAME, "executeUpdate(String sql, String[] columnNames)");
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._conn;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._statement.getFetchDirection(this._index);
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._statement.getFetchSize(this._index);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw Statement.JDBCErrorNotSupport(this.SERVICE_CLASSNAME, "getGeneratedKeys()");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._statement.getMaxFieldSize(this._index);
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._statement.getMaxRows(this._index);
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._statement.getMoreResults(this._index);
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        return this._statement.getMoreResults2(this._index, n);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._statement.getQueryTimeout(this._index);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed(this._isClosed);
        if (!this._hasResultSet) {
            return null;
        }
        ResultSet resultSet = null;
        try {
            long l = this._statement.getResultSet(this._index);
            resultSet = new ResultSet(this._factory, l, this);
        }
        catch (Exception exception) {
            throw this.checkException(exception);
        }
        return resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._statement.getResultSetConcurrency(this._index);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._statement.getResultSetHoldability(this._index);
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._statement.getResultSetType(this._index);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._statement.getUpdateCount(this._index);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed(this._isClosed);
        String string = this._statement.getWarnings(this._index);
        if (string != null) {
            return new SQLWarning(string);
        }
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this._isClosed) {
            return this._isClosed;
        }
        return this._statement.isClosed(this._index);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw Statement.JDBCErrorNotSupport(this.SERVICE_CLASSNAME, "isPoolable()");
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.checkClosed(this._isClosed);
        this._statement.setCursorName(this._index, string);
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        throw Statement.JDBCErrorNotSupport(this.SERVICE_CLASSNAME, "setEscapeProcessing(boolean enable)");
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        this._statement.setFetchDirection(this._index, n);
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        this._statement.setFetchSize(this._index, n);
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        this._statement.setMaxFieldSize(this._index, n);
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        this._statement.setMaxRows(this._index, n);
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        throw Statement.JDBCErrorNotSupport(this.SERVICE_CLASSNAME, "setPoolable(boolean poolable)");
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        this._statement.setQueryTimeout(this._index, n);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw Statement.JDBCErrorNotSupport(this.SERVICE_CLASSNAME, "isWrapperFor(Class<?> iface)");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw Statement.JDBCErrorNotSupport(this.SERVICE_CLASSNAME, "unwrap(Class<T> iface)");
    }
}

