/*
 * Decompiled with CFR 0.152.
 */
package dbmaker.sql;

import dbmaker.sql.JdbcOdbc;
import dbmaker.sql.JdbcOdbcAPI;
import dbmaker.sql.JdbcOdbcConnection;
import dbmaker.sql.JdbcOdbcResultSet;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ResourceBundle;
import java.util.Vector;

public class JdbcOdbcStatement
extends JdbcOdbc
implements Statement {
    protected JdbcOdbcConnection myConnection;
    private boolean isClose;
    protected JdbcOdbcAPI ODBCOBJ;
    protected JdbcOdbcResultSet myResultset = null;
    protected long hSTMT;
    protected int fetchDirect;
    protected SQLWarning lastWarning;
    protected boolean hasResult;
    protected boolean executed;
    private int fetchSize = 0;
    private int[] colMapping;
    private Vector batchVector = null;

    public JdbcOdbcStatement(JdbcOdbcConnection jdbcOdbcConnection) throws SQLException {
        this(jdbcOdbcConnection, 0L);
    }

    public JdbcOdbcStatement(JdbcOdbcConnection jdbcOdbcConnection, long l) throws SQLException {
        this.myConnection = jdbcOdbcConnection;
        if (l == 0L) {
            this.initialize();
        } else {
            this.initialize(l);
        }
    }

    private void initialize() throws SQLException {
        long l = 0L;
        this.ODBCOBJ = this.myConnection.myDriver.ODBCOBJ;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            try {
                l = this.ODBCOBJ.jdbcAllocStmt(this.myConnection.getHDBC());
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
            this.initialize(l);
        }
    }

    private void initialize(long l) throws SQLException {
        this.hSTMT = l;
        this.ODBCOBJ = this.myConnection.myDriver.ODBCOBJ;
        this.hasResult = false;
        this.executed = false;
        this.fetchDirect = 1000;
        this.lastWarning = null;
        this.isClose = false;
        this.colMapping = null;
        this.myConnection.registerStmt(this);
    }

    protected void finalize() {
        this.trace("Statement.finalize()");
        try {
            if (!this.myConnection.fgJavaSP) {
                this.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("Statement.executeQuery (" + string + ")");
        }
        if (string == null) {
            this.JDBCError("JERR_CANNOT_NULL_STRING", null);
        } else if (string.length() == 0) {
            this.JDBCError("JERR_CANNOT_EMPTY_STRING", null);
        }
        if (this.execute(string)) {
            return this.getResultSet();
        }
        return null;
    }

    public int executeUpdate(String string) throws SQLException {
        int n = -2;
        if (this.needTrace) {
            this.trace("Statement.executeUpdate (" + string + ")");
        }
        if (string == null) {
            this.JDBCError("JERR_CANNOT_NULL_STRING", null);
        } else if (string.length() == 0) {
            this.JDBCError("JERR_CANNOT_EMPTY_STRING", null);
        }
        this.checkClosed(this.isClosed());
        if (!this.execute(string)) {
            n = this.getUpdateCount();
        }
        return n;
    }

    public void close() throws SQLException {
        if (this.needTrace) {
            this.trace("Statement.close");
        }
        if (this.isClose) {
            throw new SQLWarning("Statement has been close");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClosed());
            this.closeResultset();
            try {
                this.ODBCOBJ.jdbcFreeStmt(this.hSTMT, 1);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
            this.hasResult = false;
            this.executed = false;
            this.hSTMT = 0L;
            this.myConnection.deregisterStmt(this);
            this.isClose = true;
        }
    }

    public void cancel() throws SQLException {
        if (this.needTrace) {
            this.trace("Statement.cancel");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClosed());
            this.closeResultset();
            try {
                this.ODBCOBJ.jdbcCancel(this.hSTMT);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
            this.hasResult = false;
            this.executed = false;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.lastWarning;
    }

    public void clearWarnings() throws SQLException {
        this.lastWarning = null;
    }

    public void setCursorName(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("Statement.setCursorName (" + string + ")");
        }
        if (string == null) {
            this.JDBCError("JERR_CANNOT_NULL_STRING", null);
        } else if (string.length() == 0) {
            this.JDBCError("JERR_CANNOT_EMPTY_STRING", null);
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClosed());
            try {
                this.ODBCOBJ.jdbcSetCursorName(this.hSTMT, string);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
    }

    public boolean execute(String string) throws SQLException {
        return this.execute(string, false);
    }

    private boolean execute(String string, boolean bl) throws SQLException {
        int n = 0;
        if (this.needTrace) {
            this.trace("Statement.execute (" + string + ")");
        }
        if (!bl && this.batchVector != null) {
            this.JDBCError("JERR_EXECUTE_AFTER_ADDBATCH", null);
        }
        if (string == null) {
            this.JDBCError("JERR_CANNOT_NULL_STRING", null);
        } else if (string.length() == 0) {
            this.JDBCError("JERR_CANNOT_EMPTY_STRING", null);
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClosed());
            if (this.myResultset != null && !this.myResultset.isClosed()) {
                this.JDBCError("JERR_PREV_RS_NOT_CLOSED", null);
            }
            try {
                this.ODBCOBJ.jdbcExecDirect(this.hSTMT, string);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
            this.executed = true;
            try {
                n = this.ODBCOBJ.jdbcNumResultCol(this.hSTMT);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
            this.hasResult = n > 0;
            this.colMapping = null;
            if (this.myConnection.getAutoCommit()) {
                this.myConnection.closeBCList(true);
            }
            if (string.toUpperCase().startsWith("SET") && !this.hasResult && this.getUpdateCount() == -1) {
                this.myConnection.initDateTimeFormat();
            }
            boolean bl2 = this.hasResult;
            return bl2;
        }
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.needTrace) {
            this.trace("Statement.getResultSet");
        }
        this.checkClosed(this.isClosed());
        if (this.executed && this.hasResult) {
            this.executed = false;
            if (!this.myConnection.fgJavaSP) {
                this.hasResult = false;
            }
            this.myResultset = new JdbcOdbcResultSet(this.ODBCOBJ, this);
        } else {
            this.myResultset = null;
        }
        return this.myResultset;
    }

    public int getUpdateCount() throws SQLException {
        long l = 0L;
        if (this.needTrace) {
            this.trace("Statement.getUpdateCount");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClosed());
            if (!this.hasResult) {
                try {
                    l = this.ODBCOBJ.jdbcRowCount(this.hSTMT);
                }
                catch (SQLWarning sQLWarning) {
                    this.lastWarning = sQLWarning;
                }
                int n = (int)l;
                return n;
            }
            int n = -1;
            return n;
        }
    }

    public void setFetchDirection(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("Statement.setFetchDirection (" + n + ")");
        }
        this.checkClosed(this.isClosed());
        if (n == 1000 || n == 1002) {
            this.fetchDirect = n;
        } else if (n == 1001) {
            this.JDBCError("JERR_UNSUPPORT_FETCH_DIRECTION_VAL", "FETCH_REVERSE");
        } else {
            this.JDBCError("JERR_INV_FETCH_DIRECTION_VAL", "FETCH_UNKNOWN, FETCH_FORWARD,or FETCH_REVERSE");
        }
    }

    public int getFetchDirection() throws SQLException {
        if (this.needTrace) {
            this.trace("Statement.getFetchDirection");
        }
        this.checkClosed(this.isClosed());
        return this.fetchDirect;
    }

    public int getResultSetConcurrency() throws SQLException {
        int n = 0;
        int n2 = 0;
        if (this.needTrace) {
            this.trace("Statement.getResultSetConcurrency");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClosed());
            try {
                n = this.ODBCOBJ.jdbcGetStmtAttrInt(this.hSTMT, 7);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
        switch (n) {
            case 1: {
                n2 = 1007;
                break;
            }
            case 2: {
                n2 = 1008;
                break;
            }
            default: {
                this.JDBCError("JERR_INTERNAL_ERROR", "- Statement.getResultSetConcurrency(), resultSetConcurrency");
            }
        }
        return n2;
    }

    public int getResultSetType() throws SQLException {
        int n = 0;
        int n2 = 0;
        if (this.needTrace) {
            this.trace("Statement.getResultSetType");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClosed());
            try {
                n = this.ODBCOBJ.jdbcGetStmtAttrInt(this.hSTMT, 6);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
        switch (n) {
            case 0: {
                n2 = 1003;
                break;
            }
            case 3: {
                n2 = 1004;
                break;
            }
            case 1: 
            case 2: {
                n2 = 1005;
                break;
            }
            default: {
                this.JDBCError("JERR_INTERNAL_ERROR", "- Statement.getResultSetType(), resultSetType");
            }
        }
        return n2;
    }

    public Connection getConnection() throws SQLException {
        if (this.needTrace) {
            this.trace("Statement.getConnection");
        }
        this.checkClosed(this.isClosed());
        return this.myConnection;
    }

    public void setMaxRows(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("setMaxRows(" + n + ")");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClosed());
            try {
                this.ODBCOBJ.jdbcSetStmtAttrInt(this.hSTMT, 1, n);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
    }

    public int getMaxRows() throws SQLException {
        int n = 0;
        if (this.needTrace) {
            this.trace("getMaxRows");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClosed());
            try {
                n = this.ODBCOBJ.jdbcGetStmtAttrInt(this.hSTMT, 1);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
        return n;
    }

    public void setFetchSize(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("setFetchSize(" + n + ")");
        }
        this.checkClosed(this.isClosed());
        if (n < 0) {
            this.JDBCError("JERR_INV_FETCH_SIZE", "ResultSet.setFetchSize(" + n + ")");
        }
        this.fetchSize = n;
    }

    public int getFetchSize() throws SQLException {
        if (this.needTrace) {
            this.trace("getFetchSize()");
        }
        this.checkClosed(this.isClosed());
        return this.fetchSize;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.getOptionInt(3);
    }

    public void setMaxFieldSize(int n) throws SQLException {
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "Statement.setEscapeProcessing(boolean)", null);
    }

    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    public void setQueryTimeout(int n) throws SQLException {
    }

    public void addBatch(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("addBatch (" + string + ")");
        }
        if (this.batchVector == null) {
            this.batchVector = new Vector();
        }
        this.batchVector.add(string);
    }

    public void clearBatch() throws SQLException {
        if (this.needTrace) {
            this.trace("clearBatch");
        }
        if (this.batchVector != null) {
            this.batchVector.clear();
            this.batchVector = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public int[] executeBatch() throws SQLException {
        if (this.needTrace) {
            this.trace("executeBatch");
        }
        var1_1 = new int[]{};
        if (this.batchVector == null) {
            return var1_1;
        }
        var2_2 = new int[]{};
        var3_3 = 0;
        var4_4 = this.batchVector.elements();
        var1_1 = new int[this.batchVector.size()];
        var5_5 = 0;
        while (var5_5 < var1_1.length) {
            block11: {
                if (var4_4.hasMoreElements()) {
                    var6_6 = (String)var4_4.nextElement();
                    try {
                        if (!this.execute(var6_6, true)) {
                            var1_1[var5_5] = this.getUpdateCount();
                            if (var1_1[var5_5] == -1) {
                                var1_1[var5_5] = -2;
                            }
                            ++var3_3;
                        } else {
                            var7_7 = this.getResultSet();
                            if (var7_7 != null) {
                                var7_7.close();
                            }
                            this.JDBCError("JERR_INVALID_SELECT_BATCH", null);
                        }
                        break block11;
                    }
                    catch (SQLException var7_8) {
                        var2_2 = new int[var3_3];
                        var8_9 = 0;
                        ** while (var8_9 <= var5_5 - 1)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var2_2[var8_9] = var1_1[var8_9];
                        ++var8_9;
                        continue;
                    }
lbl33:
                    // 1 sources

                    this.clearBatch();
                    throw new BatchUpdateException(var7_8.getMessage(), var7_8.getSQLState(), var7_8.getErrorCode(), var2_2);
                }
            }
            ++var5_5;
        }
        this.clearBatch();
        return var1_1;
    }

    public boolean getMoreResults() throws SQLException {
        int n = 0;
        if (this.myResultset != null) {
            this.closeResultset();
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClosed());
            try {
                this.hasResult = this.ODBCOBJ.jdbcMoreResults(this.hSTMT);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
            if (!this.hasResult) {
                boolean bl = this.hasResult;
                return bl;
            }
            this.executed = true;
            try {
                n = this.ODBCOBJ.jdbcNumResultCol(this.hSTMT);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
            this.hasResult = n > 0;
            this.colMapping = null;
            if (this.myConnection.getAutoCommit()) {
                this.myConnection.closeBCList(true);
            }
            boolean bl = this.hasResult;
            return bl;
        }
    }

    protected void resetSTMT() throws SQLException {
        if (this.myResultset != null) {
            this.closeResultset();
        } else if (this.executed && this.hasResult) {
            JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.checkClosed(this.isClosed());
                try {
                    this.ODBCOBJ.jdbcFreeStmt(this.hSTMT, 0);
                }
                catch (SQLWarning sQLWarning) {
                    this.lastWarning = sQLWarning;
                }
            }
        }
    }

    protected void closeResultset() throws SQLException {
        if (this.myResultset != null && !this.myResultset.isClosed()) {
            this.myResultset.close();
            this.myResultset = null;
        }
        this.colMapping = null;
    }

    public String getOptionStr(int n) throws SQLException {
        String string = null;
        if (this.needTrace) {
            this.trace("Statement.getOptionStr(" + n + ")");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClosed());
            try {
                string = this.ODBCOBJ.jdbcGetStmtAttrString(this.hSTMT, n);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
        return string;
    }

    public int getOptionInt(int n) throws SQLException {
        int n2 = 0;
        if (this.needTrace) {
            this.trace("getOptionInt(" + n + ")");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClosed());
            try {
                n2 = this.ODBCOBJ.jdbcGetStmtAttrInt(this.hSTMT, n);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
        return n2;
    }

    public byte[] getOptionBytes(int n) throws SQLException {
        byte[] byArray = null;
        if (this.needTrace) {
            this.trace("getOptionBytes(" + n + ")");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClosed());
            try {
                byArray = this.ODBCOBJ.jdbcGetStmtAttrBytes(this.hSTMT, n);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
        return byArray;
    }

    public void setOption(int n, String string) throws SQLException {
        if (this.needTrace) {
            this.trace("setOption(" + n + "," + string + ")");
        }
        this.checkClosed(this.isClosed());
        try {
            this.ODBCOBJ.jdbcSetStmtAttrString(this.hSTMT, n, string);
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
    }

    public void setOption(int n, int n2) throws SQLException {
        if (this.needTrace) {
            this.trace("setOption(" + n + "," + n2 + ")");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClosed());
            try {
                this.ODBCOBJ.jdbcSetStmtAttrInt(this.hSTMT, n, n2);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
    }

    public void setOption(int n, byte[] byArray) throws SQLException {
        if (this.needTrace) {
            this.trace("setOption(" + n + "," + byArray + ")");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClosed());
            try {
                this.ODBCOBJ.jdbcSetStmtAttrBytes(this.hSTMT, n, byArray);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
    }

    public int mapColumn(int n) throws SQLException {
        int n2 = n;
        if (this.needTrace) {
            this.trace("Statement.mapColumn(" + n + ")");
        }
        if (this.colMapping != null && n > 0 && n <= this.colMapping.length) {
            n2 = this.colMapping[n - 1];
        }
        return n2;
    }

    public void setColumnMapping(int[] nArray) throws SQLException {
        if (this.needTrace) {
            this.trace("Statement.setColumnMapping()");
        }
        this.colMapping = nArray;
    }

    public void clearColumnMapping() throws SQLException {
        if (this.needTrace) {
            this.trace("Statement.clearColumnMapping()");
        }
        this.colMapping = null;
    }

    public int colMapLength() throws SQLException {
        if (this.needTrace) {
            this.trace("Statement.colMapLength()");
        }
        if (this.colMapping == null) {
            return -1;
        }
        return this.colMapping.length;
    }

    protected long getHSTMT() throws SQLException {
        this.checkClosed(this.isClosed());
        return this.hSTMT;
    }

    protected ResourceBundle getResourceBundle() {
        return this.myConnection.getResourceBundle();
    }

    public boolean isClosed() throws SQLException {
        if (this.isClose || this.hSTMT == 0L) {
            return true;
        }
        return this.myConnection.isClosed();
    }
}

