/*
 * Decompiled with CFR 0.152.
 */
package dbmaker.sql;

import dbmaker.sql.JdbcOdbc;
import dbmaker.sql.JdbcOdbcAPI;
import dbmaker.sql.JdbcOdbcConnection;
import dbmaker.sql.JdbcOdbcStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ResourceBundle;

public class JdbcOdbcResultSetMetaData
extends JdbcOdbc
implements ResultSetMetaData {
    private JdbcOdbcAPI ODBCOBJ;
    private JdbcOdbcStatement myStatement;
    protected int columnCount;

    public JdbcOdbcResultSetMetaData(JdbcOdbcAPI jdbcOdbcAPI, JdbcOdbcStatement jdbcOdbcStatement) throws SQLException {
        if (this.needTrace) {
            this.trace("new ResultSetMetaData");
        }
        this.ODBCOBJ = jdbcOdbcAPI;
        this.myStatement = jdbcOdbcStatement;
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.columnCount = this.ODBCOBJ.jdbcNumResultCols(this.myStatement.getHSTMT());
        }
    }

    public String getCatalogName(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSetMetaData.getCatalogName(" + n + ")");
        }
        if (n <= 0 || n > this.columnCount) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSetMetaData.getCatalogName(" + n + ")");
        }
        int n2 = this.myStatement.mapColumn(n);
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            String string = this.ODBCOBJ.jdbcColAttributeStr(this.myStatement.getHSTMT(), n2, 17);
            return string;
        }
    }

    public String getColumnClassName(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSetMetaData.getColumnClassName(" + n + ")");
        }
        if (n <= 0 || n > this.columnCount) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSetMetaData.getColumnClassName(" + n + ")");
        }
        n = this.myStatement.mapColumn(n);
        int[] nArray = new int[1];
        int n2 = 0;
        nArray[0] = 99;
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.ODBCOBJ.jdbcDescribeCol(this.myStatement.getHSTMT(), n, null, 0, null, nArray, null, null, null);
        }
        n2 = this.odbc2JavaType(nArray[0]);
        return this.mapClass(n2);
    }

    public int getColumnCount() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSetMetaData.getColumnCount()");
        }
        int n = 0;
        n = this.myStatement.colMapLength();
        if (n == -1) {
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                n = this.ODBCOBJ.jdbcNumResultCols(this.myStatement.getHSTMT());
            }
        }
        return n;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSetMetaData.getColumnDisplaySize(" + n + ")");
        }
        if (n <= 0 || n > this.columnCount) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSetMetaData.getColumnDisplaySize(" + n + ")");
        }
        int n2 = this.myStatement.mapColumn(n);
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            int n3 = this.ODBCOBJ.jdbcColAttributeInt(this.myStatement.getHSTMT(), n2, 6);
            return n3;
        }
    }

    public String getColumnLabel(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSetMetaData.getColumnLabel(" + n + ")");
        }
        if (n <= 0 || n > this.columnCount) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSetMetaData.getColumnLabel(" + n + ")");
        }
        int n2 = this.myStatement.mapColumn(n);
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            String string = this.ODBCOBJ.jdbcColAttributeStr(this.myStatement.getHSTMT(), n2, 18);
            return string;
        }
    }

    public String getColumnName(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSetMetaData.getColumnName(" + n + ")");
        }
        if (n <= 0 || n > this.columnCount) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSetMetaData.getColumnName(" + n + ")");
        }
        int n2 = this.myStatement.mapColumn(n);
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            String string = this.ODBCOBJ.jdbcColAttributeStr(this.myStatement.getHSTMT(), n2, 1011);
            return string;
        }
    }

    public int getColumnType(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSetMetaData.getColumnType(" + n + ")");
        }
        if (n <= 0 || n > this.columnCount) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSetMetaData.getColumnType(" + n + ")");
        }
        n = this.myStatement.mapColumn(n);
        int[] nArray = new int[]{99};
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.ODBCOBJ.jdbcDescribeCol(this.myStatement.getHSTMT(), n, null, 0, null, nArray, null, null, null);
        }
        return this.odbc2JavaType(nArray[0]);
    }

    protected int getColumnSQLType(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSetMetaData.getColumnSQLType(" + n + ")");
        }
        if (n <= 0 || n > this.columnCount) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSetMetaData.getColumnType(" + n + ")");
        }
        n = this.myStatement.mapColumn(n);
        int[] nArray = new int[]{99};
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.ODBCOBJ.jdbcDescribeCol(this.myStatement.getHSTMT(), n, null, 0, null, nArray, null, null, null);
        }
        return nArray[0];
    }

    public String getColumnTypeName(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSetMetaData.getColumnTypeName(" + n + ")");
        }
        if (n <= 0 || n > this.columnCount) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSetMetaData.getColumnTypeName(" + n + ")");
        }
        int n2 = this.myStatement.mapColumn(n);
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            String string = this.ODBCOBJ.jdbcColAttributeStr(this.myStatement.getHSTMT(), n2, 14);
            return string;
        }
    }

    public int getPrecision(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSetMetaData.getPrecision(" + n + ")");
        }
        if (n <= 0 || n > this.columnCount) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSetMetaData.getPrecision(" + n + ")");
        }
        int n2 = this.myStatement.mapColumn(n);
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            int n3 = this.ODBCOBJ.jdbcColAttributeInt(this.myStatement.getHSTMT(), n2, 4);
            return n3;
        }
    }

    public int getScale(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSetMetaData.getPrecision(" + n + ")");
        }
        if (n <= 0 || n > this.columnCount) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSetMetaData.getPrecision(" + n + ")");
        }
        int n2 = this.myStatement.mapColumn(n);
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            int n3 = this.ODBCOBJ.jdbcColAttributeInt(this.myStatement.getHSTMT(), n2, 1006);
            return n3;
        }
    }

    public String getSchemaName(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSetMetaData.getSchemaName" + n + ")");
        }
        if (n <= 0 || n > this.columnCount) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSetMetaData.getSchemaName" + n + ")");
        }
        int n2 = this.myStatement.mapColumn(n);
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            String string = this.ODBCOBJ.jdbcColAttributeStr(this.myStatement.getHSTMT(), n2, 16);
            return string;
        }
    }

    public String getTableName(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSetMetaData.getTableName(" + n + ")");
        }
        if (n <= 0 || n > this.columnCount) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSetMetaData.getTableName(" + n + ")");
        }
        int n2 = this.myStatement.mapColumn(n);
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            String string = this.ODBCOBJ.jdbcColAttributeStr(this.myStatement.getHSTMT(), n2, 15);
            return string;
        }
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSetMetaData.isAutoIncrement(" + n + ")");
        }
        if (n <= 0 || n > this.columnCount) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSetMetaData.isAutoIncrement(" + n + ")");
        }
        int n2 = this.myStatement.mapColumn(n);
        int n3 = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            n3 = this.ODBCOBJ.jdbcColAttributeInt(this.myStatement.getHSTMT(), n2, 11);
        }
        return n3 == 1;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSetMetaData.isCaseSensitive(" + n + ")");
        }
        if (n <= 0 || n > this.columnCount) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSetMetaData.isCaseSensitive(" + n + ")");
        }
        int n2 = this.myStatement.mapColumn(n);
        int n3 = this.ODBCOBJ.jdbcColAttributeInt(this.myStatement.getHSTMT(), n2, 12);
        return n3 == 1;
    }

    public boolean isCurrency(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSetMetaData.isCurrency(" + n + ")");
        }
        if (n <= 0 || n > this.columnCount) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSetMetaData.isCurrency(" + n + ")");
        }
        int n2 = this.myStatement.mapColumn(n);
        int n3 = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            n3 = this.ODBCOBJ.jdbcColAttributeInt(this.myStatement.getHSTMT(), n2, 9);
        }
        return n3 == 1;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSetMetaData.isDefinitelyWritable(" + n + ")");
        }
        if (n <= 0 || n > this.columnCount) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSetMetaData.isDefinitelyWritable(" + n + ")");
        }
        int n2 = this.myStatement.mapColumn(n);
        int n3 = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            n3 = this.ODBCOBJ.jdbcColAttributeInt(this.myStatement.getHSTMT(), n2, 10);
        }
        return n3 == 1;
    }

    public int isNullable(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSetMetaData.isNullable(" + n + ")");
        }
        if (n <= 0 || n > this.columnCount) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSetMetaData.isNullable(" + n + ")");
        }
        if (this.myStatement.colMapLength() > 0 && (n = this.myStatement.mapColumn(n)) == 1) {
            return 0;
        }
        int n2 = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            n2 = this.ODBCOBJ.jdbcColAttributeInt(this.myStatement.getHSTMT(), n, 1008);
        }
        if (n2 == 1) {
            return 1;
        }
        if (n2 == 0) {
            return 0;
        }
        return 2;
    }

    public boolean isReadOnly(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSetMetaData.isReadOnly(" + n + ")");
        }
        if (n <= 0 || n > this.columnCount) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSetMetaData.isReadOnly(" + n + ")");
        }
        int n2 = this.myStatement.mapColumn(n);
        int n3 = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            n3 = this.ODBCOBJ.jdbcColAttributeInt(this.myStatement.getHSTMT(), n2, 10);
        }
        return n3 == 0;
    }

    public boolean isSearchable(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSetMetaData.isSearchable(" + n + ")");
        }
        if (n <= 0 || n > this.columnCount) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSetMetaData.isSearchable(" + n + ")");
        }
        int n2 = this.myStatement.mapColumn(n);
        int n3 = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            n3 = this.ODBCOBJ.jdbcColAttributeInt(this.myStatement.getHSTMT(), n2, 13);
        }
        return n3 != 0;
    }

    public boolean isSigned(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSetMetaData.isSigned(" + n + ")");
        }
        if (n <= 0 || n > this.columnCount) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSetMetaData.isSigned(" + n + ")");
        }
        int n2 = this.myStatement.mapColumn(n);
        int n3 = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            n3 = this.ODBCOBJ.jdbcColAttributeInt(this.myStatement.getHSTMT(), n2, 8);
        }
        return n3 != 1;
    }

    public boolean isWritable(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSetMetaData.isWritable(" + n + ")");
        }
        if (n <= 0 || n > this.columnCount) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSetMetaData.isWritable(" + n + ")");
        }
        int n2 = this.myStatement.mapColumn(n);
        int n3 = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            n3 = this.ODBCOBJ.jdbcColAttributeInt(this.myStatement.getHSTMT(), n2, 10);
        }
        return n3 == 2;
    }

    protected ResourceBundle getResourceBundle() {
        return this.myStatement.getResourceBundle();
    }
}

