#!/bin/sh
#
# The startup and shutdown script for DBMaker database
#

app_name=dbmaker
app_home=`awk -F: '$1~/^'${app_name}'$/ {print $6}' /etc/passwd`
app_conf=/etc/dminit.conf

app_start() {
  printf "Starging ${app_name}: "
  awk -F: '$1!~/^#/ {print $1,$2,$3 }' ${app_conf} |
  while read app_db arg2 app_owner; do
    [ -n "${app_db}" -a -n "${arg2}" -a -n "${app_owner}" ] || continue
    app_cmd="${app_home}/${arg2}/bin/dmserver"
    [ "`echo ${arg2} | cut -c1`" = "/" ] && app_cmd="${arg2}"
    su ${app_owner} -c "${app_cmd} ${app_db} 2>&1 >/dev/null" && \
      printf "${app_db} " || printf "${app_db} FAILED "
  done
  echo
}

app_stop() {
  printf "Stopping ${app_name}: "
  awk -F: '$1!~/^#/ {print $1,$2,$3 }' ${app_conf} |
  while read app_db arg2 app_owner; do
    [ -n "${app_db}" -a -n "${arg2}" -a -n "${app_owner}" ] || continue
    app_cmd="${app_home}/${arg2}/bin/dmserver"
    [ "`echo ${arg2} | cut -c1`" = "/" ] && app_cmd="${arg2}"
    ${app_cmd} -k ${app_db} 2>&1 >/dev/null && \
      printf "${app_db} " || printf "${app_db}:FAILED "
  done
  echo
}

rcINIT() {
  case "$1" in
    start)
      app_start
      ;;
    stop)
      app_stop
      ;;
    restart)
      app_stop
      sleep 5
      app_start
      ;;
    *)
      echo ""
      echo "Usage: `basename $0` { start | stop | restart }"
      echo ""
      exit 64
      ;;
  esac
}

rcINIT "$1"
