/******************************************
 * demo1: demonstrate user SYSADM
 ******************************************/
set printto usrgrp01.txt;

connect to dbsample5 'sysadm';

// SYSADM can create a user.(and create a default schema whose name is same as user name)
grant connect to dbausr xxx123;
grant dba to dbausr;	//user dbausr is granted DBA database authority

grant connect to resusr;
grant resource to resusr;	//user resusr is granted RESOURCE database authority

grant connect to connusr;	//user connusr only has CONNECT database authority

set linewidth 60;
select * from sysauthuser;

// SYSADM can alter password for other users
alter password of dbausr to '123456';

// SYSADM can create schema for other user:
create schema dbaschema1 authorization dbausr;
create schema resschema1 authorization resusr;
create schema connschema1 authorization connusr;
select * from sysschema;

// SYSADM can create table in any schema:
create table dbausr.dbat1(c1 int,c2 char(10));
create table connschema1.connt1(c1 int,c2 char(10));

// SYSADM can drop table resided in any schema;
drop table dbausr.dbat1;
drop table connschema1.connt1;

// SYSADM can drop any empty schema except default schema
drop schema dbaschema1;
drop schema resschema1;
drop schema connschema1;

// SYSADM can revoke other user's authority and can drop other users
revoke dba from dbausr; //dbausr only has CONNECT privilege
select * from sysauthuser;
revoke connect from dbausr; // drop dbausr
revoke connect from resusr; // drop resusr
revoke connect from connusr; // drop connusr;
//drop default schema after delete the user
drop schema dbausr;
drop schema resusr;
drop schema connusr;
select * from sysauthuser;

set printto off;
disconnect;
q;