#!/usr/bin/perl

use POSIX;
use CGI qw/:standard/;
use DBI;

my($dbh, $sth, $rc, $rv, $dbtable);
$dbtable = 'sample.books';
$query = new CGI;
print $query->header;
$TITLE="Perl Sample: English fortune full text search - Persistent database connections";
$pid = getpid();

# We use the path information to distinguish between calls
# to the script to:
# (1) create the frameset
# (2) create the query form
# (3) create the query response

$path_info = $query->path_info;

# If no path information is provided, then we create 
# a side-by-side frame set
if (!$path_info) {
  &print_frameset;
  exit 0;
}

# If we get here, then we either create the query form
# or we create the response.
&print_query if $path_info=~/query/;
&print_response if $path_info=~/response/;
&print_detail if $path_info=~/detail/;
&print_end;


# Create the frameset
sub print_frameset {
    $script_name = $query->script_name;
    print <<EOF;
<html><head><title>$TITLE</title></head>
<frameset rows="25,75">
<frame src="$script_name/query" name="query">
  <frameset cols="40,60">
    <frame src="$script_name/response" name="response">
    <frame src="$script_name/detail" name="detail">
  </frameset>
</frameset>
EOF
    ;
    exit 0;
}

sub print_end {
# print "pid ==> $pid<BR>\n";
  print $query->end_html;
}

sub print_query {
  print $query->start_html($TITLE);
  $script_name = $query->script_name;
  print $query->startform(-action=>"$script_name/response",-TARGET=>"response");
  print "Please input your query keyword",$query->textfield('name')," ";
  print $query->submit;
  print $query->endform;
}

sub print_response {
  print $query->start_html(-title=>$TITLE,
                           -target=>"detail");
  print qq{<BODY TEXT="#000000" BGCOLOR="#33CCFF" LINK="#0000EE"},
        qq{ VLINK="#551A8B" ALINK="#FF0000">};
  print "Result list</H1>\n";
  unless ($query->param) {
    print "Currently no result</b>\n";
    return;
  }

  unless($dbh = DBI->connect('dbi:DBMaker:DBSAMPLE5','SYSADM','')) {
    print "<H1>Connect Fail:$DBI::errstr</H1>\n";
    return;
  }
  my $querystr = $query->param(name);
  $sth = $dbh->prepare("select id, introduction from $dbtable where introduction match '$querystr'",
                       { 'LongReadLen' => 20 });
  $sth->execute;

  print "<table border><caption>Query keyword ==> <EM>'$querystr'</EM>\n";
  print "<TR ALIGN=CENTER VALIGN=TOP><TH>id<TH>introduction</TH></TR>\n";
#  $count = 0;
  $script_name = $query->script_name;
  while(@row = $sth->fetchrow_array) {
    print "<TR ALIGN=CENTER VALIGN=TOP>\n";
    print qq{<TD><A HREF="$script_name/detail?id=$row[0]">$row[0]</A></TD>\n};
    print "<TD ALIGN=LEFT>$row[1]</TD>\n";
    print "</TR>\n";
#    $count++;
#    last if($count % 10 == 0);
  }
  print "</TABLE>\n";
  $sth->finish();
  $dbh->disconnect();
}

sub print_detail {
  print $query->start_html($TITLE);
  print qq{<BODY TEXT="#FFFFFF" BGCOLOR="#666666" LINK="#66FFFF"},
        qq{ VLINK="#CC33CC" ALINK="#FF0000"BACKGROUND="/~yu/marble.jpg">};
  unless ($query->param) {
    print "<b>No.</b>";
    return;
  }
  unless($dbh = DBI->connect('dbi:DBMaker:DBSAMPLE5','SYSADM','')) {
    print "<H1>Connect Fail:$DBI::errstr</H1>\n";
    return;
  }
  my $queryid = $query->param(id);
  $sth = $dbh->prepare("select introduction from $dbtable where id = $queryid",
                       { 'LongReadLen' => 1024000 });
  $sth->execute;
  @row = $sth->fetchrow_array;
  $tmpstr = $row[0];
  $tmpstr =~ s/\n/\<BR\>\n/g;
  print "$tmpstr<BR>\n";
  print "<P>The id are: <EM>",join(", ",$query->param(id)),"</EM><BR>\n";
  undef @row;
  undef $tmpstr;
  $sth->finish();
  $dbh->disconnect();
}

