using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Data.OleDb;
using System.Data.Odbc;
using System.IO;

namespace CsSample
{
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label lblID;
		private System.Windows.Forms.Label lblFName;
		private System.Windows.Forms.Label lblLName;
		private System.Windows.Forms.Label lblTitle;
		private System.Windows.Forms.Label lblPhoto;
		private System.Windows.Forms.TextBox txtID;
		private System.Windows.Forms.TextBox txtFName;
		private System.Windows.Forms.TextBox txtLName;
		private System.Windows.Forms.TextBox txtTitle;
		private System.Windows.Forms.PictureBox picPhoto;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.TextBox txtFileName;
		private System.Windows.Forms.Button btnBrowse;
		private System.Windows.Forms.Button btnFirst;
		private System.Windows.Forms.Button btnPrev;
		private System.Windows.Forms.Button btnNext;
		private System.Windows.Forms.Button btnLast;
		private System.Windows.Forms.Button btnNew;
		private System.Windows.Forms.Button btnUpdate;
		private System.Windows.Forms.Button btnDelete;
		private System.Windows.Forms.Button btnSubmit;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.TextBox txtConnString;
		private System.Windows.Forms.Button btnLoad;
		private System.Windows.Forms.ComboBox cmbProvider;
		private System.Windows.Forms.CheckBox ckbEditPhoto;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.OpenFileDialog openFileDialog1;

		private DataSet myDS;
		private DataTable myTB;
		private IDbConnection myCN;
		private IDbCommand myCM;
		private IDbDataAdapter myDA;
		private System.ComponentModel.Component myCB;

		enum Provider{OleDbProvider, OdbcProvider};

		private Provider curProvider;
		private string curConnString;
		private int curRowIndex = -1;

		private System.ComponentModel.Container components = null;

		public Form1()
		{
			InitializeComponent();
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region The code generated by windows form designer
		private void InitializeComponent()
		{
			this.lblID = new System.Windows.Forms.Label();
			this.lblFName = new System.Windows.Forms.Label();
			this.lblLName = new System.Windows.Forms.Label();
			this.lblTitle = new System.Windows.Forms.Label();
			this.lblPhoto = new System.Windows.Forms.Label();
			this.txtID = new System.Windows.Forms.TextBox();
			this.txtFName = new System.Windows.Forms.TextBox();
			this.txtLName = new System.Windows.Forms.TextBox();
			this.txtTitle = new System.Windows.Forms.TextBox();
			this.picPhoto = new System.Windows.Forms.PictureBox();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.ckbEditPhoto = new System.Windows.Forms.CheckBox();
			this.btnBrowse = new System.Windows.Forms.Button();
			this.txtFileName = new System.Windows.Forms.TextBox();
			this.btnFirst = new System.Windows.Forms.Button();
			this.btnPrev = new System.Windows.Forms.Button();
			this.btnNext = new System.Windows.Forms.Button();
			this.btnLast = new System.Windows.Forms.Button();
			this.btnNew = new System.Windows.Forms.Button();
			this.btnUpdate = new System.Windows.Forms.Button();
			this.btnDelete = new System.Windows.Forms.Button();
			this.btnSubmit = new System.Windows.Forms.Button();
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.cmbProvider = new System.Windows.Forms.ComboBox();
			this.txtConnString = new System.Windows.Forms.TextBox();
			this.btnLoad = new System.Windows.Forms.Button();
			this.btnCancel = new System.Windows.Forms.Button();
			this.openFileDialog1 = new System.Windows.Forms.OpenFileDialog();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			//
			// lblID
			//
			this.lblID.Location = new System.Drawing.Point(24, 32);
			this.lblID.Name = "lblID";
			this.lblID.Size = new System.Drawing.Size(72, 23);
			this.lblID.TabIndex = 0;
			this.lblID.Text = "ID:";
			//
			// lblFName
			//
			this.lblFName.Location = new System.Drawing.Point(24, 64);
			this.lblFName.Name = "lblFName";
			this.lblFName.Size = new System.Drawing.Size(72, 23);
			this.lblFName.TabIndex = 1;
			this.lblFName.Text = "First Name:";
			//
			// lblLName
			//
			this.lblLName.Location = new System.Drawing.Point(24, 96);
			this.lblLName.Name = "lblLName";
			this.lblLName.Size = new System.Drawing.Size(72, 23);
			this.lblLName.TabIndex = 2;
			this.lblLName.Text = "Last Name:";
			//
			// lblTitle
			//
			this.lblTitle.Location = new System.Drawing.Point(24, 128);
			this.lblTitle.Name = "lblTitle";
			this.lblTitle.Size = new System.Drawing.Size(72, 23);
			this.lblTitle.TabIndex = 3;
			this.lblTitle.Text = "Title:";
			//
			// lblPhoto
			//
			this.lblPhoto.Location = new System.Drawing.Point(24, 160);
			this.lblPhoto.Name = "lblPhoto";
			this.lblPhoto.Size = new System.Drawing.Size(72, 23);
			this.lblPhoto.TabIndex = 4;
			this.lblPhoto.Text = "Photo:";
			//
			// txtID
			//
			this.txtID.Location = new System.Drawing.Point(104, 32);
			this.txtID.Name = "txtID";
			this.txtID.Size = new System.Drawing.Size(64, 22);
			this.txtID.TabIndex = 5;
			this.txtID.Text = "";
			//
			// txtFName
			//
			this.txtFName.Location = new System.Drawing.Point(104, 64);
			this.txtFName.Name = "txtFName";
			this.txtFName.Size = new System.Drawing.Size(168, 22);
			this.txtFName.TabIndex = 6;
			this.txtFName.Text = "";
			//
			// txtLName
			//
			this.txtLName.Location = new System.Drawing.Point(104, 96);
			this.txtLName.Name = "txtLName";
			this.txtLName.Size = new System.Drawing.Size(168, 22);
			this.txtLName.TabIndex = 7;
			this.txtLName.Text = "";
			//
			// txtTitle
			//
			this.txtTitle.Location = new System.Drawing.Point(104, 128);
			this.txtTitle.Name = "txtTitle";
			this.txtTitle.Size = new System.Drawing.Size(168, 22);
			this.txtTitle.TabIndex = 8;
			this.txtTitle.Text = "";
			//
			// picPhoto
			//
			this.picPhoto.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.picPhoto.Location = new System.Drawing.Point(104, 160);
			this.picPhoto.Name = "picPhoto";
			this.picPhoto.Size = new System.Drawing.Size(168, 104);
			this.picPhoto.TabIndex = 9;
			this.picPhoto.TabStop = false;
			//
			// groupBox1
			//
			this.groupBox1.Controls.Add(this.ckbEditPhoto);
			this.groupBox1.Controls.Add(this.btnBrowse);
			this.groupBox1.Controls.Add(this.txtFileName);
			this.groupBox1.Controls.Add(this.txtTitle);
			this.groupBox1.Controls.Add(this.txtLName);
			this.groupBox1.Controls.Add(this.picPhoto);
			this.groupBox1.Controls.Add(this.lblFName);
			this.groupBox1.Controls.Add(this.txtFName);
			this.groupBox1.Controls.Add(this.lblLName);
			this.groupBox1.Controls.Add(this.lblTitle);
			this.groupBox1.Controls.Add(this.lblPhoto);
			this.groupBox1.Controls.Add(this.txtID);
			this.groupBox1.Controls.Add(this.lblID);
			this.groupBox1.Location = new System.Drawing.Point(16, 72);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(368, 304);
			this.groupBox1.TabIndex = 10;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Card";
			//
			// ckbEditPhoto
			//
			this.ckbEditPhoto.Enabled = false;
			this.ckbEditPhoto.Location = new System.Drawing.Point(24, 264);
			this.ckbEditPhoto.Name = "ckbEditPhoto";
			this.ckbEditPhoto.Size = new System.Drawing.Size(72, 32);
			this.ckbEditPhoto.TabIndex = 12;
			this.ckbEditPhoto.Text = "Update Photo";
			this.ckbEditPhoto.CheckedChanged += new System.EventHandler(this.ckbEditPhoto_CheckedChanged);
			//
			// btnBrowse
			//
			this.btnBrowse.Enabled = false;
			this.btnBrowse.Location = new System.Drawing.Point(288, 272);
			this.btnBrowse.Name = "btnBrowse";
			this.btnBrowse.Size = new System.Drawing.Size(64, 23);
			this.btnBrowse.TabIndex = 11;
			this.btnBrowse.Text = "browse";
			this.btnBrowse.Click += new System.EventHandler(this.btnBrowse_Click);
			//
			// txtFileName
			//
			this.txtFileName.Enabled = false;
			this.txtFileName.Location = new System.Drawing.Point(104, 272);
			this.txtFileName.Name = "txtFileName";
			this.txtFileName.Size = new System.Drawing.Size(168, 22);
			this.txtFileName.TabIndex = 10;
			this.txtFileName.Text = "";
			//
			// btnFirst
			//
			this.btnFirst.Location = new System.Drawing.Point(24, 392);
			this.btnFirst.Name = "btnFirst";
			this.btnFirst.Size = new System.Drawing.Size(28, 23);
			this.btnFirst.TabIndex = 11;
			this.btnFirst.Text = "|<";
			this.btnFirst.Click += new System.EventHandler(this.btnFirst_Click);
			//
			// btnPrev
			//
			this.btnPrev.Location = new System.Drawing.Point(52, 392);
			this.btnPrev.Name = "btnPrev";
			this.btnPrev.Size = new System.Drawing.Size(28, 23);
			this.btnPrev.TabIndex = 11;
			this.btnPrev.Text = "<";
			this.btnPrev.Click += new System.EventHandler(this.btnPrev_Click);
			//
			// btnNext
			//
			this.btnNext.Location = new System.Drawing.Point(80, 392);
			this.btnNext.Name = "btnNext";
			this.btnNext.Size = new System.Drawing.Size(28, 23);
			this.btnNext.TabIndex = 11;
			this.btnNext.Text = ">";
			this.btnNext.Click += new System.EventHandler(this.btnNext_Click);
			//
			// btnLast
			//
			this.btnLast.Location = new System.Drawing.Point(108, 392);
			this.btnLast.Name = "btnLast";
			this.btnLast.Size = new System.Drawing.Size(28, 23);
			this.btnLast.TabIndex = 11;
			this.btnLast.Text = ">|";
			this.btnLast.Click += new System.EventHandler(this.btnLast_Click);
			//
			// btnNew
			//
			this.btnNew.Location = new System.Drawing.Point(168, 392);
			this.btnNew.Name = "btnNew";
			this.btnNew.Size = new System.Drawing.Size(40, 23);
			this.btnNew.TabIndex = 12;
			this.btnNew.Text = "&New";
			this.btnNew.Click += new System.EventHandler(this.btnNew_Click);
			//
			// btnUpdate
			//
			this.btnUpdate.Location = new System.Drawing.Point(208, 392);
			this.btnUpdate.Name = "btnUpdate";
			this.btnUpdate.Size = new System.Drawing.Size(56, 23);
			this.btnUpdate.TabIndex = 12;
			this.btnUpdate.Text = "&Update";
			this.btnUpdate.Click += new System.EventHandler(this.btnUpdate_Click);
			//
			// btnDelete
			//
			this.btnDelete.Location = new System.Drawing.Point(264, 392);
			this.btnDelete.Name = "btnDelete";
			this.btnDelete.Size = new System.Drawing.Size(56, 23);
			this.btnDelete.TabIndex = 12;
			this.btnDelete.Text = "&Delete";
			this.btnDelete.Click += new System.EventHandler(this.btnDelete_Click);
			//
			// btnSubmit
			//
			this.btnSubmit.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSubmit.Location = new System.Drawing.Point(320, 392);
			this.btnSubmit.Name = "btnSubmit";
			this.btnSubmit.Size = new System.Drawing.Size(56, 23);
			this.btnSubmit.TabIndex = 12;
			this.btnSubmit.Text = "&Submit";
			this.btnSubmit.Click += new System.EventHandler(this.btnSubmit_Click);
			//
			// label1
			//
			this.label1.Location = new System.Drawing.Point(16, 13);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(100, 17);
			this.label1.TabIndex = 13;
			this.label1.Text = "Provider:";
			//
			// label2
			//
			this.label2.Location = new System.Drawing.Point(16, 48);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(112, 16);
			this.label2.TabIndex = 14;
			this.label2.Text = "Connection String:";
			//
			// cmbProvider
			//
			this.cmbProvider.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.cmbProvider.Location = new System.Drawing.Point(128, 8);
			this.cmbProvider.Name = "cmbProvider";
			this.cmbProvider.Size = new System.Drawing.Size(136, 22);
			this.cmbProvider.TabIndex = 15;
			this.cmbProvider.SelectedIndexChanged += new System.EventHandler(this.cmbProvider_SelectedIndexChanged);
			//
			// txtConnString
			//
			this.txtConnString.Location = new System.Drawing.Point(128, 42);
			this.txtConnString.Name = "txtConnString";
			this.txtConnString.Size = new System.Drawing.Size(256, 22);
			this.txtConnString.TabIndex = 16;
			this.txtConnString.Text = "";
			//
			// btnLoad
			//
			this.btnLoad.Location = new System.Drawing.Point(288, 8);
			this.btnLoad.Name = "btnLoad";
			this.btnLoad.Size = new System.Drawing.Size(96, 23);
			this.btnLoad.TabIndex = 17;
			this.btnLoad.Text = "Load Data";
			this.btnLoad.Click += new System.EventHandler(this.btnLoad_Click);
			//
			// btnCancel
			//
			this.btnCancel.Location = new System.Drawing.Point(264, 392);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.Size = new System.Drawing.Size(56, 23);
			this.btnCancel.TabIndex = 18;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Visible = false;
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			//
			// openFileDialog1
			//
			this.openFileDialog1.Filter = "(*.bmp)|*.bmp|(*.jpg)|*.jpg|(*.gif)|*.gif";
			//
			// Form1
			//
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
			this.ClientSize = new System.Drawing.Size(402, 431);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnLoad);
			this.Controls.Add(this.txtConnString);
			this.Controls.Add(this.cmbProvider);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.btnNew);
			this.Controls.Add(this.btnFirst);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.btnPrev);
			this.Controls.Add(this.btnNext);
			this.Controls.Add(this.btnLast);
			this.Controls.Add(this.btnUpdate);
			this.Controls.Add(this.btnDelete);
			this.Controls.Add(this.btnSubmit);
			this.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.Name = "Form1";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "C# Sample";
			this.Load += new System.EventHandler(this.Form1_Load);
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// App Entry
		/// </summary>
		[STAThread]
		static void Main()
		{
			Application.Run(new Form1());
		}

		private void Form1_Load(object sender, System.EventArgs e)
		{
			cmbProvider.Items.Add(Provider.OleDbProvider);
			cmbProvider.Items.Add(Provider.OdbcProvider);
			cmbProvider.SelectedIndex = 0;

			lockText(true);
			lockEditButton(true,true,true,true);
			lockNavigator(true,true,true,true);
			btnCancel.Visible = false;

			myDS = new DataSet();
		}

		private void cmbProvider_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if((Provider)cmbProvider.SelectedItem == Provider.OleDbProvider)
			{
				txtConnString.Text = "Provider=DMOLE54;Data Source=DBSAMPLE5;User Id=SYSADM;Password=;";
			}
			else if((Provider)cmbProvider.SelectedItem == Provider.OdbcProvider)
			{
				txtConnString.Text = "Driver={DBMaker 5.4 Driver};Database=DBSAMPLE5;Uid=SYSADM;Pwd=;";
			}
			else
			{
				txtConnString.Text = "";
			}
		}

		private void btnLoad_Click(object sender, System.EventArgs e)
		{
			curProvider = (Provider)cmbProvider.SelectedItem;
			curConnString = txtConnString.Text;
			curRowIndex = -1;

			if(curProvider == Provider.OleDbProvider)
			{
				myCN = new OleDbConnection(curConnString);
				myCM = myCN.CreateCommand();
				myCM.CommandText = "select ID,FName,LName,Title,Photo from sample.card order by ID";
				myDA = new OleDbDataAdapter((OleDbCommand)myCM);
				//myCB = new OleDbCommandBuilder((OleDbDataAdapter)myDA);
				//not use CommandBuilder, build insert,update,delete command by hand
				string insertCmdString = "INSERT INTO SAMPLE.CARD VALUES(?,?,?,?,?)";
				string updateCmdString = "UPDATE SAMPLE.CARD SET ID = ?, FNAME = ?, LNAME = ?,";
				updateCmdString += " TITLE = ?, PHOTO = ? WHERE ";
				updateCmdString += " ( ID = ? OR ID IS NULL AND ? IS NULL) AND ";
				updateCmdString += " ( FNAME = ? OR FNAME IS NULL AND ? IS NULL) AND ";
				updateCmdString += " ( LNAME = ? OR LNAME IS NULL AND ? IS NULL) AND ";
				updateCmdString += " ( TITLE = ? OR TITLE IS NULL AND ? IS NULL)";
				string deleteCmdString = "DELETE FROM SAMPLE.CARD WHERE ";
				deleteCmdString += " ( ID = ? OR ID IS NULL AND ? IS NULL) AND ";
				deleteCmdString += " ( FNAME = ? OR FNAME IS NULL AND ? IS NULL) AND ";
				deleteCmdString += " ( LNAME = ? OR LNAME IS NULL AND ? IS NULL) AND ";
				deleteCmdString += " ( TITLE = ? OR TITLE IS NULL AND ? IS NULL)";

				OleDbCommand insertCmd = new OleDbCommand(insertCmdString,(OleDbConnection)myCN);
				insertCmd.Parameters.Add("@id",OleDbType.Integer,0,"ID");
				insertCmd.Parameters.Add("@fname",OleDbType.VarChar,30,"FName");
				insertCmd.Parameters.Add("@lname",OleDbType.VarChar,30,"LName");
				insertCmd.Parameters.Add("@title",OleDbType.VarChar,30,"Title");
				insertCmd.Parameters.Add("@photo",OleDbType.LongVarBinary,2147483647,"Photo");

				myDA.InsertCommand = insertCmd;

				OleDbCommand updateCmd = new OleDbCommand(updateCmdString,(OleDbConnection)myCN);
				updateCmd.Parameters.Add("@newid",OleDbType.Integer,0,"ID");
				updateCmd.Parameters.Add("@newfname",OleDbType.VarChar,30,"FName");
				updateCmd.Parameters.Add("@newlname",OleDbType.VarChar,30,"LName");
				updateCmd.Parameters.Add("@newtitle",OleDbType.VarChar,30,"Title");
				updateCmd.Parameters.Add("@newphoto",OleDbType.LongVarBinary,2147483647,"Photo");
				updateCmd.Parameters.Add("@oldid",OleDbType.Integer,0,"ID");
				updateCmd.Parameters.Add("@oldid1",OleDbType.Integer,0,"ID");
				updateCmd.Parameters.Add("@oldfname",OleDbType.VarChar,30,"FName");
				updateCmd.Parameters.Add("@oldfname1",OleDbType.VarChar,30,"FName");
				updateCmd.Parameters.Add("@oldlname",OleDbType.VarChar,30,"LName");
				updateCmd.Parameters.Add("@oldlname1",OleDbType.VarChar,30,"LName");
				updateCmd.Parameters.Add("@oldtitle",OleDbType.VarChar,30,"Title");
				updateCmd.Parameters.Add("@oldtitle1",OleDbType.VarChar,30,"Title");
				for(int i=5;i<13;++i) updateCmd.Parameters[i].SourceVersion = DataRowVersion.Original;

				myDA.UpdateCommand = updateCmd;

				OleDbCommand deleteCmd = new OleDbCommand(deleteCmdString,(OleDbConnection)myCN);
				deleteCmd.Parameters.Add("@oldid",OleDbType.Integer,0,"ID");
				deleteCmd.Parameters.Add("@oldid1",OleDbType.Integer,0,"ID");
				deleteCmd.Parameters.Add("@oldfname",OleDbType.VarChar,30,"FName");
				deleteCmd.Parameters.Add("@oldfname1",OleDbType.VarChar,30,"FName");
				deleteCmd.Parameters.Add("@oldlname",OleDbType.VarChar,30,"LName");
				deleteCmd.Parameters.Add("@oldlname1",OleDbType.VarChar,30,"LName");
				deleteCmd.Parameters.Add("@oldtitle",OleDbType.VarChar,30,"Title");
				deleteCmd.Parameters.Add("@oldtitle1",OleDbType.VarChar,30,"Title");
				for(int i=0;i<8;++i) deleteCmd.Parameters[i].SourceVersion = DataRowVersion.Original;

				myDA.DeleteCommand = deleteCmd;

				//register RowUpdating listener to display dynamic command information
				//((OleDbDataAdapter)myDA).RowUpdating -=new OleDbRowUpdatingEventHandler(myDA_RowUpdating);
				//((OleDbDataAdapter)myDA).RowUpdating +=new OleDbRowUpdatingEventHandler(myDA_RowUpdating);
			}
			else if(curProvider == Provider.OdbcProvider)
			{
				myCN = new OdbcConnection(curConnString);
				myCM = myCN.CreateCommand();
				myCM.CommandText = "select ID,FName,LName,Title,Photo from sample.card order by ID";
				myDA = new OdbcDataAdapter((OdbcCommand)myCM);
				//myCB = new OdbcCommandBuilder((OdbcDataAdapter)myDA);
				//Not use CommandBuilder, build insert,update,delete command by hand
				string insertCmdString = "INSERT INTO SAMPLE.CARD VALUES(?,?,?,?,?)";
				string updateCmdString = "UPDATE SAMPLE.CARD SET ID = ?, FNAME = ?, LNAME = ?,";
				updateCmdString += " TITLE = ?, PHOTO = ? WHERE ";
				updateCmdString += " ( ID = ? OR ID IS NULL AND ? IS NULL) AND ";
				updateCmdString += " ( FNAME = ? OR FNAME IS NULL AND ? IS NULL) AND ";
				updateCmdString += " ( LNAME = ? OR LNAME IS NULL AND ? IS NULL) AND ";
				updateCmdString += " ( TITLE = ? OR TITLE IS NULL AND ? IS NULL)";
				string deleteCmdString = "DELETE FROM SAMPLE.CARD WHERE ";
				deleteCmdString += " ( ID = ? OR ID IS NULL AND ? IS NULL) AND ";
				deleteCmdString += " ( FNAME = ? OR FNAME IS NULL AND ? IS NULL) AND ";
				deleteCmdString += " ( LNAME = ? OR LNAME IS NULL AND ? IS NULL) AND ";
				deleteCmdString += " ( TITLE = ? OR TITLE IS NULL AND ? IS NULL)";

				OdbcCommand insertCmd = new OdbcCommand(insertCmdString,(OdbcConnection)myCN);
				insertCmd.Parameters.Add("@id",OdbcType.Int,0,"ID");
				insertCmd.Parameters.Add("@fname",OdbcType.VarChar,30,"FName");
				insertCmd.Parameters.Add("@lname",OdbcType.VarChar,30,"LName");
				insertCmd.Parameters.Add("@title",OdbcType.VarChar,30,"Title");
				insertCmd.Parameters.Add("@photo",OdbcType.Image,2147483647,"Photo");

				myDA.InsertCommand = insertCmd;

				OdbcCommand updateCmd = new OdbcCommand(updateCmdString,(OdbcConnection)myCN);
				updateCmd.Parameters.Add("@newid",OdbcType.Int,0,"ID");
				updateCmd.Parameters.Add("@newfname",OdbcType.VarChar,30,"FName");
				updateCmd.Parameters.Add("@newlname",OdbcType.VarChar,30,"LName");
				updateCmd.Parameters.Add("@newtitle",OdbcType.VarChar,30,"Title");
				updateCmd.Parameters.Add("@newphoto",OdbcType.Image,2147483647,"Photo");
				updateCmd.Parameters.Add("@oldid",OdbcType.Int,0,"ID");
				updateCmd.Parameters.Add("@oldid1",OdbcType.Int,0,"ID");
				updateCmd.Parameters.Add("@oldfname",OdbcType.VarChar,30,"FName");
				updateCmd.Parameters.Add("@oldfname1",OdbcType.VarChar,30,"FName");
				updateCmd.Parameters.Add("@oldlname",OdbcType.VarChar,30,"LName");
				updateCmd.Parameters.Add("@oldlname1",OdbcType.VarChar,30,"LName");
				updateCmd.Parameters.Add("@oldtitle",OdbcType.VarChar,30,"Title");
				updateCmd.Parameters.Add("@oldtitle1",OdbcType.VarChar,30,"Title");
				for(int i=5;i<13;++i) updateCmd.Parameters[i].SourceVersion = DataRowVersion.Original;

				myDA.UpdateCommand = updateCmd;

				OdbcCommand deleteCmd = new OdbcCommand(deleteCmdString,(OdbcConnection)myCN);
				deleteCmd.Parameters.Add("@oldid",OdbcType.Int,0,"ID");
				deleteCmd.Parameters.Add("@oldid1",OdbcType.Int,0,"ID");
				deleteCmd.Parameters.Add("@oldfname",OdbcType.VarChar,30,"FName");
				deleteCmd.Parameters.Add("@oldfname1",OdbcType.VarChar,30,"FName");
				deleteCmd.Parameters.Add("@oldlname",OdbcType.VarChar,30,"LName");
				deleteCmd.Parameters.Add("@oldlname1",OdbcType.VarChar,30,"LName");
				deleteCmd.Parameters.Add("@oldtitle",OdbcType.VarChar,30,"Title");
				deleteCmd.Parameters.Add("@oldtitle1",OdbcType.VarChar,30,"Title");
				for(int i=0;i<8;++i) deleteCmd.Parameters[i].SourceVersion = DataRowVersion.Original;

				myDA.DeleteCommand = deleteCmd;
			}
			else
			{
				MessageBox.Show("Invalid Provider","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				return;
			}

			try
			{
				myDS.Tables.Clear();
				//myDA.MissingSchemaAction = MissingSchemaAction.AddWithKey;
				myDA.Fill(myDS);
				if(myDS.Tables.Count > 0)
				{
					myTB = myDS.Tables[0];
					//myTB.Columns[0].AutoIncrement = true;
					//myTB.PrimaryKey = new DataColumn[]{myTB.Columns[0]};
					if(myTB.Rows.Count > 0)	curRowIndex = 0;
				}
				else myTB = null;

				bindText();

				lockNavigator(true,true,false,false);
				lockEditButton(false,false,false,true);
			}
			catch(Exception ex)
			{
				MessageBox.Show(this,ex.Message,"Load Data Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				if(myCN != null) myCN.Close();
			}
		}

		private void clearText()
		{
			txtID.Text = "";
			txtFName.Text = "";
			txtLName.Text = "";
			txtTitle.Text = "";
			picPhoto.Image = null;
		}

		private void bindText()
		{
			if(myTB != null)
			{
				if((curRowIndex >= 0) && (curRowIndex < myTB.Rows.Count))
				{
					txtID.Text = myTB.Rows[curRowIndex][0].ToString();
					txtFName.Text = myTB.Rows[curRowIndex][1].ToString();
					txtLName.Text = myTB.Rows[curRowIndex][2].ToString();
					txtTitle.Text = myTB.Rows[curRowIndex][3].ToString();
					if(myTB.Rows[curRowIndex][4] != DBNull.Value )
					{
						try
						{
							System.IO.MemoryStream ms = new System.IO.MemoryStream((byte[])myTB.Rows[curRowIndex][4]);
							System.Drawing.Bitmap bmp = new Bitmap(ms);
							picPhoto.Image = bmp;
							if(bmp.Size.Height > picPhoto.Size.Height || bmp.Size.Width > picPhoto.Size.Width)
							{
								picPhoto.SizeMode = PictureBoxSizeMode.StretchImage;
							}
							else
							{
								picPhoto.SizeMode = PictureBoxSizeMode.Normal;
							}
						}
						catch(Exception )
						{
							picPhoto.Image = null;
							MessageBox.Show(this,"Invalid image format!","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
						}
					}
					else
					{
						picPhoto.Image = null;
					}
				}
				else
				{
					clearText();
				}
			}
			else
			{
				clearText();
				MessageBox.Show("Data set if null","Message");
			}
		}

		private void btnFirst_Click(object sender, System.EventArgs e)
		{
			lockNavigator(true,true,false,false);
			curRowIndex = 0;
			bindText();
		}

		private void btnPrev_Click(object sender, System.EventArgs e)
		{
			if(curRowIndex > 0) curRowIndex-=1;

			if(curRowIndex == 0) lockNavigator(true,true,false,false);
			else lockNavigator(false,false,false,false);

			bindText();
		}

		private void btnNext_Click(object sender, System.EventArgs e)
		{
			if(myTB == null || myTB.Rows.Count == 0)
			{
				MessageBox.Show(this,"No data","Warning",MessageBoxButtons.OK,MessageBoxIcon.Warning);
				return;
			}

			if(curRowIndex < myTB.Rows.Count - 1) curRowIndex += 1;

			if(curRowIndex >= myTB.Rows.Count - 1) lockNavigator(false,false,true,true);
			else lockNavigator(false,false,false,false);

			bindText();
		}

		private void btnLast_Click(object sender, System.EventArgs e)
		{
			if(myTB == null || myTB.Rows.Count == 0)
			{
				MessageBox.Show("No data","Warning");
				return;
			}

			curRowIndex = myTB.Rows.Count - 1;
			lockNavigator(false,false,true,true);
			bindText();
		}

		private void lockNavigator(bool lockedFirst,bool lockedPrev,bool lockedNext,bool lockedLast)
		{
			if(lockedFirst == true) btnFirst.Enabled = false;
			else btnFirst.Enabled = true;

			if(lockedPrev == true) btnPrev.Enabled = false;
			else btnPrev.Enabled = true;

			if(lockedNext == true) btnNext.Enabled = false;
			else btnNext.Enabled = true;

			if(lockedLast == true) btnLast.Enabled = false;
			else btnLast.Enabled = true;
		}

		private void lockText(bool locked)
		{
			if(locked)
			{
				txtID.ReadOnly = true;
				txtFName.ReadOnly = true;
				txtLName.ReadOnly = true;
				txtTitle.ReadOnly = true;
				ckbEditPhoto.Enabled = false;
			}
			else
			{
				txtID.ReadOnly = false;
				txtFName.ReadOnly = false;
				txtLName.ReadOnly = false;
				txtTitle.ReadOnly = false;
				ckbEditPhoto.Enabled = true;
			}
		}

		private void lockEditButton(bool lockedNew,bool lockedUpdate,bool lockedDelete,bool lockedSubmit)
		{
			if(lockedNew == true) btnNew.Enabled = false;
			else btnNew.Enabled = true;

			if(lockedUpdate == true) btnUpdate.Enabled = false;
			else btnUpdate.Enabled = true;

			if(lockedDelete == true) btnDelete.Enabled = false;
			else btnDelete.Enabled = true;

			if(lockedSubmit == true) btnSubmit.Enabled = false;
			else btnSubmit.Enabled = true;
		}

		private void ckbEditPhoto_CheckedChanged(object sender, System.EventArgs e)
		{
			if(ckbEditPhoto.Checked == true)
			{
				txtFileName.Enabled = true;
				btnBrowse.Enabled = true;
			}
			else
			{
				//txtFileName.Text = "";
				txtFileName.Enabled = false;
				btnBrowse.Enabled = false;
			}
		}

		private void btnNew_Click(object sender, System.EventArgs e)
		{
			if(myTB != null)
			{
				DataRow row = myTB.NewRow();
				myTB.Rows.Add(row);
				curRowIndex = myTB.Rows.Count - 1;
				bindText();
				lockText(false);
				lockNavigator(true,true,true,true);
				lockEditButton(true,true,true,false);
				btnCancel.Visible = true;
			}
			else
			{
				MessageBox.Show(this,"DataSet is null","Create New Row Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void btnUpdate_Click(object sender, System.EventArgs e)
		{
			if(myTB != null && curRowIndex >= 0 && curRowIndex < myTB.Rows.Count )
			{
				lockText(false);
				lockNavigator(true,true,true,true);
				lockEditButton(true,true,true,false);
				btnCancel.Visible = true;
			}
			else
			{
				MessageBox.Show(this,"No row can be updated.","Update Row Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void btnDelete_Click(object sender, System.EventArgs e)
		{
			if(myTB != null && curRowIndex >= 0 && curRowIndex < myTB.Rows.Count )
			{
				if(MessageBox.Show(this,"Are you sure to delete this row?","Warning",MessageBoxButtons.YesNo,MessageBoxIcon.Question) == DialogResult.Yes)
				{
					myTB.Rows[curRowIndex].Delete();
					try
					{
						myDA.Update(myDS);
					}
					catch(Exception ex)
					{
						MessageBox.Show(ex.Message,"Error");
						myTB.Rows[curRowIndex].RejectChanges();
					}
					finally
					{
						if(myCN != null) myCN.Close();
					}

					if(curRowIndex >= myTB.Rows.Count)
					{
						curRowIndex = 0;
						lockNavigator(true,true,false,false);
					}
					bindText();
				}
			}
			else
			{
				MessageBox.Show("No row can be deleted.","Error");
			}
		}

		private void btnSubmit_Click(object sender, System.EventArgs e)
		{
			if(myTB != null)
			{
				try
				{
					if(txtID.Text.Trim() !="")
						myTB.Rows[curRowIndex][0] = int.Parse(txtID.Text);
					else
						myTB.Rows[curRowIndex][0] = DBNull.Value ;
				}
				catch
				{
					MessageBox.Show(this,"ID is invalid.","Warning",MessageBoxButtons.OK,MessageBoxIcon.Warning);
					return;
				}

				if(txtFName.Text.Trim() != "")
					myTB.Rows[curRowIndex][1] = txtFName.Text.Trim();
				else
					myTB.Rows[curRowIndex][1] = DBNull.Value ;

				if(txtLName.Text.Trim() != "")
					myTB.Rows[curRowIndex][2] = txtLName.Text.Trim();
				else
					myTB.Rows[curRowIndex][2] = DBNull.Value ;

				if(txtTitle.Text.Trim() != "")
					myTB.Rows[curRowIndex][3] = txtTitle.Text.Trim();
				else
					myTB.Rows[curRowIndex][3] = DBNull.Value ;

				if(ckbEditPhoto.Checked)	// update photo field
				{
					string filename = txtFileName.Text.Trim();
					if(filename != "")
					{
						if(!File.Exists(filename))
						{
							MessageBox.Show(this,filename + " not exists","Error",
								MessageBoxButtons.OK,MessageBoxIcon.Error);
							return;
						}

						//FileInfo ff = new FileInfo(filename);
						string fileExt = filename.Substring(filename.Length - 4).ToLower();
						if(fileExt != ".bmp" && fileExt != ".jpg" && fileExt != ".gif")
						{
							MessageBox.Show(this,"Invalid picture file.","Error",
								MessageBoxButtons.OK,MessageBoxIcon.Error);
							return;
						}

						FileStream fs = new FileStream(filename, FileMode.Open, FileAccess.Read);
						BinaryReader br = new BinaryReader(fs);
						if(fs.Length > 2147483647 )
						{
							MessageBox.Show("File is too large(>2GB)","Error",
								MessageBoxButtons.OK,MessageBoxIcon.Error);
							br.Close();
							fs.Close();
							return;
						}

						byte[] bmp = br.ReadBytes((int)fs.Length);
						myTB.Rows[curRowIndex][4] = bmp;
						br.Close();
						fs.Close();
					}
					else
					{
						if(MessageBox.Show(this,"Invalid picture file!\n" +
						" photo will be updated to NULL","Error",MessageBoxButtons.YesNo) == DialogResult.Yes)
						{
							myTB.Rows[curRowIndex][4] = DBNull.Value;
						}
					}
				}

				try
				{
					myDA.Update(myDS);
					myDS.Tables.Clear();
					myDA.Fill(myDS);
					if(myDS.Tables.Count > 0) myTB = myDS.Tables[0];
					else myTB = null;
				}
				catch(Exception ex)
				{
					MessageBox.Show(ex.Message,"Update Data Source Error",
						MessageBoxButtons.OK,MessageBoxIcon.Error);
					myTB.Rows[curRowIndex].RejectChanges();
				}
				finally
				{
					if(myCN != null) myCN.Close();
				}
			}

			bindText();
			lockText(true);
			lockNavigator(false,false,false,false);
			lockEditButton(false,false,false,true);
			btnCancel.Visible = false;
			ckbEditPhoto.Checked = false;
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			if(myTB != null && curRowIndex >= 0 && curRowIndex < myTB.Rows.Count)
			{
				if(myTB.Rows[curRowIndex].RowState == DataRowState.Added)
				{
					myTB.Rows.RemoveAt(curRowIndex);
					curRowIndex -= 1;
				}
				else if(myTB.Rows[curRowIndex].RowState == DataRowState.Modified)
				{
					myTB.Rows[curRowIndex].RejectChanges();
				}
			}
			bindText();
			lockText(true);
			lockNavigator(false,false,false,false);
			lockEditButton(false,false,false,true);
			btnCancel.Visible = false;
			ckbEditPhoto.Checked = false;
		}

		private void btnBrowse_Click(object sender, System.EventArgs e)
		{
			openFileDialog1.ShowDialog(this);
			txtFileName.Text = openFileDialog1.FileName;
		}

		private void myDA_RowUpdating(object sender, OleDbRowUpdatingEventArgs e)
		{
				MessageBox.Show(e.Command.CommandText);
		}
	}


}
