<!-----------------------------------------------------------------------
	Copyright(c) 1997 - 2007 CaseMaker Inc. All rights reserved
-------------------------------------------------------------------------
NOTE:
1. This sample use OdbcDataReader to read CLOB,BLOB,NCLOB,FILE fields.
2. Using GetBytes,GetChars,GetString,GetValue method read data respectively.
3. This sample mixed server scripts and HTML elements in single page file.
4. This sample used database DBSAMPLE5 and table sample.LargeType.
------------------------------------------------------------------------->

<%@ Page Language = "C#" AutoEventWireup = "True" validateRequest=false  %>
<%@ Import Namespace = "System.Data" %>
<%@ Import Namespace = "System.Data.Odbc" %>

<html>
<head>
	<script language="C#" runat="server">
	
		//string connString = "provider=dmole43;data source=dbsample5;user id=sysadm;pwd=;";
		string connString = System.Configuration.ConfigurationSettings.AppSettings["OdbcConnectionString"];
		
		private void Page_Load(object sender,EventArgs e)
		{
			if(!IsPostBack)
			{
				OdbcConnection myCN = new OdbcConnection(connString);
				string queryString = "select c0_id,bloblen(c1_clob),bloblen(c2_blob)," + 
								"bloblen(c3_nclob),filelen(c4_file) from sample.LargeType";
				OdbcCommand myCM = new OdbcCommand(queryString,myCN);
				OdbcDataReader myDR;
			
				try
				{
					myCN.Open();
					myDR = myCM.ExecuteReader();
					grdCurData.DataSource = myDR;
					grdCurData.DataBind();
					myDR.Close();
					
					myDR = myCM.ExecuteReader();
					lstID.DataSource = myDR;
					lstID.DataTextField = "c0_id";
					lstID.DataValueField = "c0_id";
					lstID.DataBind();
					myDR.Close();
					myCN.Close();
				}
				catch(Exception ex)
				{
					lblMessage.Text += "<br>Read Current Data Error: " + ex.Message;
					if( myCN != null) myCN.Close();
				}
				
				lstField.Items.Add(new ListItem("c1_clob","c1_clob"));
				lstField.Items.Add(new ListItem("c2_blob","c2_blob"));
				lstField.Items.Add(new ListItem("c3_nclob","c3_nclob"));
				lstField.Items.Add(new ListItem("c4_file","c4_file"));
				
			}
			
			txtData.Text = "";
		}
		
		private void GetBytes(System.Text.Encoding encoding)
		{
			if(lstID.SelectedIndex < 0) return;
			if(lstField.SelectedIndex < 0) return;
			
			//int id = Integer.Parse(lstID.SelectedValue);
			//string field = lstField.SelectedValue;
			string queryString = "select " + lstField.SelectedValue + 
				" from sample.LargeType where c0_id = " + lstID.SelectedValue;
			OdbcConnection myCN = new OdbcConnection(connString);
			OdbcCommand myCM = new OdbcCommand(queryString,myCN);
			OdbcDataReader myDR;
			
			long totalSize = 0;
			long displayedSize = 0;
			
			try{
				myCN.Open();
				myDR = myCM.ExecuteReader();//CommandBehavior.SequentialAccess
				lblInfo.Text = "Command String: " + myCM.CommandText;
				if(myDR.Read())
				{
					int bufferSize = 65536;
					byte[] buffer = new byte[bufferSize];
					long startIndex = 0;
					long retLength = 0;
					
					retLength = myDR.GetBytes(0,startIndex,buffer,0,bufferSize);
					while(retLength == bufferSize)
					{
						totalSize += retLength;
						if(totalSize <= 65536*2)
						{
							displayedSize += retLength;
							txtData.Text += encoding.GetString(buffer);
						}
						
						startIndex += bufferSize;
						retLength = myDR.GetBytes(0,startIndex,buffer,0,bufferSize);
					}
					totalSize += retLength;
					if(totalSize <= 65536*2)
					{
						displayedSize += retLength;
						txtData.Text += encoding.GetString(buffer,0,(int)retLength);
					}
					
					lblMessage.Text += "<br>Total Size = " + totalSize;
					lblMessage.Text += "bytes, Displayed Size = " + displayedSize;
					lblMessage.Text += "bytes, Displayed Text Length = " + txtData.Text.Length + "chars";
				}
				else
				{
					lblMessage.Text += "<br>No rows";
				}
				
			}catch(Exception ex){
				lblMessage.Text += "<br>GetBytes Error: " + ex.Message;
				if(myCN != null) myCN.Close();
			}		
		}

		private void btnGetBytes_Click(object sender,EventArgs e)
		{
			GetBytes(System.Text.Encoding.Default);
		}

		private void btnGetBytes2_Click(object sender,EventArgs e)
		{
			GetBytes(System.Text.Encoding.Unicode);
		}
		
		private void btnGetChars_Click(object sender,EventArgs e)
		{
			if(lstID.SelectedIndex < 0) return;
			if(lstField.SelectedIndex < 0) return;
			
			//int id = Integer.Parse(lstID.SelectedValue);
			//string field = lstField.SelectedValue;
			string queryString = "select " + lstField.SelectedValue + 
				" from sample.LargeType where c0_id = " + lstID.SelectedValue;
			OdbcConnection myCN = new OdbcConnection(connString);
			OdbcCommand myCM = new OdbcCommand(queryString,myCN);
			OdbcDataReader myDR;
			
			long totalSize = 0;
			long displayedSize = 0;
			
			try{
				myCN.Open();
				myDR = myCM.ExecuteReader(CommandBehavior.SequentialAccess);
				lblInfo.Text = "Command String: " + myCM.CommandText;
				if(myDR.Read())
				{
					int bufferSize = 65536;
					char[] buffer = new char[bufferSize];
					long startIndex = 0;
					long retLength = 0;
					
					retLength = myDR.GetChars(0,startIndex,buffer,0,bufferSize);
					while(retLength == bufferSize)
					{
						totalSize += retLength;
						if(totalSize <= 65536*2)
						{
							displayedSize += retLength;
							txtData.Text += new String(buffer);
						}
						
						startIndex += bufferSize;
						retLength = myDR.GetChars(0,startIndex,buffer,0,bufferSize);
					}
					totalSize += retLength;
					if(totalSize <= 65536*2)
					{
						displayedSize += retLength;
						txtData.Text += new String(buffer,0,(int)retLength);
					}
					
					lblMessage.Text += "<br>Total Size = " + totalSize;
					lblMessage.Text += "chars, Displayed Size = " + displayedSize;
					lblMessage.Text += "chars, Displayed Text Length = " + txtData.Text.Length + "chars";
				}
				else
				{
					lblMessage.Text += "<br>No rows";
				}
				
			}catch(Exception ex){
				lblMessage.Text += "<br>GetChars Error: " + ex.Message;
				if(myCN != null) myCN.Close();
			}				
		}
		
		private void btnGetString_Click(object sender,EventArgs e)
		{
			if(lstID.SelectedIndex < 0) return;
			if(lstField.SelectedIndex < 0) return;
			
			//int id = Integer.Parse(lstID.SelectedValue);
			//string field = lstField.SelectedValue;
			string queryString = "select " + lstField.SelectedValue + 
				" from sample.LargeType where c0_id = " + lstID.SelectedValue;
			OdbcConnection myCN = new OdbcConnection(connString);
			OdbcCommand myCM = new OdbcCommand(queryString,myCN);
			OdbcDataReader myDR;
			
			long totalSize = 0;
			long displayedSize = 0;
			
			try{
				myCN.Open();
				myDR = myCM.ExecuteReader(CommandBehavior.SequentialAccess);
				lblInfo.Text = "Command String: " + myCM.CommandText;
				if(myDR.Read())
				{
					string tmpString = myDR.GetString(0);
					totalSize = tmpString.Length;
					if(totalSize > 65536*2)
					{
						txtData.Text += tmpString.Substring(0,65536*2);
					}
					else
					{
						txtData.Text += tmpString;
					}
					
					lblMessage.Text += "<br>Total Size = " + totalSize;
					lblMessage.Text += "chars, Displayed Size = " + txtData.Text.Length;
					lblMessage.Text += "chars";
				}
				else
				{
					lblMessage.Text += "<br>No rows";
				}
				
			}catch(Exception ex){
				lblMessage.Text += "<br>GetString Error: " + ex.Message;
				if(myCN != null) myCN.Close();
			}						
		}
		
		private void btnGetValue_Click(object sender,EventArgs e)
		{
			if(lstID.SelectedIndex < 0) return;
			if(lstField.SelectedIndex < 0) return;
			
			//int id = Integer.Parse(lstID.SelectedValue);
			//string field = lstField.SelectedValue;
			string queryString = "select " + lstField.SelectedValue + 
				" from sample.LargeType where c0_id = " + lstID.SelectedValue;
			OdbcConnection myCN = new OdbcConnection(connString);
			OdbcCommand myCM = new OdbcCommand(queryString,myCN);
			OdbcDataReader myDR;
			
			long totalSize = 0;
			long displayedSize = 0;
			
			try{
				myCN.Open();
				myDR = myCM.ExecuteReader(CommandBehavior.SequentialAccess);
				lblInfo.Text = "Command String: " + myCM.CommandText;
				if(myDR.Read())
				{
					string tmpString = null;
					if(lstField.SelectedValue.Trim() == "c01_clob" || lstField.SelectedValue.Trim() == "c03_nclob")
					{
						tmpString = myDR.GetValue(0).ToString();
					}
					else
					{
						tmpString = System.Text.Encoding.Default.GetString((byte[])myDR.GetValue(0));
					}
					totalSize = tmpString.Length;
					if(totalSize > 65536*2)
					{
						txtData.Text += tmpString.Substring(0,65536*2);
					}
					else
					{
						txtData.Text += tmpString;
					}
				
					lblMessage.Text += "<br>Total Size = " + totalSize;
					//lblMessage.Text += "chars, Displayed Size = " + displayedSize;
					lblMessage.Text += "chars";
				}
				else
				{
					lblMessage.Text += "<br>No rows";
				}
				
			}catch(Exception ex){
				lblMessage.Text += "<br>GetValue Error: " + ex.Message;
				if(myCN != null) myCN.Close();
			}				
		}
		
	</script>
</head>
<body>
	<form method="post" runat="server" >
		<h3>Select CLOB,BLOB,NCLOB,FILE fields <br>
		[OdbcDataReader,GetBytes(),GetChars(),GetString(),GetValue()]</h3><hr>
		Database Name: DBSAMPLE5<br>
		Table Name: Sample.LargeType<br>
		Current Data:<br>
		<asp:DataGrid id = "grdCurData" runat = "server" />
		<hr><p>
		Row ID:
		<asp:DropDownList id="lstID" runat="server" width="40px" ></asp:DropDownList>
		&nbsp;
		Field:
		<asp:DropDownList id="lstField" runat="server" width="80px"></asp:DropDownList>
		<p>
		<asp:Button id="btnGetBytes" 
					runat="server" 
					Text="GetBytes to DefaultChar" 
					OnClick="btnGetBytes_Click">
		</asp:Button>
		
		<asp:Button id="btnGetBytes2" 
					runat="server" 
					Text="GetBytes to UnicodeChar" 
					OnClick="btnGetBytes2_Click">
		</asp:Button>
		
		<asp:Button id="btnGetChars" 
					runat="server" 
					Text="GetChars" 
					OnClick="btnGetChars_Click">
		</asp:Button>
		
		<asp:Button id="btnGetString" 
					runat="server" 
					Text="GetString" 
					OnClick="btnGetString_Click">
		</asp:Button>
		
		<asp:Button id="btnGetValue" 
					runat="server" 
					Text="GetValue" 
					OnClick="btnGetValue_Click">
		</asp:Button>
		<p>
		Only display characters below 128K bytes:
		<asp:TextBox id="txtData" 
					runat="server" 
					width="100%" 
					height="300px" 
					TextMode="MultiLine" 
					ReadOnly="true" 
					EnableViewState="false"/>
		<br>
		<asp:Label id="lblMessage" runat="server" EnableViewState=false/>
		<br>
		<asp:Label id="lblInfo" runat="server" EnableViewState="false"/>
                    
	</form>
</body>
</html>