#ifndef _SQLCA_H
#define _SQLCA_H

#define MAX_ERR_STR_LEN 512

/****************************************************************************
 * SQLCA - the SQL Communications Area (SQLCA)
 ****************************************************************************/

typedef struct sqlca {
  unsigned char  sqlcaid[8];        /* the string "SQLCA   "                */
  int            sqlcabc;           /* length of SQLCA, in bytes            */
  int            sqlcode;           /* DBMaker's status code                */
  int            sqlerrml;          /* length of sqlerrmc data              */
  unsigned char  sqlerrmc[MAX_ERR_STR_LEN]; /* DBMaker's error message      */
  unsigned char  sqlerrp[8];        /* diagnostic information               */
  int            sqlerrd[6];        /* various count and error code         */
  unsigned char  sqlwarn[8];        /* warning flag array                   */
  unsigned char  sqlext[8];         /* extension to sqlwarn array           */
  char           *sqlerr_filename;  /* file name which error occur          */
  int            sqlerr_lineno;     /* line number which error occur        */
} sqlca_t;

#define SQLCODE   pSQLCA->sqlcode   /* DBMaker's status code                */
#define SQLERRMSG pSQLCA->sqlerrmc  /* DBMaker's error message              */
#define SQLDMRC   pSQLCA->sqlerrd[0]/* DBMaker's native returned code       */
#define SQLNROW   pSQLCA->sqlerrd[3]/* DBMaker's # of affected rows         */

/****************************************************************************
 * A 'W' in any of the SQLWARN fields signals a warning condition;
 * otherwise these fields each contain a blank
 ****************************************************************************/
#define SQLWARN0 pSQLCA->sqlwarn[0] /* master warning flag                  */
#define SQLWARN1 pSQLCA->sqlwarn[1] /* string truncated                     */

extern sqlca_t *pSQLCA;
extern char    *pDBEnv;

#endif /* _SQLCA_H */
