/*
 * Decompiled with CFR 0.152.
 */
package dbaut;

import dbaut.DbaUtDef;
import dbaut.FullBackupFile;
import dbaut.IncBackupFile;
import dbaut.dbalib;
import java.util.Vector;

public class JBackupHistory {
    private long[] handle = null;
    private dbalib cfun = new dbalib();
    private static final int LEN_FNAME = 256;

    public String FilePath(String dbname, String backupfile, String backupflag) {
        byte[] filepath = new byte[1024];
        int rc = this.cfun.BackupHistoryFilePath(dbname.getBytes(), backupfile.getBytes(), backupflag.getBytes(), filepath);
        return new String(filepath).trim();
    }

    public int FileOpen(String dbname, String backupfile, String backupflag) {
        this.handle = new long[2];
        int rc = this.cfun.OpenBackupHistory(this.handle, dbname.getBytes(), backupfile.getBytes(), backupflag.getBytes());
        if (rc != 0) {
            System.out.println("OpenBackupHistory failed :" + rc);
            this.handle = null;
        }
        return rc;
    }

    public int FileClose() {
        if (this.handle == null) {
            return -1;
        }
        int rc = this.cfun.CloseBackupHistory(this.handle);
        if (rc != 0) {
            System.out.println("CloseBackupHistory failed :" + rc);
        }
        this.handle = null;
        return rc;
    }

    public Vector getFullBackupList() {
        byte[] buff;
        if (this.handle == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        int[] totalnum = new int[1];
        int rc = this.cfun.GetFullBackupList(this.handle, totalnum);
        if (rc != 0) {
            System.out.println("GetFullBackupList failed :" + rc);
            return null;
        }
        for (int i = 1; i <= totalnum[0] && (rc = this.cfun.GetFullBackupListInfo(this.handle, i, buff = new byte[1024])) == 0; ++i) {
            v.addElement(new String(buff));
        }
        return v;
    }

    public Vector getFullBackupInfo(int index) {
        byte[] phyfile;
        byte[] logfile;
        byte[] dbfile;
        int rc;
        if (this.handle == null) {
            return null;
        }
        Vector<FullBackupFile> v = new Vector<FullBackupFile>();
        FullBackupFile file = null;
        while ((rc = this.cfun.GetFullBackupData(this.handle, index, dbfile = new byte[256], logfile = new byte[256], phyfile = new byte[256])) == DbaUtDef.RTN_OK) {
            file = new FullBackupFile(new String(dbfile), new String(logfile), new String(phyfile));
            v.addElement(file);
        }
        return v;
    }

    public Vector getIncBackupInfo(int bkid, String btime) {
        int rc;
        if (this.handle == null) {
            return null;
        }
        Vector<IncBackupFile> v = new Vector<IncBackupFile>();
        byte[] buff = new byte[256];
        byte[] timebuff = new byte[256];
        while ((rc = this.cfun.GetIncBackupData(this.handle, ++bkid, btime.getBytes(), buff, timebuff)) == 0) {
            IncBackupFile file = new IncBackupFile(bkid, new String(buff), new String(timebuff));
            v.addElement(file);
        }
        return v;
    }

    public int setBackupData(int backup_id, int backup_type, String db_file, String log_file, String backup_file, int flag) {
        if (this.handle == null) {
            return -1;
        }
        int rc = this.cfun.SetBackupData(this.handle, backup_id, backup_type, db_file.getBytes(), log_file.getBytes(), backup_file.getBytes(), flag);
        if (rc != 0) {
            System.out.println("SetBackupData failed :" + rc);
        }
        return rc;
    }
}

