/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.xtm.treetable;

import com.syscom.ut.comp.ReflectionAction;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class XPathTextField
extends JTextField {
    private String[] xtmFunctions = new String[]{"xtm:copy-of"};
    private String[] nsFunctions = new String[]{"count", "id", "last", "local-name", "name", "namespace-uri", "position"};
    private String[] strFunctions = new String[]{"concat", "contains", "normalize-space", "starts-with", "string", "string-length", "substring", "substring-after", "substring-before", "translate"};
    private String[] numFunctions = new String[]{"ceiling", "floor", "number", "round", "sum"};
    private Object[][] functions = new Object[][]{{"XTM functions", this.xtmFunctions}, {"NodeSet functions", this.nsFunctions}, {"String functions", this.strFunctions}, {"Number functions", this.numFunctions}};

    public XPathTextField() {
        final XPathTextField field = this;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getModifiers() == 4) {
                    JPopupMenu popupmenu = new JPopupMenu();
                    JMenuItem item = null;
                    ReflectionAction action = null;
                    int size_1 = XPathTextField.this.functions.length;
                    int size_2 = 0;
                    String[] func = null;
                    for (int i = 0; i < size_1; ++i) {
                        func = (String[])XPathTextField.this.functions[i][1];
                        size_2 = func.length;
                        for (int j = 0; j < size_2; ++j) {
                            action = new ReflectionAction(field, "menuitem_actionPerformed", func[j], null);
                            item = new JMenuItem(action);
                            item.setActionCommand(func[j]);
                            popupmenu.add(item);
                        }
                        if (i + 1 == size_1) continue;
                        popupmenu.addSeparator();
                    }
                    Point p = e.getComponent().getLocationOnScreen();
                    int menuHeight = (int)popupmenu.getPreferredSize().getHeight();
                    Dimension s = Toolkit.getDefaultToolkit().getScreenSize();
                    int screenHeight = (int)(s.getHeight() - 40.0);
                    if (p.getY() + (double)menuHeight > (double)screenHeight) {
                        int adjust = (int)(p.getY() + (double)menuHeight) - screenHeight;
                        popupmenu.show(e.getComponent(), e.getX(), e.getY() - adjust);
                    } else {
                        popupmenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        });
    }

    public void menuitem_actionPerformed(ActionEvent e) {
        try {
            Document doc = this.getDocument();
            String function = e.getActionCommand();
            String selection = this.getSelectedText();
            if (selection != null && selection.length() > 0) {
                this.replaceSelection(function + "(" + selection + ")");
            } else {
                doc.insertString(this.getCaretPosition(), function + "()", null);
            }
        }
        catch (BadLocationException ble) {
            System.out.println(ble.getMessage());
        }
    }
}

