/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.tree;

import com.syscom.tree.AbstractDmMutableTreeNode;
import com.syscom.tree.AbstractDmTransferableTreeNode;
import com.syscom.tree.DmTreeCellRenderer;
import com.syscom.tree.MultipleTransferableItems;
import com.syscom.tree.TransferableUpdateListener;
import com.syscom.ut.resource.DBAImageResource;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.metal.MetalTreeUI;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DmTree
extends JTree {
    private boolean isDragSource = false;
    private DragSource dragSource;
    private DragGestureListener dgListener;
    private DragSourceListener dsListener;
    private Vector tuListeners = new Vector();

    public DmTree(TreeModel model) {
        super(model);
        this.init();
    }

    public DmTree(TreeNode node) {
        this(node, false);
    }

    public DmTree(TreeNode node, boolean isDragSource) {
        super(node);
        this.isDragSource = isDragSource;
        this.init();
    }

    private void init() {
        this.setCellRenderer(new DmTreeCellRenderer());
        this.initTreeUI();
        this.setToolTipText("");
        if (!this.isDragSource) {
            return;
        }
        this.dragSource = new eDragSource();
        this.dgListener = new DGListener();
        this.dsListener = new DSListener();
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this.dgListener);
    }

    public void addTransferableUpdateListener(TransferableUpdateListener listener) {
        this.tuListeners.add(listener);
    }

    public void removeTransferableUpdateListener(TransferableUpdateListener listener) {
        this.tuListeners.remove(listener);
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        if (this.getRowForLocation(evt.getX(), evt.getY()) == -1) {
            return null;
        }
        TreePath curPath = this.getPathForLocation(evt.getX(), evt.getY());
        return ((AbstractDmMutableTreeNode)curPath.getLastPathComponent()).getText();
    }

    private void initTreeUI() {
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setShowsRootHandles(true);
        TreeUI treeUI = this.getUI();
        if (treeUI instanceof MetalTreeUI) {
            MetalTreeUI mTreeUI = (MetalTreeUI)treeUI;
            ImageIcon icon = DBAImageResource.getResource(this.getClass(), "/images/tree/minus.gif");
            mTreeUI.setExpandedIcon(icon);
            icon = DBAImageResource.getResource(this.getClass(), "/images/tree/plus.gif");
            mTreeUI.setCollapsedIcon(icon);
        }
    }

    class eDragSourceContext
    extends DragSourceContext {
        public eDragSourceContext(DragSourceContextPeer dscp, DragGestureEvent dgl, Cursor cursor, Image img, Point offset, Transferable t, DragSourceListener dsl) {
            super(dscp, dgl, cursor, img, offset, t, dsl);
        }

        @Override
        protected void updateCurrentCursor(int dropOp, int targetAct, int status) {
            Cursor c = null;
            switch (status) {
                default: {
                    targetAct = 0;
                }
                case 1: 
                case 2: 
                case 3: 
            }
            int ra = dropOp & targetAct;
            c = ra == 0 ? DragSource.DefaultMoveNoDrop : DragSource.DefaultMoveDrop;
            this.setCursor(c);
        }
    }

    class eDragSource
    extends DragSource {
        eDragSource() {
        }

        public DragSourceContext createDragSourceContext(DragSourceContextPeer dscp, DragGestureEvent dgl, Cursor myCursor, Image img, Point offset, Transferable t, DragSourceListener dsl) {
            return new eDragSourceContext(dscp, dgl, myCursor, img, offset, t, dsl);
        }
    }

    class DSListener
    implements DragSourceListener {
        DSListener() {
        }

        @Override
        public void dragEnter(DragSourceDragEvent e) {
        }

        @Override
        public void dragOver(DragSourceDragEvent e) {
        }

        @Override
        public void dragExit(DragSourceEvent e) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent e) {
            int size = DmTree.this.tuListeners.size();
            for (int i = 0; i < size; ++i) {
                ((TransferableUpdateListener)DmTree.this.tuListeners.elementAt(i)).setTransferable(null);
            }
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent e) {
        }
    }

    class DGListener
    implements DragGestureListener {
        DGListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent e) {
            TreePath[] ps = DmTree.this.getSelectionPaths();
            if (ps == null || ps.length == 0) {
                return;
            }
            Object obj = null;
            MultipleTransferableItems v = new MultipleTransferableItems();
            for (int i = 0; i < ps.length; ++i) {
                obj = ps[i].getLastPathComponent();
                if (!(obj instanceof Transferable)) {
                    return;
                }
                if (!((AbstractDmTransferableTreeNode)obj).isTransferable()) {
                    return;
                }
                v.add(obj);
            }
            try {
                e.startDrag(DragSource.DefaultCopyNoDrop, v, DmTree.this.dsListener);
                int size = DmTree.this.tuListeners.size();
                for (int i = 0; i < size; ++i) {
                    ((TransferableUpdateListener)DmTree.this.tuListeners.elementAt(i)).setTransferable(v);
                }
            }
            catch (InvalidDnDOperationException idoe) {
                System.err.println(idoe);
            }
        }
    }
}

