/*
 * Decompiled with CFR 0.152.
 */
package dbmaster.jdbc.ws.client2;

import com.caucho.hessian.client.DMHessianProxyFactory;
import com.dbmaster.jdbc.ws.ResultSetData;
import dbmaster.jdbc.ws.client.Blob;
import dbmaster.jdbc.ws.client.Clob;
import dbmaster.jdbc.ws.client2.UtDate;
import dbmaster.jdbc.ws.client2.UtTs;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;

public class ResultSet
extends dbmaster.jdbc.ws.client.ResultSet {
    private ResultSetData _rsdata = null;
    private boolean _wasNull = false;
    private boolean _wasLargeObject = false;

    public ResultSet(DMHessianProxyFactory dMHessianProxyFactory, long l, Statement statement) throws Exception {
        super(dMHessianProxyFactory, l, statement);
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed(this._isClosed);
        if (this._rsdata == null || this._rsdata.cur + 1 == this._rsdata.rs_num) {
            this._rsdata = this._resultset.next2(this._index);
        } else {
            ++this._rsdata.cur;
        }
        return this._rsdata._hasData;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        this._rsdata = this._resultset.absolute2(this._index, n);
        return this._rsdata._hasData;
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClosed(this._isClosed);
        this._rsdata = this._resultset.first2(this._index);
        return this._rsdata._hasData;
    }

    private void basicCheck(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        if (this._rsdata == null || !this._rsdata._hasData) {
            ResultSet.JDBCError("JERR_RS_CONTAIN_NO_ROW", null);
        }
        if (n <= 0 || n > this._rsdata._columnCount) {
            ResultSet.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.getXXX(" + n + ")");
        }
        this._wasNull = false;
        this._wasLargeObject = false;
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.basicCheck(n);
        switch (this._rsdata._data[this._rsdata.cur][n - 1]._type) {
            case 0: {
                this._wasNull = true;
                return null;
            }
            case -5: {
                return BigDecimal.valueOf(this._rsdata._data[this._rsdata.cur][n - 1].longValue);
            }
            case -4: 
            case -3: 
            case -2: 
            case 16: 
            case 2004: {
                ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return new BigDecimal(this._rsdata._data[this._rsdata.cur][n - 1].strValue);
            }
            case -1: 
            case 2005: {
                ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
            }
            case 6: 
            case 7: 
            case 8: {
                return BigDecimal.valueOf(this._rsdata._data[this._rsdata.cur][n - 1].doubleValue);
            }
            case 4: {
                return BigDecimal.valueOf(this._rsdata._data[this._rsdata.cur][n - 1].intValue);
            }
            case -6: 
            case 5: {
                return BigDecimal.valueOf(this._rsdata._data[this._rsdata.cur][n - 1].shortValue);
            }
        }
        ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
        this._wasNull = true;
        return null;
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        this.basicCheck(n);
        switch (this._rsdata._data[this._rsdata.cur][n - 1]._type) {
            case 0: {
                this._wasNull = true;
                return false;
            }
            case -5: {
                return this._rsdata._data[this._rsdata.cur][n - 1].longValue > 0L;
            }
            case -3: 
            case -2: {
                return this._rsdata._data[this._rsdata.cur][n - 1].bytesValue != null;
            }
            case -4: 
            case 2004: {
                ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
            }
            case 16: {
                return this._rsdata._data[this._rsdata.cur][n - 1].boolValue;
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return this._rsdata._data[this._rsdata.cur][n - 1].strValue != null;
            }
            case -1: 
            case 2005: {
                ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
            }
            case 6: 
            case 7: 
            case 8: {
                return this._rsdata._data[this._rsdata.cur][n - 1].doubleValue > 0.0;
            }
            case 4: {
                return this._rsdata._data[this._rsdata.cur][n - 1].intValue > 0;
            }
            case -6: 
            case 5: {
                return this._rsdata._data[this._rsdata.cur][n - 1].shortValue > 0;
            }
        }
        ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
        this._wasNull = true;
        return false;
    }

    @Override
    public byte getByte(int n) throws SQLException {
        this.basicCheck(n);
        switch (this._rsdata._data[this._rsdata.cur][n - 1]._type) {
            case 0: {
                this._wasNull = true;
                return 0;
            }
            case -5: {
                if (this._rsdata._data[this._rsdata.cur][n - 1].longValue >= 127L || this._rsdata._data[this._rsdata.cur][n - 1].longValue <= -128L) {
                    ResultSet.JDBCError(ERR_DATA_CVT_OVERFLOW);
                }
                return (byte)this._rsdata._data[this._rsdata.cur][n - 1].longValue;
            }
            case -3: 
            case -2: {
                return this._rsdata._data[this._rsdata.cur][n - 1].bytesValue[0];
            }
            case -4: 
            case 2004: {
                return super.getByte(n);
            }
            case 16: {
                return (byte)(this._rsdata._data[this._rsdata.cur][n - 1].boolValue ? 1 : 0);
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return super.getByte(n);
            }
            case -1: 
            case 2005: {
                return super.getByte(n);
            }
            case 6: 
            case 7: 
            case 8: {
                if (this._rsdata._data[this._rsdata.cur][n - 1].doubleValue >= 127.0 || this._rsdata._data[this._rsdata.cur][n - 1].doubleValue <= -128.0) {
                    ResultSet.JDBCError(ERR_DATA_CVT_OVERFLOW);
                }
                return (byte)this._rsdata._data[this._rsdata.cur][n - 1].doubleValue;
            }
            case 4: {
                if (this._rsdata._data[this._rsdata.cur][n - 1].intValue >= 127 || this._rsdata._data[this._rsdata.cur][n - 1].intValue <= -128) {
                    ResultSet.JDBCError(ERR_DATA_CVT_OVERFLOW);
                }
                return (byte)this._rsdata._data[this._rsdata.cur][n - 1].intValue;
            }
            case -6: 
            case 5: {
                if (this._rsdata._data[this._rsdata.cur][n - 1].shortValue >= 127 || this._rsdata._data[this._rsdata.cur][n - 1].shortValue <= -128) {
                    ResultSet.JDBCError(ERR_DATA_CVT_OVERFLOW);
                }
                return (byte)this._rsdata._data[this._rsdata.cur][n - 1].shortValue;
            }
            case -16: 
            case 2011: {
                return super.getByte(n);
            }
        }
        ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
        this._wasNull = true;
        return 0;
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        this.basicCheck(n);
        switch (this._rsdata._data[this._rsdata.cur][n - 1]._type) {
            case 0: {
                this._wasNull = true;
                return null;
            }
            case -5: {
                return ByteBuffer.allocate(8).putLong(this._rsdata._data[this._rsdata.cur][n - 1].longValue).array();
            }
            case -3: 
            case -2: {
                return this._rsdata._data[this._rsdata.cur][n - 1].bytesValue;
            }
            case -4: 
            case 2004: {
                return super.getBytes(n);
            }
            case 16: {
                return new byte[]{(byte)(this._rsdata._data[this._rsdata.cur][n - 1].boolValue ? 1 : 0)};
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return super.getBytes(n);
            }
            case -1: 
            case 2005: {
                return super.getBytes(n);
            }
            case 6: 
            case 7: 
            case 8: {
                return ByteBuffer.allocate(8).putDouble(this._rsdata._data[this._rsdata.cur][n - 1].doubleValue).array();
            }
            case 4: {
                return ByteBuffer.allocate(4).putInt(this._rsdata._data[this._rsdata.cur][n - 1].intValue).array();
            }
            case -6: 
            case 5: {
                return ByteBuffer.allocate(2).putShort(this._rsdata._data[this._rsdata.cur][n - 1].shortValue).array();
            }
            case -16: 
            case 2011: {
                return super.getBytes(n);
            }
        }
        ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
        this._wasNull = true;
        return null;
    }

    @Override
    public Date getDate(int n) throws SQLException {
        this.basicCheck(n);
        switch (this._rsdata._data[this._rsdata.cur][n - 1]._type) {
            case 0: {
                this._wasNull = true;
                return null;
            }
            case -5: {
                return UtDate.i2date((int)this._rsdata._data[this._rsdata.cur][n - 1].longValue);
            }
            case -4: 
            case -3: 
            case -2: 
            case 16: 
            case 2004: {
                ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return Date.valueOf(this._rsdata._data[this._rsdata.cur][n - 1].strValue);
            }
            case -1: 
            case 2005: {
                ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
            }
            case 6: 
            case 7: 
            case 8: {
                return UtDate.i2date((int)this._rsdata._data[this._rsdata.cur][n - 1].doubleValue);
            }
            case 4: {
                return UtDate.i2date(this._rsdata._data[this._rsdata.cur][n - 1].intValue);
            }
            case -6: 
            case 5: {
                return UtDate.i2date(this._rsdata._data[this._rsdata.cur][n - 1].shortValue);
            }
            case -16: 
            case 2011: {
                ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
            }
        }
        ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
        this._wasNull = true;
        return null;
    }

    @Override
    public double getDouble(int n) throws SQLException {
        this.basicCheck(n);
        switch (this._rsdata._data[this._rsdata.cur][n - 1]._type) {
            case 0: {
                this._wasNull = true;
                return 0.0;
            }
            case -5: {
                return this._rsdata._data[this._rsdata.cur][n - 1].longValue;
            }
            case -4: 
            case -3: 
            case -2: 
            case 16: 
            case 2004: {
                ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return Double.valueOf(this._rsdata._data[this._rsdata.cur][n - 1].strValue);
            }
            case -1: 
            case 2005: {
                ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
            }
            case 6: 
            case 7: 
            case 8: {
                return this._rsdata._data[this._rsdata.cur][n - 1].doubleValue;
            }
            case 4: {
                return this._rsdata._data[this._rsdata.cur][n - 1].intValue;
            }
            case -6: 
            case 5: {
                return this._rsdata._data[this._rsdata.cur][n - 1].shortValue;
            }
        }
        ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
        this._wasNull = true;
        return 0.0;
    }

    @Override
    public float getFloat(int n) throws SQLException {
        return (float)this.getDouble(n);
    }

    @Override
    public int getInt(int n) throws SQLException {
        this.basicCheck(n);
        switch (this._rsdata._data[this._rsdata.cur][n - 1]._type) {
            case 0: {
                this._wasNull = true;
                return 0;
            }
            case -5: {
                return (int)this._rsdata._data[this._rsdata.cur][n - 1].longValue;
            }
            case -4: 
            case -3: 
            case -2: 
            case 16: 
            case 2004: {
                ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
            }
            case 3: {
                BigDecimal bigDecimal = new BigDecimal(this._rsdata._data[this._rsdata.cur][n - 1].strValue);
                return bigDecimal.intValue();
            }
            case 1: 
            case 2: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return Integer.valueOf(this._rsdata._data[this._rsdata.cur][n - 1].strValue);
            }
            case -1: 
            case 2005: {
                ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
            }
            case 6: 
            case 7: 
            case 8: {
                return (int)this._rsdata._data[this._rsdata.cur][n - 1].doubleValue;
            }
            case 4: {
                return this._rsdata._data[this._rsdata.cur][n - 1].intValue;
            }
            case -6: 
            case 5: {
                return this._rsdata._data[this._rsdata.cur][n - 1].shortValue;
            }
        }
        ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
        this._wasNull = true;
        return 0;
    }

    @Override
    public long getLong(int n) throws SQLException {
        this.basicCheck(n);
        switch (this._rsdata._data[this._rsdata.cur][n - 1]._type) {
            case 0: {
                this._wasNull = true;
                return 0L;
            }
            case -5: {
                return (int)this._rsdata._data[this._rsdata.cur][n - 1].longValue;
            }
            case -4: 
            case -3: 
            case -2: 
            case 16: 
            case 2004: {
                ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
            }
            case 3: {
                BigDecimal bigDecimal = new BigDecimal(this._rsdata._data[this._rsdata.cur][n - 1].strValue);
                return bigDecimal.longValue();
            }
            case 1: 
            case 2: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return Long.valueOf(this._rsdata._data[this._rsdata.cur][n - 1].strValue);
            }
            case -1: 
            case 2005: {
                ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
            }
            case 6: 
            case 7: 
            case 8: {
                return (long)this._rsdata._data[this._rsdata.cur][n - 1].doubleValue;
            }
            case 4: {
                return this._rsdata._data[this._rsdata.cur][n - 1].intValue;
            }
            case -6: 
            case 5: {
                return this._rsdata._data[this._rsdata.cur][n - 1].shortValue;
            }
        }
        ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
        this._wasNull = true;
        return 0L;
    }

    @Override
    public Object getObject(int n) throws SQLException {
        this.basicCheck(n);
        switch (this._rsdata._data[this._rsdata.cur][n - 1]._type) {
            case 0: {
                this._wasNull = true;
                return null;
            }
            case -5: {
                return this._rsdata._data[this._rsdata.cur][n - 1].longValue;
            }
            case -3: 
            case -2: {
                return this._rsdata._data[this._rsdata.cur][n - 1].bytesValue;
            }
            case -4: 
            case 2004: {
                return super.getObject(n);
            }
            case 16: {
                return this._rsdata._data[this._rsdata.cur][n - 1].boolValue;
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                return this._rsdata._data[this._rsdata.cur][n - 1].strValue;
            }
            case -1: 
            case 2005: {
                return super.getObject(n);
            }
            case 91: {
                return Date.valueOf(this._rsdata._data[this._rsdata.cur][n - 1].strValue);
            }
            case 8: {
                return this._rsdata._data[this._rsdata.cur][n - 1].doubleValue;
            }
            case 6: 
            case 7: {
                return Float.valueOf((float)this._rsdata._data[this._rsdata.cur][n - 1].doubleValue);
            }
            case 4: {
                return this._rsdata._data[this._rsdata.cur][n - 1].intValue;
            }
            case -6: 
            case 5: {
                return this._rsdata._data[this._rsdata.cur][n - 1].shortValue;
            }
            case 92: {
                return Time.valueOf(this._rsdata._data[this._rsdata.cur][n - 1].strValue);
            }
            case 93: {
                return Timestamp.valueOf(this._rsdata._data[this._rsdata.cur][n - 1].strValue);
            }
            case -16: 
            case 2011: {
                return super.getObject(n);
            }
        }
        return this._rsdata._data[this._rsdata.cur][n - 1].strValue;
    }

    @Override
    public short getShort(int n) throws SQLException {
        this.basicCheck(n);
        switch (this._rsdata._data[this._rsdata.cur][n - 1]._type) {
            case 0: {
                this._wasNull = true;
                return 0;
            }
            case -5: {
                return (short)this._rsdata._data[this._rsdata.cur][n - 1].longValue;
            }
            case -4: 
            case -3: 
            case -2: 
            case 16: 
            case 2004: {
                ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
            }
            case 3: {
                BigDecimal bigDecimal = new BigDecimal(this._rsdata._data[this._rsdata.cur][n - 1].strValue);
                return bigDecimal.shortValue();
            }
            case 1: 
            case 2: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return Short.valueOf(this._rsdata._data[this._rsdata.cur][n - 1].strValue);
            }
            case -1: 
            case 2005: {
                ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
            }
            case 6: 
            case 7: 
            case 8: {
                return (short)this._rsdata._data[this._rsdata.cur][n - 1].doubleValue;
            }
            case 4: {
                return (short)this._rsdata._data[this._rsdata.cur][n - 1].intValue;
            }
            case -6: 
            case 5: {
                return this._rsdata._data[this._rsdata.cur][n - 1].shortValue;
            }
        }
        ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
        this._wasNull = true;
        return 0;
    }

    @Override
    public String getString(int n) throws SQLException {
        this.basicCheck(n);
        switch (this._rsdata._data[this._rsdata.cur][n - 1]._type) {
            case 0: {
                this._wasNull = true;
                return null;
            }
            case -5: {
                return Long.toString(this._rsdata._data[this._rsdata.cur][n - 1].longValue);
            }
            case -4: 
            case -3: 
            case -2: 
            case 16: 
            case 2004: {
                return super.getString(n);
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return this._rsdata._data[this._rsdata.cur][n - 1].strValue;
            }
            case -1: 
            case 2005: {
                return super.getString(n);
            }
            case 6: 
            case 7: 
            case 8: {
                return Double.toString(this._rsdata._data[this._rsdata.cur][n - 1].doubleValue);
            }
            case 4: {
                return Integer.toString(this._rsdata._data[this._rsdata.cur][n - 1].intValue);
            }
            case -6: 
            case 5: {
                return Short.toString(this._rsdata._data[this._rsdata.cur][n - 1].shortValue);
            }
            case -16: 
            case 2011: {
                return super.getString(n);
            }
        }
        return this._rsdata._data[this._rsdata.cur][n - 1].strValue;
    }

    @Override
    public Time getTime(int n) throws SQLException {
        this.basicCheck(n);
        switch (this._rsdata._data[this._rsdata.cur][n - 1]._type) {
            case 0: {
                this._wasNull = true;
                return null;
            }
            case -5: {
                return UtDate.i2time((int)this._rsdata._data[this._rsdata.cur][n - 1].longValue);
            }
            case -4: 
            case -3: 
            case -2: 
            case 16: 
            case 2004: {
                ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return Time.valueOf(this._rsdata._data[this._rsdata.cur][n - 1].strValue);
            }
            case -1: 
            case 2005: {
                ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
            }
            case 6: 
            case 7: 
            case 8: {
                return UtDate.i2time((int)this._rsdata._data[this._rsdata.cur][n - 1].doubleValue);
            }
            case 4: {
                return UtDate.i2time(this._rsdata._data[this._rsdata.cur][n - 1].intValue);
            }
            case -6: 
            case 5: {
                return UtDate.i2time(this._rsdata._data[this._rsdata.cur][n - 1].shortValue);
            }
        }
        ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
        this._wasNull = true;
        return null;
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        this.basicCheck(n);
        switch (this._rsdata._data[this._rsdata.cur][n - 1]._type) {
            case 0: {
                this._wasNull = true;
                return null;
            }
            case -5: {
                UtDate.i2time((int)this._rsdata._data[this._rsdata.cur][n - 1].longValue);
            }
            case -4: 
            case -3: 
            case -2: 
            case 16: 
            case 2004: {
                ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return Timestamp.valueOf(this._rsdata._data[this._rsdata.cur][n - 1].strValue);
            }
            case -1: 
            case 2005: {
                ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
            }
            case 6: 
            case 7: 
            case 8: {
                return UtTs.dec2ts((long)this._rsdata._data[this._rsdata.cur][n - 1].doubleValue);
            }
            case 4: {
                return UtTs.dec2ts(this._rsdata._data[this._rsdata.cur][n - 1].intValue);
            }
            case -6: 
            case 5: {
                return UtTs.dec2ts(this._rsdata._data[this._rsdata.cur][n - 1].shortValue);
            }
        }
        ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
        this._wasNull = true;
        return null;
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClosed(this._isClosed);
        this._rsdata = this._resultset.last2(this._index);
        return this._rsdata._hasData;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClosed(this._isClosed);
        this._rsdata = this._resultset.previous2(this._index);
        return this._rsdata._hasData;
    }

    @Override
    public boolean relative(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        this._rsdata = this._resultset.relative2(this._index, n);
        return this._rsdata._hasData;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed(this._isClosed);
        if (this._wasLargeObject) {
            return super.wasNull();
        }
        return this._wasNull;
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        this.basicCheck(n);
        switch (this._rsdata._data[this._rsdata.cur][n - 1]._type) {
            case 0: {
                this._wasNull = true;
                return null;
            }
            case -16: 
            case -4: 
            case -1: 
            case 2004: 
            case 2005: 
            case 2011: {
                this._wasLargeObject = true;
                return super.getBlob(n);
            }
        }
        ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
        return null;
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        this.basicCheck(n);
        switch (this._rsdata._data[this._rsdata.cur][n - 1]._type) {
            case 0: {
                this._wasNull = true;
                return null;
            }
            case -16: 
            case -4: 
            case -1: 
            case 2004: 
            case 2005: 
            case 2011: {
                this._wasLargeObject = true;
                return super.getClob(n);
            }
        }
        ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
        return null;
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        this.basicCheck(n);
        switch (this._rsdata._data[this._rsdata.cur][n - 1]._type) {
            case 0: {
                this._wasNull = true;
                return null;
            }
            case -16: 
            case -4: 
            case -1: 
            case 2004: 
            case 2005: 
            case 2011: {
                this._wasLargeObject = true;
                return super.getNClob(n);
            }
        }
        ResultSet.JDBCError("JERR_CANNOT_CVT_DATA", null);
        return null;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed(this._isClosed);
        if (this._rsdata == null || !this._rsdata._hasData) {
            return 0;
        }
        return this._rsdata._data[this._rsdata.cur][this._rsdata._columnCount].intValue;
    }
}

