/*
 * Decompiled with CFR 0.152.
 */
package com.dbmaster.jdbc.ws;

import com.dbmaster.jdbc.ws.ResultSetMetaData2;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ResultSetData
implements Serializable {
    public boolean _hasData = false;
    public static final int MAX_FETCH_RECORD = 100;
    public int _columnCount = 0;
    public Data[][] _data = null;
    public int[] _columnType = null;
    public int cur = 0;
    public int rs_size = 1;
    public int rs_num = 1;

    private boolean hasLargeObject(int[] nArray) {
        boolean bl = false;
        if (nArray == null) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            switch (nArray[i]) {
                case -16: 
                case -4: 
                case -1: 
                case 2004: 
                case 2005: 
                case 2011: {
                    bl = true;
                    break;
                }
            }
            if (bl) break;
        }
        return bl;
    }

    public ResultSetData(boolean bl, ResultSet resultSet, ResultSetMetaData2 resultSetMetaData2) throws SQLException {
        this._hasData = bl;
        if (!this._hasData) {
            return;
        }
        if (resultSetMetaData2 == null) {
            return;
        }
        this._columnType = resultSetMetaData2.columnType;
        this._columnCount = resultSetMetaData2.getColumnCount();
        if (this._columnCount <= 0) {
            return;
        }
        this.rs_size = !resultSetMetaData2.hasUpdateSet && resultSet.getType() == 1003 && resultSet.getConcurrency() == 1007 && !this.hasLargeObject(this._columnType) ? 100 : 1;
        this._data = new Data[this.rs_size][this._columnCount + 1];
        int n = 0;
        do {
            this._data[n][this._columnCount] = new Data(4, resultSet.getRow());
            block14: for (int i = 0; i < this._columnCount; ++i) {
                switch (this._columnType[i]) {
                    case -5: {
                        long l = resultSet.getLong(i + 1);
                        if (resultSet.wasNull()) {
                            this._data[n][i] = new Data(0);
                            continue block14;
                        }
                        this._data[n][i] = new Data(this._columnType[i], l);
                        continue block14;
                    }
                    case -3: 
                    case -2: {
                        byte[] byArray = resultSet.getBytes(i + 1);
                        if (resultSet.wasNull()) {
                            this._data[n][i] = new Data(0);
                            continue block14;
                        }
                        this._data[n][i] = new Data(this._columnType[i], byArray);
                        continue block14;
                    }
                    case -4: 
                    case 2004: {
                        this._data[n][i] = new Data(this._columnType[i]);
                        continue block14;
                    }
                    case 16: {
                        boolean bl2 = resultSet.getBoolean(i + 1);
                        if (resultSet.wasNull()) {
                            this._data[n][i] = new Data(0);
                            continue block14;
                        }
                        this._data[n][i] = new Data(this._columnType[i], bl2);
                        continue block14;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: {
                        String string = resultSet.getString(i + 1);
                        if (resultSet.wasNull()) {
                            this._data[n][i] = new Data(0);
                            continue block14;
                        }
                        this._data[n][i] = new Data(this._columnType[i], string);
                        continue block14;
                    }
                    case -1: 
                    case 2005: {
                        this._data[n][i] = new Data(this._columnType[i]);
                        continue block14;
                    }
                    case 8: {
                        double d = resultSet.getDouble(i + 1);
                        if (resultSet.wasNull()) {
                            this._data[n][i] = new Data(0);
                            continue block14;
                        }
                        this._data[n][i] = new Data(this._columnType[i], d);
                        continue block14;
                    }
                    case 6: 
                    case 7: {
                        float f = resultSet.getFloat(i + 1);
                        if (resultSet.wasNull()) {
                            this._data[n][i] = new Data(0);
                            continue block14;
                        }
                        this._data[n][i] = new Data(this._columnType[i], f);
                        continue block14;
                    }
                    case 4: {
                        int n2 = resultSet.getInt(i + 1);
                        if (resultSet.wasNull()) {
                            this._data[n][i] = new Data(0);
                            continue block14;
                        }
                        this._data[n][i] = new Data(this._columnType[i], n2);
                        continue block14;
                    }
                    case -6: 
                    case 5: {
                        short s = resultSet.getShort(i + 1);
                        if (resultSet.wasNull()) {
                            this._data[n][i] = new Data(0);
                            continue block14;
                        }
                        this._data[n][i] = new Data(this._columnType[i], s);
                        continue block14;
                    }
                    case -16: 
                    case 2011: {
                        this._data[n][i] = new Data(this._columnType[i]);
                        continue block14;
                    }
                    default: {
                        String string = resultSet.getString(i + 1);
                        if (resultSet.wasNull()) {
                            this._data[n][i] = new Data(0);
                            continue block14;
                        }
                        this._data[n][i] = new Data(this._columnType[i], string);
                        continue block14;
                    }
                }
            }
        } while (++n != this.rs_size && resultSet.next());
        this.rs_num = n;
    }

    public ResultSetData() {
    }

    public class Data
    implements Serializable {
        public int _type = 1;
        public String strValue = null;
        public boolean boolValue = false;
        public byte byteValue = 0;
        public byte[] bytesValue = null;
        public int intValue = 0;
        public long longValue = 0L;
        public short shortValue = 0;
        public double doubleValue = 0.0;

        Data(int n, double d) {
            this._type = n;
            this.doubleValue = d;
        }

        Data(int n) {
            this._type = n;
        }

        Data(int n, String string) {
            this._type = n;
            this.strValue = string;
        }

        Data(int n, boolean bl) {
            this._type = n;
            this.boolValue = bl;
        }

        Data(int n, byte by) {
            this._type = n;
            this.byteValue = by;
        }

        Data(int n, byte[] byArray) {
            this._type = n;
            this.bytesValue = byArray;
        }

        Data(int n, int n2) {
            this._type = n;
            this.intValue = n2;
        }

        Data(int n, long l) {
            this._type = n;
            this.longValue = l;
        }

        Data(int n, short s) {
            this._type = n;
            this.shortValue = s;
        }

        Data(int n, BigDecimal bigDecimal) {
            this._type = n;
            this.strValue = bigDecimal.toPlainString();
        }
    }
}

