/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.DispatchableEvent;
import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixModel;
import com.borland.jbcl.model.MatrixModelEvent;
import com.borland.jbcl.model.MatrixModelListener;
import java.io.Serializable;
import java.util.EventListener;

public abstract class AbstractMatrixModel
implements MatrixModel,
Serializable {
    private transient EventMulticaster modelListeners = new EventMulticaster();
    private boolean events = true;

    public MatrixLocation find(Object data) {
        return null;
    }

    public void touched(int row, int column) {
        this.fireItemTouched(row, column);
    }

    public boolean canSet(int row, int column, boolean startEdit) {
        return true;
    }

    public boolean isVariableRows() {
        return true;
    }

    public boolean isVariableColumns() {
        return true;
    }

    public void addModelListener(MatrixModelListener listener) {
        this.modelListeners.add((EventListener)listener);
    }

    public void removeModelListener(MatrixModelListener listener) {
        this.modelListeners.remove((EventListener)listener);
    }

    public void enableModelEvents(boolean enable) {
        if (this.events != enable) {
            this.events = enable;
            if (enable) {
                this.fireStructureChanged();
            }
        }
    }

    protected void fireContentChanged() {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch((DispatchableEvent)new MatrixModelEvent(this, 1));
        }
    }

    protected void fireStructureChanged() {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch((DispatchableEvent)new MatrixModelEvent(this, 2));
        }
    }

    protected void fireItemChanged(int row, int column) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch((DispatchableEvent)new MatrixModelEvent(this, 17, new MatrixLocation(row, column)));
        }
    }

    protected void fireItemTouched(int row, int column) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch((DispatchableEvent)new MatrixModelEvent(this, 33, new MatrixLocation(row, column)));
        }
    }

    protected void fireRowChanged(int row) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch((DispatchableEvent)new MatrixModelEvent(this, 49, new MatrixLocation(row, -1)));
        }
    }

    protected void fireRowAdded(int row) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch((DispatchableEvent)new MatrixModelEvent(this, 18, new MatrixLocation(row, -1)));
        }
    }

    protected void fireRowRemoved(int row) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch((DispatchableEvent)new MatrixModelEvent(this, 34, new MatrixLocation(row, -1)));
        }
    }

    protected void fireColumnChanged(int column) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch((DispatchableEvent)new MatrixModelEvent(this, 65, new MatrixLocation(-1, column)));
        }
    }

    protected void fireColumnAdded(int column) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch((DispatchableEvent)new MatrixModelEvent(this, 50, new MatrixLocation(-1, column)));
        }
    }

    protected void fireColumnRemoved(int column) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch((DispatchableEvent)new MatrixModelEvent(this, 66, new MatrixLocation(-1, column)));
        }
    }

    public abstract int getColumnCount();

    public abstract int getRowCount();

    public abstract Object get(int var1, int var2);
}

