/*
 * Decompiled with CFR 0.152.
 */
package wizard.tablespace;

import dbatool.DbFrame;
import dbatool.tableCell.PhysicalEditor;
import dbatool.tableCell.PhysicalRenderer;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.comp.DbaTable;
import dbaut.comp.TableColumnSelectionListener;
import dbaut.comp.WizardTextPane;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.CharField;
import dbaut.util.JavaTypeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import wizard.WizardPanel;
import wizard.tablespace.Wizard_ts;

public class Panel_ts3
extends WizardPanel {
    private static final long serialVersionUID = 2123053740684152570L;
    TableCols model = new TableCols();
    DbaTable jTable1 = new DbaTable(this.model);
    Wizard_ts parentWizard = null;
    boolean error = false;

    public Panel_ts3(Wizard_ts paraWizard) {
        super(0);
        try {
            this.parentWizard = paraWizard;
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initPhysicalColumn() {
        TableColumn phyColumn = this.jTable1.getColumn(this.parentWizard.res.getString("Physical_Name"));
        PhysicalRenderer renderer = new PhysicalRenderer(this.parentWizard);
        PhysicalEditor editor = new PhysicalEditor(this.parentWizard);
        phyColumn.setCellRenderer(renderer);
        phyColumn.setCellEditor(editor);
    }

    private void setColumnWidth() {
        TableColumn logName = this.jTable1.getColumnModel().getColumn(0);
        TableColumn phyName = this.jTable1.getColumnModel().getColumn(1);
        TableColumn size = this.jTable1.getColumnModel().getColumn(2);
        TableColumn type = this.jTable1.getColumnModel().getColumn(3);
        TableColumn offset = this.jTable1.getColumnModel().getColumn(4);
        logName.setPreferredWidth(113);
        phyName.setPreferredWidth(355);
        size.setPreferredWidth(70);
        type.setPreferredWidth(55);
        offset.setPreferredWidth(55);
    }

    private void jbInit() throws Exception {
        this.setName("AddFilesPanel");
        this.jTable1.setName("AddFilesTable");
        PopupMenu popupMenu1 = new PopupMenu();
        JScrollPane jPanel1 = new JScrollPane();
        this.setImage(new JLabel(DBAImageResource.getResource(this.getClass(), "/jdbaimages/tblspacewizard-2.gif")));
        this.setTextPanel(new WizardTextPane(16, 14, Color.white, this.parentWizard.res.getString("Add_files_to_the") + this.parentWizard.res.getString("Please_enter_the_logical")));
        this.jTable1.setAutoResizeMode(4);
        popupMenu1.add(new MenuItem("DATA"));
        popupMenu1.add(new MenuItem("BLOB"));
        jPanel1.getViewport().add((Component)this.jTable1, "Center");
        this.setTypeColumn(this.jTable1.getColumnModel().getColumn(3));
        RowInfo newRow = new RowInfo("", "", "", "DATA", "");
        this.model.addValue(newRow);
        this.initPhysicalColumn();
        this.jTable1.setUpCharEditor(2);
        this.jTable1.setUpIntegerEditor(4);
        this.jTable1.setUpCharEditor(0, new CharField(128, true));
        this.jTable1.addColumnSelectionListener(new TableColumnSelectionListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    Panel_ts3.this.TableSelectionChanged(e);
                }
            }
        });
        this.jTable1.addRowSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    Panel_ts3.this.TableSelectionChanged(e);
                }
            }
        });
        this.setColumnWidth();
        this.add((Component)jPanel1, "Center");
    }

    private void setTypeColumn(TableColumn phyColumn) {
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem("DATA");
        comboBox.addItem("BLOB");
        phyColumn.setCellEditor(new DefaultCellEditor(comboBox));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText(this.parentWizard.res.getString("Click_for_combo_box"));
        phyColumn.setCellRenderer(renderer);
        TableCellRenderer headerRenderer = phyColumn.getHeaderRenderer();
        if (headerRenderer != null && headerRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)headerRenderer).setToolTipText(this.parentWizard.res.getString("Click_the_DATA_or"));
        }
    }

    void TableSelectionChanged(ListSelectionEvent e) {
        int row = this.jTable1.getSelectedRow();
        int col = this.jTable1.getSelectedColumn();
        if (row < 0 || col < 0) {
            return;
        }
        if (row >= this.jTable1.getRowCount() || col >= this.jTable1.getColumnCount()) {
            return;
        }
        this.jTable1.editCellAt(row, col);
    }

    public class TableCols
    extends AbstractTableModel {
        private static final long serialVersionUID = 2320044098876816173L;
        private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.wizard.ResWizard", LocaleManager.getLocale());
        private String db_name;
        private String db_dir;
        final String[] columnNames;
        private Vector<RowInfo> data;

        public TableCols() {
            this.db_name = DbFrame.conn_DatabaseConnection.dbname;
            this.db_dir = DbFrame.conn_DatabaseConnection.getDBDir();
            this.columnNames = new String[]{this.res.getString("Logical_Name"), this.res.getString("Physical_Name"), this.res.getString("Size"), this.res.getString("Type"), this.res.getString("Offset")};
            this.data = new Vector();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        public void addValue(RowInfo newData) {
            this.data.addElement(newData);
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        @Override
        public Object getValueAt(int row, int col) {
            RowInfo rowData = this.data.elementAt(row);
            return rowData.getValueAt(col);
        }

        public void removeValue(int x) {
            this.data.remove(x);
        }

        @Override
        public Class<?> getColumnClass(int c) {
            RowInfo rowData = this.data.elementAt(0);
            return rowData.getValueAt(c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (Panel_ts3.this.parentWizard.isRegular) {
                if (GuiUt.isWindows()) {
                    return col != 4;
                }
                if (col == 4) {
                    String s = this.getValueAt(row, 1).toString().trim();
                    if ((s = s.toLowerCase()).length() <= 0) {
                        return false;
                    }
                    return s.startsWith("/dev/");
                }
                return true;
            }
            return col != 4;
        }

        private boolean isLogicalFileExists(String filename, int index) {
            JdmConfig config;
            int rc;
            boolean isFound = false;
            int size = this.getRowCount();
            if (size > 1) {
                for (int i = 0; i < size; ++i) {
                    String temp;
                    if (i == index || (temp = (String)this.getValueAt(i, 0)).length() <= 0 || !temp.equalsIgnoreCase(filename)) continue;
                    isFound = true;
                    break;
                }
            }
            if (!isFound && (rc = (config = new JdmConfig()).fileOpen("dmconfig.ini", this.db_name, "r")) == 0) {
                ArrayList<String> list = config.getExistKeys();
                for (String item : list) {
                    if (!item.equalsIgnoreCase(filename)) continue;
                    isFound = true;
                    break;
                }
                config.fileClose();
            }
            return isFound;
        }

        private String getFullPath(String file, String path) {
            String fileseparator = System.getProperty("file.separator");
            String filename = null;
            filename = file.indexOf(fileseparator) < 0 ? (path.endsWith(fileseparator) ? path + file : path + fileseparator + file) : file;
            return filename;
        }

        private boolean isFileExists(String file, String path, int index) {
            String filename = this.getFullPath(file, path);
            File f = new File(filename);
            if (f.exists()) {
                return true;
            }
            int size = this.getRowCount();
            String temp = null;
            for (int i = 0; i < size; ++i) {
                if (i == index || (temp = (String)this.getValueAt(i, 1)).length() <= 0 || !this.getFullPath(temp, path).equalsIgnoreCase(filename)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            String fileSize;
            Panel_ts3.this.error = false;
            if (value == null) {
                return;
            }
            Object orig_value = this.getValueAt(row, col);
            if (col == 0 && !value.equals(orig_value) && value.toString().length() > 0 && this.isLogicalFileExists(((String)value).trim(), row)) {
                GuiUt.showErrorDlg(Panel_ts3.this.parentWizard, value + " " + this.res.getString("file_already_exists"), null);
                Panel_ts3.this.error = true;
                return;
            }
            if (col == 1) {
                if (!value.equals(orig_value) && value.toString().length() > 0 && this.isFileExists(((String)value).trim(), this.db_dir, row)) {
                    GuiUt.showErrorDlg(Panel_ts3.this.parentWizard, value + " " + this.res.getString("file_already_exists"), null);
                    Panel_ts3.this.error = true;
                    return;
                }
                if (!GuiUt.isWindows() && value.toString().toLowerCase().indexOf("/dev/") != 0) {
                    this.setValueAt("", row, 4);
                }
            }
            if (!(col != 2 || JavaTypeUtil.isInteger(fileSize = value.toString()) && Integer.parseInt(fileSize) >= 1)) {
                Panel_ts3.this.error = true;
                return;
            }
            RowInfo rowData = this.data.elementAt(row);
            rowData.setValueAt(value, col);
            this.fireTableCellUpdated(row, col);
            int rowNumber = 0;
            rowNumber = Panel_ts3.this.jTable1.getRowCount();
            if (!(col != 0 || value.toString().equalsIgnoreCase("") || rowNumber != 1 && (String)Panel_ts3.this.jTable1.getValueAt(rowNumber - 1, 0) == "")) {
                RowInfo newRow = new RowInfo("", "", "", "DATA", "");
                this.data.addElement(newRow);
                Panel_ts3.this.jTable1.revalidate();
                Panel_ts3.this.jTable1.repaint();
            }
        }
    }

    public class RowInfo {
        Object[] data = new Object[5];

        public RowInfo(String logical_name, String physical_name, String size, String file_type, String offset) {
            this.data[0] = logical_name;
            this.data[1] = physical_name;
            this.data[2] = size;
            this.data[3] = file_type;
            this.data[4] = offset;
        }

        public Object getValueAt(int index) {
            return this.data[index];
        }

        public void setValueAt(Object value, int index) {
            this.data[index] = value;
        }
    }
}

