/*
 * Decompiled with CFR 0.152.
 */
package ui.gui;

import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.resource.DBAImageResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ui.gui.JsqlFontDialog;
import ui.gui.JsqlFrame;

public class JsqlPreferencesDialog
extends JDialog {
    private JLabel sampleContents = new JLabel("How about this font?");
    private DbaButton fontButon = new DbaButton(new Dimension(80, 24), "Setup Font", 'S', new ReflectionAction(this, "fontButtonActionPerformed"));
    private JButton foreColorButton = new JButton();
    private JButton backColorButton = new JButton();
    private DbaButton okButton = new DbaButton(new Dimension(80, 24), "OK", 'O', DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"), new ReflectionAction(this, "okButtonActionPerformed"));
    private DbaButton cancelButton = new DbaButton(new Dimension(80, 24), "Cancel", 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelButtonActionPerformed"));
    private JsqlFrame parent = null;
    private Color foregroundColor = null;
    private Color backgroundColor = null;
    private Font font = null;
    private JPanel sampleConentsPanel = null;

    public JsqlPreferencesDialog(JsqlFrame frame) {
        super(frame, "Preferences", true);
        this.parent = frame;
        this.font = this.parent.getSimulator().getSimulatorFont();
        this.foregroundColor = this.parent.getSimulator().getSimulatorForeColor();
        this.backgroundColor = this.parent.getSimulator().getSimulatorBackColor();
        this.init();
        this.setResizable(false);
        this.setSize(480, 300);
        this.pack();
    }

    private void init() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(BorderFactory.createEtchedBorder());
        JPanel upCenterPanel = new JPanel(new BorderLayout());
        upCenterPanel.setBorder(BorderFactory.createTitledBorder("Sample text"));
        upCenterPanel.setPreferredSize(new Dimension(300, 220));
        this.sampleConentsPanel = new JPanel(new BorderLayout());
        this.sampleContents.setBorder(BorderFactory.createLoweredBevelBorder());
        this.sampleConentsPanel.add(this.sampleContents);
        upCenterPanel.add(this.sampleConentsPanel);
        JPanel upEastPanel1 = new JPanel(new GridLayout(2, 1, 10, 5));
        JPanel p1 = new JPanel(new BorderLayout());
        p1.setBorder(BorderFactory.createTitledBorder("Foreground"));
        this.foreColorButton.setBorder(BorderFactory.createEtchedBorder());
        this.foreColorButton.setPreferredSize(new Dimension(100, 24));
        this.foreColorButton.setBackground(this.parent.getSimulator().getSimulatorForeColor());
        this.foreColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JsqlPreferencesDialog.this.foreColorButtonActionPerformed(e);
            }
        });
        p1.add(this.foreColorButton);
        upEastPanel1.add(p1);
        JPanel p2 = new JPanel(new BorderLayout());
        p2.setBorder(BorderFactory.createTitledBorder("Background"));
        this.backColorButton.setBorder(BorderFactory.createEtchedBorder());
        this.backColorButton.setPreferredSize(new Dimension(100, 24));
        this.backColorButton.setBackground(this.parent.getSimulator().getSimulatorBackColor());
        this.backColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JsqlPreferencesDialog.this.backColorButtonActionPerformed(e);
            }
        });
        p2.add(this.backColorButton);
        upEastPanel1.add(p2);
        JPanel emptyPanel1 = new JPanel();
        emptyPanel1.setPreferredSize(new Dimension(80, 80));
        JPanel localPanel = new JPanel(new BorderLayout());
        localPanel.add((Component)upEastPanel1, "North");
        localPanel.add((Component)new JPanel(), "Center");
        localPanel.add((Component)this.fontButon, "South");
        JPanel emptyPanel2 = new JPanel();
        JPanel upEastPanel = new JPanel(new BorderLayout());
        upEastPanel.add((Component)new JPanel(), "West");
        upEastPanel.add((Component)emptyPanel2, "East");
        upEastPanel.add((Component)new JPanel(), "North");
        upEastPanel.add((Component)localPanel, "Center");
        upEastPanel.add((Component)emptyPanel1, "South");
        centerPanel.add((Component)upCenterPanel, "Center");
        centerPanel.add((Component)upEastPanel, "East");
        JPanel southPanel = new JPanel(new FlowLayout(1));
        southPanel.add(this.okButton);
        southPanel.add(this.cancelButton);
        contentPanel.add((Component)centerPanel, "Center");
        contentPanel.add((Component)southPanel, "South");
        this.getContentPane().add(contentPanel);
        this.setDefaultCloseOperation(2);
        this.setSampleContents();
        this.setNames();
    }

    private void setNames() {
        this.setName("JsqlPreferencesDialog");
        this.okButton.setName("OKButton");
        this.cancelButton.setName("CancelButton");
        this.fontButon.setName("FontButton");
        this.foreColorButton.setName("ForeColorButton");
        this.backColorButton.setName("BackColorButton");
    }

    private void setSampleContents() {
        this.sampleContents.setForeground(this.foregroundColor);
        this.sampleContents.setBackground(this.backgroundColor);
        this.sampleConentsPanel.setBackground(this.backgroundColor);
        this.sampleContents.setFont(this.font);
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 200) {
            this.okButton.requestFocus();
        }
    }

    public void fontButtonActionPerformed(ActionEvent e) {
        Font f = JsqlFontDialog.showDialog(this.parent, "Choose Font", this.font);
        if (f == null) {
            return;
        }
        this.font = f;
        this.sampleContents.setFont(f);
        this.sampleContents.revalidate();
    }

    public void foreColorButtonActionPerformed(ActionEvent e) {
        Color c = JColorChooser.showDialog(this.parent, "Choose Color", this.parent.getSimulator().getSimulatorForeColor());
        if (c == null) {
            return;
        }
        this.foregroundColor = c;
        this.sampleContents.setForeground(c);
        this.foreColorButton.setBackground(c);
        this.sampleContents.validate();
    }

    public void backColorButtonActionPerformed(ActionEvent e) {
        Color c = JColorChooser.showDialog(this.parent, "Choose Color", this.parent.getSimulator().getSimulatorBackColor());
        if (c == null) {
            return;
        }
        this.backgroundColor = c;
        this.sampleContents.setBackground(c);
        this.sampleConentsPanel.setBackground(c);
        this.backColorButton.setBackground(c);
        this.sampleConentsPanel.validate();
    }

    public void okButtonActionPerformed(ActionEvent e) {
        this.parent.getSimulator().setSimulatorForeColor(this.foregroundColor);
        this.parent.getSimulator().setSimulatorBackColor(this.backgroundColor);
        this.parent.getSimulator().setSimulatorFont(this.font);
        this.parent.getSimulator().validate();
        this.setVisible(false);
        this.dispose();
    }

    public void cancelButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }
}

