/*
 * Decompiled with CFR 0.152.
 */
package ui.gui;

import dbaut.JdmConfig;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.comp.SteppedComboBox;
import dbaut.preference.CorePreferences;
import dbaut.resource.DBAImageResource;
import dbaut.textField.CharField;
import dbaut.textField.CharPasswordField;
import dbaut.util.PlatformUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JsqlLoginDialog
extends JDialog {
    private String dbName = null;
    private String userName = null;
    private String password = null;
    private SteppedComboBox dbNameCombBox = new SteppedComboBox();
    private CharField userNameField = new CharField(128, true);
    private CharPasswordField passwordField = new CharPasswordField(16, true);
    private DbaButton loginButton = new DbaButton(new Dimension(80, 24), "Login", 'L', DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"), new ReflectionAction(this, "loginActionPerformed"));
    private DbaButton cancelButton = new DbaButton(new Dimension(80, 24), "Cancel", 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelActionPerformed"));
    private JCheckBox saveUserName = new JCheckBox("Save User Name");
    private boolean isOKPushed = false;
    private CorePreferences cp = CorePreferences.getCorePreferences();

    public JsqlLoginDialog(JFrame frame) {
        super(frame);
        this.init();
        this.setModal(true);
        this.setResizable(false);
        this.pack();
    }

    private void init() {
        this.setTitle("Login");
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        JPanel northPanel1 = new JPanel();
        northPanel1.setLayout(new GridLayout(3, 1));
        JLabel databaseNameLabel = new JLabel("Database : ");
        databaseNameLabel.setHorizontalAlignment(2);
        JLabel userNameLabel = new JLabel("User Name : ");
        userNameLabel.setHorizontalAlignment(2);
        JLabel passwordLabel = new JLabel("Password : ");
        passwordLabel.setHorizontalAlignment(2);
        northPanel1.add(databaseNameLabel);
        northPanel1.add(userNameLabel);
        northPanel1.add(passwordLabel);
        JPanel northPanel2 = new JPanel();
        northPanel2.setLayout(new GridLayout(3, 1));
        Vector<String> dataSource = JdmConfig.getDatabaseNames("dmconfig.ini", false);
        DefaultComboBoxModel<String> comboModel = new DefaultComboBoxModel<String>(dataSource);
        this.dbNameCombBox.setModel((ComboBoxModel)comboModel);
        this.dbNameCombBox.setMaximumRowCount(6);
        this.dbNameCombBox.setPreferredSize(new Dimension(200, 24));
        this.userNameField.setPreferredSize(new Dimension(200, 24));
        this.passwordField.setPreferredSize(new Dimension(200, 24));
        this.userNameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    JsqlLoginDialog.this.userNameFieldKeyPressed(e);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                JsqlLoginDialog.this.userNameFieldKeyPressed(e);
            }
        });
        this.passwordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    JsqlLoginDialog.this.passwordFieldKeyPressed(e);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                JsqlLoginDialog.this.passwordFieldKeyPressed(e);
            }
        });
        northPanel2.add(this.dbNameCombBox);
        northPanel2.add(this.userNameField);
        northPanel2.add(this.passwordField);
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new GridLayout(2, 1, 0, 0));
        JPanel savePanel = new JPanel();
        savePanel.add(this.saveUserName);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.loginButton);
        buttonPanel.add(this.cancelButton);
        southPanel.add(savePanel);
        southPanel.add(buttonPanel);
        contentPane.add((Component)new JPanel(), "North");
        contentPane.add((Component)new JPanel(), "East");
        JPanel northPanel3 = new JPanel();
        northPanel3.setLayout(new BorderLayout());
        northPanel3.add((Component)new JPanel(), "West");
        northPanel3.add((Component)northPanel1, "Center");
        contentPane.add((Component)northPanel3, "West");
        contentPane.add((Component)northPanel2, "Center");
        contentPane.add((Component)southPanel, "South");
        this.getContentPane().add(contentPane);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JsqlLoginDialog.this.cancelActionPerformed(null);
            }

            @Override
            public void windowOpened(WindowEvent e) {
                JsqlLoginDialog.this.loginButton.requestFocus();
            }
        });
        this.initData();
        this.setNames();
    }

    private void setNames() {
        this.dbNameCombBox.setName("DatabaseNameComboBox");
        this.userNameField.setName("UserNameField");
        this.passwordField.setName("PasswordField");
        this.saveUserName.setName("SaveUserNameCheckBox");
        this.loginButton.setName("LoginButton");
        this.cancelButton.setName("CancelButton");
    }

    private void initData() {
        this.dbName = (String)this.dbNameCombBox.getSelectedItem();
        if (this.dbName == null || this.dbName.length() < 1) {
            return;
        }
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen("dmconfig.ini", this.dbName, "r");
        if (rc != 0) {
            System.out.println("Error open dmconfig.ini via JdmConfig");
        } else {
            Object o = config.getPara("DB_USRID", 4096);
            if (o instanceof String) {
                String userName = (String)o;
                this.userNameField.setText(userName);
            }
            config.fileClose();
        }
    }

    public void userNameFieldKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 && this.userNameField.getText().length() > 0) {
            this.loginActionPerformed(null);
        }
    }

    public void passwordFieldKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 && this.userNameField.getText().length() > 0) {
            this.loginActionPerformed(null);
        }
    }

    public void loginActionPerformed(ActionEvent e) {
        this.dbName = (String)this.dbNameCombBox.getSelectedItem();
        this.userName = this.userNameField.getText();
        if (this.dbName == null || this.dbName.length() < 1 || this.userName == null || this.userName.length() < 1) {
            return;
        }
        this.password = new String(this.passwordField.getPassword());
        this.isOKPushed = true;
        this.setVisible(false);
        if (this.saveUserName.isSelected()) {
            JdmConfig config = new JdmConfig();
            int rc = config.fileOpen("dmconfig.ini", this.dbName, "r+");
            if (rc != 0) {
                System.out.println("Error open dmconfig.ini via JdmConfig");
            } else {
                config.insertPara("DB_USRID", this.userName, 4096);
                config.fileClose();
            }
        }
        this.dispose();
    }

    public void saveUserName() {
    }

    public void cancelActionPerformed(ActionEvent e) {
        this.isOKPushed = false;
        this.setVisible(false);
        this.dispose();
    }

    public String getDBName() {
        return this.dbName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isLoginButtonPushed() {
        return this.isOKPushed;
    }
}

